/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.osc;

import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCMessageEvent;
import com.illposed.osc.OSCMessageListener;
import com.illposed.osc.OSCSerializeException;
import com.illposed.osc.messageselector.OSCPatternAddressMessageSelector;
import com.illposed.osc.transport.OSCPortIn;
import com.illposed.osc.transport.OSCPortOut;
import dev.slimevr.config.OSCConfig;
import dev.slimevr.osc.OSCHandler;
import io.eiren.util.collections.FastList;
import io.eiren.util.logging.LogManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class OSCRouter {
    private OSCPortIn oscReceiver;
    private OSCPortOut oscSender;
    private final OSCConfig config;
    private final FastList<OSCHandler> oscHandlers;
    private int lastPortIn;
    private int lastPortOut;
    private InetAddress lastAddress;
    private long timeAtLastError;

    public OSCRouter(OSCConfig oscConfig, FastList<OSCHandler> oscHandlers) {
        this.config = oscConfig;
        this.oscHandlers = oscHandlers;
        this.refreshSettings(false);
    }

    public void refreshSettings(boolean refreshHandlersSettings) {
        boolean wasConnected;
        boolean wasListening;
        if (refreshHandlersSettings) {
            for (OSCHandler oscHandler : this.oscHandlers) {
                oscHandler.refreshSettings(false);
            }
        }
        boolean bl = wasListening = this.oscReceiver != null && this.oscReceiver.isListening();
        if (wasListening) {
            this.oscReceiver.stopListening();
        }
        this.oscReceiver = null;
        boolean bl2 = wasConnected = this.oscSender != null && this.oscSender.isConnected();
        if (wasConnected) {
            try {
                this.oscSender.close();
            }
            catch (IOException e) {
                LogManager.severe("[OSCRouter] Error closing the OSC sender: " + String.valueOf(e));
            }
        }
        this.oscSender = null;
        if (this.config.getEnabled()) {
            InetAddress address;
            int portIn = this.config.getPortIn();
            for (OSCHandler oscHandler : this.oscHandlers) {
                if (oscHandler.getPortIn() != portIn || !oscHandler.getOscReceiver().isListening()) continue;
                this.oscReceiver = oscHandler.getOscReceiver();
                LogManager.info("[OSCRouter] Listening to port " + portIn);
            }
            if (this.oscReceiver == null) {
                try {
                    this.oscReceiver = new OSCPortIn(portIn);
                    if (this.lastPortIn != portIn || !wasListening) {
                        LogManager.info("[OSCRouter] Listening to port " + portIn);
                    }
                    this.lastPortIn = portIn;
                }
                catch (IOException e) {
                    LogManager.severe("[OSCRouter] Error listening to the port " + this.config.getPortIn() + ": " + String.valueOf(e));
                }
            }
            int portOut = this.config.getPortOut();
            try {
                address = InetAddress.getByName(this.config.getAddress());
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            for (OSCHandler oscHandler : this.oscHandlers) {
                if (oscHandler.getPortOut() != portOut || oscHandler.getAddress() != address || !oscHandler.getOscSender().isConnected()) continue;
                this.oscSender = oscHandler.getOscSender();
                LogManager.info("[OSCRouter] Sending to port " + portOut + " at address " + address.toString());
            }
            if (this.oscSender == null) {
                try {
                    this.oscSender = new OSCPortOut(new InetSocketAddress(address, portOut));
                    if (this.lastPortOut != portOut && this.lastAddress != address || !wasConnected) {
                        LogManager.info("[OSCRouter] Sending to port " + portOut + " at address " + address.toString());
                    }
                    this.lastPortOut = portOut;
                    this.lastAddress = address;
                    this.oscSender.connect();
                }
                catch (IOException e) {
                    LogManager.severe("[OSCRouter] Error connecting to port " + this.config.getPortOut() + " at the address " + this.config.getAddress() + ": " + String.valueOf(e));
                }
            }
            if (this.oscReceiver != null) {
                OSCMessageListener listener2 = this::handleReceivedMessage;
                OSCPatternAddressMessageSelector selector = new OSCPatternAddressMessageSelector("//");
                this.oscReceiver.getDispatcher().addListener(selector, listener2);
                if (!this.oscReceiver.isListening()) {
                    this.oscReceiver.startListening();
                }
            }
        }
    }

    void handleReceivedMessage(OSCMessageEvent event) {
        block3: {
            if (this.oscSender != null && this.oscSender.isConnected()) {
                OSCMessage oscMessage = new OSCMessage(event.getMessage().getAddress(), event.getMessage().getArguments());
                try {
                    this.oscSender.send(oscMessage);
                }
                catch (OSCSerializeException | IOException e) {
                    if (System.currentTimeMillis() - this.timeAtLastError <= 100L) break block3;
                    this.timeAtLastError = System.currentTimeMillis();
                    LogManager.warning("[OSCRouter] Error sending OSC packet: " + String.valueOf(e));
                }
            }
        }
    }
}

