/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.osc;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCMessageEvent;
import com.illposed.osc.OSCMessageListener;
import com.illposed.osc.OSCSerializeException;
import com.illposed.osc.messageselector.OSCPatternAddressMessageSelector;
import com.illposed.osc.transport.OSCPortIn;
import com.illposed.osc.transport.OSCPortOut;
import com.jme3.system.NanoTimer;
import dev.slimevr.VRServer;
import dev.slimevr.config.VRCOSCConfig;
import dev.slimevr.osc.OSCHandler;
import dev.slimevr.osc.VRCOSCQueryHandler;
import dev.slimevr.protocol.rpc.setup.RPCUtil;
import dev.slimevr.tracking.trackers.Device;
import dev.slimevr.tracking.trackers.DeviceManager;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerPosition;
import dev.slimevr.tracking.trackers.TrackerRole;
import dev.slimevr.tracking.trackers.TrackerStatus;
import io.eiren.util.collections.FastList;
import io.eiren.util.logging.LogManager;
import io.github.axisangles.ktmath.EulerAngles;
import io.github.axisangles.ktmath.EulerOrder;
import io.github.axisangles.ktmath.Quaternion;
import io.github.axisangles.ktmath.Vector3;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020*H\u0016J\u0016\u0010Q\u001a\u00020O2\u0006\u0010&\u001a\u00020%2\u0006\u0010R\u001a\u00020\fJ\u000e\u0010S\u001a\u00020O2\u0006\u0010T\u001a\u00020*J#\u0010U\u001a\u00020O2\u0006\u0010V\u001a\u00020%2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0016\u00a2\u0006\u0002\u0010XJ\u0018\u0010Y\u001a\u00020O2\u0006\u0010Z\u001a\u00020%2\u0006\u0010[\u001a\u00020\fH\u0016J\u0010\u0010\\\u001a\u00020O2\u0006\u0010]\u001a\u00020^H\u0002J\b\u0010_\u001a\u00020OH\u0016J\u0012\u0010`\u001a\u00020%2\b\u0010a\u001a\u0004\u0018\u00010bH\u0002J\u0010\u0010c\u001a\u00020O2\b\u0010\u001b\u001a\u0004\u0018\u00010\bJ\u0015\u0010d\u001a\u00020O2\u0006\u0010e\u001a\u00020<\u00a2\u0006\u0004\bf\u0010@J\b\u0010g\u001a\u00020\u0017H\u0016J\b\u0010h\u001a\u00020%H\u0016J\b\u0010i\u001a\u00020(H\u0016J\b\u0010j\u001a\u00020\u0015H\u0016J\b\u0010k\u001a\u00020%H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0012\n\u0004\b5\u00106\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001e\u00107\u001a\u000200X\u0082\u000e\u00a2\u0006\u0012\n\u0004\b:\u00106\u001a\u0004\b8\u00102\"\u0004\b9\u00104R\u001e\u0010;\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0012\n\u0004\bA\u00106\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001e\u0010B\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0012\n\u0004\bE\u00106\u001a\u0004\bC\u0010>\"\u0004\bD\u0010@R\u0018\u0010F\u001a\u00020<X\u0082\u0004\u00a2\u0006\f\n\u0004\bH\u00106\u001a\u0004\bG\u0010>R\u000e\u0010I\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010J\u001a\u0004\u0018\u00010KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010L\u001a\u0004\u0018\u00010MX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Ldev/slimevr/osc/VRCOSCHandler;", "Ldev/slimevr/osc/OSCHandler;", "server", "Ldev/slimevr/VRServer;", "config", "Ldev/slimevr/config/VRCOSCConfig;", "computedTrackers", "", "Ldev/slimevr/tracking/trackers/Tracker;", "<init>", "(Ldev/slimevr/VRServer;Ldev/slimevr/config/VRCOSCConfig;Ljava/util/List;)V", "localIp", "", "loopbackIp", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "vrsystemTrackersAddresses", "", "[Ljava/lang/String;", "oscTrackersAddresses", "oscReceiver", "Lcom/illposed/osc/transport/OSCPortIn;", "oscSender", "Lcom/illposed/osc/transport/OSCPortOut;", "oscQuerySender", "oscMessage", "Lcom/illposed/osc/OSCMessage;", "headTracker", "oscTrackersDevice", "Ldev/slimevr/tracking/trackers/Device;", "vrsystemTrackersDevice", "oscArgs", "Lio/eiren/util/collections/FastList;", "", "trackersEnabled", "", "oscPortIn", "", "oscPortOut", "oscIp", "Ljava/net/InetAddress;", "oscQuerySenderState", "", "oscQueryPortOut", "oscQueryIp", "timeAtLastError", "", "receivingPositionOffset", "Lio/github/axisangles/ktmath/Vector3;", "getReceivingPositionOffset", "()Lio/github/axisangles/ktmath/Vector3;", "setReceivingPositionOffset-1s-5YWc", "(FFF)V", "receivingPositionOffset-x", "F", "postReceivingPositionOffset", "getPostReceivingPositionOffset", "setPostReceivingPositionOffset-1s-5YWc", "postReceivingPositionOffset-x", "receivingRotationOffset", "Lio/github/axisangles/ktmath/Quaternion;", "getReceivingRotationOffset", "()Lio/github/axisangles/ktmath/Quaternion;", "setReceivingRotationOffset-oS71L7k", "(FFFF)V", "receivingRotationOffset-w", "receivingRotationOffsetGoal", "getReceivingRotationOffsetGoal", "setReceivingRotationOffsetGoal-oS71L7k", "receivingRotationOffsetGoal-w", "postReceivingOffset", "getPostReceivingOffset", "postReceivingOffset-w", "timeAtLastReceivedRotationOffset", "fpsTimer", "Lcom/jme3/system/NanoTimer;", "vrcOscQueryHandler", "Ldev/slimevr/osc/VRCOSCQueryHandler;", "refreshSettings", "", "refreshRouterSettings", "addOSCQuerySender", "oscIP", "closeOscQuerySender", "newState", "updateOscReceiver", "portIn", "args", "(I[Ljava/lang/String;)V", "updateOscSender", "portOut", "ip", "handleReceivedMessage", "event", "Lcom/illposed/osc/OSCMessageEvent;", "update", "getVRCOSCTrackersId", "trackerPosition", "Ldev/slimevr/tracking/trackers/TrackerPosition;", "setHeadTracker", "yawAlign", "headRot", "yawAlign-oS71L7k", "getOscSender", "getPortOut", "getAddress", "getOscReceiver", "getPortIn", "core"})
public final class VRCOSCHandler
implements OSCHandler {
    @NotNull
    private final VRServer server;
    @NotNull
    private final VRCOSCConfig config;
    @NotNull
    private final List<Tracker> computedTrackers;
    @Nullable
    private final String localIp;
    private final String loopbackIp;
    @NotNull
    private final String[] vrsystemTrackersAddresses;
    @NotNull
    private final String[] oscTrackersAddresses;
    @Nullable
    private OSCPortIn oscReceiver;
    @Nullable
    private OSCPortOut oscSender;
    @Nullable
    private OSCPortOut oscQuerySender;
    @Nullable
    private OSCMessage oscMessage;
    @Nullable
    private Tracker headTracker;
    @Nullable
    private Device oscTrackersDevice;
    @Nullable
    private Device vrsystemTrackersDevice;
    @NotNull
    private final FastList<Float> oscArgs;
    @NotNull
    private final boolean[] trackersEnabled;
    private int oscPortIn;
    private int oscPortOut;
    @Nullable
    private InetAddress oscIp;
    private boolean oscQuerySenderState;
    private int oscQueryPortOut;
    @Nullable
    private String oscQueryIp;
    private long timeAtLastError;
    private float receivingPositionOffset-x;
    private float receivingPositionOffset-y;
    private float receivingPositionOffset-z;
    private float postReceivingPositionOffset-x;
    private float postReceivingPositionOffset-y;
    private float postReceivingPositionOffset-z;
    private float receivingRotationOffset-w;
    private float receivingRotationOffset-x;
    private float receivingRotationOffset-y;
    private float receivingRotationOffset-z;
    private float receivingRotationOffsetGoal-w;
    private float receivingRotationOffsetGoal-x;
    private float receivingRotationOffsetGoal-y;
    private float receivingRotationOffsetGoal-z;
    private final float postReceivingOffset-w;
    private final float postReceivingOffset-x;
    private final float postReceivingOffset-y;
    private final float postReceivingOffset-z;
    private long timeAtLastReceivedRotationOffset;
    @Nullable
    private NanoTimer fpsTimer;
    @Nullable
    private VRCOSCQueryHandler vrcOscQueryHandler;

    public VRCOSCHandler(@NotNull VRServer server, @NotNull VRCOSCConfig config, @NotNull List<Tracker> computedTrackers) {
        Intrinsics.checkNotNullParameter(server, "server");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(computedTrackers, "computedTrackers");
        this.server = server;
        this.config = config;
        this.computedTrackers = computedTrackers;
        this.localIp = RPCUtil.getLocalIp();
        this.loopbackIp = InetAddress.getLoopbackAddress().getHostAddress();
        Object object = new String[]{"/tracking/vrsystem/head/pose", "/tracking/vrsystem/leftwrist/pose", "/tracking/vrsystem/rightwrist/pose"};
        this.vrsystemTrackersAddresses = object;
        object = new String[]{"/tracking/trackers/*/position", "/tracking/trackers/*/rotation"};
        this.oscTrackersAddresses = object;
        this.oscArgs = new FastList<int>(3);
        this.trackersEnabled = new boolean[this.computedTrackers.size()];
        object = Vector3.Companion;
        this.receivingPositionOffset-x = ((Vector3.Companion)object).getNULL-x();
        this.receivingPositionOffset-y = ((Vector3.Companion)object).getNULL-y();
        this.receivingPositionOffset-z = ((Vector3.Companion)object).getNULL-z();
        object = Vector3.Companion;
        this.postReceivingPositionOffset-x = ((Vector3.Companion)object).getNULL-x();
        this.postReceivingPositionOffset-y = ((Vector3.Companion)object).getNULL-y();
        this.postReceivingPositionOffset-z = ((Vector3.Companion)object).getNULL-z();
        object = Quaternion.Companion;
        this.receivingRotationOffset-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this.receivingRotationOffset-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this.receivingRotationOffset-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this.receivingRotationOffset-z = ((Quaternion.Companion)object).getIDENTITY-z();
        object = Quaternion.Companion;
        this.receivingRotationOffsetGoal-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this.receivingRotationOffsetGoal-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this.receivingRotationOffsetGoal-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this.receivingRotationOffsetGoal-z = ((Quaternion.Companion)object).getIDENTITY-z();
        EulerOrder eulerOrder = EulerOrder.YXZ;
        EulerAngles.constructor-impl(eulerOrder, 0.0f, (float)Math.PI, 0.0f);
        object = EulerAngles.toQuaternion-impl(eulerOrder, 0.0f, (float)Math.PI, 0.0f);
        this.postReceivingOffset-w = ((Quaternion)object).unbox-impl-w();
        this.postReceivingOffset-x = ((Quaternion)object).unbox-impl-x();
        this.postReceivingOffset-y = ((Quaternion)object).unbox-impl-y();
        this.postReceivingOffset-z = ((Quaternion)object).unbox-impl-z();
        this.timeAtLastReceivedRotationOffset = System.currentTimeMillis();
        this.refreshSettings(false);
    }

    private final Vector3 getReceivingPositionOffset() {
        return Vector3.box-impl(this.receivingPositionOffset-x, this.receivingPositionOffset-y, this.receivingPositionOffset-z);
    }

    private final void setReceivingPositionOffset-1s-5YWc(float f, float f2, float f3) {
        this.receivingPositionOffset-x = f;
        this.receivingPositionOffset-y = f2;
        this.receivingPositionOffset-z = f3;
    }

    private final Vector3 getPostReceivingPositionOffset() {
        return Vector3.box-impl(this.postReceivingPositionOffset-x, this.postReceivingPositionOffset-y, this.postReceivingPositionOffset-z);
    }

    private final void setPostReceivingPositionOffset-1s-5YWc(float f, float f2, float f3) {
        this.postReceivingPositionOffset-x = f;
        this.postReceivingPositionOffset-y = f2;
        this.postReceivingPositionOffset-z = f3;
    }

    private final Quaternion getReceivingRotationOffset() {
        return Quaternion.box-impl(this.receivingRotationOffset-w, this.receivingRotationOffset-x, this.receivingRotationOffset-y, this.receivingRotationOffset-z);
    }

    private final void setReceivingRotationOffset-oS71L7k(float f, float f2, float f3, float f4) {
        this.receivingRotationOffset-w = f;
        this.receivingRotationOffset-x = f2;
        this.receivingRotationOffset-y = f3;
        this.receivingRotationOffset-z = f4;
    }

    private final Quaternion getReceivingRotationOffsetGoal() {
        return Quaternion.box-impl(this.receivingRotationOffsetGoal-w, this.receivingRotationOffsetGoal-x, this.receivingRotationOffsetGoal-y, this.receivingRotationOffsetGoal-z);
    }

    private final void setReceivingRotationOffsetGoal-oS71L7k(float f, float f2, float f3, float f4) {
        this.receivingRotationOffsetGoal-w = f;
        this.receivingRotationOffsetGoal-x = f2;
        this.receivingRotationOffsetGoal-y = f3;
        this.receivingRotationOffsetGoal-z = f4;
    }

    private final Quaternion getPostReceivingOffset() {
        return Quaternion.box-impl(this.postReceivingOffset-w, this.postReceivingOffset-x, this.postReceivingOffset-y, this.postReceivingOffset-z);
    }

    @Override
    public void refreshSettings(boolean refreshRouterSettings) {
        int n = ((Collection)this.computedTrackers).size();
        for (int i = 0; i < n; ++i) {
            if (this.computedTrackers.get(i).getTrackerPosition() != TrackerPosition.HEAD || this.computedTrackers.get(i).getTrackerPosition() != TrackerPosition.LEFT_HAND || this.computedTrackers.get(i).getTrackerPosition() != TrackerPosition.RIGHT_HAND) {
                TrackerPosition trackerPosition = this.computedTrackers.get(i).getTrackerPosition();
                Intrinsics.checkNotNull((Object)trackerPosition);
                TrackerRole trackerRole = trackerPosition.getTrackerRole();
                Intrinsics.checkNotNull((Object)trackerRole);
                this.trackersEnabled[i] = this.config.getOSCTrackerRole(trackerRole, false);
                continue;
            }
            this.trackersEnabled[i] = false;
        }
        this.updateOscReceiver(this.config.getPortIn(), ArraysKt.plus(this.vrsystemTrackersAddresses, this.oscTrackersAddresses));
        this.updateOscSender(this.config.getPortOut(), this.config.getAddress());
        if (this.vrcOscQueryHandler == null && this.config.getEnabled() && this.config.getOscqueryEnabled()) {
            try {
                this.vrcOscQueryHandler = new VRCOSCQueryHandler(this);
            }
            catch (Throwable e) {
                LogManager.severe("Unable to initialize OSCQuery: " + e, e);
            }
        } else if (!(this.vrcOscQueryHandler == null || this.config.getEnabled() && this.config.getOscqueryEnabled())) {
            VRCOSCQueryHandler vRCOSCQueryHandler = this.vrcOscQueryHandler;
            if (vRCOSCQueryHandler != null) {
                vRCOSCQueryHandler.close();
            }
            this.vrcOscQueryHandler = null;
        }
        if (refreshRouterSettings) {
            this.server.getOSCRouter().refreshSettings(false);
        }
    }

    public final void addOSCQuerySender(int oscPortOut, @NotNull String oscIP) {
        Intrinsics.checkNotNullParameter(oscIP, "oscIP");
        InetAddress addr = InetAddress.getByName(oscIP);
        this.oscQuerySenderState = true;
        this.oscQueryIp = oscIP;
        this.oscQueryPortOut = oscPortOut;
        if (!(oscPortOut == this.getPortOut() && (Intrinsics.areEqual(oscIP, this.getAddress().getHostName()) || Intrinsics.areEqual(oscIP, this.localIp) && Intrinsics.areEqual(this.getAddress().getHostName(), this.loopbackIp)))) {
            try {
                OSCPortOut oSCPortOut = this.oscQuerySender = new OSCPortOut(new InetSocketAddress(addr, oscPortOut));
                if (oSCPortOut != null) {
                    oSCPortOut.connect();
                }
                LogManager.info("[VRCOSCHandler] OSCQuery sender sending to port " + oscPortOut + " at address " + oscIP);
            }
            catch (IOException e) {
                LogManager.severe("[VRCOSCHandler] Error connecting to port " + oscPortOut + " at the address " + oscIP + ": " + e);
            }
        }
    }

    public final void closeOscQuerySender(boolean newState) {
        block2: {
            OSCPortOut oSCPortOut = this.oscQuerySender;
            if (oSCPortOut == null) break block2;
            OSCPortOut it = oSCPortOut;
            boolean bl = false;
            try {
                it.close();
                this.oscQuerySender = null;
                this.oscQuerySenderState = newState;
            }
            catch (IOException e) {
                LogManager.severe("[VRCOSCHandler] Error closing the OSC sender: " + e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateOscReceiver(int portIn, @NotNull String[] args) {
        block9: {
            Intrinsics.checkNotNullParameter(args, "args");
            if (this.oscReceiver == null) ** GOTO lbl-1000
            v0 = this.oscReceiver;
            Intrinsics.checkNotNull(v0);
            if (v0.isListening()) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = wasListening = false;
            }
            if (wasListening) {
                v2 = this.oscReceiver;
                Intrinsics.checkNotNull(v2);
                v2.stopListening();
            }
            if (!this.config.getEnabled()) break block9;
            try {
                this.oscReceiver = new OSCPortIn(portIn);
                if (this.oscPortIn != portIn || !wasListening) {
                    LogManager.info("[VRCOSCHandler] Listening to port " + portIn);
                }
                this.oscPortIn = portIn;
                v3 = this.vrcOscQueryHandler;
                if (v3 != null) {
                    v3.updateOSCQuery-xj2QHRw(UShort.constructor-impl((short)portIn));
                }
            }
            catch (IOException e) {
                LogManager.severe("[VRCOSCHandler] Error listening to the port " + portIn + ": " + e);
            }
            v4 = this.oscReceiver;
            if (v4 != null) {
                it = v4;
                $i$a$-let-VRCOSCHandler$updateOscReceiver$1 = false;
                listener = (OSCMessageListener)LambdaMetafactory.metafactory(null, null, null, (Lcom/illposed/osc/OSCMessageEvent;)V, updateOscReceiver$lambda$2$lambda$1(dev.slimevr.osc.VRCOSCHandler com.illposed.osc.OSCMessageEvent ), (Lcom/illposed/osc/OSCMessageEvent;)V)((VRCOSCHandler)this);
                for (String address : args) {
                    it.getDispatcher().addListener(new OSCPatternAddressMessageSelector(address), listener);
                }
                it.startListening();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateOscSender(int portOut, @NotNull String ip) {
        Intrinsics.checkNotNullParameter(ip, "ip");
        if (this.oscSender == null) ** GOTO lbl-1000
        v0 = this.oscSender;
        Intrinsics.checkNotNull(v0);
        if (v0.isConnected()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = wasConnected = false;
        }
        if (wasConnected) {
            try {
                v2 = this.oscSender;
                Intrinsics.checkNotNull(v2);
                v2.close();
            }
            catch (IOException e) {
                LogManager.severe("[VRCOSCHandler] Error closing the OSC sender: " + e);
            }
        }
        if (this.config.getEnabled()) {
            try {
                addr = InetAddress.getByName(ip);
                this.oscSender = new OSCPortOut(new InetSocketAddress(addr, portOut));
                if (this.oscPortOut != portOut && !Intrinsics.areEqual(this.oscIp, addr) || !wasConnected) {
                    LogManager.info("[VRCOSCHandler] Sending to port " + portOut + " at address " + ip);
                }
                this.oscPortOut = portOut;
                this.oscIp = addr;
                v3 = this.oscSender;
                if (v3 != null) {
                    v3.connect();
                }
            }
            catch (IOException e) {
                LogManager.severe("[VRCOSCHandler] Error connecting to port " + portOut + " at the address " + ip + ": " + e);
                return;
            }
            if (this.oscQueryPortOut == portOut && (Intrinsics.areEqual(this.oscQueryIp, ip) || Intrinsics.areEqual(this.oscQueryIp, this.localIp) && Intrinsics.areEqual(ip, this.loopbackIp))) {
                if (this.oscQuerySender != null) {
                    this.closeOscQuerySender(true);
                }
            } else if (this.oscQuerySender == null && this.oscQuerySenderState) {
                v4 = this.oscQueryIp;
                Intrinsics.checkNotNull(v4);
                this.addOSCQuerySender(this.oscQueryPortOut, v4);
            }
        }
    }

    private final void handleReceivedMessage(OSCMessageEvent event) {
        block31: {
            Unit unit;
            block29: {
                Object object;
                TrackerPosition trackerPosition;
                if (!ArraysKt.contains(this.vrsystemTrackersAddresses, event.getMessage().getAddress())) break block29;
                if (this.vrsystemTrackersDevice == null) {
                    this.vrsystemTrackersDevice = this.server.deviceManager.createDevice("VRC VRSystem", null, "VRChat");
                    DeviceManager deviceManager = this.server.deviceManager;
                    Device device = this.vrsystemTrackersDevice;
                    Intrinsics.checkNotNull(device);
                    deviceManager.addDevice(device);
                }
                Object name = "VRChat ";
                String string = event.getMessage().getAddress();
                Intrinsics.checkNotNullExpressionValue(string, "getAddress(...)");
                Object object2 = new char[]{'/'};
                switch ((String)StringsKt.split$default((CharSequence)string, object2, false, 0, 6, null).get(3)) {
                    case "head": {
                        name = (String)name + "head";
                        trackerPosition = TrackerPosition.HEAD;
                        break;
                    }
                    case "leftwrist": {
                        name = (String)name + "left hand";
                        trackerPosition = TrackerPosition.LEFT_HAND;
                        break;
                    }
                    case "rightwrist": {
                        name = (String)name + "right hand";
                        trackerPosition = TrackerPosition.RIGHT_HAND;
                        break;
                    }
                    default: {
                        LogManager.warning("[VRCOSCHandler] Received invalid body part in message \"" + event.getMessage().getAddress() + "\"");
                        return;
                    }
                }
                TrackerPosition trackerPosition2 = trackerPosition;
                Device device = this.vrsystemTrackersDevice;
                Intrinsics.checkNotNull(device);
                Tracker tracker = device.getTrackers().get(trackerPosition2.ordinal());
                if (tracker == null) {
                    object2 = this.vrsystemTrackersDevice;
                    int n = VRServer.Companion.getNextLocalTrackerId();
                    Object object3 = name;
                    object = name;
                    int n2 = trackerPosition2.ordinal();
                    boolean bl = trackerPosition2 != TrackerPosition.HEAD;
                    tracker = new Tracker((Device)object2, n, (String)object3, (String)object, trackerPosition2, n2, true, true, false, true, false, true, null, true, false, bl, false, false, false, null, null, 2053376, null);
                    Device device2 = this.vrsystemTrackersDevice;
                    Intrinsics.checkNotNull(device2);
                    device2.getTrackers().put(trackerPosition2.ordinal(), tracker);
                    this.server.registerTracker(tracker);
                }
                tracker.setStatus(TrackerStatus.OK);
                Object object4 = event.getMessage().getArguments().get(0);
                Intrinsics.checkNotNull(object4, "null cannot be cast to non-null type kotlin.Float");
                float f = ((Float)object4).floatValue();
                Object object5 = event.getMessage().getArguments().get(1);
                Intrinsics.checkNotNull(object5, "null cannot be cast to non-null type kotlin.Float");
                float f2 = ((Float)object5).floatValue();
                Object object6 = event.getMessage().getArguments().get(2);
                Intrinsics.checkNotNull(object6, "null cannot be cast to non-null type kotlin.Float");
                float f3 = -((Float)object6).floatValue();
                Vector3.constructor-impl(f, f2, f3);
                tracker.setPosition-1s-5YWc(f, f2, f3);
                EulerOrder eulerOrder = EulerOrder.YXZ;
                Object object7 = event.getMessage().getArguments().get(3);
                Intrinsics.checkNotNull(object7, "null cannot be cast to non-null type kotlin.Float");
                float f4 = ((Float)object7).floatValue() * ((float)Math.PI / 180);
                Object object8 = event.getMessage().getArguments().get(4);
                Intrinsics.checkNotNull(object8, "null cannot be cast to non-null type kotlin.Float");
                float f5 = ((Float)object8).floatValue() * ((float)Math.PI / 180);
                Object object9 = event.getMessage().getArguments().get(5);
                Intrinsics.checkNotNull(object9, "null cannot be cast to non-null type kotlin.Float");
                float f6 = ((Float)object9).floatValue() * ((float)Math.PI / 180);
                EulerAngles.constructor-impl(eulerOrder, f4, f5, f6);
                object = EulerAngles.toQuaternion-impl(eulerOrder, f4, f5, f6);
                float f7 = ((Quaternion)object).unbox-impl-w();
                f4 = ((Quaternion)object).unbox-impl-x();
                f5 = ((Quaternion)object).unbox-impl-y();
                f6 = ((Quaternion)object).unbox-impl-z();
                float w = Quaternion.component1-impl(f7, f4, f5, f6);
                float x2 = Quaternion.component2-impl(f7, f4, f5, f6);
                float y2 = Quaternion.component3-impl(f7, f4, f5, f6);
                float z2 = Quaternion.component4-impl(f7, f4, f5, f6);
                float f8 = w;
                float f9 = -x2;
                float f10 = -y2;
                float f11 = z2;
                Quaternion.constructor-impl(f8, f9, f10, f11);
                tracker.setRotation-oS71L7k(f8, f9, f10, f11);
                tracker.dataTick();
                unit = Unit.INSTANCE;
                break block31;
            }
            if (this.oscTrackersDevice == null) {
                this.oscTrackersDevice = this.server.deviceManager.createDevice("OSC Tracker", null, "OSC Trackers");
                DeviceManager deviceManager = this.server.deviceManager;
                Device device = this.oscTrackersDevice;
                Intrinsics.checkNotNull(device);
                deviceManager.addDevice(device);
            }
            String string = event.getMessage().getAddress();
            Intrinsics.checkNotNullExpressionValue(string, "getAddress(...)");
            char[] trackerPosition2 = new char[]{'/'};
            List splitAddress = StringsKt.split$default((CharSequence)string, trackerPosition2, false, 0, 6, null);
            String trackerStringValue = (String)splitAddress.get(3);
            String string2 = event.getMessage().getAddress();
            Intrinsics.checkNotNullExpressionValue(string2, "getAddress(...)");
            Object object = new char[]{'/'};
            String dataType = (String)StringsKt.split$default((CharSequence)string2, object, false, 0, 6, null).get(4);
            if (Intrinsics.areEqual(trackerStringValue, "head")) {
                if (Intrinsics.areEqual(dataType, "position")) {
                    Object object10 = event.getMessage().getArguments().get(0);
                    Intrinsics.checkNotNull(object10, "null cannot be cast to non-null type kotlin.Float");
                    float f = ((Float)object10).floatValue();
                    Object object11 = event.getMessage().getArguments().get(1);
                    Intrinsics.checkNotNull(object11, "null cannot be cast to non-null type kotlin.Float");
                    float f12 = ((Float)object11).floatValue();
                    Object object12 = event.getMessage().getArguments().get(2);
                    Intrinsics.checkNotNull(object12, "null cannot be cast to non-null type kotlin.Float");
                    float f13 = -((Float)object12).floatValue();
                    Vector3.constructor-impl(f, f12, f13);
                    this.setReceivingPositionOffset-1s-5YWc(f, f12, f13);
                    Tracker tracker = this.headTracker;
                    if (tracker != null) {
                        Tracker it = tracker;
                        boolean bl = false;
                        if (it.getHasPosition()) {
                            this.setPostReceivingPositionOffset-1s-5YWc(it.getPosition-x(), it.getPosition-y(), it.getPosition-z());
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                } else {
                    float f;
                    float f14;
                    float f15;
                    float f16;
                    EulerOrder eulerOrder = EulerOrder.YXZ;
                    Object object13 = event.getMessage().getArguments().get(0);
                    Intrinsics.checkNotNull(object13, "null cannot be cast to non-null type kotlin.Float");
                    float f17 = ((Float)object13).floatValue() * ((float)Math.PI / 180);
                    Object object14 = event.getMessage().getArguments().get(1);
                    Intrinsics.checkNotNull(object14, "null cannot be cast to non-null type kotlin.Float");
                    float f18 = ((Float)object14).floatValue() * ((float)Math.PI / 180);
                    Object object15 = event.getMessage().getArguments().get(2);
                    Intrinsics.checkNotNull(object15, "null cannot be cast to non-null type kotlin.Float");
                    float f19 = ((Float)object15).floatValue() * ((float)Math.PI / 180);
                    EulerAngles.constructor-impl(eulerOrder, f17, f18, f19);
                    object = EulerAngles.toQuaternion-impl(eulerOrder, f17, f18, f19);
                    float f20 = object.unbox-impl-w();
                    f17 = object.unbox-impl-x();
                    f18 = object.unbox-impl-y();
                    f19 = object.unbox-impl-z();
                    float w = Quaternion.component1-impl(f20, f17, f18, f19);
                    float x = Quaternion.component2-impl(f20, f17, f18, f19);
                    float y = Quaternion.component3-impl(f20, f17, f18, f19);
                    float z = Quaternion.component4-impl(f20, f17, f18, f19);
                    float y2 = -x;
                    float z2 = -y;
                    Quaternion.constructor-impl(w, y2, z2, z);
                    Quaternion x2 = Quaternion.inv-impl(w, y2, z2, z);
                    this.setReceivingRotationOffsetGoal-oS71L7k(x2.unbox-impl-w(), x2.unbox-impl-x(), x2.unbox-impl-y(), x2.unbox-impl-z());
                    Tracker it = this.headTracker;
                    boolean bl = false;
                    if (it != null && it.getHasRotation()) {
                        Quaternion quaternion = it.getRotation();
                        Vector3.Companion companion = Vector3.Companion;
                        Quaternion quaternion2 = Quaternion.project-1s-5YWc(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z(), companion.getPOS_Y-x(), companion.getPOS_Y-y(), companion.getPOS_Y-z());
                        Quaternion quaternion3 = Quaternion.unit-impl(quaternion2.unbox-impl-w(), quaternion2.unbox-impl-x(), quaternion2.unbox-impl-y(), quaternion2.unbox-impl-z());
                        Quaternion quaternion4 = Quaternion.times-oS71L7k(quaternion3.unbox-impl-w(), quaternion3.unbox-impl-x(), quaternion3.unbox-impl-y(), quaternion3.unbox-impl-z(), this.receivingRotationOffsetGoal-w, this.receivingRotationOffsetGoal-x, this.receivingRotationOffsetGoal-y, this.receivingRotationOffsetGoal-z);
                        f16 = quaternion4.unbox-impl-w();
                        f15 = quaternion4.unbox-impl-x();
                        f14 = quaternion4.unbox-impl-y();
                        f = quaternion4.unbox-impl-z();
                        v24 = null;
                    } else {
                        f16 = this.receivingRotationOffsetGoal-w;
                        f15 = this.receivingRotationOffsetGoal-x;
                        f14 = this.receivingRotationOffsetGoal-y;
                        f = this.receivingRotationOffsetGoal-z;
                        v24 = null;
                    }
                    this.setReceivingRotationOffsetGoal-oS71L7k(f16, f15, f14, f);
                    if (System.currentTimeMillis() - this.timeAtLastReceivedRotationOffset > 300L) {
                        this.setReceivingRotationOffset-oS71L7k(this.receivingRotationOffsetGoal-w, this.receivingRotationOffsetGoal-x, this.receivingRotationOffsetGoal-y, this.receivingRotationOffsetGoal-z);
                    }
                    this.timeAtLastReceivedRotationOffset = System.currentTimeMillis();
                    unit = Unit.INSTANCE;
                }
            } else {
                Object object16;
                Object object17;
                Object object18;
                int trackerId = Integer.parseInt(trackerStringValue);
                Device device = this.oscTrackersDevice;
                Intrinsics.checkNotNull(device);
                Tracker tracker = device.getTrackers().get(trackerId);
                if (tracker == null) {
                    object18 = this.oscTrackersDevice;
                    int n = VRServer.Companion.getNextLocalTrackerId();
                    object17 = "OSC Tracker #" + trackerId;
                    String string3 = "OSC Tracker #" + trackerId;
                    tracker = new Tracker((Device)object18, n, (String)object17, string3, null, trackerId, true, true, false, true, false, true, null, true, false, true, false, false, false, null, null, 2053376, null);
                    object16 = trackerId;
                    Device device3 = this.oscTrackersDevice;
                    Intrinsics.checkNotNull(device3);
                    device3.getTrackers().put((Integer)object16, tracker);
                    this.server.registerTracker(tracker);
                }
                tracker.setStatus(TrackerStatus.OK);
                if (Intrinsics.areEqual(dataType, "position")) {
                    Object object19 = event.getMessage().getArguments().get(0);
                    Intrinsics.checkNotNull(object19, "null cannot be cast to non-null type kotlin.Float");
                    float f = ((Float)object19).floatValue();
                    Object object20 = event.getMessage().getArguments().get(1);
                    Intrinsics.checkNotNull(object20, "null cannot be cast to non-null type kotlin.Float");
                    float f21 = ((Float)object20).floatValue();
                    Object object21 = event.getMessage().getArguments().get(2);
                    Intrinsics.checkNotNull(object21, "null cannot be cast to non-null type kotlin.Float");
                    float y = -((Float)object21).floatValue();
                    Vector3.constructor-impl(f, f21, y);
                    object17 = Vector3.minus-1s-5YWc(f, f21, y, this.receivingPositionOffset-x, this.receivingPositionOffset-y, this.receivingPositionOffset-z);
                    object16 = Quaternion.sandwich-1s-5YWc(this.receivingRotationOffset-w, this.receivingRotationOffset-x, this.receivingRotationOffset-y, this.receivingRotationOffset-z, ((Vector3)object17).unbox-impl-x(), ((Vector3)object17).unbox-impl-y(), ((Vector3)object17).unbox-impl-z());
                    object18 = Vector3.plus-1s-5YWc(((Vector3)object16).unbox-impl-x(), ((Vector3)object16).unbox-impl-y(), ((Vector3)object16).unbox-impl-z(), this.postReceivingPositionOffset-x, this.postReceivingPositionOffset-y, this.postReceivingPositionOffset-z);
                    tracker.setPosition-1s-5YWc(((Vector3)object18).unbox-impl-x(), ((Vector3)object18).unbox-impl-y(), ((Vector3)object18).unbox-impl-z());
                } else {
                    object16 = EulerOrder.YXZ;
                    Object object22 = event.getMessage().getArguments().get(0);
                    Intrinsics.checkNotNull(object22, "null cannot be cast to non-null type kotlin.Float");
                    float f = ((Float)object22).floatValue() * ((float)Math.PI / 180);
                    Object object23 = event.getMessage().getArguments().get(1);
                    Intrinsics.checkNotNull(object23, "null cannot be cast to non-null type kotlin.Float");
                    float f22 = ((Float)object23).floatValue() * ((float)Math.PI / 180);
                    Object object24 = event.getMessage().getArguments().get(2);
                    Intrinsics.checkNotNull(object24, "null cannot be cast to non-null type kotlin.Float");
                    float f23 = ((Float)object24).floatValue() * ((float)Math.PI / 180);
                    EulerAngles.constructor-impl((EulerOrder)((Object)object16), f, f22, f23);
                    object18 = EulerAngles.toQuaternion-impl((EulerOrder)((Object)object16), f, f22, f23);
                    float f24 = ((Quaternion)object18).unbox-impl-w();
                    f = ((Quaternion)object18).unbox-impl-x();
                    f22 = ((Quaternion)object18).unbox-impl-y();
                    f23 = ((Quaternion)object18).unbox-impl-z();
                    float w = Quaternion.component1-impl(f24, f, f22, f23);
                    float x = Quaternion.component2-impl(f24, f, f22, f23);
                    float y = Quaternion.component3-impl(f24, f, f22, f23);
                    float z = Quaternion.component4-impl(f24, f, f22, f23);
                    float f25 = w;
                    float f26 = -x;
                    float f27 = -y;
                    float f28 = z;
                    Quaternion.constructor-impl(f25, f26, f27, f28);
                    Quaternion quaternion = Quaternion.times-oS71L7k(this.receivingRotationOffset-w, this.receivingRotationOffset-x, this.receivingRotationOffset-y, this.receivingRotationOffset-z, f25, f26, f27, f28);
                    Quaternion quaternion5 = Quaternion.times-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z(), this.postReceivingOffset-w, this.postReceivingOffset-x, this.postReceivingOffset-y, this.postReceivingOffset-z);
                    tracker.setRotation-oS71L7k(quaternion5.unbox-impl-w(), quaternion5.unbox-impl-x(), quaternion5.unbox-impl-y(), quaternion5.unbox-impl-z());
                }
                tracker.dataTick();
                unit = Unit.INSTANCE;
            }
        }
    }

    @Override
    public void update() {
        if (this.fpsTimer == null) {
            this.fpsTimer = VRServer.Companion.getInstance().getFpsTimer();
        }
        if (!Quaternion.equals-impl0(this.receivingRotationOffset-w, this.receivingRotationOffset-x, this.receivingRotationOffset-y, this.receivingRotationOffset-z, this.receivingRotationOffsetGoal-w, this.receivingRotationOffsetGoal-x, this.receivingRotationOffsetGoal-y, this.receivingRotationOffsetGoal-z)) {
            NanoTimer nanoTimer = this.fpsTimer;
            Quaternion quaternion = Quaternion.interpR-jCQAsEA(this.receivingRotationOffset-w, this.receivingRotationOffset-x, this.receivingRotationOffset-y, this.receivingRotationOffset-z, this.receivingRotationOffsetGoal-w, this.receivingRotationOffsetGoal-x, this.receivingRotationOffsetGoal-y, this.receivingRotationOffsetGoal-z, 0.5f * (nanoTimer != null ? nanoTimer.getTimePerFrame() : 1.0f));
            this.setReceivingRotationOffset-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
        }
        float currentTime = System.currentTimeMillis();
        if (this.oscSender != null) {
            OSCPortOut oSCPortOut = this.oscSender;
            Intrinsics.checkNotNull(oSCPortOut);
            if (oSCPortOut.isConnected()) {
                OSCBundle bundle = new OSCBundle();
                int n = ((Collection)this.computedTrackers).size();
                for (int i = 0; i < n; ++i) {
                    float z;
                    float y;
                    float x;
                    float f;
                    float f2;
                    float f3;
                    Tracker tracker;
                    if (this.trackersEnabled[i]) {
                        tracker = this.computedTrackers.get(i);
                        f3 = tracker.getPosition-x();
                        f2 = tracker.getPosition-y();
                        f = tracker.getPosition-z();
                        x = Vector3.component1-impl(f3, f2, f);
                        y = Vector3.component2-impl(f3, f2, f);
                        z = Vector3.component3-impl(f3, f2, f);
                        this.oscArgs.clear();
                        this.oscArgs.add(Float.valueOf(x));
                        this.oscArgs.add(Float.valueOf(y));
                        this.oscArgs.add(Float.valueOf(-z));
                        bundle.addPacket(new OSCMessage("/tracking/trackers/" + this.getVRCOSCTrackersId(this.computedTrackers.get(i).getTrackerPosition()) + "/position", (List)this.oscArgs.clone()));
                        Quaternion quaternion = this.computedTrackers.get(i).getRotation();
                        float f4 = quaternion.unbox-impl-w();
                        float f5 = quaternion.unbox-impl-x();
                        float f6 = quaternion.unbox-impl-y();
                        float f7 = quaternion.unbox-impl-z();
                        float w = Quaternion.component1-impl(f4, f5, f6, f7);
                        float x1 = Quaternion.component2-impl(f4, f5, f6, f7);
                        float y1 = Quaternion.component3-impl(f4, f5, f6, f7);
                        float z1 = Quaternion.component4-impl(f4, f5, f6, f7);
                        float f8 = -x1;
                        float f9 = -y1;
                        Quaternion.constructor-impl(w, f8, f9, z1);
                        EulerAngles eulerAngles = Quaternion.toEulerAngles-impl(w, f8, f9, z1, EulerOrder.YXZ);
                        EulerOrder eulerOrder = eulerAngles.unbox-impl-order();
                        f9 = eulerAngles.unbox-impl-x();
                        float f10 = eulerAngles.unbox-impl-y();
                        float f11 = eulerAngles.unbox-impl-z();
                        float x2 = EulerAngles.component2-impl(eulerOrder, f9, f10, f11);
                        float y2 = EulerAngles.component3-impl(eulerOrder, f9, f10, f11);
                        float z2 = EulerAngles.component4-impl(eulerOrder, f9, f10, f11);
                        this.oscArgs.clear();
                        this.oscArgs.add(Float.valueOf(x2 * 57.295776f));
                        this.oscArgs.add(Float.valueOf(y2 * 57.295776f));
                        this.oscArgs.add(Float.valueOf(z2 * 57.295776f));
                        bundle.addPacket(new OSCMessage("/tracking/trackers/" + this.getVRCOSCTrackersId(this.computedTrackers.get(i).getTrackerPosition()) + "/rotation", (List)this.oscArgs.clone()));
                    }
                    if (this.computedTrackers.get(i).getTrackerPosition() != TrackerPosition.HEAD) continue;
                    tracker = this.computedTrackers.get(i);
                    f3 = tracker.getPosition-x();
                    f2 = tracker.getPosition-y();
                    f = tracker.getPosition-z();
                    x = Vector3.component1-impl(f3, f2, f);
                    y = Vector3.component2-impl(f3, f2, f);
                    z = Vector3.component3-impl(f3, f2, f);
                    this.oscArgs.clear();
                    this.oscArgs.add(Float.valueOf(x));
                    this.oscArgs.add(Float.valueOf(y));
                    this.oscArgs.add(Float.valueOf(-z));
                    bundle.addPacket(new OSCMessage("/tracking/trackers/head/position", (List)this.oscArgs.clone()));
                }
                try {
                    Unit unit;
                    OSCPortOut oSCPortOut2 = this.oscSender;
                    if (oSCPortOut2 != null) {
                        oSCPortOut2.send(bundle);
                    }
                    OSCPortOut oSCPortOut3 = this.oscQuerySender;
                    if (oSCPortOut3 != null) {
                        oSCPortOut3.send(bundle);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                catch (IOException e) {
                    if (currentTime - (float)this.timeAtLastError > 100.0f) {
                        this.timeAtLastError = System.currentTimeMillis();
                        LogManager.warning("[VRCOSCHandler] Error sending OSC message to VRChat: " + e);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (OSCSerializeException e) {
                    if (currentTime - (float)this.timeAtLastError > 100.0f) {
                        this.timeAtLastError = System.currentTimeMillis();
                        LogManager.warning("[VRCOSCHandler] Error sending OSC message to VRChat: " + e);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }

    private final int getVRCOSCTrackersId(TrackerPosition trackerPosition) {
        TrackerPosition trackerPosition2 = trackerPosition;
        return switch (trackerPosition2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[trackerPosition2.ordinal()]) {
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
            case 4 -> 4;
            case 5 -> 5;
            case 6 -> 6;
            case 7 -> 7;
            case 8 -> 8;
            default -> -1;
        };
    }

    public final void setHeadTracker(@Nullable Tracker headTracker) {
        this.headTracker = headTracker;
    }

    public final void yawAlign-oS71L7k(float f, float f2, float f3, float f4) {
        if (this.oscSender != null) {
            OSCPortOut oSCPortOut = this.oscSender;
            Intrinsics.checkNotNull(oSCPortOut);
            if (oSCPortOut.isConnected()) {
                EulerAngles eulerAngles = Quaternion.toEulerAngles-impl(f, f2, f3, f4, EulerOrder.YXZ);
                EulerOrder eulerOrder = eulerAngles.unbox-impl-order();
                float f5 = eulerAngles.unbox-impl-x();
                float f6 = eulerAngles.unbox-impl-y();
                float f7 = eulerAngles.unbox-impl-z();
                float y = EulerAngles.component3-impl(eulerOrder, f5, f6, f7);
                this.oscArgs.clear();
                this.oscArgs.add(Float.valueOf(0.0f));
                this.oscArgs.add(Float.valueOf(-y * 57.295776f));
                this.oscArgs.add(Float.valueOf(0.0f));
                this.oscMessage = new OSCMessage("/tracking/trackers/head/rotation", (List)this.oscArgs);
                try {
                    Unit unit;
                    OSCPortOut oSCPortOut2 = this.oscSender;
                    if (oSCPortOut2 != null) {
                        oSCPortOut2.send(this.oscMessage);
                    }
                    OSCPortOut oSCPortOut3 = this.oscQuerySender;
                    if (oSCPortOut3 != null) {
                        oSCPortOut3.send(this.oscMessage);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                catch (IOException e) {
                    LogManager.warning("[VRCOSCHandler] Error sending OSC message to VRChat: " + e);
                    Unit unit = Unit.INSTANCE;
                }
                catch (OSCSerializeException e) {
                    LogManager.warning("[VRCOSCHandler] Error sending OSC message to VRChat: " + e);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }

    @Override
    @NotNull
    public OSCPortOut getOscSender() {
        OSCPortOut oSCPortOut = this.oscSender;
        Intrinsics.checkNotNull(oSCPortOut);
        return oSCPortOut;
    }

    @Override
    public int getPortOut() {
        return this.oscPortOut;
    }

    @Override
    @NotNull
    public InetAddress getAddress() {
        InetAddress inetAddress = this.oscIp;
        Intrinsics.checkNotNull(inetAddress);
        return inetAddress;
    }

    @Override
    @NotNull
    public OSCPortIn getOscReceiver() {
        OSCPortIn oSCPortIn = this.oscReceiver;
        Intrinsics.checkNotNull(oSCPortIn);
        return oSCPortIn;
    }

    @Override
    public int getPortIn() {
        return this.oscPortIn;
    }

    public final /* synthetic */ float getReceivingPositionOffset-x() {
        return this.receivingPositionOffset-x;
    }

    public final /* synthetic */ float getReceivingPositionOffset-y() {
        return this.receivingPositionOffset-y;
    }

    public final /* synthetic */ float getReceivingPositionOffset-z() {
        return this.receivingPositionOffset-z;
    }

    public final /* synthetic */ float getPostReceivingPositionOffset-x() {
        return this.postReceivingPositionOffset-x;
    }

    public final /* synthetic */ float getPostReceivingPositionOffset-y() {
        return this.postReceivingPositionOffset-y;
    }

    public final /* synthetic */ float getPostReceivingPositionOffset-z() {
        return this.postReceivingPositionOffset-z;
    }

    public final /* synthetic */ float getReceivingRotationOffset-w() {
        return this.receivingRotationOffset-w;
    }

    public final /* synthetic */ float getReceivingRotationOffset-x() {
        return this.receivingRotationOffset-x;
    }

    public final /* synthetic */ float getReceivingRotationOffset-y() {
        return this.receivingRotationOffset-y;
    }

    public final /* synthetic */ float getReceivingRotationOffset-z() {
        return this.receivingRotationOffset-z;
    }

    public final /* synthetic */ float getReceivingRotationOffsetGoal-w() {
        return this.receivingRotationOffsetGoal-w;
    }

    public final /* synthetic */ float getReceivingRotationOffsetGoal-x() {
        return this.receivingRotationOffsetGoal-x;
    }

    public final /* synthetic */ float getReceivingRotationOffsetGoal-y() {
        return this.receivingRotationOffsetGoal-y;
    }

    public final /* synthetic */ float getReceivingRotationOffsetGoal-z() {
        return this.receivingRotationOffsetGoal-z;
    }

    public final /* synthetic */ float getPostReceivingOffset-w() {
        return this.postReceivingOffset-w;
    }

    public final /* synthetic */ float getPostReceivingOffset-x() {
        return this.postReceivingOffset-x;
    }

    public final /* synthetic */ float getPostReceivingOffset-y() {
        return this.postReceivingOffset-y;
    }

    public final /* synthetic */ float getPostReceivingOffset-z() {
        return this.postReceivingOffset-z;
    }

    private static final void updateOscReceiver$lambda$2$lambda$1(VRCOSCHandler this$0, OSCMessageEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this$0.handleReceivedMessage(event);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackerPosition.values().length];
            try {
                nArray[TrackerPosition.HIP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_FOOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_FOOT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_UPPER_LEG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_UPPER_LEG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.UPPER_CHEST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_UPPER_ARM.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_UPPER_ARM.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

