/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.osc;

import dev.slimevr.osc.VRCOSCHandler;
import dev.slimevr.protocol.rpc.setup.RPCUtil;
import io.eiren.util.logging.LogManager;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/slimevr/osc/VRCOSCQueryHandler;", "", "vrcOscHandler", "Ldev/slimevr/osc/VRCOSCHandler;", "<init>", "(Ldev/slimevr/osc/VRCOSCHandler;)V", "oscQueryServer", "LOSCQueryServer;", "updateOSCQuery", "", "port", "Lkotlin/UShort;", "updateOSCQuery-xj2QHRw", "(S)V", "serviceAdded", "info", "LServiceInfo;", "close", "core"})
public final class VRCOSCQueryHandler {
    @NotNull
    private final VRCOSCHandler vrcOscHandler;
    @NotNull
    private final OSCQueryServer oscQueryServer;

    public VRCOSCQueryHandler(@NotNull VRCOSCHandler vrcOscHandler) {
        Intrinsics.checkNotNullParameter(vrcOscHandler, "vrcOscHandler");
        this.vrcOscHandler = vrcOscHandler;
        String string = RPCUtil.getLocalIp();
        if (string == null) {
            throw new IllegalStateException("No local IP address found for OSCQuery to bind to");
        }
        String localIp = string;
        short httpPort = OSCQueryServer_jvmKt.randomFreePort();
        this.oscQueryServer = new OSCQueryServer("SlimeVR-Server-" + UShort.toString-impl(httpPort), OscTransport.UDP, localIp, UShort.constructor-impl((short)this.vrcOscHandler.getPortIn()), httpPort, null);
        this.oscQueryServer.getRootNode().addNode(new OSCQueryNode("/tracking/vrsystem", null, null, 6, null));
        this.oscQueryServer.init();
        LogManager.info("[VRCOSCQueryHandler] SlimeVR OSCQueryServer started at http://" + localIp + ":" + UShort.toString-impl(httpPort));
        try {
            LogManager.info("[VRCOSCQueryHandler] Listening for VRChat OSCQuery");
            OSCQueryService.addServiceListener-sWB21E4$default(this.oscQueryServer.getService(), "_osc._udp.local.", null, new Function1<ServiceInfo, Unit>((Object)this){

                @Override
                public final void invoke(ServiceInfo p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    ((VRCOSCQueryHandler)this.receiver).serviceAdded(p0);
                }
            }, null, 10, null);
        }
        catch (IOException e) {
            LogManager.warning("[VRCOSCQueryHandler] " + e.getMessage());
        }
    }

    public final void updateOSCQuery-xj2QHRw(short port2) {
        if (this.oscQueryServer.getOscPort-Mh2AYeg() != port2) {
            ThreadsKt.thread$default(true, false, null, null, 0, () -> VRCOSCQueryHandler.updateOSCQuery_xj2QHRw$lambda$0(this, port2), 30, null);
        }
    }

    private final void serviceAdded(ServiceInfo info) {
        if (!StringsKt.startsWith$default(info.getName(), "VRChat-Client", false, 2, null)) {
            return;
        }
        String ip = info.getInetAddresses()[0].getHostAddress();
        int port2 = info.getPort();
        Intrinsics.checkNotNull(ip);
        this.vrcOscHandler.addOSCQuerySender(port2, ip);
    }

    public final void close() {
        this.vrcOscHandler.closeOscQuerySender(false);
        ThreadsKt.thread$default(true, false, null, null, 0, () -> VRCOSCQueryHandler.close$lambda$1(this), 30, null);
    }

    private static final Unit updateOSCQuery_xj2QHRw$lambda$0(VRCOSCQueryHandler this$0, short $port) {
        this$0.oscQueryServer.updateOscService-xj2QHRw($port);
        return Unit.INSTANCE;
    }

    private static final Unit close$lambda$1(VRCOSCQueryHandler this$0) {
        this$0.oscQueryServer.close();
        return Unit.INSTANCE;
    }
}

