/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.poseframeformat;

import dev.slimevr.poseframeformat.PoseFrames;
import dev.slimevr.poseframeformat.trackerdata.TrackerFrame;
import dev.slimevr.poseframeformat.trackerdata.TrackerFrameData;
import dev.slimevr.poseframeformat.trackerdata.TrackerFrames;
import dev.slimevr.tracking.trackers.TrackerPosition;
import io.eiren.util.collections.FastList;
import io.eiren.util.logging.LogManager;
import io.github.axisangles.ktmath.Quaternion;
import io.github.axisangles.ktmath.Vector3;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010#\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010$\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010%\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001b\u00a8\u0006&"}, d2={"Ldev/slimevr/poseframeformat/PfrIO;", "", "<init>", "()V", "writeVector3f", "", "outputStream", "Ljava/io/DataOutputStream;", "vector", "Lio/github/axisangles/ktmath/Vector3;", "writeVector3f-mSee1rQ", "(Ljava/io/DataOutputStream;FFF)V", "writeQuaternion", "quaternion", "Lio/github/axisangles/ktmath/Quaternion;", "writeQuaternion-Piknhcc", "(Ljava/io/DataOutputStream;FFFF)V", "writeFrame", "trackerFrame", "Ldev/slimevr/poseframeformat/trackerdata/TrackerFrame;", "writeFrames", "frames", "Ldev/slimevr/poseframeformat/PoseFrames;", "tryWriteFrames", "", "writeToFile", "file", "Ljava/io/File;", "tryWriteToFile", "readVector3f", "inputStream", "Ljava/io/DataInputStream;", "readQuaternion", "readFrame", "readFrames", "tryReadFrames", "readFromFile", "tryReadFromFile", "core"})
@SourceDebugExtension(value={"SMAP\nPfrIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PfrIO.kt\ndev/slimevr/poseframeformat/PfrIO\n+ 2 TrackerFrameData.kt\ndev/slimevr/poseframeformat/trackerdata/TrackerFrameData\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n22#2:192\n20#2:193\n18#2:194\n18#2:196\n18#2:197\n18#2:198\n18#2:199\n18#2:200\n18#2:201\n1#3:195\n*S KotlinDebug\n*F\n+ 1 PfrIO.kt\ndev/slimevr/poseframeformat/PfrIO\n*L\n49#1:192\n49#1:193\n58#1:194\n124#1:196\n128#1:197\n132#1:198\n135#1:199\n140#1:200\n144#1:201\n*E\n"})
public final class PfrIO {
    @NotNull
    public static final PfrIO INSTANCE = new PfrIO();

    private PfrIO() {
    }

    private final void writeVector3f-mSee1rQ(DataOutputStream outputStream2, float f, float f2, float f3) throws IOException {
        outputStream2.writeFloat(f);
        outputStream2.writeFloat(f2);
        outputStream2.writeFloat(f3);
    }

    private final void writeQuaternion-Piknhcc(DataOutputStream outputStream2, float f, float f2, float f3, float f4) throws IOException {
        outputStream2.writeFloat(f2);
        outputStream2.writeFloat(f3);
        outputStream2.writeFloat(f4);
        outputStream2.writeFloat(f);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeFrame(@NotNull DataOutputStream outputStream2, @Nullable TrackerFrame trackerFrame) {
        Object this_$iv;
        Object object;
        Intrinsics.checkNotNullParameter(outputStream2, "outputStream");
        if (trackerFrame == null) {
            outputStream2.writeInt(0);
            return;
        }
        int dataFlags = trackerFrame.getDataFlags();
        if (trackerFrame.hasData(TrackerFrameData.DESIGNATION_STRING)) {
            void dataFlags$iv;
            object = TrackerFrameData.TRACKER_POSITION_ENUM;
            TrackerFrameData this_$iv22 = TrackerFrameData.DESIGNATION_STRING;
            boolean $i$f$remove = false;
            int this_$iv22 = dataFlags ^ this_$iv22.getFlag();
            boolean $i$f$add = false;
            dataFlags = dataFlags$iv | ((TrackerFrameData)((Object)this_$iv)).getFlag();
        }
        outputStream2.writeInt(dataFlags);
        if (trackerFrame.hasData(TrackerFrameData.ROTATION)) {
            Quaternion quaternion = trackerFrame.getRotation();
            Intrinsics.checkNotNull(quaternion);
            this_$iv = quaternion;
            this.writeQuaternion-Piknhcc(outputStream2, ((Quaternion)this_$iv).unbox-impl-w(), ((Quaternion)this_$iv).unbox-impl-x(), ((Quaternion)this_$iv).unbox-impl-y(), ((Quaternion)this_$iv).unbox-impl-z());
        }
        if (trackerFrame.hasData(TrackerFrameData.POSITION)) {
            Vector3 vector3 = trackerFrame.getPosition();
            Intrinsics.checkNotNull(vector3);
            this_$iv = vector3;
            this.writeVector3f-mSee1rQ(outputStream2, ((Vector3)this_$iv).unbox-impl-x(), ((Vector3)this_$iv).unbox-impl-y(), ((Vector3)this_$iv).unbox-impl-z());
        }
        this_$iv = TrackerFrameData.TRACKER_POSITION_ENUM;
        boolean $i$f$check = false;
        if ((dataFlags & ((TrackerFrameData)((Object)this_$iv)).getFlag()) != 0) {
            TrackerPosition trackerPosition = trackerFrame.getTrackerPosition();
            Intrinsics.checkNotNull((Object)trackerPosition);
            outputStream2.writeInt(trackerPosition.getId() - 1);
        }
        if (trackerFrame.hasData(TrackerFrameData.ACCELERATION)) {
            Vector3 vector3 = trackerFrame.getAcceleration();
            Intrinsics.checkNotNull(vector3);
            object = vector3;
            this.writeVector3f-mSee1rQ(outputStream2, ((Vector3)object).unbox-impl-x(), ((Vector3)object).unbox-impl-y(), ((Vector3)object).unbox-impl-z());
        }
        if (trackerFrame.hasData(TrackerFrameData.RAW_ROTATION)) {
            Quaternion quaternion = trackerFrame.getRawRotation();
            Intrinsics.checkNotNull(quaternion);
            object = quaternion;
            this.writeQuaternion-Piknhcc(outputStream2, ((Quaternion)object).unbox-impl-w(), ((Quaternion)object).unbox-impl-x(), ((Quaternion)object).unbox-impl-y(), ((Quaternion)object).unbox-impl-z());
        }
    }

    public final void writeFrames(@NotNull DataOutputStream outputStream2, @NotNull PoseFrames frames) {
        Intrinsics.checkNotNullParameter(outputStream2, "outputStream");
        Intrinsics.checkNotNullParameter(frames, "frames");
        outputStream2.writeInt(frames.getFrameHolders().size());
        Iterator iterator2 = frames.getFrameHolders().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            TrackerFrames tracker = (TrackerFrames)iterator3.next();
            outputStream2.writeUTF(tracker.getName());
            outputStream2.writeInt(tracker.getFrames().size());
            int n = tracker.getFrames().size();
            for (int i = 0; i < n; ++i) {
                this.writeFrame(outputStream2, tracker.tryGetFrame(i));
            }
        }
    }

    public final boolean tryWriteFrames(@NotNull DataOutputStream outputStream2, @NotNull PoseFrames frames) {
        boolean bl;
        Intrinsics.checkNotNullParameter(outputStream2, "outputStream");
        Intrinsics.checkNotNullParameter(frames, "frames");
        try {
            this.writeFrames(outputStream2, frames);
            bl = true;
        }
        catch (Exception e) {
            LogManager.severe("Error writing frame to stream.", e);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToFile(@NotNull File file, @NotNull PoseFrames frames) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(frames, "frames");
        Closeable closeable = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        Throwable throwable = null;
        try {
            DataOutputStream it = (DataOutputStream)closeable;
            boolean bl = false;
            INSTANCE.writeFrames(it, frames);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public final boolean tryWriteToFile(@NotNull File file, @NotNull PoseFrames frames) {
        boolean bl;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(frames, "frames");
        try {
            this.writeToFile(file, frames);
            bl = true;
        }
        catch (Exception e) {
            LogManager.severe("Error writing frames to file.", e);
            bl = false;
        }
        return bl;
    }

    private final Vector3 readVector3f(DataInputStream inputStream2) throws IOException {
        float f = inputStream2.readFloat();
        float f2 = inputStream2.readFloat();
        float f3 = inputStream2.readFloat();
        Vector3.constructor-impl(f, f2, f3);
        return Vector3.box-impl(f, f2, f3);
    }

    private final Quaternion readQuaternion(DataInputStream inputStream2) throws IOException {
        float w;
        float x = inputStream2.readFloat();
        float y = inputStream2.readFloat();
        float z = inputStream2.readFloat();
        float f = w = inputStream2.readFloat();
        float f2 = x;
        float f3 = y;
        float f4 = z;
        Quaternion.constructor-impl(f, f2, f3, f4);
        return Quaternion.box-impl(f, f2, f3, f4);
    }

    @NotNull
    public final TrackerFrame readFrame(@NotNull DataInputStream inputStream2) {
        Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
        int dataFlags = inputStream2.readInt();
        TrackerPosition designation = null;
        TrackerFrameData this_$iv = TrackerFrameData.DESIGNATION_STRING;
        boolean $i$f$check = false;
        if ((dataFlags & this_$iv.getFlag()) != 0) {
            String string = inputStream2.readUTF();
            Intrinsics.checkNotNullExpressionValue(string, "readUTF(...)");
            designation = TrackerPosition.Companion.getByDesignation(string);
        }
        Quaternion rotation = null;
        TrackerFrameData this_$iv2 = TrackerFrameData.ROTATION;
        boolean $i$f$check2 = false;
        if ((dataFlags & this_$iv2.getFlag()) != 0) {
            rotation = this.readQuaternion(inputStream2);
        }
        Vector3 position = null;
        TrackerFrameData this_$iv3 = TrackerFrameData.POSITION;
        boolean $i$f$check3 = false;
        if ((dataFlags & this_$iv3.getFlag()) != 0) {
            position = this.readVector3f(inputStream2);
        }
        this_$iv3 = TrackerFrameData.TRACKER_POSITION_ENUM;
        $i$f$check3 = false;
        if ((dataFlags & this_$iv3.getFlag()) != 0) {
            designation = TrackerPosition.Companion.getById(inputStream2.readInt() + 1);
        }
        Vector3 acceleration = null;
        TrackerFrameData this_$iv4 = TrackerFrameData.ACCELERATION;
        boolean $i$f$check4 = false;
        if ((dataFlags & this_$iv4.getFlag()) != 0) {
            acceleration = this.readVector3f(inputStream2);
        }
        Quaternion rawRotation = null;
        TrackerFrameData this_$iv5 = TrackerFrameData.RAW_ROTATION;
        boolean $i$f$check5 = false;
        if ((dataFlags & this_$iv5.getFlag()) != 0) {
            rawRotation = this.readQuaternion(inputStream2);
        }
        return new TrackerFrame(designation, rotation, position, acceleration, rawRotation, null);
    }

    @NotNull
    public final PoseFrames readFrames(@NotNull DataInputStream inputStream2) {
        Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
        int trackerCount = inputStream2.readInt();
        FastList<int> trackers = new FastList<int>(trackerCount);
        for (int i = 0; i < trackerCount; ++i) {
            String name = inputStream2.readUTF();
            int trackerFrameCount = inputStream2.readInt();
            FastList<int> trackerFrames = new FastList<int>(trackerFrameCount);
            for (int j = 0; j < trackerFrameCount; ++j) {
                trackerFrames.add((int)this.readFrame(inputStream2));
            }
            Intrinsics.checkNotNull(name);
            trackers.add((int)new TrackerFrames(name, trackerFrames));
        }
        return new PoseFrames(trackers);
    }

    @Nullable
    public final PoseFrames tryReadFrames(@NotNull DataInputStream inputStream2) {
        PoseFrames poseFrames;
        Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
        try {
            poseFrames = this.readFrames(inputStream2);
        }
        catch (Exception e) {
            LogManager.severe("Error reading frames from stream.", e);
            poseFrames = null;
        }
        return poseFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final PoseFrames readFromFile(@NotNull File file) {
        PoseFrames poseFrames;
        Intrinsics.checkNotNullParameter(file, "file");
        Closeable closeable = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        Throwable throwable = null;
        try {
            DataInputStream it = (DataInputStream)closeable;
            boolean bl = false;
            poseFrames = INSTANCE.readFrames(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return poseFrames;
    }

    @Nullable
    public final PoseFrames tryReadFromFile(@NotNull File file) {
        PoseFrames poseFrames;
        Intrinsics.checkNotNullParameter(file, "file");
        try {
            poseFrames = this.readFromFile(file);
        }
        catch (Exception e) {
            LogManager.severe("Error reading frames from file.", e);
            poseFrames = null;
        }
        return poseFrames;
    }
}

