/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.poseframeformat;

import dev.slimevr.config.SkeletonConfig;
import dev.slimevr.poseframeformat.PfrIO;
import dev.slimevr.poseframeformat.PfsPackets;
import dev.slimevr.poseframeformat.PoseFrames;
import dev.slimevr.poseframeformat.trackerdata.TrackerFrame;
import dev.slimevr.poseframeformat.trackerdata.TrackerFrames;
import io.eiren.util.logging.LogManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018J*\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00182\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020$0#J\u000e\u0010%\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020 J\u0010\u0010&\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0006\u001a\u00020 J\u000e\u0010'\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010(\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u001d\u00a8\u0006)"}, d2={"Ldev/slimevr/poseframeformat/PfsIO;", "", "<init>", "()V", "writeRecordingDef", "", "stream", "Ljava/io/DataOutputStream;", "frameInterval", "", "writeTrackerDef", "id", "", "name", "", "writeTrackerFrame", "frameIndex", "frame", "Ldev/slimevr/poseframeformat/trackerdata/TrackerFrame;", "writeBodyProportions", "skeletonConfig", "Ldev/slimevr/config/SkeletonConfig;", "writeFrames", "frames", "Ldev/slimevr/poseframeformat/PoseFrames;", "tryWriteFrames", "", "writeToFile", "file", "Ljava/io/File;", "tryWriteToFile", "readFrame", "Ljava/io/DataInputStream;", "poseFrames", "trackers", "", "Ldev/slimevr/poseframeformat/trackerdata/TrackerFrames;", "readFrames", "tryReadFrames", "readFromFile", "tryReadFromFile", "core"})
@SourceDebugExtension(value={"SMAP\nPfsIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PfsIO.kt\ndev/slimevr/poseframeformat/PfsIO\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,199:1\n1567#2:200\n1598#2,4:201\n1#3:205\n381#4,7:206\n381#4,7:213\n*S KotlinDebug\n*F\n+ 1 PfsIO.kt\ndev/slimevr/poseframeformat/PfsIO\n*L\n57#1:200\n57#1:201,4\n122#1:206,7\n129#1:213,7\n*E\n"})
public final class PfsIO {
    @NotNull
    public static final PfsIO INSTANCE = new PfsIO();

    private PfsIO() {
    }

    private final void writeRecordingDef(DataOutputStream stream, float frameInterval) {
        stream.writeByte(PfsPackets.RECORDING_DEFINITION.getId());
        stream.writeFloat(frameInterval);
    }

    private final void writeTrackerDef(DataOutputStream stream, int id, String name) {
        stream.writeByte(PfsPackets.TRACKER_DEFINITION.getId());
        stream.writeByte(id);
        stream.writeUTF(name);
    }

    private final void writeTrackerFrame(DataOutputStream stream, int id, int frameIndex, TrackerFrame frame) {
        stream.writeByte(PfsPackets.TRACKER_FRAME.getId());
        stream.writeByte(id);
        stream.writeInt(frameIndex);
        PfrIO.INSTANCE.writeFrame(stream, frame);
    }

    private final void writeBodyProportions(DataOutputStream stream, SkeletonConfig skeletonConfig) {
        stream.writeByte(PfsPackets.PROPORTIONS_CONFIG.getId());
        stream.writeFloat(skeletonConfig.getHmdHeight());
        stream.writeFloat(skeletonConfig.getFloorHeight());
        stream.writeShort(skeletonConfig.offsets.size());
        Map<String, Float> map = skeletonConfig.offsets;
        Intrinsics.checkNotNullExpressionValue(map, "offsets");
        for (Map.Entry<String, Float> entry : map.entrySet()) {
            String key2 = entry.getKey();
            Float value = entry.getValue();
            stream.writeUTF(key2);
            Intrinsics.checkNotNull(value);
            stream.writeFloat(value.floatValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeFrames(@NotNull DataOutputStream stream, @NotNull PoseFrames frames) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(frames, "frames");
        Iterable $this$mapIndexed$iv = frames.getFrameHolders();
        boolean $i$f$mapIndexed = false;
        Object object = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void t;
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TrackerFrames trackerFrames = (TrackerFrames)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((int)i, t));
        }
        List trackers = (List)destination$iv$iv;
        this.writeRecordingDef(stream, frames.getFrameInterval());
        for (Pair tracker : trackers) {
            this.writeTrackerDef(stream, ((Number)tracker.getFirst()).intValue(), ((TrackerFrames)tracker.getSecond()).getName());
        }
        int n = frames.getMaxFrameCount();
        for (int i = 0; i < n; ++i) {
            for (Pair tracker : trackers) {
                TrackerFrame frame = ((TrackerFrames)tracker.getSecond()).tryGetFrame(i);
                if (frame == null) continue;
                this.writeTrackerFrame(stream, ((Number)tracker.getFirst()).intValue(), i, frame);
            }
        }
    }

    public final boolean tryWriteFrames(@NotNull DataOutputStream stream, @NotNull PoseFrames frames) {
        boolean bl;
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(frames, "frames");
        try {
            this.writeFrames(stream, frames);
            bl = true;
        }
        catch (Exception e) {
            LogManager.severe("[PfsIO] Error writing frame to stream.", e);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToFile(@NotNull File file, @NotNull PoseFrames frames) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(frames, "frames");
        Closeable closeable = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        Throwable throwable = null;
        try {
            DataOutputStream it = (DataOutputStream)closeable;
            boolean bl = false;
            INSTANCE.writeFrames(it, frames);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public final boolean tryWriteToFile(@NotNull File file, @NotNull PoseFrames frames) {
        boolean bl;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(frames, "frames");
        try {
            this.writeToFile(file, frames);
            bl = true;
        }
        catch (Exception e) {
            LogManager.severe("[PfsIO] Error writing frames to file.", e);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void readFrame(@NotNull DataInputStream stream, @NotNull PoseFrames poseFrames, @NotNull Map<Integer, TrackerFrames> trackers) {
        PfsPackets packetType;
        Intrinsics.checkNotNullParameter(stream, "stream");
        Intrinsics.checkNotNullParameter(poseFrames, "poseFrames");
        Intrinsics.checkNotNullParameter(trackers, "trackers");
        int packetId = stream.readUnsignedByte();
        PfsPackets pfsPackets = packetType = PfsPackets.Companion.getById().get(packetId);
        switch (pfsPackets == null ? -1 : WhenMappings.$EnumSwitchMapping$0[pfsPackets.ordinal()]) {
            case -1: {
                throw new IOException("Encountered unknown packet ID (" + packetId + ") while deserializing PFS stream.");
            }
            case 1: {
                float frameInterval = stream.readFloat();
                poseFrames.setFrameInterval(frameInterval);
                LogManager.debug("[PfsIO] Frame interval: " + frameInterval + " s");
                break;
            }
            case 2: {
                Object object;
                void $this$getOrPut$iv;
                int trackerId = stream.readUnsignedByte();
                String name = stream.readUTF();
                Map<Integer, TrackerFrames> map = trackers;
                Integer key$iv = trackerId;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Intrinsics.checkNotNull(name);
                    TrackerFrames answer$iv = new TrackerFrames(name, 0, 2, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((TrackerFrames)object).setName(name);
                break;
            }
            case 3: {
                TrackerFrames trackerFrames;
                int trackerId = stream.readUnsignedByte();
                Map<Integer, TrackerFrames> $this$getOrPut$iv = trackers;
                Integer key$iv = trackerId;
                boolean $i$f$getOrPut = false;
                TrackerFrames value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    TrackerFrames answer$iv = new TrackerFrames(null, 0, 3, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    trackerFrames = answer$iv;
                } else {
                    trackerFrames = value$iv;
                }
                TrackerFrames tracker = trackerFrames;
                int frameNum = stream.readInt();
                TrackerFrame frame = PfrIO.INSTANCE.readFrame(stream);
                tracker.getFrames().add(frameNum, frame);
                break;
            }
            case 4: {
                float hmdHeight = stream.readFloat();
                float floorHeight = stream.readFloat();
                LogManager.debug("[PfsIO] HMD height: " + hmdHeight + ", Floor height: " + floorHeight);
                int configCount = stream.readUnsignedShort();
                StringBuilder sb = new StringBuilder("[PfsIO] Body proportion configs (" + configCount + "): {");
                for (int i = 0; i < configCount; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(stream.readUTF());
                    sb.append(": ");
                    sb.append(stream.readFloat());
                }
                sb.append('}');
                LogManager.debug(sb.toString());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final PoseFrames readFrames(@NotNull DataInputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        PoseFrames poseFrames = new PoseFrames(0, 1, null);
        Map trackers = new LinkedHashMap();
        while (true) {
            try {
                this.readFrame(stream, poseFrames, trackers);
            }
            catch (EOFException eOFException) {
                poseFrames.getFrameHolders().addAll(trackers.values());
                return poseFrames;
            }
        }
    }

    @Nullable
    public final PoseFrames tryReadFrames(@NotNull DataInputStream stream) {
        PoseFrames poseFrames;
        Intrinsics.checkNotNullParameter(stream, "stream");
        try {
            poseFrames = this.readFrames(stream);
        }
        catch (Exception e) {
            LogManager.severe("[PfsIO] Error reading frames from stream.", e);
            poseFrames = null;
        }
        return poseFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final PoseFrames readFromFile(@NotNull File file) {
        PoseFrames poseFrames;
        Intrinsics.checkNotNullParameter(file, "file");
        Closeable closeable = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        Throwable throwable = null;
        try {
            DataInputStream it = (DataInputStream)closeable;
            boolean bl = false;
            poseFrames = INSTANCE.readFrames(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return poseFrames;
    }

    @Nullable
    public final PoseFrames tryReadFromFile(@NotNull File file) {
        PoseFrames poseFrames;
        Intrinsics.checkNotNullParameter(file, "file");
        try {
            poseFrames = this.readFromFile(file);
        }
        catch (Exception e) {
            LogManager.severe("[PfsIO] Error reading frames from file.", e);
            poseFrames = null;
        }
        return poseFrames;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PfsPackets.values().length];
            try {
                nArray[PfsPackets.RECORDING_DEFINITION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PfsPackets.TRACKER_DEFINITION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PfsPackets.TRACKER_FRAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PfsPackets.PROPORTIONS_CONFIG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

