/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.poseframeformat;

import dev.slimevr.VRServer;
import dev.slimevr.poseframeformat.PoseFrames;
import dev.slimevr.poseframeformat.trackerdata.TrackerFrames;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.util.TickReducer;
import io.eiren.util.collections.FastList;
import io.eiren.util.logging.LogManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u00011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001b\u001a\u00020\u001cJD\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0010\b\u0002\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150!2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\b\u0012\u00060\u0011R\u00020\u0000\u0018\u00010\u0010J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0002J\u0006\u0010%\u001a\u00020\u001cJ\u0006\u0010&\u001a\u00020\u001cJ\u0006\u0010*\u001a\u00020$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\b\u0012\u00060\u0011R\u00020\u0000\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010'\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010(R\u0019\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001e8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0013\u0010.\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00062"}, d2={"Ldev/slimevr/poseframeformat/PoseRecorder;", "", "server", "Ldev/slimevr/VRServer;", "<init>", "(Ldev/slimevr/VRServer;)V", "poseFrame", "Ldev/slimevr/poseframeformat/PoseFrames;", "numFrames", "", "frameCursor", "ticker", "Ldev/slimevr/util/TickReducer;", "recordingFuture", "Ljava/util/concurrent/CompletableFuture;", "frameCallback", "Ljava/util/function/Consumer;", "Ldev/slimevr/poseframeformat/PoseRecorder$RecordingProgress;", "trackers", "Lio/eiren/util/collections/FastList;", "Lorg/apache/commons/lang3/tuple/Pair;", "Ldev/slimevr/tracking/trackers/Tracker;", "Ldev/slimevr/poseframeformat/trackerdata/TrackerFrames;", "getTrackers", "()Lio/eiren/util/collections/FastList;", "setTrackers", "(Lio/eiren/util/collections/FastList;)V", "onTick", "", "startFrameRecording", "Ljava/util/concurrent/Future;", "interval", "", "", "internalStopFrameRecording", "cancel", "", "stopFrameRecording", "cancelFrameRecording", "isReadyToRecord", "()Z", "isRecording", "hasRecording", "framesAsync", "getFramesAsync", "()Ljava/util/concurrent/Future;", "frames", "getFrames", "()Ldev/slimevr/poseframeformat/PoseFrames;", "RecordingProgress", "core"})
@SourceDebugExtension(value={"SMAP\nPoseRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoseRecorder.kt\ndev/slimevr/poseframeformat/PoseRecorder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public final class PoseRecorder {
    @NotNull
    private final VRServer server;
    @Nullable
    private PoseFrames poseFrame;
    private int numFrames;
    private int frameCursor;
    @NotNull
    private final TickReducer ticker;
    @Nullable
    private CompletableFuture<PoseFrames> recordingFuture;
    @Nullable
    private Consumer<RecordingProgress> frameCallback;
    @NotNull
    private FastList<Pair<Tracker, TrackerFrames>> trackers;

    public PoseRecorder(@NotNull VRServer server) {
        Intrinsics.checkNotNullParameter(server, "server");
        this.server = server;
        this.numFrames = -1;
        this.ticker = new TickReducer(arg_0 -> PoseRecorder.ticker$lambda$0(this, arg_0), 0.02f, 0.0f, 4, null);
        this.trackers = new FastList();
        this.server.addOnTick(() -> PoseRecorder._init_$lambda$1(this));
    }

    @NotNull
    public final FastList<Pair<Tracker, TrackerFrames>> getTrackers() {
        return this.trackers;
    }

    public final void setTrackers(@NotNull FastList<Pair<Tracker, TrackerFrames>> fastList) {
        Intrinsics.checkNotNullParameter(fastList, "<set-?>");
        this.trackers = fastList;
    }

    public final synchronized void onTick() {
        if (this.frameCursor >= this.numFrames) {
            this.stopFrameRecording();
            return;
        }
        int n = this.frameCursor;
        this.frameCursor = n + 1;
        int cursor = n;
        Iterator iterator2 = this.trackers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Pair tracker = (Pair)iterator3.next();
            TrackerFrames trackerFrames = (TrackerFrames)tracker.getRight();
            Object l = tracker.getLeft();
            Intrinsics.checkNotNullExpressionValue(l, "getLeft(...)");
            trackerFrames.addFrameFromTracker(cursor, (Tracker)l);
        }
        Consumer<RecordingProgress> consumer = this.frameCallback;
        if (consumer != null) {
            consumer.accept(new RecordingProgress(this.frameCursor, this.numFrames));
        }
        if (this.frameCursor >= this.numFrames) {
            this.stopFrameRecording();
        }
    }

    @NotNull
    public final synchronized Future<PoseFrames> startFrameRecording(int numFrames, float interval, @NotNull List<Tracker> trackers, @Nullable Consumer<RecordingProgress> frameCallback) {
        Intrinsics.checkNotNullParameter(trackers, "trackers");
        if (!(numFrames >= 1)) {
            boolean $i$a$-require-PoseRecorder$startFrameRecording$52 = false;
            String $i$a$-require-PoseRecorder$startFrameRecording$52 = "numFrames must at least have a value of 1.";
            throw new IllegalArgumentException($i$a$-require-PoseRecorder$startFrameRecording$52.toString());
        }
        if (!(interval > 0.0f)) {
            boolean $i$a$-require-PoseRecorder$startFrameRecording$62 = false;
            String $i$a$-require-PoseRecorder$startFrameRecording$62 = "interval must be greater than 0.";
            throw new IllegalArgumentException($i$a$-require-PoseRecorder$startFrameRecording$62.toString());
        }
        if (!(!((Collection)trackers).isEmpty())) {
            boolean $i$a$-require-PoseRecorder$startFrameRecording$72 = false;
            String $i$a$-require-PoseRecorder$startFrameRecording$72 = "trackers must have at least one entry.";
            throw new IllegalArgumentException($i$a$-require-PoseRecorder$startFrameRecording$72.toString());
        }
        this.cancelFrameRecording();
        PoseFrames poseFrame = new PoseFrames(trackers.size());
        poseFrame.setFrameInterval(interval);
        this.trackers.ensureCapacity(trackers.size());
        for (Tracker tracker : trackers) {
            if (tracker == null || tracker.isInternal()) continue;
            TrackerFrames trackerFrames = new TrackerFrames(tracker, numFrames);
            poseFrame.getFrameHolders().add(trackerFrames);
            this.trackers.add(Pair.of(tracker, trackerFrames));
        }
        if (!(!((Collection)this.trackers).isEmpty())) {
            boolean bl = false;
            String string = "trackers must have at least one valid tracker.";
            throw new IllegalArgumentException(string.toString());
        }
        this.ticker.setInterval(interval);
        this.ticker.reset();
        CompletableFuture recordingFuture = new CompletableFuture();
        this.recordingFuture = recordingFuture;
        this.frameCallback = frameCallback;
        this.poseFrame = poseFrame;
        this.frameCursor = 0;
        this.numFrames = numFrames;
        LogManager.info("[PoseRecorder] Recording " + numFrames + " samples at a " + interval + " s frame interval");
        return recordingFuture;
    }

    public static /* synthetic */ Future startFrameRecording$default(PoseRecorder poseRecorder, int n, float f, List list, Consumer consumer, int n2, Object object) {
        if ((n2 & 4) != 0) {
            list = poseRecorder.server.getAllTrackers();
        }
        if ((n2 & 8) != 0) {
            consumer = null;
        }
        return poseRecorder.startFrameRecording(n, f, list, consumer);
    }

    private final synchronized void internalStopFrameRecording(boolean cancel) {
        CompletableFuture<PoseFrames> currentRecording = this.recordingFuture;
        if (currentRecording != null && !currentRecording.isDone()) {
            PoseFrames currentFrames = this.poseFrame;
            boolean bl = cancel || currentFrames == null ? currentRecording.cancel(true) : currentRecording.complete(currentFrames);
        }
        this.numFrames = -1;
        this.frameCursor = 0;
        this.trackers.clear();
        this.poseFrame = null;
    }

    public final synchronized void stopFrameRecording() {
        this.internalStopFrameRecording(false);
    }

    public final synchronized void cancelFrameRecording() {
        this.internalStopFrameRecording(true);
    }

    public final boolean isReadyToRecord() {
        return this.server.getTrackersCount() > 0;
    }

    public final boolean isRecording() {
        return this.numFrames > this.frameCursor;
    }

    public final boolean hasRecording() {
        return this.recordingFuture != null;
    }

    @Nullable
    public final Future<PoseFrames> getFramesAsync() {
        return this.recordingFuture;
    }

    @Nullable
    public final PoseFrames getFrames() throws ExecutionException, InterruptedException {
        CompletableFuture<PoseFrames> completableFuture = this.recordingFuture;
        return completableFuture != null ? completableFuture.get() : null;
    }

    private static final Unit ticker$lambda$0(PoseRecorder this$0, float it) {
        this$0.onTick();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(PoseRecorder this$0) {
        if (this$0.numFrames > 0) {
            this$0.ticker.tick(this$0.server.getFpsTimer().getTimePerFrame());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Ldev/slimevr/poseframeformat/PoseRecorder$RecordingProgress;", "", "frame", "", "totalFrames", "<init>", "(Ldev/slimevr/poseframeformat/PoseRecorder;II)V", "getFrame", "()I", "getTotalFrames", "core"})
    public final class RecordingProgress {
        private final int frame;
        private final int totalFrames;

        public RecordingProgress(int frame, int totalFrames) {
            this.frame = frame;
            this.totalFrames = totalFrames;
        }

        public final int getFrame() {
            return this.frame;
        }

        public final int getTotalFrames() {
            return this.totalFrames;
        }
    }
}

