/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.posestreamer;

import dev.slimevr.posestreamer.BVHSettings;
import dev.slimevr.posestreamer.PoseDataStream;
import dev.slimevr.posestreamer.PoseStreamer;
import dev.slimevr.tracking.processor.Bone;
import dev.slimevr.tracking.processor.skeleton.HumanSkeleton;
import io.github.axisangles.ktmath.EulerAngles;
import io.github.axisangles.ktmath.EulerOrder;
import io.github.axisangles.ktmath.Quaternion;
import io.github.axisangles.ktmath.Vector3;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 -2\u00020\u0001:\u0001-B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\r\u00a2\u0006\u0004\b\u0004\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\u000fJ\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u001c\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0002\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u001a\u0010'\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010,\u001a\u00020\u001fH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ldev/slimevr/posestreamer/BVHFileStream;", "Ldev/slimevr/posestreamer/PoseDataStream;", "outputStream", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "bvhSettings", "Ldev/slimevr/posestreamer/BVHSettings;", "(Ljava/io/OutputStream;Ldev/slimevr/posestreamer/BVHSettings;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "(Ljava/io/File;Ldev/slimevr/posestreamer/BVHSettings;)V", "", "(Ljava/lang/String;)V", "(Ljava/lang/String;Ldev/slimevr/posestreamer/BVHSettings;)V", "getBvhSettings", "()Ldev/slimevr/posestreamer/BVHSettings;", "setBvhSettings", "(Ldev/slimevr/posestreamer/BVHSettings;)V", "writer", "Ljava/io/BufferedWriter;", "frameCount", "", "frameCountOffset", "getBufferedFrameCount", "isEndBone", "", "bone", "Ldev/slimevr/tracking/processor/Bone;", "writeBoneHierarchy", "", "level", "", "writeHeader", "skeleton", "Ldev/slimevr/tracking/processor/skeleton/HumanSkeleton;", "streamer", "Ldev/slimevr/posestreamer/PoseStreamer;", "writeBoneHierarchyRotation", "inverseRootRot", "Lio/github/axisangles/ktmath/Quaternion;", "writeFrame", "writeFooter", "close", "Companion", "core"})
public final class BVHFileStream
extends PoseDataStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BVHSettings bvhSettings;
    @NotNull
    private final BufferedWriter writer;
    private long frameCount;
    private long frameCountOffset;
    private static final int LONG_MAX_VALUE_DIGITS = 19;

    @NotNull
    public final BVHSettings getBvhSettings() {
        return this.bvhSettings;
    }

    public final void setBvhSettings(@NotNull BVHSettings bVHSettings) {
        Intrinsics.checkNotNullParameter(bVHSettings, "<set-?>");
        this.bvhSettings = bVHSettings;
    }

    public BVHFileStream(@NotNull OutputStream outputStream2) {
        Intrinsics.checkNotNullParameter(outputStream2, "outputStream");
        super(outputStream2);
        this.bvhSettings = BVHSettings.Companion.getBLENDER();
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream2), 4096);
    }

    public BVHFileStream(@NotNull OutputStream outputStream2, @NotNull BVHSettings bvhSettings) {
        Intrinsics.checkNotNullParameter(outputStream2, "outputStream");
        Intrinsics.checkNotNullParameter(bvhSettings, "bvhSettings");
        this(outputStream2);
        this.bvhSettings = bvhSettings;
    }

    public BVHFileStream(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        super(file);
        this.bvhSettings = BVHSettings.Companion.getBLENDER();
        this.writer = new BufferedWriter(new OutputStreamWriter(this.getOutputStream()), 4096);
    }

    public BVHFileStream(@NotNull File file, @NotNull BVHSettings bvhSettings) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(bvhSettings, "bvhSettings");
        this(file);
        this.bvhSettings = bvhSettings;
    }

    public BVHFileStream(@NotNull String file) {
        Intrinsics.checkNotNullParameter(file, "file");
        super(file);
        this.bvhSettings = BVHSettings.Companion.getBLENDER();
        this.writer = new BufferedWriter(new OutputStreamWriter(this.getOutputStream()), 4096);
    }

    public BVHFileStream(@NotNull String file, @NotNull BVHSettings bvhSettings) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(bvhSettings, "bvhSettings");
        this(file);
        this.bvhSettings = bvhSettings;
    }

    private final String getBufferedFrameCount(long frameCount) {
        String frameString = String.valueOf(frameCount);
        int bufferCount = 19 - frameString.length();
        return bufferCount > 0 ? frameString + StringUtils.repeat(' ', bufferCount) : frameString;
    }

    private final boolean isEndBone(Bone bone) {
        return bone == null || !this.bvhSettings.shouldWriteEndNodes() && bone.getChildren().isEmpty();
    }

    private final void writeBoneHierarchy(Bone bone, int level) throws IOException {
        boolean isSingleChild;
        boolean isEndBone = this.isEndBone(bone);
        Object object = bone;
        boolean bl = isSingleChild = (object != null && (object = ((Bone)object).getParent()) != null && (object = ((Bone)object).getChildren()) != null ? object.size() : 0) <= 1;
        if (isEndBone && !isSingleChild) {
            return;
        }
        String indentLevel = StringUtils.repeat("\t", level);
        String nextIndentLevel = indentLevel + "\t";
        if (isEndBone) {
            this.writer.write(indentLevel + "End Site\n");
        } else {
            Object object2 = level > 0 ? indentLevel + "JOINT " : "ROOT ";
            Bone bone2 = bone;
            Intrinsics.checkNotNull(bone2);
            this.writer.write((String)object2 + bone2.getBoneType() + "\n");
        }
        this.writer.write(indentLevel + "{\n");
        if (level > 0 && bone != null && bone.getParent() != null) {
            float offsetScale = this.bvhSettings.getOffsetScale();
            Bone bone3 = bone.getParent();
            Intrinsics.checkNotNull(bone3);
            this.writer.write(nextIndentLevel + "OFFSET 0 " + -bone3.getLength() * offsetScale + " 0\n");
        } else {
            this.writer.write(nextIndentLevel + "OFFSET 0.0 0.0 0.0\n");
        }
        if (!isEndBone) {
            if (level > 0) {
                this.writer.write(nextIndentLevel + "CHANNELS 3 Zrotation Xrotation Yrotation\n");
            } else {
                this.writer.write(nextIndentLevel + "CHANNELS 6 Xposition Yposition Zposition Zrotation Xrotation Yrotation\n");
            }
            Bone bone4 = bone;
            Intrinsics.checkNotNull(bone4);
            if (!((Collection)bone4.getChildren()).isEmpty()) {
                for (Bone childBone : bone.getChildren()) {
                    this.writeBoneHierarchy(childBone, level + 1);
                }
            } else {
                this.writeBoneHierarchy(null, level + 1);
            }
        }
        this.writer.write(indentLevel + "}\n");
    }

    static /* synthetic */ void writeBoneHierarchy$default(BVHFileStream bVHFileStream, Bone bone, int n, int n2, Object object) throws IOException {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        bVHFileStream.writeBoneHierarchy(bone, n);
    }

    @Override
    public void writeHeader(@NotNull HumanSkeleton skeleton, @NotNull PoseStreamer streamer) throws IOException {
        Intrinsics.checkNotNullParameter(skeleton, "skeleton");
        Intrinsics.checkNotNullParameter(streamer, "streamer");
        this.writer.write("HIERARCHY\n");
        BVHFileStream.writeBoneHierarchy$default(this, skeleton.getHeadBone(), 0, 2, null);
        this.writer.write("MOTION\n");
        this.writer.write("Frames: ");
        if (this.getOutputStream() instanceof FileOutputStream) {
            this.writer.flush();
            this.frameCountOffset = ((FileOutputStream)this.getOutputStream()).getChannel().position();
        }
        this.writer.write(this.getBufferedFrameCount(this.frameCount) + "\n");
        this.writer.write("Frame Time: " + streamer.getFrameInterval() + "\n");
    }

    private final void writeBoneHierarchyRotation(Bone bone, Quaternion inverseRootRot) throws IOException {
        Object object;
        Quaternion quaternion = bone.getGlobalRotation();
        float f = quaternion.unbox-impl-w();
        float f2 = quaternion.unbox-impl-x();
        float f3 = quaternion.unbox-impl-y();
        float f4 = quaternion.unbox-impl-z();
        if (inverseRootRot != null) {
            object = Quaternion.times-oS71L7k(inverseRootRot.unbox-impl-w(), inverseRootRot.unbox-impl-x(), inverseRootRot.unbox-impl-y(), inverseRootRot.unbox-impl-z(), f, f2, f3, f4);
            float f5 = ((Quaternion)object).unbox-impl-w();
            float f6 = ((Quaternion)object).unbox-impl-x();
            float f7 = ((Quaternion)object).unbox-impl-y();
            float f8 = ((Quaternion)object).unbox-impl-z();
            f = f5;
            f2 = f6;
            f3 = f7;
            f4 = f8;
        }
        object = Quaternion.toEulerAngles-impl(f, f2, f3, f4, EulerOrder.ZXY);
        EulerOrder eulerOrder = ((EulerAngles)object).unbox-impl-order();
        float f9 = ((EulerAngles)object).unbox-impl-x();
        float f10 = ((EulerAngles)object).unbox-impl-y();
        float f11 = ((EulerAngles)object).unbox-impl-z();
        this.writer.write(f11 * 57.295776f + " " + f9 * 57.295776f + " " + f10 * 57.295776f);
        if (!((Collection)bone.getChildren()).isEmpty()) {
            Quaternion quaternion2 = bone.getGlobalRotation();
            Quaternion quaternion3 = Quaternion.inv-impl(quaternion2.unbox-impl-w(), quaternion2.unbox-impl-x(), quaternion2.unbox-impl-y(), quaternion2.unbox-impl-z());
            float f12 = quaternion3.unbox-impl-w();
            float f13 = quaternion3.unbox-impl-x();
            float f14 = quaternion3.unbox-impl-y();
            float f15 = quaternion3.unbox-impl-z();
            for (Bone childBode : bone.getChildren()) {
                if (this.isEndBone(childBode)) continue;
                this.writer.write(" ");
                this.writeBoneHierarchyRotation(childBode, Quaternion.box-impl(f12, f13, f14, f15));
            }
        }
    }

    @Override
    public void writeFrame(@NotNull HumanSkeleton skeleton) throws IOException {
        Intrinsics.checkNotNullParameter(skeleton, "skeleton");
        Bone rootBone = skeleton.getHeadBone();
        Vector3 vector3 = rootBone.getPosition();
        float f = vector3.unbox-impl-x();
        float f2 = vector3.unbox-impl-y();
        float f3 = vector3.unbox-impl-z();
        float positionScale = this.bvhSettings.getPositionScale();
        this.writer.write(f * positionScale + " " + f2 * positionScale + " " + f3 * positionScale);
        this.writer.write(" ");
        this.writeBoneHierarchyRotation(rootBone, null);
        this.writer.newLine();
        long l = this.frameCount;
        this.frameCount = l + 1L;
    }

    @Override
    public void writeFooter(@NotNull HumanSkeleton skeleton) throws IOException {
        Intrinsics.checkNotNullParameter(skeleton, "skeleton");
        if (this.getOutputStream() instanceof FileOutputStream) {
            this.writer.flush();
            ((FileOutputStream)this.getOutputStream()).getChannel().position(this.frameCountOffset);
            this.writer.write(String.valueOf(this.frameCount));
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        super.close();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/slimevr/posestreamer/BVHFileStream$Companion;", "", "<init>", "()V", "LONG_MAX_VALUE_DIGITS", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

