/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.posestreamer;

import dev.slimevr.VRServer;
import dev.slimevr.posestreamer.BVHFileStream;
import dev.slimevr.posestreamer.PoseDataStream;
import dev.slimevr.posestreamer.ServerPoseStreamer;
import io.eiren.util.logging.LogManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u0015"}, d2={"Ldev/slimevr/posestreamer/BVHRecorder;", "", "server", "Ldev/slimevr/VRServer;", "<init>", "(Ldev/slimevr/VRServer;)V", "poseStreamer", "Ldev/slimevr/posestreamer/ServerPoseStreamer;", "poseDataStream", "Ldev/slimevr/posestreamer/PoseDataStream;", "isRecording", "", "()Z", "startRecording", "", "path", "Ljava/nio/file/Path;", "endRecording", "getBvhFile", "Ljava/io/File;", "bvhSaveDir", "core"})
public final class BVHRecorder {
    @NotNull
    private final ServerPoseStreamer poseStreamer;
    @Nullable
    private PoseDataStream poseDataStream;

    public BVHRecorder(@NotNull VRServer server) {
        Intrinsics.checkNotNullParameter(server, "server");
        this.poseStreamer = new ServerPoseStreamer(server);
    }

    public final boolean isRecording() {
        return this.poseDataStream != null;
    }

    public final void startRecording(@NotNull Path path) {
        File file;
        Intrinsics.checkNotNullParameter(path, "path");
        File filePath = path.toFile();
        if (filePath.isDirectory()) {
            Intrinsics.checkNotNull(filePath);
            file = this.getBvhFile(filePath);
            if (file == null) {
                return;
            }
        } else {
            file = filePath;
        }
        File file2 = file;
        try {
            Intrinsics.checkNotNull(file2);
            BVHFileStream stream = new BVHFileStream(file2);
            this.poseDataStream = stream;
            this.poseStreamer.setOutput(stream, 0.01f);
        }
        catch (IOException iOException) {
            LogManager.severe("[BVH] Failed to create the recording file \"" + file2.getPath() + "\".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void endRecording() {
        try {
            PoseDataStream stream = this.poseDataStream;
            if (stream != null) {
                this.poseStreamer.closeOutput(stream);
            }
        }
        catch (Exception e1) {
            LogManager.severe("[BVH] Exception while closing poseDataStream", e1);
        }
        finally {
            this.poseDataStream = null;
        }
    }

    private final File getBvhFile(File bvhSaveDir) {
        if (bvhSaveDir.isDirectory() || bvhSaveDir.mkdirs()) {
            File saveRecording = null;
            int recordingIndex = 1;
            while ((saveRecording = new File(bvhSaveDir, "BVH-Recording" + recordingIndex++ + ".bvh")).exists()) {
            }
            return saveRecording;
        }
        LogManager.severe("[BVH] Failed to create the recording directory \"" + bvhSaveDir.getPath() + "\".");
        return null;
    }
}

