/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.posestreamer;

import dev.slimevr.posestreamer.PoseDataStream;
import dev.slimevr.tracking.processor.skeleton.HumanSkeleton;
import io.eiren.util.logging.LogManager;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020\u000fJ\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u0005R$\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R(\u0010\u0018\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u0016\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Ldev/slimevr/posestreamer/PoseStreamer;", "", "skeleton", "Ldev/slimevr/tracking/processor/skeleton/HumanSkeleton;", "<init>", "(Ldev/slimevr/tracking/processor/skeleton/HumanSkeleton;)V", "intervalInternal", "", "stream", "Ldev/slimevr/posestreamer/PoseDataStream;", "value", "getSkeleton", "()Ldev/slimevr/tracking/processor/skeleton/HumanSkeleton;", "setSkeleton", "captureFrame", "", "interval", "frameInterval", "getFrameInterval", "()F", "setFrameInterval", "(F)V", "setOutput", "poseFileStream", "output", "getOutput", "()Ldev/slimevr/posestreamer/PoseDataStream;", "(Ldev/slimevr/posestreamer/PoseDataStream;)V", "hasOutput", "", "getHasOutput", "()Z", "closeOutput", "core"})
@SourceDebugExtension(value={"SMAP\nPoseStreamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoseStreamer.kt\ndev/slimevr/posestreamer/PoseStreamer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public class PoseStreamer {
    private float intervalInternal;
    @Nullable
    private PoseDataStream stream;
    @NotNull
    private HumanSkeleton skeleton;

    public PoseStreamer(@NotNull HumanSkeleton skeleton) {
        Intrinsics.checkNotNullParameter(skeleton, "skeleton");
        this.intervalInternal = 0.016666668f;
        this.skeleton = skeleton;
    }

    @NotNull
    public final HumanSkeleton getSkeleton() {
        return this.skeleton;
    }

    protected final void setSkeleton(@NotNull HumanSkeleton humanSkeleton) {
        Intrinsics.checkNotNullParameter(humanSkeleton, "<set-?>");
        this.skeleton = humanSkeleton;
    }

    public final synchronized void captureFrame() {
        PoseDataStream stream = this.stream;
        if (stream == null || stream.isClosed()) {
            return;
        }
        try {
            stream.writeFrame(this.skeleton);
        }
        catch (Exception e) {
            LogManager.severe("[PoseStreamer] Exception while saving frame", e);
        }
    }

    public float getFrameInterval() {
        return this.intervalInternal;
    }

    public void setFrameInterval(float interval) {
        if (!(interval > 0.0f)) {
            boolean bl = false;
            String string = "interval must be a value greater than 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.intervalInternal = interval;
    }

    public final synchronized void setOutput(@NotNull PoseDataStream poseFileStream, float interval) throws IOException {
        Intrinsics.checkNotNullParameter(poseFileStream, "poseFileStream");
        this.setFrameInterval(interval);
        this.setOutput(poseFileStream);
    }

    @Nullable
    public PoseDataStream getOutput() {
        return this.stream;
    }

    public synchronized void setOutput(@Nullable PoseDataStream stream) throws IOException {
        if (stream == null) {
            boolean bl = false;
            String string = "stream must not be null";
            throw new IllegalArgumentException(string.toString());
        }
        stream.writeHeader(this.skeleton, this);
        this.stream = stream;
    }

    public final boolean getHasOutput() {
        PoseDataStream poseDataStream = this.getOutput();
        return poseDataStream != null ? !poseDataStream.isClosed() : false;
    }

    public final synchronized void closeOutput() throws IOException {
        PoseDataStream stream = this.stream;
        if (stream != null) {
            this.closeOutput(stream);
            this.stream = null;
        }
    }

    public final synchronized void closeOutput(@NotNull PoseDataStream stream) throws IOException {
        Intrinsics.checkNotNullParameter(stream, "stream");
        stream.writeFooter(this.skeleton);
        stream.close();
    }
}

