/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.protocol;

import com.google.flatbuffers.Table;
import dev.slimevr.VRServer;
import dev.slimevr.protocol.GenericConnection;
import dev.slimevr.protocol.ProtocolAPIServer;
import dev.slimevr.protocol.datafeed.DataFeedHandler;
import dev.slimevr.protocol.pubsub.PubSubHandler;
import dev.slimevr.protocol.rpc.RPCHandler;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import solarxr_protocol.MessageBundle;
import solarxr_protocol.data_feed.DataFeedMessageHeader;
import solarxr_protocol.pub_sub.PubSubHeader;
import solarxr_protocol.rpc.RpcMessageHeader;

public class ProtocolAPI {
    public final VRServer server;
    public final RPCHandler rpcHandler;
    public final DataFeedHandler dataFeedHandler;
    public final PubSubHandler pubSubHandler;
    private final List<ProtocolAPIServer> servers = new ArrayList<ProtocolAPIServer>();

    public ProtocolAPI(VRServer server) {
        this.server = server;
        this.rpcHandler = new RPCHandler(this);
        this.dataFeedHandler = new DataFeedHandler(this);
        this.pubSubHandler = new PubSubHandler(this);
    }

    public void onMessage(GenericConnection conn, ByteBuffer message) {
        MessageBundle messageBundle = MessageBundle.getRootAsMessageBundle(message);
        try {
            Table header;
            int index;
            for (index = 0; index < messageBundle.dataFeedMsgsLength(); ++index) {
                header = messageBundle.dataFeedMsgsVector().get(index);
                this.dataFeedHandler.onMessage(conn, (DataFeedMessageHeader)header);
            }
            for (index = 0; index < messageBundle.rpcMsgsLength(); ++index) {
                header = messageBundle.rpcMsgsVector().get(index);
                this.rpcHandler.onMessage(conn, (RpcMessageHeader)header);
            }
            for (index = 0; index < messageBundle.pubSubMsgsLength(); ++index) {
                header = messageBundle.pubSubMsgsVector().get(index);
                this.pubSubHandler.onMessage(conn, (PubSubHeader)header);
            }
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
        }
    }

    public List<ProtocolAPIServer> getAPIServers() {
        return this.servers;
    }

    public void registerAPIServer(ProtocolAPIServer server) {
        this.servers.add(server);
    }

    public void removeAPIServer(ProtocolAPIServer server) {
        this.servers.remove(server);
    }
}

