/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.protocol.datafeed;

import com.google.flatbuffers.FlatBufferBuilder;
import dev.slimevr.math.Angle;
import dev.slimevr.tracking.processor.skeleton.HumanSkeleton;
import dev.slimevr.tracking.processor.stayaligned.poses.RelaxedPose;
import dev.slimevr.tracking.processor.stayaligned.trackers.RestDetector;
import dev.slimevr.tracking.processor.stayaligned.trackers.StayAlignedTrackerState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import solarxr_protocol.data_feed.stay_aligned.StayAlignedPose;
import solarxr_protocol.data_feed.stay_aligned.StayAlignedTracker;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Ldev/slimevr/protocol/datafeed/DataFeedBuilderKotlin;", "", "<init>", "()V", "createStayAlignedPose", "", "fbb", "Lcom/google/flatbuffers/FlatBufferBuilder;", "humanSkeleton", "Ldev/slimevr/tracking/processor/skeleton/HumanSkeleton;", "createTrackerStayAlignedTracker", "state", "Ldev/slimevr/tracking/processor/stayaligned/trackers/StayAlignedTrackerState;", "core"})
public final class DataFeedBuilderKotlin {
    @NotNull
    public static final DataFeedBuilderKotlin INSTANCE = new DataFeedBuilderKotlin();

    private DataFeedBuilderKotlin() {
    }

    public final int createStayAlignedPose(@NotNull FlatBufferBuilder fbb, @NotNull HumanSkeleton humanSkeleton) {
        Intrinsics.checkNotNullParameter(fbb, "fbb");
        Intrinsics.checkNotNullParameter(humanSkeleton, "humanSkeleton");
        RelaxedPose relaxedPose = RelaxedPose.Companion.fromTrackers(humanSkeleton);
        StayAlignedPose.startStayAlignedPose(fbb);
        StayAlignedPose.addUpperLegAngleInDeg(fbb, Angle.toDeg-impl(relaxedPose.getUpperLeg-ncrbCcM()));
        StayAlignedPose.addLowerLegAngleInDeg(fbb, Angle.toDeg-impl(relaxedPose.getLowerLeg-ncrbCcM()));
        StayAlignedPose.addFootAngleInDeg(fbb, Angle.toDeg-impl(relaxedPose.getFoot-ncrbCcM()));
        return StayAlignedPose.endStayAlignedPose(fbb);
    }

    public final int createTrackerStayAlignedTracker(@NotNull FlatBufferBuilder fbb, @NotNull StayAlignedTrackerState state) {
        Intrinsics.checkNotNullParameter(fbb, "fbb");
        Intrinsics.checkNotNullParameter(state, "state");
        StayAlignedTracker.startStayAlignedTracker(fbb);
        StayAlignedTracker.addYawCorrectionInDeg(fbb, Angle.toDeg-impl(state.getYawCorrection-ncrbCcM()));
        StayAlignedTracker.addLockedErrorInDeg(fbb, Angle.toDeg-impl(state.getYawErrors().getLockedError().toL2Norm-ncrbCcM()));
        StayAlignedTracker.addCenterErrorInDeg(fbb, Angle.toDeg-impl(state.getYawErrors().getCenterError().toL2Norm-ncrbCcM()));
        StayAlignedTracker.addNeighborErrorInDeg(fbb, Angle.toDeg-impl(state.getYawErrors().getNeighborError().toL2Norm-ncrbCcM()));
        StayAlignedTracker.addLocked(fbb, state.getRestDetector().getState() == RestDetector.State.AT_REST);
        return StayAlignedTracker.endStayAlignedTracker(fbb);
    }
}

