/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.protocol.datafeed;

import com.google.flatbuffers.FlatBufferBuilder;
import dev.slimevr.protocol.GenericConnection;
import dev.slimevr.protocol.ProtocolAPI;
import dev.slimevr.protocol.ProtocolHandler;
import dev.slimevr.protocol.datafeed.DataFeedBuilder;
import dev.slimevr.protocol.datafeed.DataFeedBuilderKotlin;
import dev.slimevr.tracking.processor.HumanPoseManager;
import dev.slimevr.tracking.trackers.Tracker;
import io.eiren.util.logging.LogManager;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import solarxr_protocol.MessageBundle;
import solarxr_protocol.data_feed.DataFeedConfigT;
import solarxr_protocol.data_feed.DataFeedMessage;
import solarxr_protocol.data_feed.DataFeedMessageHeader;
import solarxr_protocol.data_feed.DataFeedUpdate;
import solarxr_protocol.data_feed.PollDataFeed;
import solarxr_protocol.data_feed.StartDataFeed;

public class DataFeedHandler
extends ProtocolHandler<DataFeedMessageHeader> {
    private final ProtocolAPI api;

    public DataFeedHandler(ProtocolAPI api) {
        this.api = api;
        this.registerPacketListener((byte)2, this::onStartDataFeed);
        this.registerPacketListener((byte)1, this::onPollDataFeedRequest);
        this.api.server.addOnTick(this::sendDataFeedUpdate);
    }

    private void onStartDataFeed(GenericConnection conn, DataFeedMessageHeader header) {
        StartDataFeed req = (StartDataFeed)header.message(new StartDataFeed());
        if (req == null) {
            return;
        }
        int dataFeeds = req.dataFeedsLength();
        conn.getContext().clearDataFeeds();
        for (int i = 0; i < dataFeeds; ++i) {
            DataFeedConfigT config = req.dataFeeds(i).unpack();
            conn.getContext().getDataFeedConfigList().add(config);
            conn.getContext().getDataFeedTimers().add(System.currentTimeMillis());
        }
    }

    private void onPollDataFeedRequest(GenericConnection conn, DataFeedMessageHeader messageHeader) {
        PollDataFeed req = (PollDataFeed)messageHeader.message(new PollDataFeed());
        if (req == null) {
            return;
        }
        FlatBufferBuilder fbb = new FlatBufferBuilder(300);
        int messageOffset = this.buildDatafeed(fbb, req.config().unpack(), 0);
        DataFeedMessageHeader.startDataFeedMessageHeader(fbb);
        DataFeedMessageHeader.addMessage(fbb, messageOffset);
        DataFeedMessageHeader.addMessageType(fbb, (byte)3);
        int headerOffset = DataFeedMessageHeader.endDataFeedMessageHeader(fbb);
        MessageBundle.startDataFeedMsgsVector(fbb, 1);
        MessageBundle.addDataFeedMsgs(fbb, headerOffset);
        int datafeedMessagesOffset = fbb.endVector();
        int packet = this.createMessage(fbb, datafeedMessagesOffset);
        fbb.finish(packet);
        conn.send(fbb.dataBuffer());
    }

    public int buildDatafeed(FlatBufferBuilder fbb, DataFeedConfigT config, int index) {
        int devicesOffset = DataFeedBuilder.createDevicesData(fbb, config.getDataMask(), this.api.server.deviceManager.getDevices());
        int trackersOffset = DataFeedBuilder.createSyntheticTrackersData(fbb, config.getSyntheticTrackersMask(), this.api.server.getAllTrackers().stream().filter(Tracker::isComputed).collect(Collectors.toList()));
        HumanPoseManager h = this.api.server.humanPoseManager;
        int bonesOffset = DataFeedBuilder.createBonesData(fbb, config.getBoneMask(), h.getAllBones());
        int stayAlignedPoseOffset = 0;
        if (config.getStayAlignedPoseMask()) {
            stayAlignedPoseOffset = DataFeedBuilderKotlin.INSTANCE.createStayAlignedPose(fbb, this.api.server.humanPoseManager.skeleton);
        }
        return DataFeedUpdate.createDataFeedUpdate(fbb, devicesOffset, trackersOffset, bonesOffset, stayAlignedPoseOffset, index);
    }

    public void sendDataFeedUpdate() {
        long currTime = System.currentTimeMillis();
        this.api.getAPIServers().forEach(server -> server.getAPIConnections().forEach(conn -> {
            FlatBufferBuilder fbb = null;
            int configsCount = conn.getContext().getDataFeedConfigList().size();
            int[] data = new int[configsCount];
            for (int index = 0; index < configsCount; ++index) {
                Long lastTimeSent = conn.getContext().getDataFeedTimers().get(index);
                DataFeedConfigT configT = conn.getContext().getDataFeedConfigList().get(index);
                if (currTime - lastTimeSent <= (long)configT.getMinimumTimeSinceLast()) continue;
                if (fbb == null) {
                    fbb = new FlatBufferBuilder(300);
                }
                int messageOffset = this.buildDatafeed(fbb, configT, index);
                DataFeedMessageHeader.startDataFeedMessageHeader(fbb);
                DataFeedMessageHeader.addMessage(fbb, messageOffset);
                DataFeedMessageHeader.addMessageType(fbb, (byte)3);
                data[index] = DataFeedMessageHeader.endDataFeedMessageHeader(fbb);
                conn.getContext().getDataFeedTimers().set(index, currTime);
                int messages = MessageBundle.createDataFeedMsgsVector(fbb, data);
                int packet = this.createMessage(fbb, messages);
                fbb.finish(packet);
                conn.send(fbb.dataBuffer());
            }
        }));
    }

    @Override
    public void onMessage(GenericConnection conn, DataFeedMessageHeader message) {
        BiConsumer consumer = this.handlers[message.messageType()];
        if (consumer != null) {
            consumer.accept(conn, message);
        } else {
            LogManager.info("[ProtocolAPI] Unhandled Datafeed packet received id: " + message.messageType());
        }
    }

    @Override
    public int messagesCount() {
        return DataFeedMessage.names.length;
    }

    public int createMessage(FlatBufferBuilder fbb, int datafeedMessagesOffset) {
        MessageBundle.startMessageBundle(fbb);
        if (datafeedMessagesOffset > -1) {
            MessageBundle.addDataFeedMsgs(fbb, datafeedMessagesOffset);
        }
        return MessageBundle.endMessageBundle(fbb);
    }
}

