/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.protocol.pubsub;

import com.google.flatbuffers.FlatBufferBuilder;
import dev.slimevr.protocol.GenericConnection;
import dev.slimevr.protocol.ProtocolAPI;
import dev.slimevr.protocol.ProtocolHandler;
import dev.slimevr.protocol.pubsub.HashedTopicId;
import io.eiren.util.logging.LogManager;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import solarxr_protocol.MessageBundle;
import solarxr_protocol.pub_sub.Message;
import solarxr_protocol.pub_sub.MessageT;
import solarxr_protocol.pub_sub.PubSubHeader;
import solarxr_protocol.pub_sub.PubSubUnion;
import solarxr_protocol.pub_sub.SubscriptionRequest;
import solarxr_protocol.pub_sub.TopicHandle;
import solarxr_protocol.pub_sub.TopicHandleRequest;
import solarxr_protocol.pub_sub.TopicHandleRequestT;
import solarxr_protocol.pub_sub.TopicId;
import solarxr_protocol.pub_sub.TopicIdT;
import solarxr_protocol.pub_sub.TopicMapping;

public class PubSubHandler
extends ProtocolHandler<PubSubHeader> {
    private final ProtocolAPI api;
    public HashMap<HashedTopicId, Integer> topicsHandle = new HashMap();
    public HashMap<Integer, HashedTopicId> handleTopics = new HashMap();
    public AtomicInteger nextLocalHandle = new AtomicInteger();

    public PubSubHandler(ProtocolAPI api) {
        this.api = api;
        this.registerPacketListener((byte)2, this::onSubscriptionRequest);
        this.registerPacketListener((byte)3, this::onTopicHandleRequest);
        this.registerPacketListener((byte)1, this::onTopicMessage);
    }

    private int getTopicHandle(TopicIdT topicIdT) {
        HashedTopicId hashedTopicId = new HashedTopicId(topicIdT);
        Integer handleT = this.topicsHandle.get(hashedTopicId);
        if (handleT == null) {
            handleT = this.nextLocalHandle.incrementAndGet();
            this.topicsHandle.put(hashedTopicId, handleT);
            this.handleTopics.put(handleT, hashedTopicId);
        }
        return handleT;
    }

    public void onSubscriptionRequest(GenericConnection conn, PubSubHeader messageHeader) {
        TopicId topicId;
        SubscriptionRequest req = (SubscriptionRequest)messageHeader.u(new SubscriptionRequest());
        if (req == null) {
            return;
        }
        int subHandle = -1;
        if (req.topicType() == 1) {
            TopicHandle handle2 = (TopicHandle)req.topic(new TopicHandle());
            if (handle2 != null && this.handleTopics.containsKey(handle2.id())) {
                subHandle = handle2.id();
            }
        } else if (req.topicType() == 2 && (topicId = (TopicId)req.topic(new TopicId())) != null) {
            subHandle = this.getTopicHandle(topicId.unpack());
        }
        assert (subHandle != -1);
        int finalSubHandle = subHandle;
        Optional<Integer> first = conn.getContext().getSubscribedTopics().stream().filter(handle -> handle == finalSubHandle).findFirst();
        if (!first.isPresent()) {
            conn.getContext().getSubscribedTopics().add(finalSubHandle);
        }
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        int topicIdOffset = TopicId.pack(fbb, this.handleTopics.get(finalSubHandle).getInner());
        int topicHandleOffset = TopicHandle.createTopicHandle(fbb, finalSubHandle);
        int outbound = this.createMessage(fbb, (byte)4, TopicMapping.createTopicMapping(fbb, topicIdOffset, topicHandleOffset));
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    public void onTopicHandleRequest(GenericConnection conn, PubSubHeader messageHeader) {
        TopicHandleRequest req = (TopicHandleRequest)messageHeader.u(new TopicHandleRequest());
        if (req == null) {
            return;
        }
        TopicHandleRequestT topicRequest = req.unpack();
        int handle = this.getTopicHandle(topicRequest.getId());
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        int topicIdOffset = TopicId.pack(fbb, topicRequest.getId());
        int topicHandleOffset = TopicHandle.createTopicHandle(fbb, handle);
        int outbound = this.createMessage(fbb, (byte)4, TopicMapping.createTopicMapping(fbb, topicIdOffset, topicHandleOffset));
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    public void onTopicMessage(GenericConnection c, PubSubHeader messageHeader) {
        Message req = (Message)messageHeader.u(new Message());
        if (req == null) {
            return;
        }
        MessageT messageT = req.unpack();
        int subHandle = 1;
        if (messageT.getTopic().getType() == 1) {
            subHandle = messageT.getTopic().asTopicHandle().getId();
        } else if (messageT.getTopic().getType() == 2) {
            subHandle = this.getTopicHandle(messageT.getTopic().asTopicId());
        }
        assert (subHandle != -1);
        int finalSubHandle = subHandle;
        this.api.getAPIServers().forEach(server -> server.getAPIConnections().forEach(conn -> {
            if (!conn.getConnectionId().equals(c.getConnectionId()) && conn.getContext().getSubscribedTopics().contains(finalSubHandle)) {
                FlatBufferBuilder fbb = new FlatBufferBuilder(32);
                int outbound = this.createMessage(fbb, (byte)1, Message.pack(fbb, messageT));
                fbb.finish(outbound);
                conn.send(fbb.dataBuffer());
            }
        }));
    }

    @Override
    public void onMessage(GenericConnection conn, PubSubHeader message) {
        BiConsumer consumer = this.handlers[message.uType()];
        if (consumer != null) {
            consumer.accept(conn, message);
        } else {
            LogManager.info("[ProtocolAPI] Unhandled PubSub packet received id: " + message.uType());
        }
    }

    @Override
    public int messagesCount() {
        return PubSubUnion.names.length;
    }

    public int createMessage(FlatBufferBuilder fbb, byte messageType, int messageOffset) {
        int[] data = new int[]{PubSubHeader.createPubSubHeader(fbb, messageType, messageOffset)};
        int messages = MessageBundle.createPubSubMsgsVector(fbb, data);
        MessageBundle.startMessageBundle(fbb);
        MessageBundle.addPubSubMsgs(fbb, messages);
        return MessageBundle.endMessageBundle(fbb);
    }
}

