/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.protocol.rpc;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import dev.slimevr.VRServer;
import dev.slimevr.config.ConfigManager;
import dev.slimevr.config.OverlayConfig;
import dev.slimevr.config.StayAlignedConfig;
import dev.slimevr.config.StayAlignedRelaxedPoseConfig;
import dev.slimevr.config.TrackerConfigKt;
import dev.slimevr.math.Angle;
import dev.slimevr.posestreamer.BVHRecorder;
import dev.slimevr.protocol.GenericConnection;
import dev.slimevr.protocol.ProtocolAPI;
import dev.slimevr.protocol.ProtocolHandler;
import dev.slimevr.protocol.datafeed.DataFeedBuilder;
import dev.slimevr.protocol.rpc.RPCBuilderKt;
import dev.slimevr.protocol.rpc.autobone.RPCAutoBoneHandler;
import dev.slimevr.protocol.rpc.firmware.RPCFirmwareUpdateHandler;
import dev.slimevr.protocol.rpc.games.vrchat.RPCVRChatHandler;
import dev.slimevr.protocol.rpc.reset.RPCResetHandler;
import dev.slimevr.protocol.rpc.serial.RPCProvisioningHandler;
import dev.slimevr.protocol.rpc.serial.RPCSerialHandler;
import dev.slimevr.protocol.rpc.settings.RPCSettingsBuilder;
import dev.slimevr.protocol.rpc.settings.RPCSettingsHandler;
import dev.slimevr.protocol.rpc.setup.RPCHandshakeHandler;
import dev.slimevr.protocol.rpc.setup.RPCTapSetupHandler;
import dev.slimevr.protocol.rpc.setup.RPCUtil;
import dev.slimevr.protocol.rpc.status.RPCStatusHandler;
import dev.slimevr.protocol.rpc.trackingpause.RPCTrackingPause;
import dev.slimevr.tracking.processor.HumanPoseManager;
import dev.slimevr.tracking.processor.config.SkeletonConfigOffsets;
import dev.slimevr.tracking.processor.stayaligned.poses.RelaxedPose;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerPosition;
import dev.slimevr.tracking.trackers.TrackerStatus;
import dev.slimevr.tracking.trackers.TrackerUtils;
import io.eiren.util.logging.LogManager;
import io.github.axisangles.ktmath.Quaternion;
import io.github.axisangles.ktmath.Vector3;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solarxr_protocol.MessageBundle;
import solarxr_protocol.datatypes.TrackerIdT;
import solarxr_protocol.datatypes.TransactionId;
import solarxr_protocol.rpc.AssignTrackerRequest;
import solarxr_protocol.rpc.ChangeMagToggleRequest;
import solarxr_protocol.rpc.ChangeSkeletonConfigRequest;
import solarxr_protocol.rpc.ClearDriftCompensationRequest;
import solarxr_protocol.rpc.ClearMountingResetRequest;
import solarxr_protocol.rpc.EnableStayAlignedRequest;
import solarxr_protocol.rpc.HeightResponse;
import solarxr_protocol.rpc.LegTweaksTmpChange;
import solarxr_protocol.rpc.LegTweaksTmpClear;
import solarxr_protocol.rpc.MagToggleRequest;
import solarxr_protocol.rpc.MagToggleResponse;
import solarxr_protocol.rpc.OverlayDisplayModeChangeRequest;
import solarxr_protocol.rpc.OverlayDisplayModeResponse;
import solarxr_protocol.rpc.RecordBVHRequest;
import solarxr_protocol.rpc.RecordBVHStatus;
import solarxr_protocol.rpc.RecordBVHStatusRequest;
import solarxr_protocol.rpc.ResetRequest;
import solarxr_protocol.rpc.ResetStayAlignedRelaxedPoseRequest;
import solarxr_protocol.rpc.RpcMessage;
import solarxr_protocol.rpc.RpcMessageHeader;
import solarxr_protocol.rpc.ServerInfosResponse;
import solarxr_protocol.rpc.SetPauseTrackingRequest;
import solarxr_protocol.rpc.SkeletonConfigRequest;
import solarxr_protocol.rpc.SkeletonResetAllRequest;
import solarxr_protocol.rpc.StatusMessageT;
import solarxr_protocol.rpc.StatusSystemRequest;
import solarxr_protocol.rpc.StatusSystemResponse;
import solarxr_protocol.rpc.StatusSystemResponseT;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u000e\u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001/B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0016\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0016\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0016\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0016\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0016\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0016\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0016\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0016\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0016\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001e2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0002H\u0007J\b\u0010%\u001a\u00020\u001eH\u0016J\u0016\u0010&\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0016\u0010'\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0018\u0010(\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002J\u0016\u0010)\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0016\u0010*\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002J\u0018\u0010+\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010,\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010-\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010.\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Ldev/slimevr/protocol/rpc/RPCHandler;", "Ldev/slimevr/protocol/ProtocolHandler;", "Lsolarxr_protocol/rpc/RpcMessageHeader;", "api", "Ldev/slimevr/protocol/ProtocolAPI;", "<init>", "(Ldev/slimevr/protocol/ProtocolAPI;)V", "mainScope", "Lkotlinx/coroutines/CoroutineScope;", "onServerInfosRequest", "", "conn", "Ldev/slimevr/protocol/GenericConnection;", "messageHeader", "onOverlayDisplayModeRequest", "onOverlayDisplayModeChangeRequest", "onSkeletonResetAllRequest", "onSkeletonConfigRequest", "onChangeSkeletonConfigRequest", "onRecordBVHRequest", "onBVHStatusRequest", "onResetRequest", "onClearMountingResetRequest", "onAssignTrackerRequest", "onClearDriftCompensationRequest", "onLegTweaksTmpChange", "onLegTweaksTmpClear", "onMessage", "message", "createRPCMessage", "", "fbb", "Lcom/google/flatbuffers/FlatBufferBuilder;", "messageType", "", "messageOffset", "respondTo", "messagesCount", "onStatusSystemRequest", "onSetPauseTrackingRequest", "onHeightRequest", "onMagToggleRequest", "onChangeMagToggleRequest", "onEnableStayAlignedRequest", "onDetectStayAlignedRelaxedPoseRequest", "onResetStayAlignedRelaxedPoseRequest", "sendSettingsChangedResponse", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nRPCHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RPCHandler.kt\ndev/slimevr/protocol/rpc/RPCHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,741:1\n774#2:742\n865#2,2:743\n1#3:745\n*S KotlinDebug\n*F\n+ 1 RPCHandler.kt\ndev/slimevr/protocol/rpc/RPCHandler\n*L\n545#1:742\n545#1:743,2\n*E\n"})
public final class RPCHandler
extends ProtocolHandler<RpcMessageHeader> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProtocolAPI api;
    @NotNull
    private final CoroutineScope mainScope;
    @NotNull
    private static final String RESET_SOURCE_NAME = "WebSocketAPI";

    public RPCHandler(@NotNull ProtocolAPI api) {
        Intrinsics.checkNotNullParameter(api, "api");
        this.api = api;
        this.mainScope = CoroutineScopeKt.CoroutineScope(SupervisorKt.SupervisorJob$default(null, 1, null));
        new RPCResetHandler(this, this.api);
        new RPCSerialHandler(this, this.api);
        new RPCProvisioningHandler(this, this.api);
        new RPCSettingsHandler(this, this.api);
        new RPCTapSetupHandler(this, this.api);
        new RPCStatusHandler(this, this.api);
        new RPCAutoBoneHandler(this, this.api);
        new RPCHandshakeHandler(this, this.api);
        new RPCTrackingPause(this, this.api);
        new RPCFirmwareUpdateHandler(this, this.api);
        new RPCVRChatHandler(this, this.api);
        this.registerPacketListener((byte)3, (arg_0, arg_1) -> RPCHandler._init_$lambda$0(this, arg_0, arg_1));
        this.registerPacketListener((byte)45, (arg_0, arg_1) -> RPCHandler._init_$lambda$1(this, arg_0, arg_1));
        this.registerPacketListener((byte)5, (arg_0, arg_1) -> RPCHandler._init_$lambda$2(this, arg_0, arg_1));
        this.registerPacketListener((byte)9, (arg_0, arg_1) -> RPCHandler._init_$lambda$3(this, arg_0, arg_1));
        this.registerPacketListener((byte)10, (arg_0, arg_1) -> RPCHandler._init_$lambda$4(this, arg_0, arg_1));
        this.registerPacketListener((byte)65, (arg_0, arg_1) -> RPCHandler._init_$lambda$5(this, arg_0, arg_1));
        this.registerPacketListener((byte)14, (arg_0, arg_1) -> RPCHandler._init_$lambda$6(this, arg_0, arg_1));
        this.registerPacketListener((byte)12, (arg_0, arg_1) -> RPCHandler._init_$lambda$7(this, arg_0, arg_1));
        this.registerPacketListener((byte)13, (arg_0, arg_1) -> RPCHandler._init_$lambda$8(this, arg_0, arg_1));
        this.registerPacketListener((byte)24, (arg_0, arg_1) -> RPCHandler._init_$lambda$9(this, arg_0, arg_1));
        this.registerPacketListener((byte)23, (arg_0, arg_1) -> RPCHandler._init_$lambda$10(this, arg_0, arg_1));
        this.registerPacketListener((byte)35, (arg_0, arg_1) -> RPCHandler._init_$lambda$11(this, arg_0, arg_1));
        this.registerPacketListener((byte)37, (arg_0, arg_1) -> RPCHandler._init_$lambda$12(this, arg_0, arg_1));
        this.registerPacketListener((byte)38, (arg_0, arg_1) -> RPCHandler._init_$lambda$13(this, arg_0, arg_1));
        this.registerPacketListener((byte)41, (arg_0, arg_1) -> RPCHandler._init_$lambda$14(this, arg_0, arg_1));
        this.registerPacketListener((byte)40, (arg_0, arg_1) -> RPCHandler._init_$lambda$15(this, arg_0, arg_1));
        this.registerPacketListener((byte)46, (arg_0, arg_1) -> RPCHandler._init_$lambda$16(this, arg_0, arg_1));
        this.registerPacketListener((byte)62, (arg_0, arg_1) -> RPCHandler._init_$lambda$17(this, arg_0, arg_1));
        this.registerPacketListener((byte)64, (arg_0, arg_1) -> RPCHandler._init_$lambda$18(this, arg_0, arg_1));
        this.registerPacketListener((byte)68, (arg_0, arg_1) -> RPCHandler._init_$lambda$19(this, arg_0, arg_1));
        this.registerPacketListener((byte)69, (arg_0, arg_1) -> RPCHandler._init_$lambda$20(this, arg_0, arg_1));
        this.registerPacketListener((byte)70, (arg_0, arg_1) -> RPCHandler._init_$lambda$21(this, arg_0, arg_1));
    }

    private final void onServerInfosRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        String string = RPCUtil.getLocalIp();
        if (string == null) {
            return;
        }
        String localIp = string;
        int response = ServerInfosResponse.createServerInfosResponse(fbb, fbb.createString(localIp));
        int outbound = this.createRPCMessage(fbb, (byte)36, response, messageHeader);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    private final void onOverlayDisplayModeRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        OverlayConfig config = this.api.server.configManager.getVrConfig().getOverlay();
        int response = OverlayDisplayModeResponse.createOverlayDisplayModeResponse(fbb, config.isVisible(), config.isMirrored());
        int outbound = this.createRPCMessage(fbb, (byte)25, response, messageHeader);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    private final void onOverlayDisplayModeChangeRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        Table table = messageHeader.message(new OverlayDisplayModeChangeRequest());
        OverlayDisplayModeChangeRequest overlayDisplayModeChangeRequest = table instanceof OverlayDisplayModeChangeRequest ? (OverlayDisplayModeChangeRequest)table : null;
        if (overlayDisplayModeChangeRequest == null) {
            return;
        }
        OverlayDisplayModeChangeRequest req = overlayDisplayModeChangeRequest;
        OverlayConfig config = this.api.server.configManager.getVrConfig().getOverlay();
        config.setMirrored(req.isMirrored());
        config.setVisible(req.isVisible());
        this.api.server.configManager.saveConfig();
    }

    public final void onSkeletonResetAllRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        if (!(messageHeader.message(new SkeletonResetAllRequest()) instanceof SkeletonResetAllRequest)) {
            return;
        }
        this.api.server.humanPoseManager.resetOffsets();
        this.api.server.humanPoseManager.saveConfig();
        this.api.server.configManager.saveConfig();
        FlatBufferBuilder fbb = new FlatBufferBuilder(300);
        int config = RPCBuilderKt.createSkeletonConfig(fbb, this.api.server.humanPoseManager);
        int outbound = this.createRPCMessage(fbb, (byte)15, config, messageHeader);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    public final void onSkeletonConfigRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        if (!(messageHeader.message(new SkeletonConfigRequest()) instanceof SkeletonConfigRequest)) {
            return;
        }
        FlatBufferBuilder fbb = new FlatBufferBuilder(300);
        int config = RPCBuilderKt.createSkeletonConfig(fbb, this.api.server.humanPoseManager);
        int outbound = this.createRPCMessage(fbb, (byte)15, config, messageHeader);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    public final void onChangeSkeletonConfigRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        Table table = messageHeader.message(new ChangeSkeletonConfigRequest());
        ChangeSkeletonConfigRequest changeSkeletonConfigRequest = table instanceof ChangeSkeletonConfigRequest ? (ChangeSkeletonConfigRequest)table : null;
        if (changeSkeletonConfigRequest == null) {
            return;
        }
        ChangeSkeletonConfigRequest req = changeSkeletonConfigRequest;
        SkeletonConfigOffsets joint = SkeletonConfigOffsets.getById(req.bone());
        HumanPoseManager humanPoseManager = this.api.server.humanPoseManager;
        Intrinsics.checkNotNull((Object)joint);
        humanPoseManager.setOffset(joint, Float.valueOf(req.value()));
        this.api.server.humanPoseManager.saveConfig();
        this.api.server.configManager.saveConfig();
    }

    public final void onRecordBVHRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        Table table = messageHeader.message(new RecordBVHRequest());
        RecordBVHRequest recordBVHRequest = table instanceof RecordBVHRequest ? (RecordBVHRequest)table : null;
        if (recordBVHRequest == null) {
            return;
        }
        RecordBVHRequest req = recordBVHRequest;
        if (req.stop()) {
            if (this.api.server.bvhRecorder.isRecording()) {
                this.api.server.bvhRecorder.endRecording();
            }
        } else if (!this.api.server.bvhRecorder.isRecording()) {
            BVHRecorder bVHRecorder = this.api.server.bvhRecorder;
            String string = req.path();
            Intrinsics.checkNotNullExpressionValue(string, "path(...)");
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path, "get(...)");
            bVHRecorder.startRecording(path);
        }
        FlatBufferBuilder fbb = new FlatBufferBuilder(40);
        int status = RecordBVHStatus.createRecordBVHStatus(fbb, this.api.server.bvhRecorder.isRecording());
        int outbound = this.createRPCMessage(fbb, (byte)11, status, messageHeader);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    public final void onBVHStatusRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        if (!(messageHeader.message(new RecordBVHStatusRequest()) instanceof RecordBVHStatusRequest)) {
            return;
        }
        FlatBufferBuilder fbb = new FlatBufferBuilder(40);
        int status = RecordBVHStatus.createRecordBVHStatus(fbb, this.api.server.bvhRecorder.isRecording());
        int outbound = this.createRPCMessage(fbb, (byte)11, status, messageHeader);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    public final void onResetRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        Table table = messageHeader.message(new ResetRequest());
        ResetRequest resetRequest = table instanceof ResetRequest ? (ResetRequest)table : null;
        if (resetRequest == null) {
            return;
        }
        ResetRequest req = resetRequest;
        List bodyParts = new ArrayList();
        if (req.bodyPartsLength() > 0) {
            ByteBuffer buffer = req.bodyPartsAsByteBuffer();
            while (buffer.hasRemaining()) {
                bodyParts.add(Integer.valueOf(buffer.get()));
            }
        }
        if (req.resetType() == 0) {
            if (bodyParts.isEmpty()) {
                VRServer.resetTrackersYaw$default(this.api.server, RESET_SOURCE_NAME, null, 2, null);
            } else {
                this.api.server.resetTrackersYaw(RESET_SOURCE_NAME, CollectionsKt.toList(bodyParts));
            }
        }
        if (req.resetType() == 1) {
            if (bodyParts.isEmpty()) {
                VRServer.resetTrackersFull$default(this.api.server, RESET_SOURCE_NAME, null, 2, null);
            } else {
                this.api.server.resetTrackersFull(RESET_SOURCE_NAME, CollectionsKt.toList(bodyParts));
            }
        }
        if (req.resetType() == 2) {
            if (bodyParts.isEmpty()) {
                VRServer.resetTrackersMounting$default(this.api.server, RESET_SOURCE_NAME, null, 2, null);
            } else {
                this.api.server.resetTrackersMounting(RESET_SOURCE_NAME, CollectionsKt.toList(bodyParts));
            }
        }
    }

    public final void onClearMountingResetRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        if (!(messageHeader.message(new ClearMountingResetRequest()) instanceof ClearMountingResetRequest)) {
            return;
        }
        this.api.server.clearTrackersMounting(RESET_SOURCE_NAME);
    }

    public final void onAssignTrackerRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Tracker previousTracker;
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        Table table = messageHeader.message(new AssignTrackerRequest());
        AssignTrackerRequest assignTrackerRequest = table instanceof AssignTrackerRequest ? (AssignTrackerRequest)table : null;
        if (assignTrackerRequest == null) {
            return;
        }
        AssignTrackerRequest req = assignTrackerRequest;
        VRServer vRServer = this.api.server;
        TrackerIdT trackerIdT = req.trackerId().unpack();
        Intrinsics.checkNotNullExpressionValue(trackerIdT, "unpack(...)");
        Tracker tracker = vRServer.getTrackerById(trackerIdT);
        if (tracker == null) {
            return;
        }
        Tracker tracker2 = tracker;
        TrackerPosition pos = TrackerPosition.Companion.getByBodyPart(req.bodyPosition());
        Tracker tracker3 = previousTracker = pos != null ? TrackerUtils.getTrackerForSkeleton(this.api.server.getAllTrackers(), pos) : null;
        if (previousTracker != null) {
            previousTracker.setTrackerPosition(null);
            this.api.server.trackerUpdated(previousTracker);
        }
        tracker2.setTrackerPosition(pos);
        if (req.mountingOrientation() != null && tracker2.getNeedsMounting()) {
            float f = req.mountingOrientation().w();
            float f2 = req.mountingOrientation().x();
            float f3 = req.mountingOrientation().y();
            float f4 = req.mountingOrientation().z();
            Quaternion.constructor-impl(f, f2, f3, f4);
            tracker2.getResetsHandler().setMountingOrientation-oS71L7k(f, f2, f3, f4);
        }
        if (req.displayName() != null) {
            tracker2.setCustomName(req.displayName());
        }
        if (tracker2.isImu()) {
            tracker2.getResetsHandler().setAllowDriftCompensation(req.allowDriftCompensation());
        }
        this.api.server.trackerUpdated(tracker2);
    }

    public final void onClearDriftCompensationRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        if (!(messageHeader.message(new ClearDriftCompensationRequest()) instanceof ClearDriftCompensationRequest)) {
            return;
        }
        this.api.server.clearTrackersDriftCompensation();
    }

    public final void onLegTweaksTmpChange(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        Table table = messageHeader.message(new LegTweaksTmpChange());
        LegTweaksTmpChange legTweaksTmpChange = table instanceof LegTweaksTmpChange ? (LegTweaksTmpChange)table : null;
        if (legTweaksTmpChange == null) {
            return;
        }
        LegTweaksTmpChange req = legTweaksTmpChange;
        this.api.server.humanPoseManager.setLegTweaksStateTemp(req.skatingCorrection(), req.floorClip(), req.toeSnap(), req.footPlant());
    }

    public final void onLegTweaksTmpClear(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        Table table = messageHeader.message(new LegTweaksTmpClear());
        LegTweaksTmpClear legTweaksTmpClear = table instanceof LegTweaksTmpClear ? (LegTweaksTmpClear)table : null;
        if (legTweaksTmpClear == null) {
            return;
        }
        LegTweaksTmpClear req = legTweaksTmpClear;
        this.api.server.humanPoseManager.clearLegTweaksStateTemp(req.skatingCorrection(), req.floorClip(), req.toeSnap(), req.footPlant());
    }

    @Override
    public void onMessage(@NotNull GenericConnection conn, @NotNull RpcMessageHeader message) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(message, "message");
        BiConsumer consumer = this.handlers[message.messageType()];
        if (consumer != null) {
            consumer.accept(conn, message);
        } else {
            LogManager.info("[ProtocolAPI] Unhandled RPC packet received id: " + message.messageType());
        }
    }

    @JvmOverloads
    public final int createRPCMessage(@NotNull FlatBufferBuilder fbb, byte messageType, int messageOffset, @Nullable RpcMessageHeader respondTo) {
        Intrinsics.checkNotNullParameter(fbb, "fbb");
        int[] data = new int[1];
        RpcMessageHeader.startRpcMessageHeader(fbb);
        RpcMessageHeader.addMessage(fbb, messageOffset);
        RpcMessageHeader.addMessageType(fbb, messageType);
        Object object = respondTo;
        if (object != null && (object = ((RpcMessageHeader)object).txId()) != null) {
            Object txId = object;
            boolean bl = false;
            RpcMessageHeader.addTxId(fbb, TransactionId.createTransactionId(fbb, ((TransactionId)txId).id()));
        }
        data[0] = RpcMessageHeader.endRpcMessageHeader(fbb);
        int messages = MessageBundle.createRpcMsgsVector(fbb, data);
        MessageBundle.startMessageBundle(fbb);
        MessageBundle.addRpcMsgs(fbb, messages);
        return MessageBundle.endMessageBundle(fbb);
    }

    public static /* synthetic */ int createRPCMessage$default(RPCHandler rPCHandler, FlatBufferBuilder flatBufferBuilder, byte by, int n, RpcMessageHeader rpcMessageHeader, int n2, Object object) {
        if ((n2 & 8) != 0) {
            rpcMessageHeader = null;
        }
        return rPCHandler.createRPCMessage(flatBufferBuilder, by, n, rpcMessageHeader);
    }

    @Override
    public int messagesCount() {
        return RpcMessage.names.length;
    }

    public final void onStatusSystemRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        Table table = messageHeader.message(new StatusSystemRequest());
        StatusSystemRequest statusSystemRequest = table instanceof StatusSystemRequest ? (StatusSystemRequest)table : null;
        if (statusSystemRequest == null) {
            return;
        }
        StatusSystemRequest req = statusSystemRequest;
        StatusMessageT[] statuses = this.api.server.statusSystem.getStatuses();
        FlatBufferBuilder fbb = new FlatBufferBuilder(statuses.length * 32);
        StatusSystemResponseT response = new StatusSystemResponseT();
        response.setCurrentStatuses(statuses);
        int offset = StatusSystemResponse.pack(fbb, response);
        int outbound = this.createRPCMessage(fbb, (byte)42, offset, messageHeader);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    public final void onSetPauseTrackingRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        Table table = messageHeader.message(new SetPauseTrackingRequest());
        SetPauseTrackingRequest setPauseTrackingRequest = table instanceof SetPauseTrackingRequest ? (SetPauseTrackingRequest)table : null;
        if (setPauseTrackingRequest == null) {
            return;
        }
        SetPauseTrackingRequest req = setPauseTrackingRequest;
        this.api.server.setPauseTracking(req.pauseTracking(), RESET_SOURCE_NAME);
    }

    /*
     * WARNING - void declaration
     */
    public final void onHeightRequest(@NotNull GenericConnection conn, @Nullable RpcMessageHeader messageHeader) {
        int n;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(conn, "conn");
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        Iterable $this$filter$iv = this.api.server.getAllTrackers();
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tracker it = (Tracker)element$iv$iv;
            boolean bl = false;
            if (!(!it.isInternal() && it.getStatus() == TrackerStatus.OK && it.getHasPosition() && it.getTrackerPosition() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List posTrackers = (List)destination$iv$iv;
        if (!((Collection)posTrackers).isEmpty()) {
            float f;
            Iterator iterator3;
            Tracker it;
            Iterator iterator4;
            Object object;
            float f2;
            FlatBufferBuilder flatBufferBuilder;
            block10: {
                Iterable iterable = posTrackers;
                flatBufferBuilder = fbb;
                iterator2 = iterable.iterator();
                if (!iterator2.hasNext()) {
                    throw new NoSuchElementException();
                }
                Tracker it2 = (Tracker)iterator2.next();
                boolean bl = false;
                float f3 = it2.getPosition-y();
                while (iterator2.hasNext()) {
                    Tracker it3 = (Tracker)iterator2.next();
                    $i$a$-minOf-RPCHandler$onHeightRequest$response$1 = false;
                    float f4 = it3.getPosition-y();
                    f3 = Math.min(f3, f4);
                }
                f2 = f3;
                Iterator iterator5 = iterator2 = (Iterable)posTrackers;
                object = iterator5.iterator();
                while (object.hasNext()) {
                    iterator4 = object.next();
                    it = (Tracker)((Object)iterator4);
                    boolean bl2 = false;
                    if (!(it.getTrackerPosition() == TrackerPosition.HEAD)) continue;
                    iterator3 = iterator4;
                    break block10;
                }
                iterator3 = null;
            }
            Iterator iterator6 = iterator3;
            FlatBufferBuilder flatBufferBuilder2 = flatBufferBuilder;
            float f5 = f2;
            Object object2 = (Tracker)((Object)iterator6);
            if (object2 != null && (object2 = ((Tracker)object2).getPosition()) != null) {
                f = ((Vector3)object2).unbox-impl-y();
            } else {
                object = posTrackers;
                f2 = f5;
                flatBufferBuilder = flatBufferBuilder2;
                iterator4 = object.iterator();
                if (!iterator4.hasNext()) {
                    throw new NoSuchElementException();
                }
                it = (Tracker)iterator4.next();
                boolean bl = false;
                float f6 = it.getPosition-y();
                while (iterator4.hasNext()) {
                    Tracker it4 = (Tracker)iterator4.next();
                    $i$a$-maxOf-RPCHandler$onHeightRequest$response$3 = false;
                    float f7 = it4.getPosition-y();
                    f6 = Math.max(f6, f7);
                }
                float f8 = f6;
                flatBufferBuilder2 = flatBufferBuilder;
                f5 = f2;
                f = f8;
            }
            n = HeightResponse.createHeightResponse(flatBufferBuilder2, f5, f);
        } else {
            n = HeightResponse.createHeightResponse(fbb, 0.0f, 0.0f);
        }
        int response = n;
        fbb.finish(this.createRPCMessage(fbb, (byte)47, response, messageHeader));
        conn.send(fbb.dataBuffer());
    }

    public final void onMagToggleRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        Table table = messageHeader.message(new MagToggleRequest());
        MagToggleRequest magToggleRequest = table instanceof MagToggleRequest ? (MagToggleRequest)table : null;
        if (magToggleRequest == null) {
            return;
        }
        MagToggleRequest req = magToggleRequest;
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        if (req.trackerId() == null) {
            int response = MagToggleResponse.createMagToggleResponse(fbb, 0, this.api.server.configManager.getVrConfig().getServer().getUseMagnetometerOnAllTrackers());
            fbb.finish(this.createRPCMessage(fbb, (byte)63, response, messageHeader));
            conn.send(fbb.dataBuffer());
            return;
        }
        VRServer vRServer = this.api.server;
        TrackerIdT trackerIdT = req.trackerId().unpack();
        Intrinsics.checkNotNullExpressionValue(trackerIdT, "unpack(...)");
        Tracker tracker = vRServer.getTrackerById(trackerIdT);
        if (tracker == null) {
            return;
        }
        Tracker tracker2 = tracker;
        int trackerId = DataFeedBuilder.createTrackerId(fbb, tracker2);
        int response = MagToggleResponse.createMagToggleResponse(fbb, trackerId, Intrinsics.areEqual(TrackerConfigKt.getConfig(tracker2).getShouldHaveMagEnabled(), true));
        fbb.finish(this.createRPCMessage(fbb, (byte)63, response, messageHeader));
        conn.send(fbb.dataBuffer());
    }

    public final void onChangeMagToggleRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        Table table = messageHeader.message(new ChangeMagToggleRequest());
        ChangeMagToggleRequest changeMagToggleRequest = table instanceof ChangeMagToggleRequest ? (ChangeMagToggleRequest)table : null;
        if (changeMagToggleRequest == null) {
            return;
        }
        ChangeMagToggleRequest req = changeMagToggleRequest;
        if (req.trackerId() == null) {
            BuildersKt.launch$default(this.mainScope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, messageHeader, conn, req, null){
                int label;
                final /* synthetic */ RPCHandler this$0;
                final /* synthetic */ RpcMessageHeader $messageHeader;
                final /* synthetic */ GenericConnection $conn;
                final /* synthetic */ ChangeMagToggleRequest $req;
                {
                    this.this$0 = $receiver;
                    this.$messageHeader = $messageHeader;
                    this.$conn = $conn;
                    this.$req = $req;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            this.label = 1;
                            v0 = TimeoutKt.withTimeoutOrNull(10000L, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$req, null){
                                int label;
                                final /* synthetic */ RPCHandler this$0;
                                final /* synthetic */ ChangeMagToggleRequest $req;
                                {
                                    this.this$0 = $receiver;
                                    this.$req = $req;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.label = 1;
                                            Object object3 = RPCHandler.access$getApi$p((RPCHandler)this.this$0).server.configManager.getVrConfig().getServer().defineMagOnAllTrackers(this.$req.enable(), this);
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure($result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            fbb = new FlatBufferBuilder(32);
                            response = MagToggleResponse.createMagToggleResponse(fbb, 0, RPCHandler.access$getApi$p((RPCHandler)this.this$0).server.configManager.getVrConfig().getServer().getUseMagnetometerOnAllTrackers());
                            fbb.finish(this.this$0.createRPCMessage(fbb, (byte)63, response, this.$messageHeader));
                            this.$conn.send(fbb.dataBuffer());
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
            return;
        }
        VRServer vRServer = this.api.server;
        TrackerIdT trackerIdT = req.trackerId().unpack();
        Intrinsics.checkNotNullExpressionValue(trackerIdT, "unpack(...)");
        Tracker tracker = vRServer.getTrackerById(trackerIdT);
        if (tracker == null) {
            return;
        }
        Tracker tracker2 = tracker;
        if (tracker2.getDevice() == null || Intrinsics.areEqual(TrackerConfigKt.getConfig(tracker2).getShouldHaveMagEnabled(), req.enable())) {
            return;
        }
        boolean state = req.enable();
        TrackerConfigKt.getConfig(tracker2).setShouldHaveMagEnabled(state);
        if (!this.api.server.configManager.getVrConfig().getServer().getUseMagnetometerOnAllTrackers()) {
            FlatBufferBuilder fbb = new FlatBufferBuilder(32);
            int trackerId = DataFeedBuilder.createTrackerId(fbb, tracker2);
            int response = MagToggleResponse.createMagToggleResponse(fbb, trackerId, state);
            fbb.finish(this.createRPCMessage(fbb, (byte)63, response, messageHeader));
            conn.send(fbb.dataBuffer());
            return;
        }
        BuildersKt.launch$default(this.mainScope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(tracker2, state, this, messageHeader, conn, null){
            int label;
            final /* synthetic */ Tracker $tracker;
            final /* synthetic */ boolean $state;
            final /* synthetic */ RPCHandler this$0;
            final /* synthetic */ RpcMessageHeader $messageHeader;
            final /* synthetic */ GenericConnection $conn;
            {
                this.$tracker = $tracker;
                this.$state = $state;
                this.this$0 = $receiver;
                this.$messageHeader = $messageHeader;
                this.$conn = $conn;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        this.label = 1;
                        v0 = TimeoutKt.withTimeoutOrNull(10000L, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$tracker, this.$state, null){
                            int label;
                            final /* synthetic */ Tracker $tracker;
                            final /* synthetic */ boolean $state;
                            {
                                this.$tracker = $tracker;
                                this.$state = $state;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        this.label = 1;
                                        Object object3 = this.$tracker.getDevice().setMag(this.$state, this.$tracker.getTrackerNum(), this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure($result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, this);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        fbb = new FlatBufferBuilder(32);
                        trackerId = DataFeedBuilder.createTrackerId(fbb, this.$tracker);
                        response = MagToggleResponse.createMagToggleResponse(fbb, trackerId, this.$state);
                        fbb.finish(this.this$0.createRPCMessage(fbb, (byte)63, response, this.$messageHeader));
                        this.$conn.send(fbb.dataBuffer());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final void onEnableStayAlignedRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        Table table = messageHeader.message(new EnableStayAlignedRequest());
        EnableStayAlignedRequest enableStayAlignedRequest = table instanceof EnableStayAlignedRequest ? (EnableStayAlignedRequest)table : null;
        if (enableStayAlignedRequest == null) {
            return;
        }
        EnableStayAlignedRequest request = enableStayAlignedRequest;
        ConfigManager configManager = this.api.server.configManager;
        StayAlignedConfig config = configManager.getVrConfig().getStayAlignedConfig();
        config.setEnabled(request.enable());
        if (request.enable()) {
            config.setSetupComplete(true);
        }
        configManager.saveConfig();
        this.sendSettingsChangedResponse(conn, messageHeader);
    }

    private final void onDetectStayAlignedRelaxedPoseRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        StayAlignedRelaxedPoseConfig stayAlignedRelaxedPoseConfig;
        Table table = messageHeader.message(new ResetStayAlignedRelaxedPoseRequest());
        ResetStayAlignedRelaxedPoseRequest resetStayAlignedRelaxedPoseRequest = table instanceof ResetStayAlignedRelaxedPoseRequest ? (ResetStayAlignedRelaxedPoseRequest)table : null;
        if (resetStayAlignedRelaxedPoseRequest == null) {
            return;
        }
        ResetStayAlignedRelaxedPoseRequest request = resetStayAlignedRelaxedPoseRequest;
        ConfigManager configManager = this.api.server.configManager;
        StayAlignedConfig config = configManager.getVrConfig().getStayAlignedConfig();
        int pose = request.pose();
        switch (pose) {
            case 0: {
                stayAlignedRelaxedPoseConfig = config.getStandingRelaxedPose();
                break;
            }
            case 1: {
                stayAlignedRelaxedPoseConfig = config.getSittingRelaxedPose();
                break;
            }
            case 2: {
                stayAlignedRelaxedPoseConfig = config.getFlatRelaxedPose();
                break;
            }
            default: {
                return;
            }
        }
        StayAlignedRelaxedPoseConfig poseConfig = stayAlignedRelaxedPoseConfig;
        RelaxedPose relaxedPose = RelaxedPose.Companion.fromTrackers(this.api.server.humanPoseManager.getSkeleton());
        poseConfig.setEnabled(true);
        poseConfig.setUpperLegAngleInDeg(Angle.toDeg-impl(relaxedPose.getUpperLeg-ncrbCcM()));
        poseConfig.setLowerLegAngleInDeg(Angle.toDeg-impl(relaxedPose.getLowerLeg-ncrbCcM()));
        poseConfig.setFootAngleInDeg(Angle.toDeg-impl(relaxedPose.getFoot-ncrbCcM()));
        configManager.saveConfig();
        LogManager.info("[detectStayAlignedRelaxedPose] pose=" + pose + " " + relaxedPose);
        this.sendSettingsChangedResponse(conn, messageHeader);
    }

    private final void onResetStayAlignedRelaxedPoseRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        StayAlignedRelaxedPoseConfig stayAlignedRelaxedPoseConfig;
        Table table = messageHeader.message(new ResetStayAlignedRelaxedPoseRequest());
        ResetStayAlignedRelaxedPoseRequest resetStayAlignedRelaxedPoseRequest = table instanceof ResetStayAlignedRelaxedPoseRequest ? (ResetStayAlignedRelaxedPoseRequest)table : null;
        if (resetStayAlignedRelaxedPoseRequest == null) {
            return;
        }
        ResetStayAlignedRelaxedPoseRequest request = resetStayAlignedRelaxedPoseRequest;
        ConfigManager configManager = this.api.server.configManager;
        StayAlignedConfig config = configManager.getVrConfig().getStayAlignedConfig();
        int pose = request.pose();
        switch (pose) {
            case 0: {
                stayAlignedRelaxedPoseConfig = config.getStandingRelaxedPose();
                break;
            }
            case 1: {
                stayAlignedRelaxedPoseConfig = config.getSittingRelaxedPose();
                break;
            }
            case 2: {
                stayAlignedRelaxedPoseConfig = config.getFlatRelaxedPose();
                break;
            }
            default: {
                return;
            }
        }
        StayAlignedRelaxedPoseConfig poseConfig = stayAlignedRelaxedPoseConfig;
        poseConfig.setEnabled(false);
        poseConfig.setUpperLegAngleInDeg(0.0f);
        poseConfig.setLowerLegAngleInDeg(0.0f);
        poseConfig.setFootAngleInDeg(0.0f);
        LogManager.info("[resetStayAlignedRelaxedPose] pose=" + pose);
        this.sendSettingsChangedResponse(conn, messageHeader);
    }

    public final void sendSettingsChangedResponse(@NotNull GenericConnection conn, @Nullable RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        int settings = RPCSettingsBuilder.createSettingsResponse(fbb, this.api.server);
        int outbound = this.createRPCMessage(fbb, (byte)7, settings, messageHeader);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    @JvmOverloads
    public final int createRPCMessage(@NotNull FlatBufferBuilder fbb, byte messageType, int messageOffset) {
        Intrinsics.checkNotNullParameter(fbb, "fbb");
        return RPCHandler.createRPCMessage$default(this, fbb, messageType, messageOffset, null, 8, null);
    }

    private static final void _init_$lambda$0(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onResetRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$1(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onClearMountingResetRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$2(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onAssignTrackerRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$3(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onClearDriftCompensationRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$4(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onRecordBVHRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$5(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onBVHStatusRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$6(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onSkeletonResetAllRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$7(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onSkeletonConfigRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$8(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onChangeSkeletonConfigRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$9(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onOverlayDisplayModeChangeRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$10(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onOverlayDisplayModeRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$11(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onServerInfosRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$12(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onLegTweaksTmpChange(conn, messageHeader);
    }

    private static final void _init_$lambda$13(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onLegTweaksTmpClear(conn, messageHeader);
    }

    private static final void _init_$lambda$14(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onStatusSystemRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$15(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onSetPauseTrackingRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$16(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onHeightRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$17(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onMagToggleRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$18(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onChangeMagToggleRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$19(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onEnableStayAlignedRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$20(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onDetectStayAlignedRelaxedPoseRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$21(RPCHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onResetStayAlignedRelaxedPoseRequest(conn, messageHeader);
    }

    public static final /* synthetic */ ProtocolAPI access$getApi$p(RPCHandler $this) {
        return $this.api;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/slimevr/protocol/rpc/RPCHandler$Companion;", "", "<init>", "()V", "RESET_SOURCE_NAME", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

