/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.protocol.rpc.autobone;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import dev.slimevr.autobone.AutoBone;
import dev.slimevr.autobone.AutoBoneListener;
import dev.slimevr.autobone.AutoBoneProcessType;
import dev.slimevr.poseframeformat.PoseFrames;
import dev.slimevr.protocol.GenericConnection;
import dev.slimevr.protocol.ProtocolAPI;
import dev.slimevr.protocol.ProtocolAPIServer;
import dev.slimevr.protocol.rpc.RPCBuilderKt;
import dev.slimevr.protocol.rpc.RPCHandler;
import dev.slimevr.tracking.processor.config.SkeletonConfigOffsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solarxr_protocol.rpc.AutoBoneEpochResponse;
import solarxr_protocol.rpc.AutoBoneProcessRequest;
import solarxr_protocol.rpc.AutoBoneProcessStatusResponse;
import solarxr_protocol.rpc.RpcMessageHeader;
import solarxr_protocol.rpc.SkeletonPart;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJB\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u00020\u000b2\n\u0010!\u001a\u00060\"R\u00020#H\u0016J\u001c\u0010$\u001a\u00020\u000b2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00190&H\u0016J\u0018\u0010(\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010)\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010*\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010+\u001a\u00020\u000b2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006."}, d2={"Ldev/slimevr/protocol/rpc/autobone/RPCAutoBoneHandler;", "Ldev/slimevr/autobone/AutoBoneListener;", "rpcHandler", "Ldev/slimevr/protocol/rpc/RPCHandler;", "api", "Ldev/slimevr/protocol/ProtocolAPI;", "<init>", "(Ldev/slimevr/protocol/rpc/RPCHandler;Ldev/slimevr/protocol/ProtocolAPI;)V", "getApi", "()Ldev/slimevr/protocol/ProtocolAPI;", "onAutoBoneProcessRequest", "", "conn", "Ldev/slimevr/protocol/GenericConnection;", "messageHeader", "Lsolarxr_protocol/rpc/RpcMessageHeader;", "onAutoBoneProcessStatus", "processType", "Ldev/slimevr/autobone/AutoBoneProcessType;", "message", "", "current", "", "total", "eta", "", "completed", "", "success", "onAutoBoneRecordingEnd", "recording", "Ldev/slimevr/poseframeformat/PoseFrames;", "onAutoBoneEpoch", "epoch", "Ldev/slimevr/autobone/AutoBone$Epoch;", "Ldev/slimevr/autobone/AutoBone;", "onAutoBoneEnd", "configValues", "Ljava/util/EnumMap;", "Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "onAutoBoneApplyRequest", "onAutoBoneStopRecordingRequest", "onAutoBoneCancelRecordingRequest", "forAllListeners", "action", "Lkotlin/Function1;", "core"})
@SourceDebugExtension(value={"SMAP\nRPCAutoBoneHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RPCAutoBoneHandler.kt\ndev/slimevr/protocol/rpc/autobone/RPCAutoBoneHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,182:1\n1863#2,2:183\n126#3:185\n153#3,3:186\n*S KotlinDebug\n*F\n+ 1 RPCAutoBoneHandler.kt\ndev/slimevr/protocol/rpc/autobone/RPCAutoBoneHandler\n*L\n177#1:183,2\n118#1:185\n118#1:186,3\n*E\n"})
public final class RPCAutoBoneHandler
implements AutoBoneListener {
    @NotNull
    private final RPCHandler rpcHandler;
    @NotNull
    private final ProtocolAPI api;

    public RPCAutoBoneHandler(@NotNull RPCHandler rpcHandler, @NotNull ProtocolAPI api) {
        Intrinsics.checkNotNullParameter(rpcHandler, "rpcHandler");
        Intrinsics.checkNotNullParameter(api, "api");
        this.rpcHandler = rpcHandler;
        this.api = api;
        this.rpcHandler.registerPacketListener((byte)20, this::onAutoBoneProcessRequest);
        this.rpcHandler.registerPacketListener((byte)48, this::onAutoBoneApplyRequest);
        this.rpcHandler.registerPacketListener((byte)49, this::onAutoBoneStopRecordingRequest);
        this.rpcHandler.registerPacketListener((byte)50, this::onAutoBoneCancelRecordingRequest);
        this.api.server.autoBoneHandler.addListener(this);
    }

    @NotNull
    public final ProtocolAPI getApi() {
        return this.api;
    }

    public final void onAutoBoneProcessRequest(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        Table table = messageHeader.message(new AutoBoneProcessRequest());
        Intrinsics.checkNotNull(table, "null cannot be cast to non-null type solarxr_protocol.rpc.AutoBoneProcessRequest");
        AutoBoneProcessRequest req = (AutoBoneProcessRequest)table;
        if (conn.getContext().useAutoBone()) {
            return;
        }
        conn.getContext().setUseAutoBone(true);
        this.api.server.autoBoneHandler.startProcessByType(AutoBoneProcessType.Companion.getById(req.processType()));
    }

    @Override
    public void onAutoBoneProcessStatus(@NotNull AutoBoneProcessType processType, @Nullable String message, long current, long total, float eta, boolean completed, boolean success) {
        Intrinsics.checkNotNullParameter((Object)processType, "processType");
        this.forAllListeners(arg_0 -> RPCAutoBoneHandler.onAutoBoneProcessStatus$lambda$0(processType, current, total, eta, completed, success, this, arg_0));
    }

    @Override
    public void onAutoBoneRecordingEnd(@NotNull PoseFrames recording) {
        Intrinsics.checkNotNullParameter(recording, "recording");
    }

    @Override
    public void onAutoBoneEpoch(@NotNull AutoBone.Epoch epoch) {
        Intrinsics.checkNotNullParameter(epoch, "epoch");
        this.forAllListeners(arg_0 -> RPCAutoBoneHandler.onAutoBoneEpoch$lambda$2(epoch, this, arg_0));
    }

    @Override
    public void onAutoBoneEnd(@NotNull EnumMap<SkeletonConfigOffsets, Float> configValues) {
        Intrinsics.checkNotNullParameter(configValues, "configValues");
    }

    private final void onAutoBoneApplyRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        this.api.server.autoBoneHandler.applyValues();
        FlatBufferBuilder fbb = new FlatBufferBuilder(300);
        int outbound = RPCHandler.createRPCMessage$default(this.rpcHandler, fbb, (byte)15, RPCBuilderKt.createSkeletonConfig(fbb, this.api.server.humanPoseManager), null, 8, null);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    private final void onAutoBoneStopRecordingRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        this.api.server.autoBoneHandler.stopRecording();
    }

    private final void onAutoBoneCancelRecordingRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        this.api.server.autoBoneHandler.cancelRecording();
    }

    private final void forAllListeners(Function1<? super GenericConnection, Unit> action) {
        List<ProtocolAPIServer> list = this.api.getAPIServers();
        Intrinsics.checkNotNullExpressionValue(list, "getAPIServers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtocolAPIServer it = (ProtocolAPIServer)element$iv;
            boolean bl = false;
            it.getAPIConnections().forEach(arg_0 -> RPCAutoBoneHandler.forAllListeners$lambda$4$lambda$3(action, arg_0));
        }
    }

    private static final Unit onAutoBoneProcessStatus$lambda$0(AutoBoneProcessType $processType, long $current, long $total, float $eta, boolean $completed, boolean $success, RPCAutoBoneHandler this$0, GenericConnection conn) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        if (!conn.getContext().useAutoBone()) {
            return Unit.INSTANCE;
        }
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        AutoBoneProcessStatusResponse.startAutoBoneProcessStatusResponse(fbb);
        AutoBoneProcessStatusResponse.addProcessType(fbb, $processType.getId());
        AutoBoneProcessStatusResponse.addCurrent(fbb, $current);
        AutoBoneProcessStatusResponse.addTotal(fbb, $total);
        AutoBoneProcessStatusResponse.addEta(fbb, $eta);
        AutoBoneProcessStatusResponse.addCompleted(fbb, $completed);
        AutoBoneProcessStatusResponse.addSuccess(fbb, $success);
        int update = AutoBoneProcessStatusResponse.endAutoBoneProcessStatusResponse(fbb);
        int outbound = RPCHandler.createRPCMessage$default(this$0.rpcHandler, fbb, (byte)21, update, null, 8, null);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
        if ($completed) {
            conn.getContext().setUseAutoBone(false);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onAutoBoneEpoch$lambda$2(AutoBone.Epoch $epoch, RPCAutoBoneHandler this$0, GenericConnection conn) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(conn, "conn");
        if (!conn.getContext().useAutoBone()) {
            return Unit.INSTANCE;
        }
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        Map map = $epoch.getConfigValues();
        FlatBufferBuilder flatBufferBuilder = fbb;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SkeletonConfigOffsets key2 = (SkeletonConfigOffsets)((Object)entry.getKey());
            Float value = (Float)entry.getValue();
            int n = key2.id;
            Intrinsics.checkNotNull(value);
            collection.add(SkeletonPart.createSkeletonPart(fbb, n, value.floatValue()));
        }
        int skeletonPartsOffset = AutoBoneEpochResponse.createAdjustedSkeletonPartsVector(flatBufferBuilder, CollectionsKt.toIntArray((List)destination$iv$iv));
        int update = AutoBoneEpochResponse.createAutoBoneEpochResponse(fbb, $epoch.getEpoch(), $epoch.getTotalEpochs(), $epoch.getEpochError().getMean(), skeletonPartsOffset);
        int outbound = RPCHandler.createRPCMessage$default(this$0.rpcHandler, fbb, (byte)22, update, null, 8, null);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
        return Unit.INSTANCE;
    }

    private static final void forAllListeners$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

