/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.protocol.rpc.firmware;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import dev.slimevr.firmware.FirmwareUpdateListener;
import dev.slimevr.firmware.FirmwareUpdateMethod;
import dev.slimevr.firmware.UpdateDeviceId;
import dev.slimevr.firmware.UpdateStatusEvent;
import dev.slimevr.protocol.GenericConnection;
import dev.slimevr.protocol.ProtocolAPI;
import dev.slimevr.protocol.ProtocolAPIServer;
import dev.slimevr.protocol.rpc.RPCHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import solarxr_protocol.datatypes.DeviceIdT;
import solarxr_protocol.datatypes.DeviceIdTableT;
import solarxr_protocol.rpc.FirmwareUpdateDeviceIdUnion;
import solarxr_protocol.rpc.FirmwareUpdateRequest;
import solarxr_protocol.rpc.FirmwareUpdateRequestT;
import solarxr_protocol.rpc.FirmwareUpdateStatusResponse;
import solarxr_protocol.rpc.RpcMessageHeader;
import solarxr_protocol.rpc.SerialDevicePortT;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0013\u001a\u00020\r2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u00182\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Ldev/slimevr/protocol/rpc/firmware/RPCFirmwareUpdateHandler;", "Ldev/slimevr/firmware/FirmwareUpdateListener;", "rpcHandler", "Ldev/slimevr/protocol/rpc/RPCHandler;", "api", "Ldev/slimevr/protocol/ProtocolAPI;", "<init>", "(Ldev/slimevr/protocol/rpc/RPCHandler;Ldev/slimevr/protocol/ProtocolAPI;)V", "getApi", "()Ldev/slimevr/protocol/ProtocolAPI;", "setApi", "(Ldev/slimevr/protocol/ProtocolAPI;)V", "onFirmwareUpdateStopQueuesRequest", "", "conn", "Ldev/slimevr/protocol/GenericConnection;", "messageHeader", "Lsolarxr_protocol/rpc/RpcMessageHeader;", "onFirmwareUpdateRequest", "onUpdateStatusChange", "event", "Ldev/slimevr/firmware/UpdateStatusEvent;", "buildUpdateDeviceId", "Ldev/slimevr/firmware/UpdateDeviceId;", "", "req", "Lsolarxr_protocol/rpc/FirmwareUpdateRequestT;", "createUpdateDeviceId", "data", "core"})
@SourceDebugExtension(value={"SMAP\nRPCFirmwareUpdateHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RPCFirmwareUpdateHandler.kt\ndev/slimevr/protocol/rpc/firmware/RPCFirmwareUpdateHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1863#2,2:135\n*S KotlinDebug\n*F\n+ 1 RPCFirmwareUpdateHandler.kt\ndev/slimevr/protocol/rpc/firmware/RPCFirmwareUpdateHandler\n*L\n84#1:135,2\n*E\n"})
public final class RPCFirmwareUpdateHandler
implements FirmwareUpdateListener {
    @NotNull
    private final RPCHandler rpcHandler;
    @NotNull
    private ProtocolAPI api;

    public RPCFirmwareUpdateHandler(@NotNull RPCHandler rpcHandler, @NotNull ProtocolAPI api) {
        Intrinsics.checkNotNullParameter(rpcHandler, "rpcHandler");
        Intrinsics.checkNotNullParameter(api, "api");
        this.rpcHandler = rpcHandler;
        this.api = api;
        this.api.server.getFirmwareUpdateHandler().addListener(this);
        this.rpcHandler.registerPacketListener((byte)58, this::onFirmwareUpdateRequest);
        this.rpcHandler.registerPacketListener((byte)60, this::onFirmwareUpdateStopQueuesRequest);
    }

    @NotNull
    public final ProtocolAPI getApi() {
        return this.api;
    }

    public final void setApi(@NotNull ProtocolAPI protocolAPI) {
        Intrinsics.checkNotNullParameter(protocolAPI, "<set-?>");
        this.api = protocolAPI;
    }

    private final void onFirmwareUpdateStopQueuesRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        this.api.server.getFirmwareUpdateHandler().cancelUpdates();
    }

    private final void onFirmwareUpdateRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        Table table = messageHeader.message(new FirmwareUpdateRequest());
        Intrinsics.checkNotNull(table, "null cannot be cast to non-null type solarxr_protocol.rpc.FirmwareUpdateRequest");
        FirmwareUpdateRequestT req = ((FirmwareUpdateRequest)table).unpack();
        Intrinsics.checkNotNull(req);
        UpdateDeviceId<Object> updateDeviceId = this.buildUpdateDeviceId(req);
        if (updateDeviceId == null) {
            return;
        }
        UpdateDeviceId<Object> updateDeviceId2 = updateDeviceId;
        this.api.server.getFirmwareUpdateHandler().queueFirmwareUpdate(req, updateDeviceId2);
    }

    @Override
    public void onUpdateStatusChange(@NotNull UpdateStatusEvent<?> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        FirmwareUpdateDeviceIdUnion dataUnion = new FirmwareUpdateDeviceIdUnion();
        dataUnion.setType(event.getDeviceId().getType().getId());
        dataUnion.setValue(this.createUpdateDeviceId(event.getDeviceId()));
        int deviceIdOffset = FirmwareUpdateDeviceIdUnion.pack(fbb, dataUnion);
        FirmwareUpdateStatusResponse.startFirmwareUpdateStatusResponse(fbb);
        FirmwareUpdateStatusResponse.addStatus(fbb, event.getStatus().getId());
        FirmwareUpdateStatusResponse.addDeviceIdType(fbb, dataUnion.getType());
        FirmwareUpdateStatusResponse.addDeviceId(fbb, deviceIdOffset);
        FirmwareUpdateStatusResponse.addProgress(fbb, (byte)event.getProgress());
        int update = FirmwareUpdateStatusResponse.endFirmwareUpdateStatusResponse(fbb);
        int outbound = RPCHandler.createRPCMessage$default(this.rpcHandler, fbb, (byte)59, update, null, 8, null);
        fbb.finish(outbound);
        List<ProtocolAPIServer> list = this.api.getAPIServers();
        Intrinsics.checkNotNullExpressionValue(list, "getAPIServers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtocolAPIServer server = (ProtocolAPIServer)element$iv;
            boolean bl = false;
            server.getAPIConnections().forEach(arg_0 -> RPCFirmwareUpdateHandler.onUpdateStatusChange$lambda$2$lambda$1(arg_0 -> RPCFirmwareUpdateHandler.onUpdateStatusChange$lambda$2$lambda$0(fbb, arg_0), arg_0));
        }
    }

    private final UpdateDeviceId<Object> buildUpdateDeviceId(FirmwareUpdateRequestT req) {
        byte by = req.getMethod().getType();
        if (by == 1) {
            return new UpdateDeviceId<Object>(FirmwareUpdateMethod.OTA, req.getMethod().asOTAFirmwareUpdate().getDeviceId().getId());
        }
        if (by == 2) {
            return new UpdateDeviceId<Object>(FirmwareUpdateMethod.SERIAL, req.getMethod().asSerialFirmwareUpdate().getDeviceId().getPort());
        }
        return null;
    }

    private final Object createUpdateDeviceId(UpdateDeviceId<?> data) {
        return switch (WhenMappings.$EnumSwitchMapping$0[data.getType().ordinal()]) {
            case 1 -> throw new IllegalStateException("Unsupported method".toString());
            case 2 -> {
                void $this$createUpdateDeviceId_u24lambda_u244_u24lambda_u243;
                DeviceIdT var5_8;
                DeviceIdTableT var2_2;
                if (!(data.getId() instanceof Integer)) {
                    throw new IllegalStateException("Invalid state, the id type should be Int".toString());
                }
                DeviceIdTableT $this$createUpdateDeviceId_u24lambda_u244 = var2_2 = new DeviceIdTableT();
                boolean $i$a$-apply-RPCFirmwareUpdateHandler$createUpdateDeviceId$1 = false;
                DeviceIdT var6_9 = var5_8 = new DeviceIdT();
                DeviceIdTableT var7_10 = $this$createUpdateDeviceId_u24lambda_u244;
                boolean $i$a$-apply-RPCFirmwareUpdateHandler$createUpdateDeviceId$1$1 = false;
                $this$createUpdateDeviceId_u24lambda_u244_u24lambda_u243.setId(((Number)data.getId()).intValue());
                var7_10.setId(var5_8);
                yield var2_2;
            }
            case 3 -> {
                SerialDevicePortT var2_3;
                if (!(data.getId() instanceof String)) {
                    throw new IllegalStateException("Invalid state, the id type should be String".toString());
                }
                SerialDevicePortT $this$createUpdateDeviceId_u24lambda_u245 = var2_3 = new SerialDevicePortT();
                boolean $i$a$-apply-RPCFirmwareUpdateHandler$createUpdateDeviceId$2 = false;
                $this$createUpdateDeviceId_u24lambda_u245.setPort((String)data.getId());
                yield var2_3;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit onUpdateStatusChange$lambda$2$lambda$0(FlatBufferBuilder $fbb, GenericConnection conn) {
        conn.send($fbb.dataBuffer());
        return Unit.INSTANCE;
    }

    private static final void onUpdateStatusChange$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirmwareUpdateMethod.values().length];
            try {
                nArray[FirmwareUpdateMethod.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirmwareUpdateMethod.OTA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirmwareUpdateMethod.SERIAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

