/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.protocol.rpc.serial;

import com.google.flatbuffers.FlatBufferBuilder;
import dev.slimevr.protocol.GenericConnection;
import dev.slimevr.protocol.ProtocolAPI;
import dev.slimevr.protocol.rpc.RPCHandler;
import dev.slimevr.serial.ProvisioningListener;
import dev.slimevr.serial.ProvisioningStatus;
import dev.slimevr.serial.SerialPort;
import java.util.function.Consumer;
import solarxr_protocol.rpc.RpcMessageHeader;
import solarxr_protocol.rpc.StartWifiProvisioningRequest;
import solarxr_protocol.rpc.StopWifiProvisioningRequest;
import solarxr_protocol.rpc.WifiProvisioningStatusResponse;

public class RPCProvisioningHandler
implements ProvisioningListener {
    public RPCHandler rpcHandler;
    public ProtocolAPI api;

    public RPCProvisioningHandler(RPCHandler rpcHandler, ProtocolAPI api) {
        this.rpcHandler = rpcHandler;
        this.api = api;
        rpcHandler.registerPacketListener((byte)32, this::onStartWifiProvisioningRequest);
        rpcHandler.registerPacketListener((byte)33, this::onStopWifiProvisioningRequest);
        this.api.server.provisioningHandler.addListener(this);
    }

    public void onStartWifiProvisioningRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        StartWifiProvisioningRequest req = (StartWifiProvisioningRequest)messageHeader.message(new StartWifiProvisioningRequest());
        if (req == null) {
            return;
        }
        this.api.server.provisioningHandler.start(req.ssid(), req.password(), req.port());
        conn.getContext().setUseProvisioning(true);
    }

    public void onStopWifiProvisioningRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        StopWifiProvisioningRequest req = (StopWifiProvisioningRequest)messageHeader.message(new StopWifiProvisioningRequest());
        if (req == null) {
            return;
        }
        conn.getContext().setUseProvisioning(false);
        this.api.server.provisioningHandler.stop();
    }

    @Override
    public void onProvisioningStatusChange(ProvisioningStatus status, SerialPort port2) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        WifiProvisioningStatusResponse.startWifiProvisioningStatusResponse(fbb);
        WifiProvisioningStatusResponse.addStatus(fbb, status.id);
        int update = WifiProvisioningStatusResponse.endWifiProvisioningStatusResponse(fbb);
        int outbound = this.rpcHandler.createRPCMessage(fbb, (byte)34, update);
        fbb.finish(outbound);
        this.forAllListeners(conn -> conn.send(fbb.dataBuffer()));
    }

    private void forAllListeners(Consumer<? super GenericConnection> action) {
        this.api.getAPIServers().forEach(server -> server.getAPIConnections().filter(conn -> conn.getContext().useProvisioning()).forEach(action));
    }
}

