/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.protocol.rpc.serial;

import com.google.flatbuffers.FlatBufferBuilder;
import dev.slimevr.protocol.GenericConnection;
import dev.slimevr.protocol.ProtocolAPI;
import dev.slimevr.protocol.rpc.RPCHandler;
import dev.slimevr.serial.SerialListener;
import dev.slimevr.serial.SerialPort;
import io.eiren.util.logging.LogManager;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import solarxr_protocol.rpc.CloseSerialRequest;
import solarxr_protocol.rpc.NewSerialDeviceResponse;
import solarxr_protocol.rpc.OpenSerialRequest;
import solarxr_protocol.rpc.RpcMessageHeader;
import solarxr_protocol.rpc.SerialDevice;
import solarxr_protocol.rpc.SerialDevicesRequest;
import solarxr_protocol.rpc.SerialDevicesResponse;
import solarxr_protocol.rpc.SerialTrackerFactoryResetRequest;
import solarxr_protocol.rpc.SerialTrackerGetInfoRequest;
import solarxr_protocol.rpc.SerialTrackerGetWifiScanRequest;
import solarxr_protocol.rpc.SerialTrackerRebootRequest;
import solarxr_protocol.rpc.SerialUpdateResponse;
import solarxr_protocol.rpc.SetWifiRequest;

public class RPCSerialHandler
implements SerialListener {
    public RPCHandler rpcHandler;
    public ProtocolAPI api;

    public RPCSerialHandler(RPCHandler rpcHandler, ProtocolAPI api) {
        this.rpcHandler = rpcHandler;
        this.api = api;
        rpcHandler.registerPacketListener((byte)26, this::onSerialTrackerRebootRequest);
        rpcHandler.registerPacketListener((byte)27, this::onSerialTrackerGetInfoRequest);
        rpcHandler.registerPacketListener((byte)28, this::onSerialTrackerFactoryResetRequest);
        rpcHandler.registerPacketListener((byte)54, this::onSerialTrackerGetWifiScanRequest);
        rpcHandler.registerPacketListener((byte)18, this::onSetWifiRequest);
        rpcHandler.registerPacketListener((byte)16, this::onOpenSerialRequest);
        rpcHandler.registerPacketListener((byte)17, this::onCloseSerialRequest);
        rpcHandler.registerPacketListener((byte)29, this::onRequestSerialDevices);
        this.api.server.serialHandler.addListener(this);
    }

    @Override
    public void onSerialDisconnected() {
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        SerialUpdateResponse.startSerialUpdateResponse(fbb);
        SerialUpdateResponse.addClosed(fbb, true);
        int update = SerialUpdateResponse.endSerialUpdateResponse(fbb);
        int outbound = this.rpcHandler.createRPCMessage(fbb, (byte)19, update);
        fbb.finish(outbound);
        this.forAllListeners(conn -> {
            conn.send(fbb.dataBuffer());
            conn.getContext().setUseSerial(false);
        });
    }

    @Override
    public void onSerialLog(String str, boolean server) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        int logOffset = fbb.createString(str);
        SerialUpdateResponse.startSerialUpdateResponse(fbb);
        SerialUpdateResponse.addLog(fbb, logOffset);
        int update = SerialUpdateResponse.endSerialUpdateResponse(fbb);
        int outbound = this.rpcHandler.createRPCMessage(fbb, (byte)19, update);
        fbb.finish(outbound);
        this.forAllListeners(conn -> conn.send(fbb.dataBuffer()));
    }

    @Override
    public void onNewSerialDevice(SerialPort port2) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        int portOffset = fbb.createString(port2.getPortLocation());
        int nameOffset = fbb.createString(port2.getDescriptivePortName());
        int deviceOffset = SerialDevice.createSerialDevice(fbb, portOffset, nameOffset);
        int newSerialOffset = NewSerialDeviceResponse.createNewSerialDeviceResponse(fbb, deviceOffset);
        int outbound = this.rpcHandler.createRPCMessage(fbb, (byte)31, newSerialOffset);
        fbb.finish(outbound);
        this.api.getAPIServers().forEach(server -> server.getAPIConnections().forEach(conn -> conn.send(fbb.dataBuffer())));
    }

    @Override
    public void onSerialConnected(SerialPort port2) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        SerialUpdateResponse.startSerialUpdateResponse(fbb);
        SerialUpdateResponse.addClosed(fbb, false);
        int update = SerialUpdateResponse.endSerialUpdateResponse(fbb);
        int outbound = this.rpcHandler.createRPCMessage(fbb, (byte)19, update);
        fbb.finish(outbound);
        this.forAllListeners(conn -> conn.send(fbb.dataBuffer()));
    }

    public void onSerialTrackerRebootRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        SerialTrackerRebootRequest req = (SerialTrackerRebootRequest)messageHeader.message(new SerialTrackerRebootRequest());
        if (req == null) {
            return;
        }
        this.api.server.serialHandler.rebootRequest();
    }

    public void onSerialTrackerGetInfoRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        SerialTrackerGetInfoRequest req = (SerialTrackerGetInfoRequest)messageHeader.message(new SerialTrackerGetInfoRequest());
        if (req == null) {
            return;
        }
        this.api.server.serialHandler.infoRequest();
    }

    public void onSerialTrackerFactoryResetRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        SerialTrackerFactoryResetRequest req = (SerialTrackerFactoryResetRequest)messageHeader.message(new SerialTrackerFactoryResetRequest());
        if (req == null) {
            return;
        }
        this.api.server.serialHandler.factoryResetRequest();
    }

    public void onSerialTrackerGetWifiScanRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        SerialTrackerGetWifiScanRequest req = (SerialTrackerGetWifiScanRequest)messageHeader.message(new SerialTrackerGetWifiScanRequest());
        if (req == null) {
            return;
        }
        this.api.server.serialHandler.wifiScanRequest();
    }

    private void onRequestSerialDevices(GenericConnection conn, RpcMessageHeader messageHeader) {
        SerialDevicesRequest req = (SerialDevicesRequest)messageHeader.message(new SerialDevicesRequest());
        if (req == null) {
            return;
        }
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        ArrayList devicesOffsets = new ArrayList();
        try {
            this.api.server.serialHandler.getKnownPorts().forEach(port2 -> {
                int portOffset = fbb.createString(port2.getPortLocation());
                int nameOffset = fbb.createString(port2.getDescriptivePortName());
                devicesOffsets.add(SerialDevice.createSerialDevice(fbb, portOffset, nameOffset));
            });
        }
        catch (Throwable e) {
            LogManager.severe("Using serial ports is not supported on this platform", e);
        }
        SerialDevicesResponse.startDevicesVector(fbb, devicesOffsets.size());
        devicesOffsets.forEach(offset -> SerialDevicesResponse.addDevices(fbb, offset));
        int devices = fbb.endVector();
        int serialDeviceOffsets = SerialDevicesResponse.createSerialDevicesResponse(fbb, devices);
        int outbound = this.rpcHandler.createRPCMessage(fbb, (byte)30, serialDeviceOffsets);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    public void onSetWifiRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        SetWifiRequest req = (SetWifiRequest)messageHeader.message(new SetWifiRequest());
        if (req == null) {
            return;
        }
        if (req.password() == null || req.ssid() == null || !this.api.server.serialHandler.isConnected()) {
            return;
        }
        this.api.server.serialHandler.setWifi(req.ssid(), req.password());
    }

    public void onOpenSerialRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        OpenSerialRequest req = (OpenSerialRequest)messageHeader.message(new OpenSerialRequest());
        if (req == null) {
            return;
        }
        conn.getContext().setUseSerial(true);
        try {
            this.api.server.serialHandler.openSerial(req.port(), req.auto());
        }
        catch (Exception e) {
            LogManager.severe("Unable to open serial port", e);
        }
        catch (Throwable e) {
            LogManager.severe("Using serial ports is not supported on this platform", e);
        }
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        SerialUpdateResponse.startSerialUpdateResponse(fbb);
        SerialUpdateResponse.addClosed(fbb, !this.api.server.serialHandler.isConnected());
        int update = SerialUpdateResponse.endSerialUpdateResponse(fbb);
        int outbound = this.rpcHandler.createRPCMessage(fbb, (byte)19, update);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    public void onCloseSerialRequest(GenericConnection conn, RpcMessageHeader messageHeader) {
        CloseSerialRequest req = (CloseSerialRequest)messageHeader.message(new CloseSerialRequest());
        if (req == null) {
            return;
        }
        conn.getContext().setUseSerial(false);
        this.api.server.serialHandler.closeSerial();
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        SerialUpdateResponse.startSerialUpdateResponse(fbb);
        SerialUpdateResponse.addClosed(fbb, !this.api.server.serialHandler.isConnected());
        int update = SerialUpdateResponse.endSerialUpdateResponse(fbb);
        int outbound = this.rpcHandler.createRPCMessage(fbb, (byte)19, update);
        fbb.finish(outbound);
        conn.send(fbb.dataBuffer());
    }

    public void forAllListeners(Consumer<? super GenericConnection> action) {
        this.api.getAPIServers().forEach(server -> server.getAPIConnections().filter(conn -> conn.getContext().useSerial()).forEach(action));
    }

    @Override
    public void onSerialDeviceDeleted(@NotNull SerialPort port2) {
    }
}

