/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.protocol.rpc.settings;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import dev.slimevr.bridge.ISteamVRBridge;
import dev.slimevr.config.ArmsResetModes;
import dev.slimevr.config.AutoBoneConfig;
import dev.slimevr.config.DriftCompensationConfig;
import dev.slimevr.config.FiltersConfig;
import dev.slimevr.config.LegTweaksConfig;
import dev.slimevr.config.OSCConfig;
import dev.slimevr.config.ResetsConfig;
import dev.slimevr.config.StayAlignedConfig;
import dev.slimevr.config.TapDetectionConfig;
import dev.slimevr.config.VMCConfig;
import dev.slimevr.config.VRCOSCConfig;
import dev.slimevr.filtering.TrackerFilters;
import dev.slimevr.osc.OSCRouter;
import dev.slimevr.osc.VMCHandler;
import dev.slimevr.osc.VRCOSCHandler;
import dev.slimevr.protocol.GenericConnection;
import dev.slimevr.protocol.ProtocolAPI;
import dev.slimevr.protocol.ProtocolAPIServer;
import dev.slimevr.protocol.rpc.RPCHandler;
import dev.slimevr.protocol.rpc.settings.RPCSettingsBuilder;
import dev.slimevr.tracking.processor.HumanPoseManager;
import dev.slimevr.tracking.processor.config.SkeletonConfigToggles;
import dev.slimevr.tracking.processor.config.SkeletonConfigValues;
import dev.slimevr.tracking.trackers.TrackerRole;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solarxr_protocol.rpc.AutoBoneSettings;
import solarxr_protocol.rpc.ChangeSettingsRequest;
import solarxr_protocol.rpc.OSCSettings;
import solarxr_protocol.rpc.OSCTrackersSetting;
import solarxr_protocol.rpc.RpcMessageHeader;
import solarxr_protocol.rpc.SettingsResponse;
import solarxr_protocol.rpc.StayAlignedSettings;
import solarxr_protocol.rpc.TapDetectionSettings;
import solarxr_protocol.rpc.settings.LegTweaksSettings;
import solarxr_protocol.rpc.settings.ModelRatios;
import solarxr_protocol.rpc.settings.ModelSettings;
import solarxr_protocol.rpc.settings.ModelToggles;
import solarxr_protocol.rpc.settings.SkeletonHeight;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0018\u0010\u0016\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Ldev/slimevr/protocol/rpc/settings/RPCSettingsHandler;", "", "rpcHandler", "Ldev/slimevr/protocol/rpc/RPCHandler;", "api", "Ldev/slimevr/protocol/ProtocolAPI;", "<init>", "(Ldev/slimevr/protocol/rpc/RPCHandler;Ldev/slimevr/protocol/ProtocolAPI;)V", "getRpcHandler", "()Ldev/slimevr/protocol/rpc/RPCHandler;", "setRpcHandler", "(Ldev/slimevr/protocol/rpc/RPCHandler;)V", "getApi", "()Ldev/slimevr/protocol/ProtocolAPI;", "setApi", "(Ldev/slimevr/protocol/ProtocolAPI;)V", "onSettingsRequest", "", "conn", "Ldev/slimevr/protocol/GenericConnection;", "messageHeader", "Lsolarxr_protocol/rpc/RpcMessageHeader;", "onChangeSettingsRequest", "onSettingsResetRequest", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nRPCSettingsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RPCSettingsHandler.kt\ndev/slimevr/protocol/rpc/settings/RPCSettingsHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,398:1\n1#2:399\n*E\n"})
public final class RPCSettingsHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private RPCHandler rpcHandler;
    @NotNull
    private ProtocolAPI api;

    public RPCSettingsHandler(@NotNull RPCHandler rpcHandler, @NotNull ProtocolAPI api) {
        Intrinsics.checkNotNullParameter(rpcHandler, "rpcHandler");
        Intrinsics.checkNotNullParameter(api, "api");
        this.rpcHandler = rpcHandler;
        this.api = api;
        this.rpcHandler.registerPacketListener((byte)6, (arg_0, arg_1) -> RPCSettingsHandler._init_$lambda$0(this, arg_0, arg_1));
        this.rpcHandler.registerPacketListener((byte)8, (arg_0, arg_1) -> RPCSettingsHandler._init_$lambda$1(this, arg_0, arg_1));
        this.rpcHandler.registerPacketListener((byte)61, (arg_0, arg_1) -> RPCSettingsHandler._init_$lambda$2(this, arg_0, arg_1));
    }

    @NotNull
    public final RPCHandler getRpcHandler() {
        return this.rpcHandler;
    }

    public final void setRpcHandler(@NotNull RPCHandler rPCHandler) {
        Intrinsics.checkNotNullParameter(rPCHandler, "<set-?>");
        this.rpcHandler = rPCHandler;
    }

    @NotNull
    public final ProtocolAPI getApi() {
        return this.api;
    }

    public final void setApi(@NotNull ProtocolAPI protocolAPI) {
        Intrinsics.checkNotNullParameter(protocolAPI, "<set-?>");
        this.api = protocolAPI;
    }

    public final void onSettingsRequest(@NotNull GenericConnection conn, @Nullable RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        this.rpcHandler.sendSettingsChangedResponse(conn, messageHeader);
    }

    public final void onChangeSettingsRequest(@Nullable GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        AutoBoneSettings autoBoneSettings;
        ModelSettings modelSettings;
        Object trackers;
        OSCSettings osc;
        TrackerFilters type;
        ISteamVRBridge bridge;
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        Table table = messageHeader.message(new ChangeSettingsRequest());
        ChangeSettingsRequest changeSettingsRequest = table instanceof ChangeSettingsRequest ? (ChangeSettingsRequest)table : null;
        if (changeSettingsRequest == null) {
            return;
        }
        ChangeSettingsRequest req = changeSettingsRequest;
        if (req.steamVrTrackers() != null && (bridge = this.api.server.getVRBridge(ISteamVRBridge.class)) != null) {
            bridge.changeShareSettings(TrackerRole.WAIST, req.steamVrTrackers().waist());
            bridge.changeShareSettings(TrackerRole.CHEST, req.steamVrTrackers().chest());
            bridge.changeShareSettings(TrackerRole.LEFT_FOOT, req.steamVrTrackers().leftFoot());
            bridge.changeShareSettings(TrackerRole.RIGHT_FOOT, req.steamVrTrackers().rightFoot());
            bridge.changeShareSettings(TrackerRole.LEFT_KNEE, req.steamVrTrackers().leftKnee());
            bridge.changeShareSettings(TrackerRole.RIGHT_KNEE, req.steamVrTrackers().rightKnee());
            bridge.changeShareSettings(TrackerRole.LEFT_ELBOW, req.steamVrTrackers().leftElbow());
            bridge.changeShareSettings(TrackerRole.RIGHT_ELBOW, req.steamVrTrackers().rightElbow());
            bridge.changeShareSettings(TrackerRole.LEFT_HAND, req.steamVrTrackers().leftHand());
            bridge.changeShareSettings(TrackerRole.RIGHT_HAND, req.steamVrTrackers().rightHand());
            bridge.setAutomaticSharedTrackers(req.steamVrTrackers().automaticTrackerToggle());
        }
        if (req.filtering() != null && (type = TrackerFilters.Companion.fromId(req.filtering().type())) != null) {
            FiltersConfig filtersConfig = this.api.server.configManager.getVrConfig().getFilters();
            filtersConfig.setType(type.getConfigKey());
            filtersConfig.setAmount(req.filtering().amount());
            filtersConfig.updateTrackersFilters();
        }
        if (req.driftCompensation() != null) {
            DriftCompensationConfig driftCompensationConfig = this.api.server.configManager.getVrConfig().getDriftCompensation();
            driftCompensationConfig.setEnabled(req.driftCompensation().enabled());
            driftCompensationConfig.setPrediction(req.driftCompensation().prediction());
            driftCompensationConfig.setAmount(req.driftCompensation().amount());
            driftCompensationConfig.setMaxResets(req.driftCompensation().maxResets());
            driftCompensationConfig.updateTrackersDriftCompensation();
        }
        if (req.oscRouter() != null) {
            OSCConfig oscRouterConfig = this.api.server.configManager.getVrConfig().getOscRouter();
            OSCRouter oscRouter = this.api.server.getOSCRouter();
            osc = req.oscRouter().oscSettings();
            if (osc != null) {
                oscRouterConfig.setEnabled(osc.enabled());
                oscRouterConfig.setPortIn(osc.portIn());
                oscRouterConfig.setPortOut(osc.portOut());
                oscRouterConfig.setAddress(osc.address());
            }
            oscRouter.refreshSettings(true);
        }
        if (req.vrcOsc() != null) {
            VRCOSCConfig vrcOSCConfig = this.api.server.configManager.getVrConfig().getVrcOSC();
            VRCOSCHandler vrcOscHandler = this.api.server.vrcOSCHandler;
            osc = req.vrcOsc().oscSettings();
            trackers = req.vrcOsc().trackers();
            if (osc != null) {
                vrcOSCConfig.setEnabled(osc.enabled());
                vrcOSCConfig.setPortIn(osc.portIn());
                vrcOSCConfig.setPortOut(osc.portOut());
                vrcOSCConfig.setAddress(osc.address());
            }
            if (trackers != null) {
                vrcOSCConfig.setOSCTrackerRole(TrackerRole.HEAD, ((OSCTrackersSetting)trackers).head());
                vrcOSCConfig.setOSCTrackerRole(TrackerRole.CHEST, ((OSCTrackersSetting)trackers).chest());
                vrcOSCConfig.setOSCTrackerRole(TrackerRole.WAIST, ((OSCTrackersSetting)trackers).waist());
                vrcOSCConfig.setOSCTrackerRole(TrackerRole.LEFT_KNEE, ((OSCTrackersSetting)trackers).knees());
                vrcOSCConfig.setOSCTrackerRole(TrackerRole.RIGHT_KNEE, ((OSCTrackersSetting)trackers).knees());
                vrcOSCConfig.setOSCTrackerRole(TrackerRole.LEFT_FOOT, ((OSCTrackersSetting)trackers).feet());
                vrcOSCConfig.setOSCTrackerRole(TrackerRole.RIGHT_FOOT, ((OSCTrackersSetting)trackers).feet());
                vrcOSCConfig.setOSCTrackerRole(TrackerRole.LEFT_ELBOW, ((OSCTrackersSetting)trackers).elbows());
                vrcOSCConfig.setOSCTrackerRole(TrackerRole.RIGHT_ELBOW, ((OSCTrackersSetting)trackers).elbows());
                vrcOSCConfig.setOSCTrackerRole(TrackerRole.LEFT_HAND, ((OSCTrackersSetting)trackers).hands());
                vrcOSCConfig.setOSCTrackerRole(TrackerRole.RIGHT_HAND, ((OSCTrackersSetting)trackers).hands());
            }
            vrcOSCConfig.setOscqueryEnabled(req.vrcOsc().oscqueryEnabled());
            vrcOscHandler.refreshSettings(true);
        }
        if (req.vmcOsc() != null) {
            VMCConfig vmcConfig = this.api.server.configManager.getVrConfig().getVMC();
            VMCHandler vmcHandler = this.api.server.getVMCHandler();
            osc = req.vmcOsc().oscSettings();
            if (osc != null) {
                vmcConfig.setEnabled(osc.enabled());
                vmcConfig.setPortIn(osc.portIn());
                vmcConfig.setPortOut(osc.portOut());
                vmcConfig.setAddress(osc.address());
            }
            if (req.vmcOsc().vrmJson() != null) {
                Object object;
                VMCConfig vMCConfig = vmcConfig;
                trackers = req.vmcOsc().vrmJson();
                if (trackers.length() == 0) {
                    VMCConfig vMCConfig2 = vMCConfig;
                    boolean bl = false;
                    object = null;
                    vMCConfig = vMCConfig2;
                } else {
                    object = trackers;
                }
                vMCConfig.setVrmJson((String)object);
            }
            vmcConfig.setAnchorHip(req.vmcOsc().anchorHip());
            vmcConfig.setMirrorTracking(req.vmcOsc().mirrorTracking());
            vmcHandler.refreshSettings(true);
        }
        if (req.tapDetectionSettings() != null) {
            TapDetectionConfig tapDetectionConfig = this.api.server.configManager.getVrConfig().getTapDetection();
            TapDetectionSettings tapDetectionSettings = req.tapDetectionSettings();
            if (tapDetectionSettings != null) {
                tapDetectionConfig.setYawResetEnabled(tapDetectionSettings.yawResetEnabled());
                tapDetectionConfig.setFullResetEnabled(tapDetectionSettings.fullResetEnabled());
                tapDetectionConfig.setMountingResetEnabled(tapDetectionSettings.mountingResetEnabled());
                tapDetectionConfig.setSetupMode(tapDetectionSettings.setupMode());
                if (tapDetectionSettings.hasNumberTrackersOverThreshold()) {
                    tapDetectionConfig.setNumberTrackersOverThreshold(tapDetectionSettings.numberTrackersOverThreshold());
                }
                if (tapDetectionSettings.hasYawResetDelay()) {
                    tapDetectionConfig.setYawResetDelay(tapDetectionSettings.yawResetDelay());
                }
                if (tapDetectionSettings.hasFullResetDelay()) {
                    tapDetectionConfig.setFullResetDelay(tapDetectionSettings.fullResetDelay());
                }
                if (tapDetectionSettings.hasMountingResetDelay()) {
                    tapDetectionConfig.setMountingResetDelay(tapDetectionSettings.mountingResetDelay());
                }
                if (tapDetectionSettings.hasYawResetTaps()) {
                    tapDetectionConfig.setYawResetTaps(tapDetectionSettings.yawResetTaps());
                }
                if (tapDetectionSettings.hasFullResetTaps()) {
                    tapDetectionConfig.setFullResetTaps(tapDetectionSettings.fullResetTaps());
                }
                if (tapDetectionSettings.hasMountingResetTaps()) {
                    tapDetectionConfig.setMountingResetTaps(tapDetectionSettings.mountingResetTaps());
                }
                this.api.server.humanPoseManager.updateTapDetectionConfig();
            }
        }
        if ((modelSettings = req.modelSettings()) != null) {
            HumanPoseManager hpm = this.api.server.humanPoseManager;
            LegTweaksConfig legTweaksConfig = this.api.server.configManager.getVrConfig().getLegTweaks();
            ModelToggles toggles = modelSettings.toggles();
            ModelRatios ratios = modelSettings.ratios();
            LegTweaksSettings legTweaks = modelSettings.legTweaks();
            if (toggles != null) {
                hpm.setToggle(SkeletonConfigToggles.EXTENDED_SPINE_MODEL, toggles.extendedSpine());
                hpm.setToggle(SkeletonConfigToggles.EXTENDED_PELVIS_MODEL, toggles.extendedPelvis());
                hpm.setToggle(SkeletonConfigToggles.EXTENDED_KNEE_MODEL, toggles.extendedKnee());
                hpm.setToggle(SkeletonConfigToggles.FORCE_ARMS_FROM_HMD, toggles.forceArmsFromHmd());
                hpm.setToggle(SkeletonConfigToggles.EXTENDED_SPINE_MODEL, toggles.extendedSpine());
                hpm.setToggle(SkeletonConfigToggles.EXTENDED_PELVIS_MODEL, toggles.extendedPelvis());
                hpm.setToggle(SkeletonConfigToggles.EXTENDED_KNEE_MODEL, toggles.extendedKnee());
                hpm.setToggle(SkeletonConfigToggles.FORCE_ARMS_FROM_HMD, toggles.forceArmsFromHmd());
                hpm.setToggle(SkeletonConfigToggles.FLOOR_CLIP, toggles.floorClip());
                hpm.setToggle(SkeletonConfigToggles.SKATING_CORRECTION, toggles.skatingCorrection());
                hpm.setToggle(SkeletonConfigToggles.TOE_SNAP, toggles.toeSnap());
                hpm.setToggle(SkeletonConfigToggles.FOOT_PLANT, toggles.footPlant());
                hpm.setToggle(SkeletonConfigToggles.SELF_LOCALIZATION, toggles.selfLocalization());
                hpm.setToggle(SkeletonConfigToggles.ENFORCE_CONSTRAINTS, toggles.enforceConstraints());
                hpm.setToggle(SkeletonConfigToggles.CORRECT_CONSTRAINTS, toggles.correctConstraints());
            }
            if (ratios != null) {
                if (ratios.hasImputeWaistFromChestHip()) {
                    hpm.setValue(SkeletonConfigValues.WAIST_FROM_CHEST_HIP_AVERAGING, Float.valueOf(Math.max(0.0f, ratios.imputeWaistFromChestHip())));
                }
                if (ratios.hasImputeWaistFromChestLegs()) {
                    hpm.setValue(SkeletonConfigValues.WAIST_FROM_CHEST_LEGS_AVERAGING, Float.valueOf(Math.max(0.0f, ratios.imputeWaistFromChestLegs())));
                }
                if (ratios.hasImputeHipFromChestLegs()) {
                    hpm.setValue(SkeletonConfigValues.HIP_FROM_CHEST_LEGS_AVERAGING, Float.valueOf(Math.max(0.0f, ratios.imputeHipFromChestLegs())));
                }
                if (ratios.hasImputeHipFromWaistLegs()) {
                    hpm.setValue(SkeletonConfigValues.HIP_FROM_WAIST_LEGS_AVERAGING, Float.valueOf(Math.max(0.0f, ratios.imputeHipFromWaistLegs())));
                }
                if (ratios.hasInterpHipLegs()) {
                    hpm.setValue(SkeletonConfigValues.HIP_LEGS_AVERAGING, Float.valueOf(Math.max(0.0f, ratios.interpHipLegs())));
                }
                if (ratios.hasInterpKneeTrackerAnkle()) {
                    hpm.setValue(SkeletonConfigValues.KNEE_TRACKER_ANKLE_AVERAGING, Float.valueOf(Math.max(0.0f, ratios.interpKneeTrackerAnkle())));
                }
                if (ratios.hasInterpKneeAnkle()) {
                    hpm.setValue(SkeletonConfigValues.KNEE_ANKLE_AVERAGING, Float.valueOf(Math.max(0.0f, ratios.interpKneeAnkle())));
                }
            }
            if (legTweaks != null) {
                if (legTweaks.hasCorrectionStrength()) {
                    legTweaksConfig.setCorrectionStrength(legTweaks.correctionStrength());
                }
                this.api.server.humanPoseManager.updateLegTweaksConfig();
            }
            SkeletonHeight skeletonHeight = modelSettings.skeletonHeight();
            if (skeletonHeight != null) {
                SkeletonHeight it = skeletonHeight;
                boolean bl = false;
                this.api.server.configManager.getVrConfig().getSkeleton().setHmdHeight(it.hmdHeight());
                this.api.server.configManager.getVrConfig().getSkeleton().setFloorHeight(it.floorHeight());
            }
            hpm.saveConfig();
        }
        if ((autoBoneSettings = req.autoBoneSettings()) != null) {
            AutoBoneConfig autoBoneConfig = this.api.server.configManager.getVrConfig().getAutoBone();
            RPCSettingsBuilder.readAutoBoneSettings(autoBoneSettings, autoBoneConfig);
        }
        if (req.resetsSettings() != null) {
            ResetsConfig resetsConfig = this.api.server.configManager.getVrConfig().getResetsConfig();
            ArmsResetModes mode = ArmsResetModes.Companion.fromId(Math.max(req.resetsSettings().armsMountingResetMode(), 0));
            if (mode != null) {
                resetsConfig.setMode(mode);
            }
            resetsConfig.setResetMountingFeet(req.resetsSettings().resetMountingFeet());
            resetsConfig.setSaveMountingReset(req.resetsSettings().saveMountingReset());
            resetsConfig.setYawResetSmoothTime(req.resetsSettings().yawResetSmoothTime());
            resetsConfig.setResetHmdPitch(req.resetsSettings().resetHmdPitch());
            resetsConfig.updateTrackersResetsSettings();
        }
        if (req.stayAligned() != null) {
            StayAlignedConfig config = this.api.server.configManager.getVrConfig().getStayAlignedConfig();
            StayAlignedSettings requestConfig = req.stayAligned();
            config.setEnabled(requestConfig.enabled());
            config.setHideYawCorrection(requestConfig.hideYawCorrection());
            config.getStandingRelaxedPose().setEnabled(requestConfig.standingEnabled());
            config.getStandingRelaxedPose().setUpperLegAngleInDeg(requestConfig.standingUpperLegAngle());
            config.getStandingRelaxedPose().setLowerLegAngleInDeg(requestConfig.standingLowerLegAngle());
            config.getStandingRelaxedPose().setFootAngleInDeg(requestConfig.standingFootAngle());
            config.getSittingRelaxedPose().setEnabled(requestConfig.sittingEnabled());
            config.getSittingRelaxedPose().setUpperLegAngleInDeg(requestConfig.sittingUpperLegAngle());
            config.getSittingRelaxedPose().setLowerLegAngleInDeg(requestConfig.sittingLowerLegAngle());
            config.getSittingRelaxedPose().setFootAngleInDeg(requestConfig.sittingFootAngle());
            config.getFlatRelaxedPose().setEnabled(requestConfig.flatEnabled());
            config.getFlatRelaxedPose().setUpperLegAngleInDeg(requestConfig.flatUpperLegAngle());
            config.getFlatRelaxedPose().setLowerLegAngleInDeg(requestConfig.flatLowerLegAngle());
            config.getFlatRelaxedPose().setFootAngleInDeg(requestConfig.flatFootAngle());
        }
        this.api.server.configManager.saveConfig();
    }

    public final void onSettingsResetRequest(@NotNull GenericConnection conn, @Nullable RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        this.api.server.configManager.resetConfig();
    }

    private static final void _init_$lambda$0(RPCSettingsHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        this$0.onSettingsRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$1(RPCSettingsHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        this$0.onChangeSettingsRequest(conn, messageHeader);
    }

    private static final void _init_$lambda$2(RPCSettingsHandler this$0, GenericConnection conn, RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        this$0.onSettingsResetRequest(conn, messageHeader);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ldev/slimevr/protocol/rpc/settings/RPCSettingsHandler$Companion;", "", "<init>", "()V", "sendSteamVRUpdatedSettings", "", "api", "Ldev/slimevr/protocol/ProtocolAPI;", "rpcHandler", "Ldev/slimevr/protocol/rpc/RPCHandler;", "core"})
    @SourceDebugExtension(value={"SMAP\nRPCSettingsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RPCSettingsHandler.kt\ndev/slimevr/protocol/rpc/settings/RPCSettingsHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,398:1\n1863#2,2:399\n*S KotlinDebug\n*F\n+ 1 RPCSettingsHandler.kt\ndev/slimevr/protocol/rpc/settings/RPCSettingsHandler$Companion\n*L\n392#1:399,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void sendSteamVRUpdatedSettings(@NotNull ProtocolAPI api, @NotNull RPCHandler rpcHandler) {
            Intrinsics.checkNotNullParameter(api, "api");
            Intrinsics.checkNotNullParameter(rpcHandler, "rpcHandler");
            FlatBufferBuilder fbb = new FlatBufferBuilder(32);
            ISteamVRBridge iSteamVRBridge = api.server.getVRBridge(ISteamVRBridge.class);
            if (iSteamVRBridge == null) {
                return;
            }
            ISteamVRBridge bridge = iSteamVRBridge;
            int settings = SettingsResponse.createSettingsResponse(fbb, RPCSettingsBuilder.createSteamVRSettings(fbb, bridge), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
            int outbound = RPCHandler.createRPCMessage$default(rpcHandler, fbb, (byte)7, settings, null, 8, null);
            fbb.finish(outbound);
            List<ProtocolAPIServer> list = api.getAPIServers();
            Intrinsics.checkNotNullExpressionValue(list, "getAPIServers(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProtocolAPIServer apiServer = (ProtocolAPIServer)element$iv;
                boolean bl = false;
                apiServer.getAPIConnections().forEach(arg_0 -> Companion.sendSteamVRUpdatedSettings$lambda$2$lambda$1(arg_0 -> Companion.sendSteamVRUpdatedSettings$lambda$2$lambda$0(fbb, arg_0), arg_0));
            }
        }

        private static final Unit sendSteamVRUpdatedSettings$lambda$2$lambda$0(FlatBufferBuilder $fbb, GenericConnection it) {
            it.send($fbb.dataBuffer());
            return Unit.INSTANCE;
        }

        private static final void sendSteamVRUpdatedSettings$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

