/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.protocol.rpc.setup;

import com.google.flatbuffers.FlatBufferBuilder;
import dev.slimevr.protocol.GenericConnection;
import dev.slimevr.protocol.ProtocolAPI;
import dev.slimevr.protocol.ProtocolAPIServer;
import dev.slimevr.protocol.rpc.RPCHandler;
import dev.slimevr.setup.HandshakeListener;
import dev.slimevr.tracking.trackers.Device;
import dev.slimevr.tracking.trackers.udp.UDPDevice;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import solarxr_protocol.rpc.AddUnknownDeviceRequest;
import solarxr_protocol.rpc.ForgetDeviceRequest;
import solarxr_protocol.rpc.RpcMessageHeader;
import solarxr_protocol.rpc.UnknownDeviceHandshakeNotification;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Ldev/slimevr/protocol/rpc/setup/RPCHandshakeHandler;", "Ldev/slimevr/setup/HandshakeListener;", "rpcHandler", "Ldev/slimevr/protocol/rpc/RPCHandler;", "api", "Ldev/slimevr/protocol/ProtocolAPI;", "<init>", "(Ldev/slimevr/protocol/rpc/RPCHandler;Ldev/slimevr/protocol/ProtocolAPI;)V", "getApi", "()Ldev/slimevr/protocol/ProtocolAPI;", "onUnknownHandshake", "", "macAddress", "", "onAddUnknownDevice", "conn", "Ldev/slimevr/protocol/GenericConnection;", "messageHeader", "Lsolarxr_protocol/rpc/RpcMessageHeader;", "onForgetDevice", "core"})
@SourceDebugExtension(value={"SMAP\nRPCHandshakeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RPCHandshakeHandler.kt\ndev/slimevr/protocol/rpc/setup/RPCHandshakeHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1863#2,2:88\n1#3:90\n*S KotlinDebug\n*F\n+ 1 RPCHandshakeHandler.kt\ndev/slimevr/protocol/rpc/setup/RPCHandshakeHandler\n*L\n48#1:88,2\n*E\n"})
public final class RPCHandshakeHandler
implements HandshakeListener {
    @NotNull
    private final RPCHandler rpcHandler;
    @NotNull
    private final ProtocolAPI api;

    public RPCHandshakeHandler(@NotNull RPCHandler rpcHandler, @NotNull ProtocolAPI api) {
        Intrinsics.checkNotNullParameter(rpcHandler, "rpcHandler");
        Intrinsics.checkNotNullParameter(api, "api");
        this.rpcHandler = rpcHandler;
        this.api = api;
        this.rpcHandler.registerPacketListener((byte)56, this::onAddUnknownDevice);
        this.rpcHandler.registerPacketListener((byte)57, this::onForgetDevice);
        this.api.server.handshakeHandler.addListener(this);
    }

    @NotNull
    public final ProtocolAPI getApi() {
        return this.api;
    }

    @Override
    public void onUnknownHandshake(@NotNull String macAddress) {
        Intrinsics.checkNotNullParameter(macAddress, "macAddress");
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        int string = fbb.createString(macAddress);
        int update = UnknownDeviceHandshakeNotification.createUnknownDeviceHandshakeNotification(fbb, string);
        int outbound = RPCHandler.createRPCMessage$default(this.rpcHandler, fbb, (byte)55, update, null, 8, null);
        fbb.finish(outbound);
        List<ProtocolAPIServer> list = this.api.getAPIServers();
        Intrinsics.checkNotNullExpressionValue(list, "getAPIServers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtocolAPIServer apiServer = (ProtocolAPIServer)element$iv;
            boolean bl = false;
            apiServer.getAPIConnections().forEach(arg_0 -> RPCHandshakeHandler.onUnknownHandshake$lambda$2$lambda$1(arg_0 -> RPCHandshakeHandler.onUnknownHandshake$lambda$2$lambda$0(fbb, arg_0), arg_0));
        }
    }

    public final void onAddUnknownDevice(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
        AddUnknownDeviceRequest addUnknownDeviceRequest = (AddUnknownDeviceRequest)messageHeader.message(new AddUnknownDeviceRequest());
        if (addUnknownDeviceRequest == null) {
            return;
        }
        AddUnknownDeviceRequest req = addUnknownDeviceRequest;
        String string = req.macAddress();
        if (string == null) {
            return;
        }
        this.api.server.configManager.getVrConfig().addKnownDevice(string);
        this.api.server.configManager.saveConfig();
    }

    public final void onForgetDevice(@NotNull GenericConnection conn, @NotNull RpcMessageHeader messageHeader) {
        Object v2;
        block4: {
            Intrinsics.checkNotNullParameter(conn, "conn");
            Intrinsics.checkNotNullParameter(messageHeader, "messageHeader");
            ForgetDeviceRequest forgetDeviceRequest = (ForgetDeviceRequest)messageHeader.message(new ForgetDeviceRequest());
            if (forgetDeviceRequest == null) {
                return;
            }
            ForgetDeviceRequest req = forgetDeviceRequest;
            String string = req.macAddress();
            if (string == null) {
                return;
            }
            this.api.server.configManager.getVrConfig().forgetKnownDevice(string);
            Iterable iterable = this.api.server.deviceManager.getDevices();
            for (Object t : iterable) {
                Device it = (Device)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getHardwareIdentifier(), req.macAddress())) continue;
                v2 = t;
                break block4;
            }
            v2 = null;
        }
        Device device = v2;
        if (device != null && device instanceof UDPDevice) {
            this.api.server.getTrackersServer().disconnectDevice((UDPDevice)device);
        }
        this.api.server.configManager.saveConfig();
    }

    private static final Unit onUnknownHandshake$lambda$2$lambda$0(FlatBufferBuilder $fbb, GenericConnection it) {
        it.send($fbb.dataBuffer());
        return Unit.INSTANCE;
    }

    private static final void onUnknownHandshake$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

