/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.protocol.rpc.setup;

import com.google.flatbuffers.FlatBufferBuilder;
import dev.slimevr.protocol.GenericConnection;
import dev.slimevr.protocol.ProtocolAPI;
import dev.slimevr.protocol.ProtocolAPIServer;
import dev.slimevr.protocol.datafeed.DataFeedBuilder;
import dev.slimevr.protocol.rpc.RPCHandler;
import dev.slimevr.setup.TapSetupListener;
import dev.slimevr.tracking.trackers.Tracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import solarxr_protocol.rpc.TapDetectionSetupNotification;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Ldev/slimevr/protocol/rpc/setup/RPCTapSetupHandler;", "Ldev/slimevr/setup/TapSetupListener;", "rpcHandler", "Ldev/slimevr/protocol/rpc/RPCHandler;", "api", "Ldev/slimevr/protocol/ProtocolAPI;", "<init>", "(Ldev/slimevr/protocol/rpc/RPCHandler;Ldev/slimevr/protocol/ProtocolAPI;)V", "getApi", "()Ldev/slimevr/protocol/ProtocolAPI;", "onStarted", "", "tracker", "Ldev/slimevr/tracking/trackers/Tracker;", "forAllListeners", "action", "Lkotlin/Function1;", "Ldev/slimevr/protocol/GenericConnection;", "core"})
@SourceDebugExtension(value={"SMAP\nRPCTapSetupHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RPCTapSetupHandler.kt\ndev/slimevr/protocol/rpc/setup/RPCTapSetupHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1863#2,2:47\n*S KotlinDebug\n*F\n+ 1 RPCTapSetupHandler.kt\ndev/slimevr/protocol/rpc/setup/RPCTapSetupHandler\n*L\n39#1:47,2\n*E\n"})
public final class RPCTapSetupHandler
implements TapSetupListener {
    @NotNull
    private final RPCHandler rpcHandler;
    @NotNull
    private final ProtocolAPI api;

    public RPCTapSetupHandler(@NotNull RPCHandler rpcHandler, @NotNull ProtocolAPI api) {
        Intrinsics.checkNotNullParameter(rpcHandler, "rpcHandler");
        Intrinsics.checkNotNullParameter(api, "api");
        this.rpcHandler = rpcHandler;
        this.api = api;
        this.api.server.tapSetupHandler.addListener(this);
    }

    @NotNull
    public final ProtocolAPI getApi() {
        return this.api;
    }

    @Override
    public void onStarted(@NotNull Tracker tracker) {
        Intrinsics.checkNotNullParameter(tracker, "tracker");
        FlatBufferBuilder fbb = new FlatBufferBuilder(32);
        int idOffset = DataFeedBuilder.createTrackerId(fbb, tracker);
        int update = TapDetectionSetupNotification.createTapDetectionSetupNotification(fbb, idOffset);
        int outbound = RPCHandler.createRPCMessage$default(this.rpcHandler, fbb, (byte)39, update, null, 8, null);
        fbb.finish(outbound);
        this.forAllListeners(arg_0 -> RPCTapSetupHandler.onStarted$lambda$0(fbb, arg_0));
    }

    private final void forAllListeners(Function1<? super GenericConnection, Unit> action) {
        List<ProtocolAPIServer> list = this.api.getAPIServers();
        Intrinsics.checkNotNullExpressionValue(list, "getAPIServers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtocolAPIServer it = (ProtocolAPIServer)element$iv;
            boolean bl = false;
            it.getAPIConnections().forEach(arg_0 -> RPCTapSetupHandler.forAllListeners$lambda$2$lambda$1(action, arg_0));
        }
    }

    private static final Unit onStarted$lambda$0(FlatBufferBuilder $fbb, GenericConnection it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.send($fbb.dataBuffer());
        return Unit.INSTANCE;
    }

    private static final void forAllListeners$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

