/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.protocol.rpc.setup;

import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Ldev/slimevr/protocol/rpc/setup/RPCUtil;", "", "<init>", "()V", "getLocalIp", "", "core"})
public final class RPCUtil {
    @NotNull
    public static final RPCUtil INSTANCE = new RPCUtil();

    private RPCUtil() {
    }

    @JvmStatic
    @Nullable
    public static final String getLocalIp() {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        Intrinsics.checkNotNullExpressionValue(enumeration, "getNetworkInterfaces(...)");
        Iterator<NetworkInterface> iterator2 = CollectionsKt.iterator(enumeration);
        while (iterator2.hasNext()) {
            NetworkInterface netInt = iterator2.next();
            if (!netInt.isUp() || netInt.isLoopback() || netInt.isVirtual()) continue;
            for (InterfaceAddress netAddr : netInt.getInterfaceAddresses()) {
                if (!netAddr.getAddress().isSiteLocalAddress() || netAddr.getBroadcast() == null) continue;
                return netAddr.getAddress().getHostAddress();
            }
        }
        return null;
    }
}

