/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.serial;

import dev.slimevr.VRServer;
import dev.slimevr.serial.ProvisioningListener;
import dev.slimevr.serial.ProvisioningStatus;
import dev.slimevr.serial.SerialListener;
import dev.slimevr.serial.SerialPort;
import io.eiren.util.logging.LogManager;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

public class ProvisioningHandler
implements SerialListener {
    private ProvisioningStatus provisioningStatus = ProvisioningStatus.NONE;
    private boolean isRunning = false;
    private final List<ProvisioningListener> listeners = new CopyOnWriteArrayList<ProvisioningListener>();
    private String ssid;
    private String password;
    private String preferredPort;
    private final Timer provisioningTickTimer = new Timer("ProvisioningTickTimer");
    private long lastStatusChange = -1L;
    private byte connectRetries = 0;
    private boolean hasLogs = false;
    private final byte MAX_CONNECTION_RETRIES = 1;
    private final VRServer vrServer;

    public ProvisioningHandler(VRServer vrServer2) {
        this.vrServer = vrServer2;
        vrServer2.serialHandler.addListener(this);
        this.provisioningTickTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!ProvisioningHandler.this.isRunning) {
                    return;
                }
                ProvisioningHandler.this.provisioningTick();
            }
        }, 0L, 1000L);
    }

    public void start(String ssid, String password, String port2) {
        this.isRunning = true;
        this.hasLogs = false;
        this.ssid = ssid;
        this.password = password;
        this.preferredPort = port2;
        this.provisioningStatus = ProvisioningStatus.NONE;
        this.connectRetries = 0;
    }

    public void stop() {
        this.isRunning = false;
        this.hasLogs = false;
        this.ssid = null;
        this.password = null;
        this.connectRetries = 0;
        this.changeStatus(ProvisioningStatus.NONE);
        this.vrServer.serialHandler.closeSerial();
    }

    public void initSerial(String port2) {
        this.provisioningStatus = ProvisioningStatus.SERIAL_INIT;
        this.hasLogs = false;
        try {
            boolean openResult = false;
            openResult = port2 != null ? this.vrServer.serialHandler.openSerial(port2, false) : this.vrServer.serialHandler.openSerial(null, true);
            if (!openResult) {
                LogManager.info("[SerialHandler] Serial port wasn't open...");
            }
        }
        catch (Exception e) {
            LogManager.severe("[SerialHandler] Unable to open serial port", e);
        }
        catch (Throwable e) {
            LogManager.severe("[SerialHandler] Using serial ports is not supported on this platform", e);
        }
    }

    public void tryObtainMacAddress() {
        this.changeStatus(ProvisioningStatus.OBTAINING_MAC_ADDRESS);
        this.vrServer.serialHandler.infoRequest();
    }

    public void tryProvisioning() {
        this.changeStatus(ProvisioningStatus.PROVISIONING);
        this.vrServer.serialHandler.setWifi(this.ssid, this.password);
    }

    public void provisioningTick() {
        if (this.provisioningStatus == ProvisioningStatus.OBTAINING_MAC_ADDRESS) {
            this.tryObtainMacAddress();
        }
        if (!this.hasLogs && this.provisioningStatus == ProvisioningStatus.OBTAINING_MAC_ADDRESS && System.currentTimeMillis() - this.lastStatusChange > 1000L) {
            this.changeStatus(ProvisioningStatus.NO_SERIAL_LOGS_ERROR);
            return;
        }
        if (this.provisioningStatus == ProvisioningStatus.SERIAL_INIT && this.vrServer.serialHandler.getKnownPorts().findAny().isEmpty() && System.currentTimeMillis() - this.lastStatusChange > 15000L) {
            this.changeStatus(ProvisioningStatus.NO_SERIAL_DEVICE_FOUND);
            return;
        }
        if (System.currentTimeMillis() - this.lastStatusChange > (long)this.provisioningStatus.getTimeout()) {
            if (this.provisioningStatus == ProvisioningStatus.NONE || this.provisioningStatus == ProvisioningStatus.SERIAL_INIT) {
                this.initSerial(this.preferredPort);
            } else if (this.provisioningStatus == ProvisioningStatus.CONNECTING) {
                this.changeStatus(ProvisioningStatus.CONNECTION_ERROR);
            } else if (this.provisioningStatus == ProvisioningStatus.LOOKING_FOR_SERVER) {
                this.changeStatus(ProvisioningStatus.COULD_NOT_FIND_SERVER);
            } else if (!this.provisioningStatus.isError()) {
                this.changeStatus(ProvisioningStatus.CONNECTION_ERROR);
            }
        }
    }

    @Override
    public void onSerialConnected(@NotNull SerialPort port2) {
        if (!this.isRunning) {
            return;
        }
        this.tryObtainMacAddress();
    }

    @Override
    public void onSerialDisconnected() {
        if (!this.isRunning) {
            return;
        }
        this.changeStatus(ProvisioningStatus.NONE);
        this.connectRetries = 0;
    }

    @Override
    public void onSerialLog(@NotNull String str, boolean server) {
        MatchGroup b;
        MatchResult match;
        if (!this.isRunning) {
            return;
        }
        if (!server) {
            this.hasLogs = true;
            if (this.provisioningStatus == ProvisioningStatus.NO_SERIAL_LOGS_ERROR) {
                this.changeStatus(ProvisioningStatus.OBTAINING_MAC_ADDRESS);
            }
        }
        if (this.provisioningStatus == ProvisioningStatus.OBTAINING_MAC_ADDRESS && str.contains("mac:") && (match = new Regex("mac: (?<mac>([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})), ").find(str, str.indexOf("mac:"))) != null && (b = match.getGroups().get(1)) != null) {
            this.vrServer.configManager.getVrConfig().addKnownDevice(b.getValue());
            this.vrServer.configManager.saveConfig();
            this.tryProvisioning();
        }
        if (this.provisioningStatus == ProvisioningStatus.PROVISIONING && str.contains("New wifi credentials set")) {
            this.changeStatus(ProvisioningStatus.CONNECTING);
        }
        if (this.provisioningStatus == ProvisioningStatus.CONNECTING && (str.contains("Looking for the server") || str.contains("Searching for the server"))) {
            this.changeStatus(ProvisioningStatus.LOOKING_FOR_SERVER);
        }
        if (this.provisioningStatus == ProvisioningStatus.LOOKING_FOR_SERVER && str.contains("Handshake successful")) {
            this.changeStatus(ProvisioningStatus.DONE);
        }
        if (this.provisioningStatus == ProvisioningStatus.CONNECTING && str.contains("Can't connect from any credentials")) {
            this.connectRetries = (byte)(this.connectRetries + 1);
            if (this.connectRetries >= 1) {
                this.changeStatus(ProvisioningStatus.CONNECTION_ERROR);
            } else {
                this.vrServer.serialHandler.rebootRequest();
            }
        }
    }

    public void changeStatus(ProvisioningStatus status) {
        if (this.provisioningStatus != status) {
            this.lastStatusChange = System.currentTimeMillis();
            this.listeners.forEach(l -> l.onProvisioningStatusChange(status, this.vrServer.serialHandler.getCurrentPort()));
            this.provisioningStatus = status;
        }
    }

    @Override
    public void onNewSerialDevice(SerialPort port2) {
        if (!this.isRunning) {
            return;
        }
        this.initSerial(this.preferredPort);
    }

    public void addListener(ProvisioningListener channel) {
        this.listeners.add(channel);
    }

    public void removeListener(ProvisioningListener l) {
        this.listeners.removeIf(listener2 -> l == listener2);
    }

    @Override
    public void onSerialDeviceDeleted(@NotNull SerialPort port2) {
    }
}

