/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.serial;

import dev.slimevr.serial.SerialListener;
import dev.slimevr.serial.SerialPort;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0006\b&\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u001a\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0005H&J\b\u0010\u0015\u001a\u00020\rH&J\b\u0010\u0016\u001a\u00020\rH&J\b\u0010\u0017\u001a\u00020\rH&J\b\u0010\u0018\u001a\u00020\rH&J\b\u0010\u0019\u001a\u00020\rH&J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH&J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H&J\n\u0010 \u001a\u0004\u0018\u00010\tH&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u001a\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Ldev/slimevr/serial/SerialHandler;", "", "<init>", "()V", "isConnected", "", "()Z", "knownPorts", "Ljava/util/stream/Stream;", "Ldev/slimevr/serial/SerialPort;", "getKnownPorts", "()Ljava/util/stream/Stream;", "addListener", "", "channel", "Ldev/slimevr/serial/SerialListener;", "removeListener", "openSerial", "portLocation", "", "auto", "rebootRequest", "factoryResetRequest", "infoRequest", "wifiScanRequest", "closeSerial", "write", "buff", "", "setWifi", "ssid", "passwd", "getCurrentPort", "Companion", "core"})
public abstract class SerialHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<Pair<Integer, Integer>> supportedSerial;

    public abstract boolean isConnected();

    @NotNull
    public abstract Stream<? extends SerialPort> getKnownPorts();

    public abstract void addListener(@NotNull SerialListener var1);

    public abstract void removeListener(@NotNull SerialListener var1);

    public abstract boolean openSerial(@Nullable String var1, boolean var2);

    public abstract void rebootRequest();

    public abstract void factoryResetRequest();

    public abstract void infoRequest();

    public abstract void wifiScanRequest();

    public abstract void closeSerial();

    public abstract void write(@NotNull byte[] var1);

    public abstract void setWifi(@NotNull String var1, @NotNull String var2);

    @Nullable
    public abstract SerialPort getCurrentPort();

    static {
        Pair[] pairArray = new Pair[]{new Pair<Integer, Integer>(6790, 29986), new Pair<Integer, Integer>(6790, 29987), new Pair<Integer, Integer>(6790, 21795), new Pair<Integer, Integer>(6790, 21972), new Pair<Integer, Integer>(4292, 60000), new Pair<Integer, Integer>(12346, 4097), new Pair<Integer, Integer>(1027, 24577)};
        supportedSerial = SetsKt.setOf(pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Ldev/slimevr/serial/SerialHandler$Companion;", "", "<init>", "()V", "supportedSerial", "", "Lkotlin/Pair;", "", "getSupportedSerial", "()Ljava/util/Set;", "isKnownBoard", "", "port", "Ldev/slimevr/serial/SerialPort;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Pair<Integer, Integer>> getSupportedSerial() {
            return supportedSerial;
        }

        public final boolean isKnownBoard(@NotNull SerialPort port2) {
            Intrinsics.checkNotNullParameter(port2, "port");
            return CollectionsKt.contains((Iterable)this.getSupportedSerial(), new Pair<Integer, Integer>(port2.getVendorId(), port2.getProductId()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

