/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.processor;

import dev.slimevr.tracking.processor.BoneType;
import dev.slimevr.tracking.processor.Constraint;
import dev.slimevr.tracking.processor.TransformNode;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerFilteringHandler;
import dev.slimevr.tracking.trackers.TrackerResetsHandler;
import io.github.axisangles.ktmath.Quaternion;
import io.github.axisangles.ktmath.Transform;
import io.github.axisangles.ktmath.Vector3;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0000J\u0006\u0010(\u001a\u00020&J\u0006\u0010)\u001a\u00020&J\u000e\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020&H\u0002J\u0006\u0010.\u001a\u00020\u0018J\u0006\u0010/\u001a\u00020\u0018J\u0015\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020\u0018\u00a2\u0006\u0004\b2\u0010\u001cJ\u0015\u00103\u001a\u00020&2\u0006\u00101\u001a\u00020\u0018\u00a2\u0006\u0004\b4\u0010\u001cJ\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u000206J\u0015\u00108\u001a\u00020&2\u0006\u00109\u001a\u000206\u00a2\u0006\u0004\b:\u0010;J\u0010\u0010C\u001a\u00020&2\u0006\u0010>\u001a\u00020=H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0004\u0018\u00010\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0000@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00000\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R$\u0010>\u001a\u00020=2\u0006\u0010<\u001a\u00020=8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010@\"\u0004\bA\u0010B\u00a8\u0006D"}, d2={"Ldev/slimevr/tracking/processor/Bone;", "", "boneType", "Ldev/slimevr/tracking/processor/BoneType;", "rotationConstraint", "Ldev/slimevr/tracking/processor/Constraint;", "<init>", "(Ldev/slimevr/tracking/processor/BoneType;Ldev/slimevr/tracking/processor/Constraint;)V", "getBoneType", "()Ldev/slimevr/tracking/processor/BoneType;", "getRotationConstraint", "()Ldev/slimevr/tracking/processor/Constraint;", "headNode", "Ldev/slimevr/tracking/processor/TransformNode;", "tailNode", "value", "parent", "getParent", "()Ldev/slimevr/tracking/processor/Bone;", "children", "", "getChildren", "()Ljava/util/List;", "rotationOffset", "Lio/github/axisangles/ktmath/Quaternion;", "getRotationOffset", "()Lio/github/axisangles/ktmath/Quaternion;", "setRotationOffset-oS71L7k", "(FFFF)V", "rotationOffset-w", "F", "attachedTracker", "Ldev/slimevr/tracking/trackers/Tracker;", "getAttachedTracker", "()Ldev/slimevr/tracking/trackers/Tracker;", "setAttachedTracker", "(Ldev/slimevr/tracking/trackers/Tracker;)V", "attachChild", "", "bone", "detachWithChildren", "update", "updateWithConstraints", "correctConstraints", "", "updateThisNode", "getGlobalRotation", "getLocalRotation", "setRotation", "rotation", "setRotation-oS71L7k", "setRotationRaw", "setRotationRaw-oS71L7k", "getPosition", "Lio/github/axisangles/ktmath/Vector3;", "getTailPosition", "setPosition", "position", "setPosition-1s-5YWc", "(FFF)V", "len", "", "length", "getLength", "()F", "setLength", "(F)V", "updateLength", "core"})
@SourceDebugExtension(value={"SMAP\nBone.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bone.kt\ndev/slimevr/tracking/processor/Bone\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
public final class Bone {
    @NotNull
    private final BoneType boneType;
    @NotNull
    private final Constraint rotationConstraint;
    @NotNull
    private final TransformNode headNode;
    @NotNull
    private final TransformNode tailNode;
    @Nullable
    private Bone parent;
    @NotNull
    private final List<Bone> children;
    private float rotationOffset-w;
    private float rotationOffset-x;
    private float rotationOffset-y;
    private float rotationOffset-z;
    @Nullable
    private Tracker attachedTracker;

    public Bone(@NotNull BoneType boneType, @NotNull Constraint rotationConstraint) {
        Intrinsics.checkNotNullParameter((Object)boneType, "boneType");
        Intrinsics.checkNotNullParameter(rotationConstraint, "rotationConstraint");
        this.boneType = boneType;
        this.rotationConstraint = rotationConstraint;
        this.headNode = new TransformNode(true);
        this.tailNode = new TransformNode(false);
        this.children = new CopyOnWriteArrayList();
        Quaternion.Companion companion = Quaternion.Companion;
        this.rotationOffset-w = companion.getIDENTITY-w();
        this.rotationOffset-x = companion.getIDENTITY-x();
        this.rotationOffset-y = companion.getIDENTITY-y();
        this.rotationOffset-z = companion.getIDENTITY-z();
        this.headNode.attachChild(this.tailNode);
    }

    @NotNull
    public final BoneType getBoneType() {
        return this.boneType;
    }

    @NotNull
    public final Constraint getRotationConstraint() {
        return this.rotationConstraint;
    }

    @Nullable
    public final Bone getParent() {
        return this.parent;
    }

    @NotNull
    public final List<Bone> getChildren() {
        return this.children;
    }

    @NotNull
    public final Quaternion getRotationOffset() {
        return Quaternion.box-impl(this.rotationOffset-w, this.rotationOffset-x, this.rotationOffset-y, this.rotationOffset-z);
    }

    public final void setRotationOffset-oS71L7k(float f, float f2, float f3, float f4) {
        this.rotationOffset-w = f;
        this.rotationOffset-x = f2;
        this.rotationOffset-y = f3;
        this.rotationOffset-z = f4;
    }

    @Nullable
    public final Tracker getAttachedTracker() {
        return this.attachedTracker;
    }

    public final void setAttachedTracker(@Nullable Tracker tracker) {
        this.attachedTracker = tracker;
    }

    public final void attachChild(@NotNull Bone bone) {
        Intrinsics.checkNotNullParameter(bone, "bone");
        if (!(bone.parent == null)) {
            boolean bl = false;
            String string = "The child bone must not already have a parent.";
            throw new IllegalArgumentException(string.toString());
        }
        this.children.add(bone);
        bone.parent = this;
        this.tailNode.attachChild(bone.headNode);
    }

    public final void detachWithChildren() {
        for (Bone child : this.children) {
            child.parent = null;
        }
        this.children.clear();
        Object object = this.parent;
        if (object != null && (object = ((Bone)object).children) != null) {
            object.remove(this);
        }
        this.parent = null;
        this.headNode.detachWithChildren();
        this.tailNode.detachWithChildren();
        this.headNode.attachChild(this.tailNode);
    }

    public final void update() {
        this.headNode.update();
    }

    public final void updateWithConstraints(boolean correctConstraints) {
        Quaternion quaternion = this.getGlobalRotation();
        float f = quaternion.unbox-impl-w();
        float f2 = quaternion.unbox-impl-x();
        float f3 = quaternion.unbox-impl-y();
        float f4 = quaternion.unbox-impl-z();
        Quaternion quaternion2 = this.rotationConstraint.applyConstraint-jCQAsEA(f, f2, f3, f4, this);
        float f5 = quaternion2.unbox-impl-w();
        float f6 = quaternion2.unbox-impl-x();
        float f7 = quaternion2.unbox-impl-y();
        float f8 = quaternion2.unbox-impl-z();
        this.setRotationRaw-oS71L7k(f5, f6, f7, f8);
        this.updateThisNode();
        if (this.rotationConstraint.getConstraintType() != Constraint.Companion.ConstraintType.HINGE && this.rotationConstraint.getConstraintType() != Constraint.Companion.ConstraintType.LOOSE_HINGE && this.boneType.bodyPart != 22) {
            Quaternion quaternion3 = Quaternion.inv-impl(f, f2, f3, f4);
            Quaternion quaternion4 = Quaternion.times-oS71L7k(f5, f6, f7, f8, quaternion3.unbox-impl-w(), quaternion3.unbox-impl-x(), quaternion3.unbox-impl-y(), quaternion3.unbox-impl-z());
            float f9 = quaternion4.unbox-impl-w();
            float f10 = quaternion4.unbox-impl-x();
            float f11 = quaternion4.unbox-impl-y();
            float f12 = quaternion4.unbox-impl-z();
            float angle = Quaternion.angleR-impl(f9, f10, f11, f12);
            if (correctConstraints && angle > 0.004f) {
                Object object = this.attachedTracker;
                float f13 = object != null && (object = ((Tracker)object).getFilteringHandler()) != null ? ((TrackerFilteringHandler)object).getFilteringImpact() : 1.0f;
                if (f13 < 0.0349f) {
                    Object object2;
                    Object object3 = this.parent;
                    float f14 = object3 != null && (object3 = ((Bone)object3).attachedTracker) != null && (object3 = ((Tracker)object3).getFilteringHandler()) != null ? ((TrackerFilteringHandler)object3).getFilteringImpact() : 0.0f;
                    if (f14 < 0.0349f && (object2 = this.attachedTracker) != null && (object2 = ((Tracker)object2).getResetsHandler()) != null) {
                        ((TrackerResetsHandler)object2).updateConstraintFix-oS71L7k(f9, f10, f11, f12);
                    }
                }
            }
        }
        for (Bone child : this.children) {
            child.updateWithConstraints(correctConstraints);
        }
    }

    private final void updateThisNode() {
        this.headNode.updateThisNode();
        this.tailNode.updateThisNode();
    }

    @NotNull
    public final Quaternion getGlobalRotation() {
        return this.headNode.getWorldTransform().getRotation();
    }

    @NotNull
    public final Quaternion getLocalRotation() {
        return this.headNode.getLocalTransform().getRotation();
    }

    public final void setRotation-oS71L7k(float f, float f2, float f3, float f4) {
        Quaternion quaternion = Quaternion.times-oS71L7k(f, f2, f3, f4, this.rotationOffset-w, this.rotationOffset-x, this.rotationOffset-y, this.rotationOffset-z);
        this.headNode.getLocalTransform().setRotation-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
    }

    public final void setRotationRaw-oS71L7k(float f, float f2, float f3, float f4) {
        this.headNode.getLocalTransform().setRotation-oS71L7k(f, f2, f3, f4);
    }

    @NotNull
    public final Vector3 getPosition() {
        return this.headNode.getWorldTransform().getTranslation();
    }

    @NotNull
    public final Vector3 getTailPosition() {
        return this.tailNode.getWorldTransform().getTranslation();
    }

    public final void setPosition-1s-5YWc(float f, float f2, float f3) {
        if (!(this.parent == null)) {
            boolean bl = false;
            String string = "Cannot set the position of a child bone.";
            throw new IllegalArgumentException(string.toString());
        }
        this.headNode.getLocalTransform().setTranslation-1s-5YWc(f, f2, f3);
    }

    public final float getLength() {
        Transform transform = this.tailNode.getLocalTransform();
        return Vector3.len-impl(transform.getTranslation-x(), transform.getTranslation-y(), transform.getTranslation-z());
    }

    public final void setLength(float len) {
        this.updateLength(len);
    }

    private final void updateLength(float length) {
        float f = -length;
        Vector3.constructor-impl(0.0f, f, 0.0f);
        this.tailNode.getLocalTransform().setTranslation-1s-5YWc(0.0f, f, 0.0f);
    }

    public final /* synthetic */ float getRotationOffset-w() {
        return this.rotationOffset-w;
    }

    public final /* synthetic */ float getRotationOffset-x() {
        return this.rotationOffset-x;
    }

    public final /* synthetic */ float getRotationOffset-y() {
        return this.rotationOffset-y;
    }

    public final /* synthetic */ float getRotationOffset-z() {
        return this.rotationOffset-z;
    }
}

