/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.processor;

import dev.slimevr.VRServer;
import dev.slimevr.autobone.errors.BodyProportionError;
import dev.slimevr.config.ConfigManager;
import dev.slimevr.tracking.processor.Bone;
import dev.slimevr.tracking.processor.BoneType;
import dev.slimevr.tracking.processor.config.SkeletonConfigManager;
import dev.slimevr.tracking.processor.config.SkeletonConfigOffsets;
import dev.slimevr.tracking.processor.config.SkeletonConfigToggles;
import dev.slimevr.tracking.processor.config.SkeletonConfigValues;
import dev.slimevr.tracking.processor.skeleton.HumanSkeleton;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerPosition;
import dev.slimevr.tracking.trackers.TrackerRole;
import dev.slimevr.tracking.trackers.TrackerStatus;
import dev.slimevr.tracking.trackers.TrackerUtils;
import dev.slimevr.trackingpause.TrackingPauseHandler;
import io.eiren.util.collections.FastList;
import io.eiren.util.logging.LogManager;
import io.github.axisangles.ktmath.Quaternion;
import io.github.axisangles.ktmath.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.math3.util.Precision;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solarxr_protocol.datatypes.DeviceIdT;
import solarxr_protocol.datatypes.TrackerIdT;
import solarxr_protocol.rpc.StatusDataUnion;
import solarxr_protocol.rpc.StatusUnassignedHMDT;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\tB/\b\u0016\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0004\u0010\u000eBE\b\u0016\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u0012\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0004\u0010\u0010J \u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020.H\u0002J\u000e\u0010/\u001a\u00020.2\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020.J\b\u00103\u001a\u00020.H\u0002J\u0010\u00104\u001a\u00020.2\b\u00105\u001a\u0004\u0018\u00010\bJ\u0010\u00106\u001a\u00020.2\b\u00105\u001a\u0004\u0018\u00010\bJ\u0014\u00107\u001a\u00020.2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u0006\u0010<\u001a\u00020.J\u000e\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020?J\u000e\u0010D\u001a\u00020A2\u0006\u0010E\u001a\u00020FJ\u0010\u0010N\u001a\u00020\r2\b\u0010O\u001a\u0004\u0018\u00010\fJ\u001d\u0010P\u001a\u00020.2\u0006\u0010O\u001a\u00020\f2\b\u0010Q\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010RJ\u0006\u0010S\u001a\u00020.J\u0010\u0010T\u001a\u00020:2\b\u0010O\u001a\u0004\u0018\u00010UJ\u001d\u0010V\u001a\u00020.2\u0006\u0010O\u001a\u00020U2\b\u0010W\u001a\u0004\u0018\u00010:\u00a2\u0006\u0002\u0010XJ\u0006\u0010Y\u001a\u00020.J\u000e\u0010Z\u001a\u00020\r2\u0006\u0010O\u001a\u00020[J\u001d\u0010\\\u001a\u00020.2\u0006\u0010O\u001a\u00020[2\b\u0010W\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010]J\u0006\u0010^\u001a\u00020.J\u0006\u0010_\u001a\u00020.J\u0006\u0010`\u001a\u00020.J\u001d\u0010a\u001a\u00020.2\u0006\u0010E\u001a\u00020F2\u0006\u0010b\u001a\u00020c\u00a2\u0006\u0004\bd\u0010eJ\u0006\u0010f\u001a\u00020.J\u0016\u0010g\u001a\u00020.2\u0006\u0010h\u001a\u00020U2\u0006\u0010W\u001a\u00020:J\u0016\u0010i\u001a\u00020.2\u0006\u0010j\u001a\u00020[2\u0006\u0010W\u001a\u00020\rJ\u000e\u0010k\u001a\u00020.2\u0006\u0010l\u001a\u00020FJ\"\u0010m\u001a\u00020.2\b\u0010n\u001a\u0004\u0018\u00010)2\u000e\b\u0002\u0010o\u001a\b\u0012\u0004\u0012\u00020p0\u0007H\u0007J\"\u0010q\u001a\u00020.2\b\u0010n\u001a\u0004\u0018\u00010)2\u000e\b\u0002\u0010o\u001a\b\u0012\u0004\u0012\u00020p0\u0007H\u0007J\b\u0010r\u001a\u00020.H\u0002J\"\u0010s\u001a\u00020.2\b\u0010n\u001a\u0004\u0018\u00010)2\u000e\b\u0002\u0010o\u001a\b\u0012\u0004\u0012\u00020p0\u0007H\u0007J\u0010\u0010t\u001a\u00020.2\b\u0010n\u001a\u0004\u0018\u00010)J\u000e\u0010y\u001a\u00020.2\u0006\u0010z\u001a\u00020:J\u000e\u0010{\u001a\u00020.2\u0006\u0010z\u001a\u00020:J\u000e\u0010|\u001a\u00020.2\u0006\u0010z\u001a\u00020:J(\u0010}\u001a\u00020.2\u0006\u0010~\u001a\u00020:2\u0006\u0010\u007f\u001a\u00020:2\u0007\u0010\u0080\u0001\u001a\u00020:2\u0007\u0010\u0081\u0001\u001a\u00020:J)\u0010\u0082\u0001\u001a\u00020.2\u0006\u0010~\u001a\u00020:2\u0006\u0010\u007f\u001a\u00020:2\u0007\u0010\u0080\u0001\u001a\u00020:2\u0007\u0010\u0081\u0001\u001a\u00020:J\u0007\u0010\u0083\u0001\u001a\u00020.J\u0007\u0010\u0084\u0001\u001a\u00020.J\u0007\u0010\u008b\u0001\u001a\u00020:J\u001b\u0010\u008c\u0001\u001a\u00020.2\u0007\u0010\u008d\u0001\u001a\u00020:2\t\u0010\u008e\u0001\u001a\u0004\u0018\u00010)J\u0012\u0010\u008f\u0001\u001a\u00020:2\t\u0010\u008e\u0001\u001a\u0004\u0018\u00010)J\u0007\u0010\u0090\u0001\u001a\u00020.J\u0007\u0010\u0094\u0001\u001a\u00020.J\u0011\u0010\u0095\u0001\u001a\u00020.2\u0006\u00105\u001a\u00020\bH\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u0019X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u00109\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010;R\u0011\u0010@\u001a\u00020A8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0011\u0010G\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR\u0011\u0010J\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010;R\u0011\u0010K\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010;R\u0017\u0010L\u001a\b\u0012\u0004\u0012\u00020A0\u00078F\u00a2\u0006\u0006\u001a\u0004\bM\u0010\u0016R\u0011\u0010u\u001a\u00020v8F\u00a2\u0006\u0006\u001a\u0004\bw\u0010xR\u0013\u0010\u0085\u0001\u001a\u00020\r8F\u00a2\u0006\u0007\u001a\u0005\b\u0086\u0001\u0010IR\u0013\u0010\u0087\u0001\u001a\u00020\r8F\u00a2\u0006\u0007\u001a\u0005\b\u0088\u0001\u0010IR\u0013\u0010\u0089\u0001\u001a\u00020\r8F\u00a2\u0006\u0007\u001a\u0005\b\u008a\u0001\u0010IR\u0013\u0010\u0091\u0001\u001a\u00030\u0092\u0001X\u0082\u000e\u00a2\u0006\u0005\n\u0003\u0010\u0093\u0001\u00a8\u0006\u0096\u0001"}, d2={"Ldev/slimevr/tracking/processor/HumanPoseManager;", "", "server", "Ldev/slimevr/VRServer;", "<init>", "(Ldev/slimevr/VRServer;)V", "trackers", "", "Ldev/slimevr/tracking/trackers/Tracker;", "(Ljava/util/List;)V", "offsetConfigs", "", "Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "", "(Ljava/util/List;Ljava/util/Map;)V", "altOffsetConfigs", "(Ljava/util/List;Ljava/util/Map;Ljava/util/Map;)V", "getServer", "()Ldev/slimevr/VRServer;", "computedTrackers", "", "getComputedTrackers", "()Ljava/util/List;", "onSkeletonUpdated", "Ljava/util/function/Consumer;", "Ldev/slimevr/tracking/processor/skeleton/HumanSkeleton;", "skeletonConfigManager", "Ldev/slimevr/tracking/processor/config/SkeletonConfigManager;", "skeleton", "getSkeleton", "()Ldev/slimevr/tracking/processor/skeleton/HumanSkeleton;", "setSkeleton", "(Ldev/slimevr/tracking/processor/skeleton/HumanSkeleton;)V", "timeAtLastReset", "", "trackingPauseHandler", "Ldev/slimevr/trackingpause/TrackingPauseHandler;", "getTrackingPauseHandler", "()Ldev/slimevr/trackingpause/TrackingPauseHandler;", "makeComputedTracker", "name", "", "display", "pos", "Ldev/slimevr/tracking/trackers/TrackerPosition;", "initializeComputedHumanPoseTracker", "", "loadFromConfig", "configManager", "Ldev/slimevr/config/ConfigManager;", "updateSkeletonModelFromServer", "connectComputedHumanPoseTrackers", "trackerAdded", "tracker", "trackerUpdated", "addSkeletonUpdatedCallback", "consumer", "isSkeletonPresent", "", "()Z", "update", "getComputedTracker", "trackerRole", "Ldev/slimevr/tracking/trackers/TrackerRole;", "headBone", "Ldev/slimevr/tracking/processor/Bone;", "getHeadBone", "()Ldev/slimevr/tracking/processor/Bone;", "getBone", "boneType", "Ldev/slimevr/tracking/processor/BoneType;", "hmdHeight", "getHmdHeight", "()F", "isTrackingLeftArmFromController", "isTrackingRightArmFromController", "allBones", "getAllBones", "getOffset", "key", "setOffset", "newLength", "(Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;Ljava/lang/Float;)V", "resetOffsets", "getToggle", "Ldev/slimevr/tracking/processor/config/SkeletonConfigToggles;", "setToggle", "newValue", "(Ldev/slimevr/tracking/processor/config/SkeletonConfigToggles;Ljava/lang/Boolean;)V", "resetToggles", "getValue", "Ldev/slimevr/tracking/processor/config/SkeletonConfigValues;", "setValue", "(Ldev/slimevr/tracking/processor/config/SkeletonConfigValues;Ljava/lang/Float;)V", "resetValues", "resetAllConfigs", "saveConfig", "updateNodeOffset", "offset", "Lio/github/axisangles/ktmath/Vector3;", "updateNodeOffset-mSee1rQ", "(Ldev/slimevr/tracking/processor/BoneType;FFF)V", "updateNodeOffsetsInSkeleton", "updateToggleState", "configToggle", "updateValueState", "configValue", "computeNodeOffset", "node", "resetTrackersFull", "resetSourceName", "bodyParts", "", "resetTrackersYaw", "logTrackersDrift", "resetTrackersMounting", "clearTrackersMounting", "legTweaksState", "", "getLegTweaksState", "()[Z", "setLegTweaksEnabled", "value", "setFloorClipEnabled", "setSkatingCorrectionEnabled", "setLegTweaksStateTemp", "skatingCorrection", "floorClip", "toeSnap", "footPlant", "clearLegTweaksStateTemp", "updateTapDetectionConfig", "updateLegTweaksConfig", "userHeightFromConfig", "getUserHeightFromConfig", "userNeckHeightFromConfig", "getUserNeckHeightFromConfig", "realUserHeight", "getRealUserHeight", "getPauseTracking", "setPauseTracking", "pauseTracking", "sourceName", "togglePauseTracking", "checkTrackersRequiringReset", "lastMissingHmdStatus", "Lkotlin/UInt;", "I", "checkReportMissingHmd", "reportMissingHmd", "core"})
@SourceDebugExtension(value={"SMAP\nHumanPoseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HumanPoseManager.kt\ndev/slimevr/tracking/processor/HumanPoseManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,721:1\n774#2:722\n865#2,2:723\n1863#2,2:725\n295#2,2:727\n1#3:729\n*S KotlinDebug\n*F\n+ 1 HumanPoseManager.kt\ndev/slimevr/tracking/processor/HumanPoseManager\n*L\n672#1:722\n672#1:723,2\n673#1:725,2\n683#1:727,2\n*E\n"})
public final class HumanPoseManager {
    @Nullable
    private final VRServer server;
    @NotNull
    private final List<Tracker> computedTrackers;
    @NotNull
    private final List<Consumer<HumanSkeleton>> onSkeletonUpdated;
    @NotNull
    private final SkeletonConfigManager skeletonConfigManager;
    public HumanSkeleton skeleton;
    private long timeAtLastReset;
    @NotNull
    private final TrackingPauseHandler trackingPauseHandler;
    private int lastMissingHmdStatus;

    public HumanPoseManager(@Nullable VRServer server) {
        this.server = server;
        this.computedTrackers = new FastList();
        this.onSkeletonUpdated = new FastList();
        this.skeletonConfigManager = new SkeletonConfigManager(true, this);
        this.trackingPauseHandler = new TrackingPauseHandler();
        this.initializeComputedHumanPoseTracker();
        if (this.server != null) {
            this.setSkeleton(new HumanSkeleton(this, this.server));
            this.loadFromConfig(this.server.configManager);
            for (Consumer<HumanSkeleton> sc : this.onSkeletonUpdated) {
                sc.accept(this.getSkeleton());
            }
        }
    }

    @Nullable
    public final VRServer getServer() {
        return this.server;
    }

    @NotNull
    public final List<Tracker> getComputedTrackers() {
        return this.computedTrackers;
    }

    @NotNull
    public final HumanSkeleton getSkeleton() {
        HumanSkeleton humanSkeleton = this.skeleton;
        if (humanSkeleton != null) {
            return humanSkeleton;
        }
        Intrinsics.throwUninitializedPropertyAccessException("skeleton");
        return null;
    }

    public final void setSkeleton(@NotNull HumanSkeleton humanSkeleton) {
        Intrinsics.checkNotNullParameter(humanSkeleton, "<set-?>");
        this.skeleton = humanSkeleton;
    }

    @NotNull
    public final TrackingPauseHandler getTrackingPauseHandler() {
        return this.trackingPauseHandler;
    }

    public HumanPoseManager(@Nullable List<Tracker> trackers) {
        this((VRServer)null);
        this.setSkeleton(new HumanSkeleton(this, trackers));
        this.skeletonConfigManager.computeAllNodeOffsets();
        this.skeletonConfigManager.updateSettingsInSkeleton();
    }

    public HumanPoseManager(@Nullable List<Tracker> trackers, @Nullable Map<SkeletonConfigOffsets, Float> offsetConfigs) {
        this((VRServer)null);
        this.setSkeleton(new HumanSkeleton(this, trackers));
        this.skeletonConfigManager.setOffsets(offsetConfigs);
        this.skeletonConfigManager.updateSettingsInSkeleton();
    }

    public HumanPoseManager(@Nullable List<Tracker> trackers, @Nullable Map<SkeletonConfigOffsets, Float> offsetConfigs, @Nullable Map<SkeletonConfigOffsets, Float> altOffsetConfigs) {
        this((VRServer)null);
        this.setSkeleton(new HumanSkeleton(this, trackers));
        if (altOffsetConfigs != null) {
            this.skeletonConfigManager.setOffsets(altOffsetConfigs);
        }
        this.skeletonConfigManager.setOffsets(offsetConfigs);
        this.skeletonConfigManager.updateSettingsInSkeleton();
    }

    private final Tracker makeComputedTracker(String name, String display, TrackerPosition pos) {
        return new Tracker(null, VRServer.Companion.getNextLocalTrackerId(), name, display, pos, null, true, true, false, false, true, true, null, false, false, false, false, false, false, null, null, 1815328, null);
    }

    private final void initializeComputedHumanPoseTracker() {
        this.computedTrackers.add(this.makeComputedTracker("human://HEAD", "Computed head", TrackerPosition.HEAD));
        this.computedTrackers.add(this.makeComputedTracker("human://CHEST", "Computed chest", TrackerPosition.UPPER_CHEST));
        this.computedTrackers.add(this.makeComputedTracker("human://WAIST", "Computed hip", TrackerPosition.HIP));
        this.computedTrackers.add(this.makeComputedTracker("human://LEFT_KNEE", "Computed left knee", TrackerPosition.LEFT_UPPER_LEG));
        this.computedTrackers.add(this.makeComputedTracker("human://RIGHT_KNEE", "Computed right knee", TrackerPosition.RIGHT_UPPER_LEG));
        this.computedTrackers.add(this.makeComputedTracker("human://LEFT_FOOT", "Computed left foot", TrackerPosition.LEFT_FOOT));
        this.computedTrackers.add(this.makeComputedTracker("human://RIGHT_FOOT", "Computed right foot", TrackerPosition.RIGHT_FOOT));
        this.computedTrackers.add(this.makeComputedTracker("human://LEFT_ELBOW", "Computed left elbow", TrackerPosition.LEFT_UPPER_ARM));
        this.computedTrackers.add(this.makeComputedTracker("human://RIGHT_ELBOW", "Computed right elbow", TrackerPosition.RIGHT_UPPER_ARM));
        this.computedTrackers.add(this.makeComputedTracker("human://LEFT_HAND", "Computed left hand", TrackerPosition.LEFT_HAND));
        this.computedTrackers.add(this.makeComputedTracker("human://RIGHT_HAND", "Computed right hand", TrackerPosition.RIGHT_HAND));
        this.connectComputedHumanPoseTrackers();
    }

    public final void loadFromConfig(@NotNull ConfigManager configManager) {
        Intrinsics.checkNotNullParameter(configManager, "configManager");
        this.skeletonConfigManager.loadFromConfig(configManager);
    }

    public final void updateSkeletonModelFromServer() {
        HumanSkeleton humanSkeleton = this.getSkeleton();
        VRServer vRServer = this.server;
        Intrinsics.checkNotNull(vRServer);
        humanSkeleton.setTrackersFromList(vRServer.getAllTrackers());
    }

    private final void connectComputedHumanPoseTrackers() {
        for (Tracker t : this.computedTrackers) {
            t.setStatus(TrackerStatus.OK);
        }
    }

    public final void trackerAdded(@Nullable Tracker tracker) {
    }

    public final void trackerUpdated(@Nullable Tracker tracker) {
    }

    public final void addSkeletonUpdatedCallback(@NotNull Consumer<HumanSkeleton> consumer) {
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        this.onSkeletonUpdated.add(consumer);
        consumer.accept(this.getSkeleton());
    }

    public final boolean isSkeletonPresent() {
        return this.skeleton != null;
    }

    public final void update() {
        this.getSkeleton().updatePose();
    }

    @NotNull
    public final Tracker getComputedTracker(@NotNull TrackerRole trackerRole) {
        Intrinsics.checkNotNullParameter((Object)trackerRole, "trackerRole");
        return this.getSkeleton().getComputedTracker(trackerRole);
    }

    @NotNull
    public final Bone getHeadBone() {
        return this.getSkeleton().getHeadBone();
    }

    @NotNull
    public final Bone getBone(@NotNull BoneType boneType) {
        Intrinsics.checkNotNullParameter((Object)boneType, "boneType");
        return this.getSkeleton().getBone(boneType);
    }

    public final float getHmdHeight() {
        return this.getSkeleton().getHmdHeight();
    }

    public final boolean isTrackingLeftArmFromController() {
        return this.getSkeleton().isTrackingLeftArmFromController();
    }

    public final boolean isTrackingRightArmFromController() {
        return this.getSkeleton().isTrackingRightArmFromController();
    }

    @NotNull
    public final List<Bone> getAllBones() {
        Bone[] boneArray = this.getSkeleton().getAllHumanBones();
        return CollectionsKt.listOf(Arrays.copyOf(boneArray, boneArray.length));
    }

    public final float getOffset(@Nullable SkeletonConfigOffsets key2) {
        return this.skeletonConfigManager.getOffset(key2);
    }

    public final void setOffset(@NotNull SkeletonConfigOffsets key2, @Nullable Float newLength) {
        Intrinsics.checkNotNullParameter((Object)key2, "key");
        this.skeletonConfigManager.setOffset(key2, newLength);
    }

    public final void resetOffsets() {
        this.skeletonConfigManager.resetOffsets();
    }

    public final boolean getToggle(@Nullable SkeletonConfigToggles key2) {
        return this.skeletonConfigManager.getToggle(key2);
    }

    public final void setToggle(@NotNull SkeletonConfigToggles key2, @Nullable Boolean newValue) {
        Intrinsics.checkNotNullParameter((Object)key2, "key");
        this.skeletonConfigManager.setToggle(key2, newValue);
    }

    public final void resetToggles() {
        this.skeletonConfigManager.resetToggles();
    }

    public final float getValue(@NotNull SkeletonConfigValues key2) {
        Intrinsics.checkNotNullParameter((Object)key2, "key");
        return this.skeletonConfigManager.getValue(key2);
    }

    public final void setValue(@NotNull SkeletonConfigValues key2, @Nullable Float newValue) {
        Intrinsics.checkNotNullParameter((Object)key2, "key");
        this.skeletonConfigManager.setValue(key2, newValue);
    }

    public final void resetValues() {
        this.skeletonConfigManager.resetValues();
    }

    public final void resetAllConfigs() {
        this.skeletonConfigManager.resetAllConfigs();
    }

    public final void saveConfig() {
        this.skeletonConfigManager.save();
    }

    public final void updateNodeOffset-mSee1rQ(@NotNull BoneType boneType, float f, float f2, float f3) {
        Intrinsics.checkNotNullParameter((Object)boneType, "boneType");
        if (!this.isSkeletonPresent()) {
            return;
        }
        this.getSkeleton().updateNodeOffset-mSee1rQ(boneType, f, f2, f3);
    }

    public final void updateNodeOffsetsInSkeleton() {
        if (!this.isSkeletonPresent()) {
            return;
        }
        this.skeletonConfigManager.updateNodeOffsetsInSkeleton();
    }

    public final void updateToggleState(@NotNull SkeletonConfigToggles configToggle, boolean newValue) {
        Intrinsics.checkNotNullParameter((Object)configToggle, "configToggle");
        this.getSkeleton().updateToggleState(configToggle, newValue);
    }

    public final void updateValueState(@NotNull SkeletonConfigValues configValue, float newValue) {
        Intrinsics.checkNotNullParameter((Object)configValue, "configValue");
        this.getSkeleton().updateValueState(configValue, newValue);
    }

    public final void computeNodeOffset(@NotNull BoneType node) {
        Intrinsics.checkNotNullParameter((Object)node, "node");
        this.skeletonConfigManager.computeNodeOffset(node);
    }

    @JvmOverloads
    public final void resetTrackersFull(@Nullable String resetSourceName, @NotNull List<Integer> bodyParts) {
        Intrinsics.checkNotNullParameter(bodyParts, "bodyParts");
        this.getSkeleton().resetTrackersFull(resetSourceName, bodyParts);
        if (this.server != null) {
            Object object;
            if (this.getSkeleton().getHeadTracker() == null && this.getSkeleton().getNeckTracker() == null) {
                object = Quaternion.Companion;
                this.server.vrcOSCHandler.yawAlign-oS71L7k(((Quaternion.Companion)object).getIDENTITY-w(), ((Quaternion.Companion)object).getIDENTITY-x(), ((Quaternion.Companion)object).getIDENTITY-y(), ((Quaternion.Companion)object).getIDENTITY-z());
            } else {
                Quaternion quaternion = this.getHeadBone().getGlobalRotation();
                Vector3.Companion companion = Vector3.Companion;
                object = Quaternion.project-1s-5YWc(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z(), companion.getPOS_Y-x(), companion.getPOS_Y-y(), companion.getPOS_Y-z());
                this.server.vrcOSCHandler.yawAlign-oS71L7k(((Quaternion)object).unbox-impl-w(), ((Quaternion)object).unbox-impl-x(), ((Quaternion)object).unbox-impl-y(), ((Quaternion)object).unbox-impl-z());
            }
            object = this.getHeadBone().getGlobalRotation();
            this.server.getVMCHandler().alignVMCTracking-oS71L7k(((Quaternion)object).unbox-impl-w(), ((Quaternion)object).unbox-impl-x(), ((Quaternion)object).unbox-impl-y(), ((Quaternion)object).unbox-impl-z());
            this.logTrackersDrift();
        }
    }

    public static /* synthetic */ void resetTrackersFull$default(HumanPoseManager humanPoseManager, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        humanPoseManager.resetTrackersFull(string, list);
    }

    @JvmOverloads
    public final void resetTrackersYaw(@Nullable String resetSourceName, @NotNull List<Integer> bodyParts) {
        Intrinsics.checkNotNullParameter(bodyParts, "bodyParts");
        this.getSkeleton().resetTrackersYaw(resetSourceName, bodyParts);
        if (this.server != null) {
            Object object;
            if (this.getSkeleton().getHeadTracker() == null && this.getSkeleton().getNeckTracker() == null) {
                object = Quaternion.Companion;
                this.server.vrcOSCHandler.yawAlign-oS71L7k(((Quaternion.Companion)object).getIDENTITY-w(), ((Quaternion.Companion)object).getIDENTITY-x(), ((Quaternion.Companion)object).getIDENTITY-y(), ((Quaternion.Companion)object).getIDENTITY-z());
            } else {
                Quaternion quaternion = this.getHeadBone().getGlobalRotation();
                Vector3.Companion companion = Vector3.Companion;
                object = Quaternion.project-1s-5YWc(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z(), companion.getPOS_Y-x(), companion.getPOS_Y-y(), companion.getPOS_Y-z());
                this.server.vrcOSCHandler.yawAlign-oS71L7k(((Quaternion)object).unbox-impl-w(), ((Quaternion)object).unbox-impl-x(), ((Quaternion)object).unbox-impl-y(), ((Quaternion)object).unbox-impl-z());
            }
            object = this.getHeadBone().getGlobalRotation();
            this.server.getVMCHandler().alignVMCTracking-oS71L7k(((Quaternion)object).unbox-impl-w(), ((Quaternion)object).unbox-impl-x(), ((Quaternion)object).unbox-impl-y(), ((Quaternion)object).unbox-impl-z());
            this.logTrackersDrift();
        }
    }

    public static /* synthetic */ void resetTrackersYaw$default(HumanPoseManager humanPoseManager, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = TrackerUtils.INSTANCE.getAllBodyPartsButFingers();
        }
        humanPoseManager.resetTrackersYaw(string, list);
    }

    private final void logTrackersDrift() {
        if (this.timeAtLastReset == 0L) {
            this.timeAtLastReset = System.currentTimeMillis();
        }
        long timeSinceLastReset = (System.currentTimeMillis() - this.timeAtLastReset) / 1000L;
        this.timeAtLastReset = System.currentTimeMillis();
        StringBuilder trackersDriftText = new StringBuilder();
        VRServer vRServer = this.server;
        Intrinsics.checkNotNull(vRServer);
        for (Tracker tracker : vRServer.getAllTrackers()) {
            Quaternion quaternion;
            if (!tracker.isImu() || !tracker.getNeedsReset() || tracker.getResetsHandler().getLastResetQuaternion() == null) continue;
            if (((CharSequence)trackersDriftText).length() > 0) {
                trackersDriftText.append(" | ");
            }
            Quaternion quaternion2 = tracker.getRotation();
            Intrinsics.checkNotNull(tracker.getResetsHandler().getLastResetQuaternion());
            Quaternion quaternion3 = Quaternion.inv-impl(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
            Quaternion quaternion4 = Quaternion.times-oS71L7k(quaternion2.unbox-impl-w(), quaternion2.unbox-impl-x(), quaternion2.unbox-impl-y(), quaternion2.unbox-impl-z(), quaternion3.unbox-impl-w(), quaternion3.unbox-impl-x(), quaternion3.unbox-impl-y(), quaternion3.unbox-impl-z());
            float f = quaternion4.unbox-impl-w();
            float f2 = quaternion4.unbox-impl-x();
            float f3 = quaternion4.unbox-impl-y();
            float f4 = quaternion4.unbox-impl-z();
            float trackerDriftAngle = Math.abs((float)Math.atan2(f3, f) * (float)2 * 57.295776f);
            if (trackerDriftAngle > 180.0f) {
                trackerDriftAngle = Math.abs(trackerDriftAngle - (float)360);
            }
            float driftPerMin = trackerDriftAngle / ((float)timeSinceLastReset / 60.0f);
            trackersDriftText.append(tracker.getName());
            TrackerPosition trackerPosition = tracker.getTrackerPosition();
            if (trackerPosition != null) {
                trackersDriftText.append(" (").append(trackerPosition.name()).append(")");
            }
            trackersDriftText.append(", ").append(Precision.round(trackerDriftAngle, 4)).append(" deg (").append(Precision.round(driftPerMin, 4)).append(" deg/min)");
        }
        if (((CharSequence)trackersDriftText).length() > 0) {
            LogManager.info("[HumanPoseManager] " + timeSinceLastReset + " seconds since last reset. Tracker yaw drifts: " + trackersDriftText);
        }
    }

    @JvmOverloads
    public final void resetTrackersMounting(@Nullable String resetSourceName, @NotNull List<Integer> bodyParts) {
        Intrinsics.checkNotNullParameter(bodyParts, "bodyParts");
        this.getSkeleton().resetTrackersMounting(resetSourceName, bodyParts);
    }

    public static /* synthetic */ void resetTrackersMounting$default(HumanPoseManager humanPoseManager, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = TrackerUtils.INSTANCE.getAllBodyPartsButFingers();
        }
        humanPoseManager.resetTrackersMounting(string, list);
    }

    public final void clearTrackersMounting(@Nullable String resetSourceName) {
        this.getSkeleton().clearTrackersMounting(resetSourceName);
    }

    @NotNull
    public final boolean[] getLegTweaksState() {
        return this.getSkeleton().getLegTweaksState();
    }

    public final void setLegTweaksEnabled(boolean value) {
        this.getSkeleton().setLegTweaksEnabled(value);
    }

    public final void setFloorClipEnabled(boolean value) {
        this.getSkeleton().setFloorclipEnabled(value);
        if (this.server != null) {
            Map<String, Boolean> map = this.server.configManager.getVrConfig().getSkeleton().getToggles();
            Intrinsics.checkNotNullExpressionValue(map, "getToggles(...)");
            Map<String, Boolean> map2 = map;
            String string = SkeletonConfigToggles.FLOOR_CLIP.configKey;
            Boolean bl = value;
            map2.put(string, bl);
            this.server.configManager.saveConfig();
        }
    }

    public final void setSkatingCorrectionEnabled(boolean value) {
        this.getSkeleton().setSkatingCorrectionEnabled(value);
        if (this.server != null) {
            Map<String, Boolean> map = this.server.configManager.getVrConfig().getSkeleton().getToggles();
            Intrinsics.checkNotNullExpressionValue(map, "getToggles(...)");
            Map<String, Boolean> map2 = map;
            String string = SkeletonConfigToggles.SKATING_CORRECTION.configKey;
            Boolean bl = value;
            map2.put(string, bl);
            this.server.configManager.saveConfig();
        }
    }

    public final void setLegTweaksStateTemp(boolean skatingCorrection, boolean floorClip, boolean toeSnap, boolean footPlant) {
        this.getSkeleton().setLegTweaksStateTemp(skatingCorrection, floorClip, toeSnap, footPlant);
    }

    public final void clearLegTweaksStateTemp(boolean skatingCorrection, boolean floorClip, boolean toeSnap, boolean footPlant) {
        this.getSkeleton().clearLegTweaksStateTemp(skatingCorrection, floorClip, toeSnap, footPlant);
    }

    public final void updateTapDetectionConfig() {
        this.getSkeleton().updateTapDetectionConfig();
    }

    public final void updateLegTweaksConfig() {
        this.getSkeleton().updateLegTweaksConfig();
    }

    public final float getUserHeightFromConfig() {
        return this.skeletonConfigManager.getUserHeightFromOffsets();
    }

    public final float getUserNeckHeightFromConfig() {
        return this.skeletonConfigManager.getUserNeckHeightFromOffsets();
    }

    public final float getRealUserHeight() {
        return this.skeletonConfigManager.getUserHeightFromOffsets() / BodyProportionError.eyeHeightToHeightRatio;
    }

    public final boolean getPauseTracking() {
        return this.getSkeleton().getPauseTracking();
    }

    public final void setPauseTracking(boolean pauseTracking, @Nullable String sourceName) {
        this.getSkeleton().setPauseTracking(pauseTracking, sourceName);
    }

    public final boolean togglePauseTracking(@Nullable String sourceName) {
        return this.getSkeleton().togglePauseTracking(sourceName);
    }

    /*
     * WARNING - void declaration
     */
    public final void checkTrackersRequiringReset() {
        void $this$filterTo$iv$iv;
        block6: {
            block5: {
                if (this.server == null) break block5;
                Tracker tracker = this.getSkeleton().getHeadTracker();
                if (tracker != null ? tracker.isComputed() : false) break block6;
            }
            return;
        }
        Iterable $this$filter$iv = this.server.getAllTrackers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tracker it = (Tracker)element$iv$iv;
            boolean bl = false;
            if (!(!it.isInternal() && it.getTrackerPosition() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tracker it = (Tracker)element$iv;
            boolean bl = false;
            it.checkReportRequireReset();
        }
    }

    public final void checkReportMissingHmd() {
        Object v0;
        block5: {
            if (this.server == null) {
                return;
            }
            Iterable $this$firstOrNull$iv = VRServer.Companion.getInstance().getAllTrackers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Tracker it = (Tracker)element$iv;
                boolean bl = false;
                if (!(it.isHmd() && !it.isInternal() && it.getStatus().getSendData())) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        Tracker tracker = v0;
        if (this.getSkeleton().getHeadTracker() == null && this.lastMissingHmdStatus == 0 && tracker != null) {
            this.reportMissingHmd(tracker);
        } else if (this.lastMissingHmdStatus != 0 && (this.getSkeleton().getHeadTracker() != null || tracker == null)) {
            this.server.statusSystem.removeStatusInt(this.lastMissingHmdStatus);
            this.lastMissingHmdStatus = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportMissingHmd(Tracker tracker) {
        void $this$reportMissingHmd_u24lambda_u248_u24lambda_u247_u24lambda_u246;
        void $this$reportMissingHmd_u24lambda_u248_u24lambda_u247;
        TrackerIdT trackerIdT;
        StatusUnassignedHMDT statusUnassignedHMDT;
        StatusDataUnion statusDataUnion;
        if (!(this.lastMissingHmdStatus == 0)) {
            boolean $i$a$-require-HumanPoseManager$reportMissingHmd$32 = false;
            String $i$a$-require-HumanPoseManager$reportMissingHmd$32 = "lastMissingHmdStatus must be 0u, but was " + UInt.toString-impl(this.lastMissingHmdStatus);
            throw new IllegalArgumentException($i$a$-require-HumanPoseManager$reportMissingHmd$32.toString());
        }
        if (!(this.server != null)) {
            boolean bl = false;
            String string = "server must not be null";
            throw new IllegalArgumentException(string.toString());
        }
        StatusDataUnion $this$reportMissingHmd_u24lambda_u248 = statusDataUnion = new StatusDataUnion();
        boolean bl = false;
        $this$reportMissingHmd_u24lambda_u248.setType((byte)4);
        StatusUnassignedHMDT statusUnassignedHMDT2 = statusUnassignedHMDT = new StatusUnassignedHMDT();
        StatusDataUnion statusDataUnion2 = $this$reportMissingHmd_u24lambda_u248;
        boolean bl2 = false;
        TrackerIdT trackerIdT2 = trackerIdT = new TrackerIdT();
        void var12_15 = $this$reportMissingHmd_u24lambda_u248_u24lambda_u247;
        boolean bl3 = false;
        if (tracker.getDevice() != null) {
            void $this$reportMissingHmd_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245;
            DeviceIdT deviceIdT;
            DeviceIdT deviceIdT2 = deviceIdT = new DeviceIdT();
            void var16_19 = $this$reportMissingHmd_u24lambda_u248_u24lambda_u247_u24lambda_u246;
            boolean bl4 = false;
            $this$reportMissingHmd_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setId(tracker.getDevice().getId());
            var16_19.setDeviceId(deviceIdT);
        }
        $this$reportMissingHmd_u24lambda_u248_u24lambda_u247_u24lambda_u246.setTrackerNum(tracker.getTrackerNum());
        var12_15.setTrackerId(trackerIdT);
        statusDataUnion2.setValue(statusUnassignedHMDT);
        StatusDataUnion status = statusDataUnion;
        this.lastMissingHmdStatus = this.server.statusSystem.addStatusInt(status, true);
    }

    @JvmOverloads
    public final void resetTrackersFull(@Nullable String resetSourceName) {
        HumanPoseManager.resetTrackersFull$default(this, resetSourceName, null, 2, null);
    }

    @JvmOverloads
    public final void resetTrackersYaw(@Nullable String resetSourceName) {
        HumanPoseManager.resetTrackersYaw$default(this, resetSourceName, null, 2, null);
    }

    @JvmOverloads
    public final void resetTrackersMounting(@Nullable String resetSourceName) {
        HumanPoseManager.resetTrackersMounting$default(this, resetSourceName, null, 2, null);
    }
}

