/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.processor;

import io.github.axisangles.ktmath.Quaternion;
import io.github.axisangles.ktmath.Transform;
import io.github.axisangles.ktmath.Vector3;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\u0016\u0010\u001c\u001a\u00020\u00172\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u001eJ\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0006\u0010 \u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\"\u0010\u000f\u001a\u0004\u0018\u00010\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u0000@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Ldev/slimevr/tracking/processor/TransformNode;", "", "localRotation", "", "<init>", "(Z)V", "getLocalRotation", "()Z", "localTransform", "Lio/github/axisangles/ktmath/Transform;", "getLocalTransform", "()Lio/github/axisangles/ktmath/Transform;", "worldTransform", "getWorldTransform", "value", "parent", "getParent", "()Ldev/slimevr/tracking/processor/TransformNode;", "children", "", "getChildren", "()Ljava/util/List;", "attachChild", "", "node", "update", "updateThisNode", "updateWorldTransforms", "depthFirstTraversal", "visitor", "Ljava/util/function/Consumer;", "combineWithParentGlobalRotation", "detachWithChildren", "core"})
@SourceDebugExtension(value={"SMAP\nTransformNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformNode.kt\ndev/slimevr/tracking/processor/TransformNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class TransformNode {
    private final boolean localRotation;
    @NotNull
    private final Transform localTransform;
    @NotNull
    private final Transform worldTransform;
    @Nullable
    private TransformNode parent;
    @NotNull
    private final List<TransformNode> children;

    public TransformNode(boolean localRotation) {
        this.localRotation = localRotation;
        this.localTransform = new Transform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1023, null);
        this.worldTransform = new Transform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1023, null);
        this.children = new CopyOnWriteArrayList();
    }

    public final boolean getLocalRotation() {
        return this.localRotation;
    }

    @NotNull
    public final Transform getLocalTransform() {
        return this.localTransform;
    }

    @NotNull
    public final Transform getWorldTransform() {
        return this.worldTransform;
    }

    @Nullable
    public final TransformNode getParent() {
        return this.parent;
    }

    @NotNull
    public final List<TransformNode> getChildren() {
        return this.children;
    }

    public final void attachChild(@NotNull TransformNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        if (!(node.parent == null)) {
            boolean bl = false;
            String string = "The child node must not already have a parent.";
            throw new IllegalArgumentException(string.toString());
        }
        this.children.add(node);
        node.parent = this;
    }

    public final void update() {
        this.updateWorldTransforms();
        for (TransformNode node : this.children) {
            node.update();
        }
    }

    public final void updateThisNode() {
        this.updateWorldTransforms();
    }

    private final synchronized void updateWorldTransforms() {
        block2: {
            this.worldTransform.set(this.localTransform);
            TransformNode transformNode = this.parent;
            if (transformNode == null) break block2;
            TransformNode it = transformNode;
            boolean bl = false;
            if (this.localRotation) {
                this.worldTransform.combineWithParent(it.worldTransform);
            } else {
                this.combineWithParentGlobalRotation(it.worldTransform);
            }
        }
    }

    public final void depthFirstTraversal(@NotNull Consumer<TransformNode> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        for (TransformNode node : this.children) {
            node.depthFirstTraversal(visitor2);
        }
        visitor2.accept(this);
    }

    private final void combineWithParentGlobalRotation(Transform parent) {
        Object object = this.worldTransform;
        Vector3 vector3 = Vector3.hadamard-1s-5YWc(((Transform)object).getScale-x(), ((Transform)object).getScale-y(), ((Transform)object).getScale-z(), parent.getScale-x(), parent.getScale-y(), parent.getScale-z());
        this.worldTransform.setScale-1s-5YWc(vector3.unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z());
        Transform transform = this.worldTransform;
        object = Vector3.hadamard-1s-5YWc(transform.getTranslation-x(), transform.getTranslation-y(), transform.getTranslation-z(), parent.getScale-x(), parent.getScale-y(), parent.getScale-z());
        float f = ((Vector3)object).unbox-impl-x();
        float f2 = ((Vector3)object).unbox-impl-y();
        float f3 = ((Vector3)object).unbox-impl-z();
        Vector3 vector32 = Quaternion.sandwich-1s-5YWc(parent.getRotation-w(), parent.getRotation-x(), parent.getRotation-y(), parent.getRotation-z(), f, f2, f3);
        Vector3 vector33 = Vector3.plus-1s-5YWc(vector32.unbox-impl-x(), vector32.unbox-impl-y(), vector32.unbox-impl-z(), parent.getTranslation-x(), parent.getTranslation-y(), parent.getTranslation-z());
        this.worldTransform.setTranslation-1s-5YWc(vector33.unbox-impl-x(), vector33.unbox-impl-y(), vector33.unbox-impl-z());
    }

    public final void detachWithChildren() {
        for (TransformNode child : this.children) {
            child.parent = null;
        }
        this.children.clear();
        Object object = this.parent;
        if (object != null && (object = ((TransformNode)object).children) != null) {
            object.remove(this);
        }
        this.parent = null;
    }
}

