/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.processor.config;

import dev.slimevr.VRServer;
import dev.slimevr.autobone.errors.BodyProportionError;
import dev.slimevr.autobone.errors.proportions.ProportionLimiter;
import dev.slimevr.config.ConfigManager;
import dev.slimevr.config.SkeletonConfig;
import dev.slimevr.config.VRConfig;
import dev.slimevr.tracking.processor.BoneType;
import dev.slimevr.tracking.processor.HumanPoseManager;
import dev.slimevr.tracking.processor.config.SkeletonConfigOffsets;
import dev.slimevr.tracking.processor.config.SkeletonConfigToggles;
import dev.slimevr.tracking.processor.config.SkeletonConfigValues;
import io.github.axisangles.ktmath.Vector3;
import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 @2\u00020\u0001:\u0001@B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ%\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020\u0003\u00a2\u0006\u0002\u0010#J\u001d\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010\nJ\b\u0010&\u001a\u00020\u000bH\u0002J\u001d\u0010'\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\r2\b\u0010!\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00032\b\u0010 \u001a\u0004\u0018\u00010\rJ\u001d\u0010*\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010\u000fJ(\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000bH\u0004J\u000e\u00102\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u0014J\u0006\u00103\u001a\u00020\u001dJ$\u00104\u001a\u00020\u001d2\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u0001052\u0006\u0010\"\u001a\u00020\u0003J\u001c\u00104\u001a\u00020\u001d2\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u000105J\u000e\u00104\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u0000J\u0006\u00107\u001a\u00020\u001dJ\u0006\u00108\u001a\u00020\u001dJ\u0006\u00109\u001a\u00020\u001dJ\u0006\u0010:\u001a\u00020\u001dJ\u000e\u0010;\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\nJ\u000e\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020>J\u0006\u0010?\u001a\u00020\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006A"}, d2={"Ldev/slimevr/tracking/processor/config/SkeletonConfigManager;", "", "autoUpdateOffsets", "", "humanPoseManager", "Ldev/slimevr/tracking/processor/HumanPoseManager;", "<init>", "(ZLdev/slimevr/tracking/processor/HumanPoseManager;)V", "configOffsets", "Ljava/util/EnumMap;", "Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "", "configToggles", "Ldev/slimevr/tracking/processor/config/SkeletonConfigToggles;", "configValues", "Ldev/slimevr/tracking/processor/config/SkeletonConfigValues;", "changedToggles", "", "changedValues", "nodeOffsets", "Ldev/slimevr/tracking/processor/BoneType;", "Lio/github/axisangles/ktmath/Vector3;", "value", "userHeightFromOffsets", "getUserHeightFromOffsets", "()F", "userNeckHeightFromOffsets", "getUserNeckHeightFromOffsets", "updateSettingsInSkeleton", "", "updateNodeOffsetsInSkeleton", "setOffset", "config", "newValue", "computeOffsets", "(Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;Ljava/lang/Float;Z)V", "(Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;Ljava/lang/Float;)V", "getOffset", "calculateUserHeight", "setToggle", "(Ldev/slimevr/tracking/processor/config/SkeletonConfigToggles;Ljava/lang/Boolean;)V", "getToggle", "setValue", "(Ldev/slimevr/tracking/processor/config/SkeletonConfigValues;Ljava/lang/Float;)V", "getValue", "setNodeOffset", "nodeOffset", "x", "y", "z", "computeNodeOffset", "computeAllNodeOffsets", "setOffsets", "", "skeletonConfigManager", "resetOffsets", "resetToggles", "resetValues", "resetAllConfigs", "resetOffset", "loadFromConfig", "configManager", "Ldev/slimevr/config/ConfigManager;", "save", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nSkeletonConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkeletonConfigManager.kt\ndev/slimevr/tracking/processor/config/SkeletonConfigManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,567:1\n216#2,2:568\n216#2,2:570\n1#3:572\n*S KotlinDebug\n*F\n+ 1 SkeletonConfigManager.kt\ndev/slimevr/tracking/processor/config/SkeletonConfigManager\n*L\n362#1:568,2\n387#1:570,2\n*E\n"})
public final class SkeletonConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean autoUpdateOffsets;
    @Nullable
    private final HumanPoseManager humanPoseManager;
    @NotNull
    private final EnumMap<SkeletonConfigOffsets, Float> configOffsets;
    @NotNull
    private final EnumMap<SkeletonConfigToggles, Boolean> configToggles;
    @NotNull
    private final EnumMap<SkeletonConfigValues, Float> configValues;
    @NotNull
    private boolean[] changedToggles;
    @NotNull
    private boolean[] changedValues;
    @NotNull
    private final EnumMap<BoneType, Vector3> nodeOffsets;
    private float userHeightFromOffsets;
    private float userNeckHeightFromOffsets;
    @NotNull
    private static final SkeletonConfigOffsets[] HEIGHT_OFFSETS;
    public static final float FLOOR_OFFSET = 0.05f;

    public SkeletonConfigManager(boolean autoUpdateOffsets, @Nullable HumanPoseManager humanPoseManager) {
        this.autoUpdateOffsets = autoUpdateOffsets;
        this.humanPoseManager = humanPoseManager;
        this.configOffsets = new EnumMap(SkeletonConfigOffsets.class);
        this.configToggles = new EnumMap(SkeletonConfigToggles.class);
        this.configValues = new EnumMap(SkeletonConfigValues.class);
        this.changedToggles = new boolean[SkeletonConfigToggles.values.length];
        this.changedValues = new boolean[SkeletonConfigValues.values.length];
        this.nodeOffsets = new EnumMap(BoneType.class);
        this.userHeightFromOffsets = this.calculateUserHeight();
        this.userNeckHeightFromOffsets = this.calculateUserHeight();
        HumanPoseManager humanPoseManager2 = this.humanPoseManager;
        if (!(humanPoseManager2 != null ? !humanPoseManager2.isSkeletonPresent() : false)) {
            this.updateSettingsInSkeleton();
            if (this.autoUpdateOffsets) {
                this.computeAllNodeOffsets();
            }
        }
    }

    public /* synthetic */ SkeletonConfigManager(boolean bl, HumanPoseManager humanPoseManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            humanPoseManager = null;
        }
        this(bl, humanPoseManager);
    }

    public final float getUserHeightFromOffsets() {
        return this.userHeightFromOffsets;
    }

    public final float getUserNeckHeightFromOffsets() {
        return this.userNeckHeightFromOffsets;
    }

    public final void updateSettingsInSkeleton() {
        Enum config;
        if (this.humanPoseManager == null) {
            return;
        }
        Iterator<Enum> iterator2 = ArrayIteratorKt.iterator(SkeletonConfigToggles.values);
        while (iterator2.hasNext()) {
            config = iterator2.next();
            Boolean configToggle = this.configToggles.get(config);
            Intrinsics.checkNotNull(config);
            Boolean bl = configToggle;
            this.humanPoseManager.updateToggleState((SkeletonConfigToggles)config, bl != null ? bl : ((SkeletonConfigToggles)config).defaultValue);
        }
        iterator2 = ArrayIteratorKt.iterator(SkeletonConfigValues.values);
        while (iterator2.hasNext()) {
            config = (SkeletonConfigValues)iterator2.next();
            Float configValue = this.configValues.get(config);
            Intrinsics.checkNotNull(config);
            Float f = configValue;
            this.humanPoseManager.updateValueState((SkeletonConfigValues)config, f != null ? f.floatValue() : ((SkeletonConfigValues)config).defaultValue);
        }
    }

    public final void updateNodeOffsetsInSkeleton() {
        if (this.humanPoseManager == null) {
            return;
        }
        Iterator<BoneType> iterator2 = ArrayIteratorKt.iterator(BoneType.values);
        while (iterator2.hasNext()) {
            BoneType config = iterator2.next();
            Vector3 nodeOffset = this.nodeOffsets.get((Object)config);
            if (nodeOffset == null) continue;
            Intrinsics.checkNotNull((Object)config);
            this.humanPoseManager.updateNodeOffset-mSee1rQ(config, nodeOffset.unbox-impl-x(), nodeOffset.unbox-impl-y(), nodeOffset.unbox-impl-z());
        }
    }

    public final void setOffset(@NotNull SkeletonConfigOffsets config, @Nullable Float newValue, boolean computeOffsets) {
        Intrinsics.checkNotNullParameter((Object)config, "config");
        if (newValue != null) {
            ((Map)this.configOffsets).put(config, newValue);
        } else {
            this.configOffsets.remove((Object)config);
        }
        if (computeOffsets && this.autoUpdateOffsets && config.affectedOffsets != null) {
            Iterator<BoneType> iterator2 = ArrayIteratorKt.iterator(config.affectedOffsets);
            while (iterator2.hasNext()) {
                BoneType offset = iterator2.next();
                Intrinsics.checkNotNull((Object)offset);
                this.computeNodeOffset(offset);
            }
        }
        this.userHeightFromOffsets = this.calculateUserHeight();
        this.userNeckHeightFromOffsets = this.userHeightFromOffsets - this.getOffset(SkeletonConfigOffsets.NECK);
    }

    public final void setOffset(@NotNull SkeletonConfigOffsets config, @Nullable Float newValue) {
        Intrinsics.checkNotNullParameter((Object)config, "config");
        this.setOffset(config, newValue, true);
    }

    public final float getOffset(@Nullable SkeletonConfigOffsets config) {
        Float configOffset;
        if (config == null) {
            return 0.0f;
        }
        Float f = configOffset = this.configOffsets.get((Object)config);
        return f != null ? f.floatValue() : config.defaultValue;
    }

    private final float calculateUserHeight() {
        float height = 0.0f;
        for (SkeletonConfigOffsets offset : HEIGHT_OFFSETS) {
            height += this.getOffset(offset);
        }
        return height;
    }

    public final void setToggle(@NotNull SkeletonConfigToggles config, @Nullable Boolean newValue) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)config, "config");
            if (newValue != null) {
                if (this.configToggles.get((Object)config) != null && !Intrinsics.areEqual(newValue, this.configToggles.get((Object)config))) {
                    this.changedToggles[config.ordinal()] = true;
                }
                ((Map)this.configToggles).put(config, newValue);
            } else {
                this.configToggles.remove((Object)config);
            }
            HumanPoseManager humanPoseManager = this.humanPoseManager;
            if (humanPoseManager == null) break block3;
            Boolean bl = newValue;
            humanPoseManager.updateToggleState(config, bl != null ? bl : config.defaultValue);
        }
    }

    public final boolean getToggle(@Nullable SkeletonConfigToggles config) {
        Boolean configToggle;
        if (config == null) {
            return false;
        }
        Boolean bl = configToggle = this.configToggles.get((Object)config);
        return bl != null ? bl : config.defaultValue;
    }

    public final void setValue(@NotNull SkeletonConfigValues config, @Nullable Float newValue) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)config, "config");
            if (newValue != null) {
                if (this.configValues.get((Object)config) != null && !Intrinsics.areEqual(newValue, this.configValues.get((Object)config))) {
                    this.changedValues[config.ordinal()] = true;
                }
                ((Map)this.configValues).put(config, newValue);
            } else {
                this.configValues.remove((Object)config);
            }
            HumanPoseManager humanPoseManager = this.humanPoseManager;
            if (humanPoseManager == null) break block3;
            Float f = newValue;
            humanPoseManager.updateValueState(config, f != null ? f.floatValue() : config.defaultValue);
        }
    }

    public final float getValue(@Nullable SkeletonConfigValues config) {
        Float configValue;
        if (config == null) {
            return 0.0f;
        }
        Float f = configValue = this.configValues.get((Object)config);
        return f != null ? f.floatValue() : config.defaultValue;
    }

    protected final void setNodeOffset(@NotNull BoneType nodeOffset, float x, float y, float z) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)nodeOffset, "nodeOffset");
            float f = x;
            float f2 = y;
            float f3 = z;
            Vector3.constructor-impl(f, f2, f3);
            ((Map)this.nodeOffsets).put(nodeOffset, Vector3.box-impl(f, f2, f3));
            HumanPoseManager humanPoseManager = this.humanPoseManager;
            if (humanPoseManager == null) break block0;
            humanPoseManager.updateNodeOffset-mSee1rQ(nodeOffset, f, f2, f3);
        }
    }

    public final void computeNodeOffset(@NotNull BoneType nodeOffset) {
        Intrinsics.checkNotNullParameter((Object)nodeOffset, "nodeOffset");
        switch (WhenMappings.$EnumSwitchMapping$0[nodeOffset.ordinal()]) {
            case 1: {
                this.setNodeOffset(nodeOffset, 0.0f, 0.0f, this.getOffset(SkeletonConfigOffsets.HEAD));
                break;
            }
            case 2: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.NECK), 0.0f);
                break;
            }
            case 3: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.UPPER_CHEST), 0.0f);
                break;
            }
            case 4: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.CHEST_OFFSET) - this.getOffset(SkeletonConfigOffsets.CHEST), -this.getOffset(SkeletonConfigOffsets.SKELETON_OFFSET));
                break;
            }
            case 5: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.CHEST), 0.0f);
                break;
            }
            case 6: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.WAIST), 0.0f);
                break;
            }
            case 7: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.HIP), 0.0f);
                break;
            }
            case 8: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.HIP_OFFSET), -this.getOffset(SkeletonConfigOffsets.SKELETON_OFFSET));
                break;
            }
            case 9: {
                this.setNodeOffset(nodeOffset, -this.getOffset(SkeletonConfigOffsets.HIPS_WIDTH) / 2.0f, 0.0f, 0.0f);
                break;
            }
            case 10: {
                this.setNodeOffset(nodeOffset, this.getOffset(SkeletonConfigOffsets.HIPS_WIDTH) / 2.0f, 0.0f, 0.0f);
                break;
            }
            case 11: 
            case 12: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.UPPER_LEG), 0.0f);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.setNodeOffset(nodeOffset, 0.0f, 0.0f, -this.getOffset(SkeletonConfigOffsets.SKELETON_OFFSET));
                break;
            }
            case 17: 
            case 18: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.LOWER_LEG), -this.getOffset(SkeletonConfigOffsets.FOOT_SHIFT));
                break;
            }
            case 19: 
            case 20: {
                this.setNodeOffset(nodeOffset, 0.0f, 0.0f, -this.getOffset(SkeletonConfigOffsets.FOOT_LENGTH));
                break;
            }
            case 21: {
                this.setNodeOffset(nodeOffset, 0.0f, 0.0f, 0.0f);
                break;
            }
            case 22: {
                this.setNodeOffset(nodeOffset, 0.0f, 0.0f, 0.0f);
                break;
            }
            case 23: {
                this.setNodeOffset(nodeOffset, -this.getOffset(SkeletonConfigOffsets.SHOULDERS_WIDTH) / 2.0f, -this.getOffset(SkeletonConfigOffsets.SHOULDERS_DISTANCE), 0.0f);
                break;
            }
            case 24: {
                this.setNodeOffset(nodeOffset, this.getOffset(SkeletonConfigOffsets.SHOULDERS_WIDTH) / 2.0f, -this.getOffset(SkeletonConfigOffsets.SHOULDERS_DISTANCE), 0.0f);
                break;
            }
            case 25: 
            case 26: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.UPPER_ARM), 0.0f);
                break;
            }
            case 27: 
            case 28: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.LOWER_ARM), 0.0f);
                break;
            }
            case 29: 
            case 30: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.HAND_Y), -this.getOffset(SkeletonConfigOffsets.HAND_Z));
                break;
            }
            case 31: 
            case 32: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.ELBOW_OFFSET), 0.0f);
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.HAND_Y) * 0.2f, -this.getOffset(SkeletonConfigOffsets.HAND_Y) * 0.1f);
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.HAND_Y) * 0.25f, 0.0f);
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.HAND_Y) * 0.3f, 0.0f);
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.HAND_Y) * 0.28f, 0.0f);
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.setNodeOffset(nodeOffset, 0.0f, -this.getOffset(SkeletonConfigOffsets.HAND_Y) * 0.2f, 0.0f);
            }
        }
    }

    public final void computeAllNodeOffsets() {
        Iterator<BoneType> iterator2 = ArrayIteratorKt.iterator(BoneType.values);
        while (iterator2.hasNext()) {
            BoneType offset = iterator2.next();
            Intrinsics.checkNotNull((Object)offset);
            this.computeNodeOffset(offset);
        }
    }

    public final void setOffsets(@Nullable Map<SkeletonConfigOffsets, Float> configOffsets, boolean computeOffsets) {
        Map<SkeletonConfigOffsets, Float> map = configOffsets;
        if (map != null) {
            Map<SkeletonConfigOffsets, Float> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<SkeletonConfigOffsets, Float>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<SkeletonConfigOffsets, Float> element$iv;
                Map.Entry<SkeletonConfigOffsets, Float> entry = element$iv = iterator2.next();
                boolean bl = false;
                SkeletonConfigOffsets key2 = entry.getKey();
                float value = ((Number)entry.getValue()).floatValue();
                this.setOffset(key2, Float.valueOf(value), false);
            }
        }
        if (computeOffsets && this.autoUpdateOffsets) {
            this.computeAllNodeOffsets();
        }
    }

    public final void setOffsets(@Nullable Map<SkeletonConfigOffsets, Float> configOffsets) {
        this.setOffsets(configOffsets, true);
    }

    public final void setOffsets(@NotNull SkeletonConfigManager skeletonConfigManager) {
        Intrinsics.checkNotNullParameter(skeletonConfigManager, "skeletonConfigManager");
        this.setOffsets((Map<SkeletonConfigOffsets, Float>)skeletonConfigManager.configOffsets, false);
        Map $this$forEach$iv = skeletonConfigManager.nodeOffsets;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, "component1(...)");
            BoneType key2 = (BoneType)((Object)k);
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "component2(...)");
            Vector3 value = (Vector3)v;
            this.setNodeOffset(key2, value.unbox-impl-x(), value.unbox-impl-y(), value.unbox-impl-z());
        }
    }

    public final void resetOffsets() {
        if (this.humanPoseManager != null) {
            Iterator<SkeletonConfigOffsets> iterator2 = ArrayIteratorKt.iterator(SkeletonConfigOffsets.values);
            while (iterator2.hasNext()) {
                SkeletonConfigOffsets config = iterator2.next();
                Intrinsics.checkNotNull((Object)config);
                this.resetOffset(config);
            }
        } else {
            this.configOffsets.clear();
            if (this.autoUpdateOffsets) {
                this.computeAllNodeOffsets();
            }
        }
    }

    public final void resetToggles() {
        Iterator<SkeletonConfigToggles> iterator2;
        this.configToggles.clear();
        if (this.humanPoseManager != null) {
            iterator2 = ArrayIteratorKt.iterator(SkeletonConfigToggles.values);
            while (iterator2.hasNext()) {
                SkeletonConfigToggles config = iterator2.next();
                Intrinsics.checkNotNull((Object)config);
                this.humanPoseManager.updateToggleState(config, config.defaultValue);
            }
        }
        Arrays.fill(this.changedToggles, false);
        if (VRServer.Companion.getInstanceInitialized()) {
            iterator2 = ArrayIteratorKt.iterator(SkeletonConfigToggles.values);
            while (iterator2.hasNext()) {
                SkeletonConfigToggles value = iterator2.next();
                VRServer.Companion.getInstance().configManager.getVrConfig().getSkeleton().getToggles().remove(value.configKey);
            }
        }
    }

    public final void resetValues() {
        Iterator<SkeletonConfigValues> iterator2;
        this.configValues.clear();
        if (this.humanPoseManager != null) {
            iterator2 = ArrayIteratorKt.iterator(SkeletonConfigValues.values);
            while (iterator2.hasNext()) {
                SkeletonConfigValues config = iterator2.next();
                Intrinsics.checkNotNull((Object)config);
                this.humanPoseManager.updateValueState(config, config.defaultValue);
            }
        }
        Arrays.fill(this.changedValues, false);
        if (VRServer.Companion.getInstanceInitialized()) {
            iterator2 = ArrayIteratorKt.iterator(SkeletonConfigValues.values);
            while (iterator2.hasNext()) {
                SkeletonConfigValues value = iterator2.next();
                VRServer.Companion.getInstance().configManager.getVrConfig().getSkeleton().getValues().remove(value.configKey);
            }
        }
    }

    public final void resetAllConfigs() {
        this.resetOffsets();
        this.resetToggles();
        this.resetValues();
    }

    public final void resetOffset(@NotNull SkeletonConfigOffsets config) {
        Intrinsics.checkNotNullParameter((Object)config, "config");
        switch (WhenMappings.$EnumSwitchMapping$1[config.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                float height;
                Object object = this.humanPoseManager;
                float f = object != null && (object = ((HumanPoseManager)object).getServer()) != null && (object = ((VRServer)object).configManager) != null && (object = ((ConfigManager)object).getVrConfig()) != null && (object = ((VRConfig)object).getSkeleton()) != null ? ((SkeletonConfig)object).getUserHeight() : (height = -1.0f);
                if (height > 0.4f) {
                    ProportionLimiter proportionLimiter = BodyProportionError.Companion.getProportionLimitMap().get((Object)config);
                    if (proportionLimiter != null) {
                        this.setOffset(config, Float.valueOf(height * proportionLimiter.getTargetRatio()));
                        break;
                    }
                    this.setOffset(config, null);
                    break;
                }
                this.setOffset(config, null);
                break;
            }
            default: {
                this.setOffset(config, null);
            }
        }
    }

    public final void loadFromConfig(@NotNull ConfigManager configManager) {
        Object configValue;
        Intrinsics.checkNotNullParameter(configManager, "configManager");
        SkeletonConfig skeletonConfig = configManager.getVrConfig().getSkeleton();
        Map<String, Float> offsets = skeletonConfig.getOffsets();
        Iterator<SkeletonConfigOffsets> iterator2 = ArrayIteratorKt.iterator(SkeletonConfigOffsets.values);
        while (iterator2.hasNext()) {
            configValue = iterator2.next();
            Float offset = offsets.get(((SkeletonConfigOffsets)((Object)configValue)).configKey);
            if (offset == null) continue;
            Intrinsics.checkNotNull(configValue);
            this.setOffset((SkeletonConfigOffsets)((Object)configValue), offset, false);
        }
        Map<String, Boolean> toggles = skeletonConfig.getToggles();
        configValue = ArrayIteratorKt.iterator(SkeletonConfigToggles.values);
        while (configValue.hasNext()) {
            SkeletonConfigToggles configValue2 = (SkeletonConfigToggles)((Object)configValue.next());
            Boolean toggle = toggles.get(configValue2.configKey);
            if (toggle != null) {
                Intrinsics.checkNotNull((Object)configValue2);
                this.setToggle(configValue2, toggle);
                continue;
            }
            HumanPoseManager humanPoseManager = this.humanPoseManager;
            if (humanPoseManager == null) continue;
            Intrinsics.checkNotNull((Object)configValue2);
            humanPoseManager.updateToggleState(configValue2, configValue2.defaultValue);
        }
        Map<String, Float> values2 = skeletonConfig.getValues();
        Iterator<SkeletonConfigValues> iterator3 = ArrayIteratorKt.iterator(SkeletonConfigValues.values);
        while (iterator3.hasNext()) {
            SkeletonConfigValues configValue3 = iterator3.next();
            Float value = values2.get(configValue3.configKey);
            if (value != null) {
                Intrinsics.checkNotNull((Object)configValue3);
                this.setValue(configValue3, value);
                continue;
            }
            HumanPoseManager humanPoseManager = this.humanPoseManager;
            if (humanPoseManager == null) continue;
            Intrinsics.checkNotNull((Object)configValue3);
            humanPoseManager.updateValueState(configValue3, configValue3.defaultValue);
        }
        if (this.autoUpdateOffsets) {
            this.computeAllNodeOffsets();
        }
    }

    public final void save() {
        Map<String, Constable> map;
        Constable constable;
        String string;
        Enum value;
        if (!VRServer.Companion.getInstanceInitialized()) {
            boolean bl = false;
            String string2 = "VRServer instance is not initialized, config cannot be saved.";
            throw new IllegalArgumentException(string2.toString());
        }
        SkeletonConfig skeletonConfig = VRServer.Companion.getInstance().configManager.getVrConfig().getSkeleton();
        Iterator<Enum> iterator2 = ArrayIteratorKt.iterator(SkeletonConfigOffsets.values);
        while (iterator2.hasNext()) {
            value = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(skeletonConfig.getOffsets(), "getOffsets(...)");
            string = ((SkeletonConfigOffsets)value).configKey;
            constable = Float.valueOf(this.getOffset((SkeletonConfigOffsets)value));
            map.put(string, constable);
        }
        iterator2 = ArrayIteratorKt.iterator(SkeletonConfigToggles.values);
        while (iterator2.hasNext()) {
            value = (SkeletonConfigToggles)iterator2.next();
            if (!this.changedToggles[value.ordinal()]) continue;
            Intrinsics.checkNotNullExpressionValue(skeletonConfig.getToggles(), "getToggles(...)");
            string = ((SkeletonConfigToggles)value).configKey;
            constable = Boolean.valueOf(this.getToggle((SkeletonConfigToggles)value));
            map.put(string, constable);
        }
        iterator2 = ArrayIteratorKt.iterator(SkeletonConfigValues.values);
        while (iterator2.hasNext()) {
            value = (SkeletonConfigValues)iterator2.next();
            if (!this.changedValues[value.ordinal()]) continue;
            Intrinsics.checkNotNullExpressionValue(skeletonConfig.getValues(), "getValues(...)");
            string = ((SkeletonConfigValues)value).configKey;
            constable = Float.valueOf(this.getValue((SkeletonConfigValues)value));
            map.put(string, constable);
        }
    }

    static {
        SkeletonConfigOffsets[] skeletonConfigOffsetsArray = new SkeletonConfigOffsets[]{SkeletonConfigOffsets.NECK, SkeletonConfigOffsets.UPPER_CHEST, SkeletonConfigOffsets.CHEST, SkeletonConfigOffsets.WAIST, SkeletonConfigOffsets.HIP, SkeletonConfigOffsets.UPPER_LEG, SkeletonConfigOffsets.LOWER_LEG};
        HEIGHT_OFFSETS = skeletonConfigOffsetsArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/slimevr/tracking/processor/config/SkeletonConfigManager$Companion;", "", "<init>", "()V", "HEIGHT_OFFSETS", "", "Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "getHEIGHT_OFFSETS", "()[Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "[Ldev/slimevr/tracking/processor/config/SkeletonConfigOffsets;", "FLOOR_OFFSET", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SkeletonConfigOffsets[] getHEIGHT_OFFSETS() {
            return HEIGHT_OFFSETS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[BoneType.values().length];
            try {
                nArray[BoneType.HEAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.NECK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.UPPER_CHEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.CHEST_TRACKER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.CHEST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.WAIST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.HIP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.HIP_TRACKER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_HIP.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_HIP.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_UPPER_LEG.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_UPPER_LEG.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_KNEE_TRACKER.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_KNEE_TRACKER.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_FOOT_TRACKER.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_FOOT_TRACKER.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_LOWER_LEG.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_LOWER_LEG.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_FOOT.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_FOOT.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_UPPER_SHOULDER.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_UPPER_SHOULDER.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_SHOULDER.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_SHOULDER.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_UPPER_ARM.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_UPPER_ARM.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_LOWER_ARM.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_LOWER_ARM.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_HAND.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_HAND.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_ELBOW_TRACKER.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_ELBOW_TRACKER.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_THUMB_METACARPAL.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_THUMB_PROXIMAL.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_THUMB_DISTAL.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_THUMB_METACARPAL.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_THUMB_PROXIMAL.ordinal()] = 37;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_THUMB_DISTAL.ordinal()] = 38;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_INDEX_PROXIMAL.ordinal()] = 39;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_INDEX_INTERMEDIATE.ordinal()] = 40;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_INDEX_DISTAL.ordinal()] = 41;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_INDEX_PROXIMAL.ordinal()] = 42;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_INDEX_INTERMEDIATE.ordinal()] = 43;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_INDEX_DISTAL.ordinal()] = 44;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_MIDDLE_PROXIMAL.ordinal()] = 45;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_MIDDLE_INTERMEDIATE.ordinal()] = 46;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_MIDDLE_DISTAL.ordinal()] = 47;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_MIDDLE_PROXIMAL.ordinal()] = 48;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_MIDDLE_INTERMEDIATE.ordinal()] = 49;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_MIDDLE_DISTAL.ordinal()] = 50;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_RING_PROXIMAL.ordinal()] = 51;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_RING_INTERMEDIATE.ordinal()] = 52;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_RING_DISTAL.ordinal()] = 53;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_RING_PROXIMAL.ordinal()] = 54;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_RING_INTERMEDIATE.ordinal()] = 55;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_RING_DISTAL.ordinal()] = 56;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_LITTLE_PROXIMAL.ordinal()] = 57;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_LITTLE_INTERMEDIATE.ordinal()] = 58;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.LEFT_LITTLE_DISTAL.ordinal()] = 59;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_LITTLE_PROXIMAL.ordinal()] = 60;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_LITTLE_INTERMEDIATE.ordinal()] = 61;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoneType.RIGHT_LITTLE_DISTAL.ordinal()] = 62;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SkeletonConfigOffsets.values().length];
            try {
                nArray[SkeletonConfigOffsets.UPPER_ARM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkeletonConfigOffsets.LOWER_ARM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkeletonConfigOffsets.UPPER_CHEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkeletonConfigOffsets.CHEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkeletonConfigOffsets.WAIST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkeletonConfigOffsets.HIP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkeletonConfigOffsets.UPPER_LEG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkeletonConfigOffsets.LOWER_LEG.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

