/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.processor.skeleton;

import dev.slimevr.tracking.processor.skeleton.HumanSkeleton;
import dev.slimevr.tracking.trackers.Tracker;
import io.github.axisangles.ktmath.Vector3;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 +2\u00020\u0001:\u0001+B\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001d\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010!\u001a\u00020\u001fJ\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0015J\u0006\u0010$\u001a\u00020\u001fJ\u0010\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u0007H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0019R\u0014\u0010'\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0019\u00a8\u0006,"}, d2={"Ldev/slimevr/tracking/processor/skeleton/TapDetection;", "", "skeleton", "Ldev/slimevr/tracking/processor/skeleton/HumanSkeleton;", "<init>", "(Ldev/slimevr/tracking/processor/skeleton/HumanSkeleton;)V", "trackerToWatch", "Ldev/slimevr/tracking/trackers/Tracker;", "(Ldev/slimevr/tracking/processor/skeleton/HumanSkeleton;Ldev/slimevr/tracking/trackers/Tracker;)V", "enabled", "", "accelList", "Ljava/util/LinkedList;", "", "tapTimes", "", "value", "tracker", "getTracker", "()Ldev/slimevr/tracking/trackers/Tracker;", "numberTrackersOverThreshold", "", "timeWindowNS", "detectionTime", "getDetectionTime", "()F", "taps", "getTaps", "()I", "waitForLowAccel", "setTrackerToWatch", "", "setNumberTrackersOverThreshold", "resetDetector", "setMaxTaps", "maxTaps", "update", "accelDelta", "getAccelDelta", "maxAccel", "getMaxAccel", "isUserStatic", "trackerToExclude", "Companion", "core"})
public final class TapDetection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final HumanSkeleton skeleton;
    @JvmField
    public boolean enabled;
    @NotNull
    private final LinkedList<float[]> accelList = new LinkedList();
    @NotNull
    private final LinkedList<Float> tapTimes = new LinkedList();
    @Nullable
    private Tracker tracker;
    private int numberTrackersOverThreshold = 1;
    private float timeWindowNS = 6.0E8f;
    private float detectionTime = -1.0f;
    private int taps;
    private boolean waitForLowAccel;
    private static final float NS_CONVERTER = 1.0E9f;
    private static final float NEEDED_ACCEL_DELTA = 6.0f;
    private static final float ALLOWED_BODY_ACCEL = 2.5f;
    private static final float ALLOWED_BODY_ACCEL_SQUARED = 6.25f;
    private static final float CLUMP_TIME_NS = 6.0E7f;

    @Nullable
    public final Tracker getTracker() {
        return this.tracker;
    }

    public final float getDetectionTime() {
        return this.detectionTime;
    }

    public final int getTaps() {
        return this.taps;
    }

    public TapDetection(@Nullable HumanSkeleton skeleton) {
        this.skeleton = skeleton;
    }

    public TapDetection(@Nullable HumanSkeleton skeleton, @Nullable Tracker trackerToWatch) {
        this.skeleton = skeleton;
        this.tracker = trackerToWatch;
    }

    public final void setTrackerToWatch(@Nullable Tracker tracker) {
        this.tracker = tracker;
    }

    public final void setNumberTrackersOverThreshold(int numberTrackersOverThreshold) {
        this.numberTrackersOverThreshold = numberTrackersOverThreshold;
    }

    public final void resetDetector() {
        this.tapTimes.clear();
        this.accelList.clear();
        this.taps = 0;
    }

    public final void setMaxTaps(int maxTaps) {
        this.timeWindowNS = 0.3f * (float)maxTaps * 1.0E9f;
    }

    public final void update() {
        int newTaps;
        if (this.skeleton == null || !this.enabled) {
            return;
        }
        if (this.tracker == null) {
            return;
        }
        float time = System.nanoTime();
        float[] fArray = new float[2];
        Tracker tracker = this.tracker;
        Intrinsics.checkNotNull(tracker);
        Vector3 vector3 = tracker.getAcceleration();
        fArray[0] = Vector3.len-impl(vector3.unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z());
        fArray[1] = time;
        float[] listval = fArray;
        this.accelList.add(listval);
        while (time - ((float[])CollectionsKt.first((List)this.accelList))[1] > 6.0E7f) {
            this.accelList.removeFirst();
        }
        float accelDelta = this.getAccelDelta();
        if (accelDelta > 6.0f && !this.waitForLowAccel) {
            this.tapTimes.add(Float.valueOf(time));
            this.waitForLowAccel = true;
        }
        if (this.getMaxAccel() < 2.5f) {
            this.waitForLowAccel = false;
        }
        if (!this.tapTimes.isEmpty()) {
            while (time - ((Number)CollectionsKt.first((List)this.tapTimes)).floatValue() > this.timeWindowNS) {
                this.tapTimes.removeFirst();
                if (!this.tapTimes.isEmpty()) continue;
                return;
            }
        }
        Tracker tracker2 = this.tracker;
        Intrinsics.checkNotNull(tracker2);
        if (!this.isUserStatic(tracker2)) {
            this.tapTimes.clear();
            this.accelList.clear();
        }
        if ((newTaps = this.tapTimes.size()) > this.taps) {
            this.taps = newTaps;
            this.detectionTime = time;
        }
    }

    private final float getAccelDelta() {
        float max = -999.9f;
        float min = 999.9f;
        Iterator iterator2 = this.accelList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            float[] val = (float[])e;
            if (val[0] > max) {
                max = val[0];
            }
            if (!(val[0] < min)) continue;
            min = val[0];
        }
        return max - min;
    }

    private final float getMaxAccel() {
        float max = 0.0f;
        Iterator iterator2 = this.accelList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            float[] val = (float[])e;
            if (!(val[0] > max)) continue;
            max = val[0];
        }
        return max;
    }

    private final boolean isUserStatic(Tracker trackerToExclude) {
        Vector3 vector3;
        int num = 0;
        HumanSkeleton humanSkeleton = this.skeleton;
        Intrinsics.checkNotNull(humanSkeleton);
        if (humanSkeleton.getUpperChestTracker() != null && !Intrinsics.areEqual(this.skeleton.getUpperChestTracker(), trackerToExclude)) {
            Tracker tracker = this.skeleton.getUpperChestTracker();
            Intrinsics.checkNotNull(tracker);
            vector3 = tracker.getAcceleration();
            if (Vector3.lenSq-impl(vector3.unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z()) > 6.25f) {
                ++num;
            }
        }
        if (this.skeleton.getChestTracker() != null && !Intrinsics.areEqual(this.skeleton.getChestTracker(), trackerToExclude)) {
            Tracker tracker = this.skeleton.getChestTracker();
            Intrinsics.checkNotNull(tracker);
            vector3 = tracker.getAcceleration();
            if (Vector3.lenSq-impl(vector3.unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z()) > 6.25f) {
                ++num;
            }
        }
        if (this.skeleton.getHipTracker() != null && !Intrinsics.areEqual(this.skeleton.getHipTracker(), trackerToExclude)) {
            Tracker tracker = this.skeleton.getHipTracker();
            Intrinsics.checkNotNull(tracker);
            vector3 = tracker.getAcceleration();
            if (Vector3.lenSq-impl(vector3.unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z()) > 6.25f) {
                ++num;
            }
        }
        if (this.skeleton.getWaistTracker() != null && !Intrinsics.areEqual(this.skeleton.getWaistTracker(), trackerToExclude)) {
            Tracker tracker = this.skeleton.getWaistTracker();
            Intrinsics.checkNotNull(tracker);
            vector3 = tracker.getAcceleration();
            if (Vector3.lenSq-impl(vector3.unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z()) > 6.25f) {
                ++num;
            }
        }
        if (this.skeleton.getLeftUpperLegTracker() != null && !Intrinsics.areEqual(this.skeleton.getLeftUpperLegTracker(), trackerToExclude)) {
            Tracker tracker = this.skeleton.getLeftUpperLegTracker();
            Intrinsics.checkNotNull(tracker);
            vector3 = tracker.getAcceleration();
            if (Vector3.lenSq-impl(vector3.unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z()) > 6.25f) {
                ++num;
            }
        }
        if (this.skeleton.getRightUpperLegTracker() != null && !Intrinsics.areEqual(this.skeleton.getRightUpperLegTracker(), trackerToExclude)) {
            Tracker tracker = this.skeleton.getRightUpperLegTracker();
            Intrinsics.checkNotNull(tracker);
            vector3 = tracker.getAcceleration();
            if (Vector3.lenSq-impl(vector3.unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z()) > 6.25f) {
                ++num;
            }
        }
        if (this.skeleton.getLeftFootTracker() != null && !Intrinsics.areEqual(this.skeleton.getLeftFootTracker(), trackerToExclude)) {
            Tracker tracker = this.skeleton.getLeftFootTracker();
            Intrinsics.checkNotNull(tracker);
            vector3 = tracker.getAcceleration();
            if (Vector3.lenSq-impl(vector3.unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z()) > 6.25f) {
                ++num;
            }
        }
        if (this.skeleton.getRightFootTracker() != null && !Intrinsics.areEqual(this.skeleton.getRightFootTracker(), trackerToExclude)) {
            Tracker tracker = this.skeleton.getRightFootTracker();
            Intrinsics.checkNotNull(tracker);
            vector3 = tracker.getAcceleration();
            if (Vector3.lenSq-impl(vector3.unbox-impl-x(), vector3.unbox-impl-y(), vector3.unbox-impl-z()) > 6.25f) {
                ++num;
            }
        }
        return num < this.numberTrackersOverThreshold;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/slimevr/tracking/processor/skeleton/TapDetection$Companion;", "", "<init>", "()V", "NS_CONVERTER", "", "NEEDED_ACCEL_DELTA", "ALLOWED_BODY_ACCEL", "ALLOWED_BODY_ACCEL_SQUARED", "CLUMP_TIME_NS", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

