/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.processor.skeleton;

import dev.slimevr.VRServer;
import dev.slimevr.config.TapDetectionConfig;
import dev.slimevr.reset.ResetHandler;
import dev.slimevr.setup.TapSetupHandler;
import dev.slimevr.tracking.processor.HumanPoseManager;
import dev.slimevr.tracking.processor.skeleton.HumanSkeleton;
import dev.slimevr.tracking.processor.skeleton.TapDetection;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerUtils;
import java.util.ArrayList;
import java.util.List;

public class TapDetectionManager {
    private static final String resetSourceName = "TapDetection";
    private static final int tapsForSetupMode = 2;
    private final HumanSkeleton skeleton;
    private HumanPoseManager humanPoseManager;
    private TapDetectionConfig config;
    private TapDetection yawResetDetector;
    private TapDetection fullResetDetector;
    private TapDetection mountingResetDetector;
    private ArrayList<TapDetection> tapDetectors;
    private int yawResetTaps = 2;
    private int fullResetTaps = 3;
    private int mountingResetTaps = 3;
    private static final float NS_CONVERTER = 1.0E9f;
    private float fullResetDelayNs = 2.0E8f;
    private float yawResetDelayNs = 1.0E9f;
    private float mountingResetDelayNs = 1.0E9f;
    private boolean yawResetAllowPlaySound = true;
    private boolean fullResetAllowPlaySound = true;
    private boolean mountingResetAllowPlaySound = true;
    private ResetHandler resetHandler;
    private TapSetupHandler tapSetupHandler;

    public TapDetectionManager(HumanSkeleton skeleton) {
        this.skeleton = skeleton;
    }

    public TapDetectionManager(HumanSkeleton skeleton, HumanPoseManager humanPoseManager, TapDetectionConfig config, ResetHandler resetHandler, TapSetupHandler tapSetupHandler, List<Tracker> trackers) {
        this.skeleton = skeleton;
        this.humanPoseManager = humanPoseManager;
        this.config = config;
        this.resetHandler = resetHandler;
        this.tapSetupHandler = tapSetupHandler;
        this.updateConfig(trackers);
    }

    public void updateConfig(List<Tracker> trackers) {
        this.yawResetDetector = new TapDetection(this.skeleton, this.getTrackerToWatchYawReset());
        this.fullResetDetector = new TapDetection(this.skeleton, this.getTrackerToWatchFullReset());
        this.mountingResetDetector = new TapDetection(this.skeleton, this.getTrackerToWatchMountingReset());
        if (trackers != null) {
            this.tapDetectors = new ArrayList();
            for (Tracker tracker : trackers) {
                TapDetection tapDetector = new TapDetection(this.skeleton, tracker);
                tapDetector.enabled = true;
                this.tapDetectors.add(tapDetector);
            }
        }
        if (this.config == null) {
            return;
        }
        this.yawResetDelayNs = this.config.getYawResetDelay() * 1.0E9f;
        this.fullResetDelayNs = this.config.getFullResetDelay() * 1.0E9f;
        this.mountingResetDelayNs = this.config.getMountingResetDelay() * 1.0E9f;
        this.yawResetDetector.enabled = this.config.getYawResetEnabled();
        this.fullResetDetector.enabled = this.config.getFullResetEnabled();
        this.mountingResetDetector.enabled = this.config.getMountingResetEnabled();
        this.yawResetTaps = this.config.getYawResetTaps();
        this.fullResetTaps = this.config.getFullResetTaps();
        this.mountingResetTaps = this.config.getMountingResetTaps();
        this.yawResetDetector.setMaxTaps(this.yawResetTaps);
        this.fullResetDetector.setMaxTaps(this.fullResetTaps);
        this.mountingResetDetector.setMaxTaps(this.mountingResetTaps);
        this.yawResetDetector.setNumberTrackersOverThreshold(this.config.getNumberTrackersOverThreshold());
        this.fullResetDetector.setNumberTrackersOverThreshold(this.config.getNumberTrackersOverThreshold());
        this.mountingResetDetector.setNumberTrackersOverThreshold(this.config.getNumberTrackersOverThreshold());
    }

    public void update() {
        if (this.yawResetDetector == null || this.fullResetDetector == null || this.mountingResetDetector == null || this.tapDetectors == null || this.config == null) {
            return;
        }
        if (this.config.getSetupMode()) {
            for (TapDetection tapDetector : this.tapDetectors) {
                tapDetector.update();
                if (tapDetector.getTaps() < 2) continue;
                this.tapSetupHandler.sendTap(tapDetector.getTracker());
                tapDetector.resetDetector();
            }
        } else {
            this.yawResetDetector.update();
            this.fullResetDetector.update();
            this.mountingResetDetector.update();
            this.checkYawReset();
            this.checkFullReset();
            this.checkMountingReset();
        }
    }

    private void checkYawReset() {
        boolean tapped;
        boolean bl = tapped = this.yawResetTaps <= this.yawResetDetector.getTaps();
        if (tapped && this.yawResetAllowPlaySound) {
            this.resetHandler.sendStarted(0);
            this.yawResetAllowPlaySound = false;
        }
        if (tapped && (float)System.nanoTime() - this.yawResetDetector.getDetectionTime() > this.yawResetDelayNs) {
            if (this.humanPoseManager != null) {
                this.humanPoseManager.resetTrackersYaw(resetSourceName);
            } else {
                this.skeleton.resetTrackersYaw(resetSourceName);
            }
            this.yawResetDetector.resetDetector();
            this.yawResetAllowPlaySound = true;
            this.resetHandler.sendFinished(0);
        }
    }

    private void checkFullReset() {
        boolean tapped;
        boolean bl = tapped = this.fullResetTaps <= this.fullResetDetector.getTaps();
        if (tapped && this.fullResetAllowPlaySound) {
            this.resetHandler.sendStarted(1);
            this.fullResetAllowPlaySound = false;
        }
        if (tapped && (float)System.nanoTime() - this.fullResetDetector.getDetectionTime() > this.fullResetDelayNs) {
            if (this.humanPoseManager != null) {
                this.humanPoseManager.resetTrackersFull(resetSourceName);
            } else {
                this.skeleton.resetTrackersFull(resetSourceName);
            }
            this.fullResetDetector.resetDetector();
            this.fullResetAllowPlaySound = true;
            this.resetHandler.sendFinished(1);
        }
    }

    private void checkMountingReset() {
        boolean tapped;
        VRServer server = this.humanPoseManager.getServer();
        if (server != null && server.statusSystem.hasStatusType((byte)1)) {
            this.mountingResetDetector.resetDetector();
            return;
        }
        boolean bl = tapped = this.mountingResetTaps <= this.mountingResetDetector.getTaps();
        if (tapped && this.mountingResetAllowPlaySound) {
            this.resetHandler.sendStarted(2);
            this.mountingResetAllowPlaySound = false;
        }
        if (tapped && (float)System.nanoTime() - this.mountingResetDetector.getDetectionTime() > this.mountingResetDelayNs) {
            this.skeleton.resetTrackersMounting(resetSourceName, TrackerUtils.INSTANCE.getAllBodyPartsButFingers());
            this.mountingResetDetector.resetDetector();
            this.mountingResetAllowPlaySound = true;
            this.resetHandler.sendFinished(2);
        }
    }

    private Tracker getTrackerToWatchYawReset() {
        if (this.skeleton.getUpperChestTracker() != null) {
            return this.skeleton.getUpperChestTracker();
        }
        if (this.skeleton.getChestTracker() != null) {
            return this.skeleton.getChestTracker();
        }
        if (this.skeleton.getHipTracker() != null) {
            return this.skeleton.getHipTracker();
        }
        if (this.skeleton.getWaistTracker() != null) {
            return this.skeleton.getWaistTracker();
        }
        return null;
    }

    private Tracker getTrackerToWatchFullReset() {
        if (this.skeleton.getLeftUpperLegTracker() != null) {
            return this.skeleton.getLeftUpperLegTracker();
        }
        if (this.skeleton.getLeftLowerLegTracker() != null) {
            return this.skeleton.getLeftLowerLegTracker();
        }
        return null;
    }

    private Tracker getTrackerToWatchMountingReset() {
        if (this.skeleton.getRightUpperLegTracker() != null) {
            return this.skeleton.getRightUpperLegTracker();
        }
        if (this.skeleton.getRightLowerLegTracker() != null) {
            return this.skeleton.getRightLowerLegTracker();
        }
        return null;
    }
}

