/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.processor.stayaligned;

import dev.slimevr.VRServer;
import dev.slimevr.config.StayAlignedConfig;
import dev.slimevr.math.Angle;
import dev.slimevr.tracking.processor.stayaligned.StayAlignedDefaults;
import dev.slimevr.tracking.processor.stayaligned.adjust.AdjustTrackerYaw;
import dev.slimevr.tracking.processor.stayaligned.trackers.TrackerSkeleton;
import dev.slimevr.tracking.trackers.Tracker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/slimevr/tracking/processor/stayaligned/StayAligned;", "", "<init>", "()V", "nextTrackerIndex", "", "adjustNextTracker", "", "trackers", "Ldev/slimevr/tracking/processor/stayaligned/trackers/TrackerSkeleton;", "config", "Ldev/slimevr/config/StayAlignedConfig;", "core"})
public final class StayAligned {
    @NotNull
    public static final StayAligned INSTANCE = new StayAligned();
    private static int nextTrackerIndex;

    private StayAligned() {
    }

    public final void adjustNextTracker(@NotNull TrackerSkeleton trackers, @NotNull StayAlignedConfig config) {
        Intrinsics.checkNotNullParameter(trackers, "trackers");
        Intrinsics.checkNotNullParameter(config, "config");
        if (!config.getEnabled()) {
            return;
        }
        int numTrackers = trackers.getAllTrackers().size();
        if (numTrackers == 0) {
            return;
        }
        Tracker trackerToAdjust = trackers.getAllTrackers().get(nextTrackerIndex % numTrackers);
        ++nextTrackerIndex;
        trackerToAdjust.getStayAligned().setHideCorrection(config.getHideYawCorrection());
        float yawCorrectionPerSec = StayAlignedDefaults.INSTANCE.getIMU_TO_YAW_CORRECTION().getOrDefault((Object)trackerToAdjust.getImuType(), Angle.box-impl(StayAlignedDefaults.INSTANCE.getYAW_CORRECTION_DEFAULT-ncrbCcM())).unbox-impl();
        if (Angle.equals-impl0(yawCorrectionPerSec, Angle.Companion.getZERO-ncrbCcM())) {
            return;
        }
        float yawCorrection = Angle.times-m5kTJmo(Angle.times-m5kTJmo(yawCorrectionPerSec, VRServer.Companion.getInstance().getFpsTimer().getTimePerFrame()), numTrackers);
        AdjustTrackerYaw.INSTANCE.adjust-x35fVSo(trackerToAdjust, trackers, yawCorrection, config);
    }
}

