/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.processor.stayaligned.adjust;

import dev.slimevr.config.StayAlignedConfig;
import dev.slimevr.math.Angle;
import dev.slimevr.tracking.processor.stayaligned.adjust.CenterErrorVisitor;
import dev.slimevr.tracking.processor.stayaligned.adjust.CenterYaw;
import dev.slimevr.tracking.processor.stayaligned.adjust.LockedErrorVisitor;
import dev.slimevr.tracking.processor.stayaligned.adjust.NeighborErrorVisitor;
import dev.slimevr.tracking.processor.stayaligned.poses.PlayerPose;
import dev.slimevr.tracking.processor.stayaligned.poses.RelaxedPose;
import dev.slimevr.tracking.processor.stayaligned.trackers.RestDetector;
import dev.slimevr.tracking.processor.stayaligned.trackers.StayAlignedTrackerState;
import dev.slimevr.tracking.processor.stayaligned.trackers.TrackerSkeleton;
import dev.slimevr.tracking.processor.stayaligned.trackers.YawErrors;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.udp.MagnetometerStatus;
import io.github.axisangles.ktmath.Quaternion;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000fJB\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u001a0\u0017H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b \u0010!\u00a8\u0006\""}, d2={"Ldev/slimevr/tracking/processor/stayaligned/adjust/AdjustTrackerYaw;", "", "<init>", "()V", "adjust", "", "tracker", "Ldev/slimevr/tracking/trackers/Tracker;", "trackers", "Ldev/slimevr/tracking/processor/stayaligned/trackers/TrackerSkeleton;", "yawCorrection", "Ldev/slimevr/math/Angle;", "config", "Ldev/slimevr/config/StayAlignedConfig;", "adjust-x35fVSo", "(Ldev/slimevr/tracking/trackers/Tracker;Ldev/slimevr/tracking/processor/stayaligned/trackers/TrackerSkeleton;FLdev/slimevr/config/StayAlignedConfig;)V", "adjustLockedTracker", "adjustLockedTracker-6izB1p8", "(Ldev/slimevr/tracking/trackers/Tracker;Ldev/slimevr/tracking/processor/stayaligned/trackers/TrackerSkeleton;F)V", "adjustMovingTracker", "adjustMovingTracker-x35fVSo", "adjustByError", "errorFn", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Ldev/slimevr/tracking/processor/stayaligned/trackers/YawErrors;", "adjustByError-uUe8KvI", "(Ldev/slimevr/tracking/trackers/Tracker;FLkotlin/jvm/functions/Function1;)V", "gradient", "errors", "base", "gradient-A83Pbzk", "(Ldev/slimevr/tracking/processor/stayaligned/trackers/YawErrors;Ldev/slimevr/tracking/processor/stayaligned/trackers/YawErrors;)F", "core"})
public final class AdjustTrackerYaw {
    @NotNull
    public static final AdjustTrackerYaw INSTANCE = new AdjustTrackerYaw();

    private AdjustTrackerYaw() {
    }

    public final void adjust-x35fVSo(@NotNull Tracker tracker, @NotNull TrackerSkeleton trackers, float yawCorrection, @NotNull StayAlignedConfig config) {
        Intrinsics.checkNotNullParameter(tracker, "tracker");
        Intrinsics.checkNotNullParameter(trackers, "trackers");
        Intrinsics.checkNotNullParameter(config, "config");
        if (!tracker.isImu()) {
            return;
        }
        if (tracker.getMagStatus() == MagnetometerStatus.ENABLED) {
            return;
        }
        StayAlignedTrackerState state = tracker.getStayAligned();
        state.setYawErrors(new YawErrors());
        RestDetector restDetector = state.getRestDetector();
        switch (WhenMappings.$EnumSwitchMapping$0[restDetector.getState().ordinal()]) {
            case 1: {
                this.adjustMovingTracker-x35fVSo(tracker, trackers, yawCorrection, config);
                break;
            }
            case 2: {
                this.adjustLockedTracker-6izB1p8(tracker, trackers, yawCorrection);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void adjustLockedTracker-6izB1p8(Tracker tracker, TrackerSkeleton trackers, float yawCorrection) {
        Quaternion quaternion = tracker.getStayAligned().getLockedRotation();
        if (quaternion == null) {
            return;
        }
        Quaternion quaternion2 = quaternion;
        float f = quaternion2.unbox-impl-w();
        float f2 = quaternion2.unbox-impl-x();
        float f3 = quaternion2.unbox-impl-y();
        float f4 = quaternion2.unbox-impl-z();
        this.adjustByError-uUe8KvI(tracker, yawCorrection, arg_0 -> AdjustTrackerYaw.adjustLockedTracker_6izB1p8$lambda$1(trackers, tracker, f, f2, f3, f4, arg_0));
    }

    private final void adjustMovingTracker-x35fVSo(Tracker tracker, TrackerSkeleton trackers, float yawCorrection, StayAlignedConfig config) {
        Angle angle = CenterYaw.INSTANCE.ofSkeleton-LWuyBuw(trackers);
        if (angle == null) {
            return;
        }
        float centerYaw = angle.unbox-impl();
        PlayerPose pose = PlayerPose.Companion.ofTrackers(trackers);
        RelaxedPose relaxedPose = RelaxedPose.Companion.forPose(pose, config);
        if (relaxedPose == null) {
            return;
        }
        RelaxedPose relaxedPose2 = relaxedPose;
        this.adjustByError-uUe8KvI(tracker, yawCorrection, arg_0 -> AdjustTrackerYaw.adjustMovingTracker_x35fVSo$lambda$3(trackers, tracker, centerYaw, relaxedPose2, arg_0));
    }

    private final void adjustByError-uUe8KvI(Tracker tracker, float yawCorrection, Function1<? super Tracker, YawErrors> errorFn) {
        StayAlignedTrackerState state = tracker.getStayAligned();
        float curYaw = state.getYawCorrection-ncrbCcM();
        YawErrors curError = errorFn.invoke(tracker);
        float posYaw = Angle.plus-FbPx49Y(curYaw, yawCorrection);
        state.setYawCorrection-oSiUSQg(posYaw);
        YawErrors posError = errorFn.invoke(tracker);
        float negYaw = Angle.minus-FbPx49Y(curYaw, yawCorrection);
        state.setYawCorrection-oSiUSQg(negYaw);
        YawErrors negError = errorFn.invoke(tracker);
        float posYawDelta = this.gradient-A83Pbzk(posError, curError);
        float negYawDelta = this.gradient-A83Pbzk(negError, curError);
        if (Angle.compareTo-oSiUSQg(posYawDelta, Angle.Companion.getZERO-ncrbCcM()) < 0 && Angle.compareTo-oSiUSQg(posYawDelta, negYawDelta) < 0) {
            state.setYawCorrection-oSiUSQg(posYaw);
            state.setYawErrors(posError);
        } else if (Angle.compareTo-oSiUSQg(negYawDelta, Angle.Companion.getZERO-ncrbCcM()) < 0) {
            state.setYawCorrection-oSiUSQg(negYaw);
            state.setYawErrors(negError);
        } else {
            state.setYawCorrection-oSiUSQg(curYaw);
            state.setYawErrors(curError);
        }
    }

    private final float gradient-A83Pbzk(YawErrors errors, YawErrors base) {
        return Angle.plus-FbPx49Y(Angle.plus-FbPx49Y(Angle.times-m5kTJmo(Angle.minus-FbPx49Y(errors.getLockedError().toL2Norm-ncrbCcM(), base.getLockedError().toL2Norm-ncrbCcM()), 10.0f), Angle.times-m5kTJmo(Angle.minus-FbPx49Y(errors.getCenterError().toL2Norm-ncrbCcM(), base.getCenterError().toL2Norm-ncrbCcM()), 2.0f)), Angle.times-m5kTJmo(Angle.minus-FbPx49Y(errors.getNeighborError().toL2Norm-ncrbCcM(), base.getNeighborError().toL2Norm-ncrbCcM()), 1.0f));
    }

    private static final YawErrors adjustLockedTracker_6izB1p8$lambda$1(TrackerSkeleton $trackers, Tracker $tracker, float f, float f2, float f3, float f4, Tracker it) {
        YawErrors yawErrors;
        Intrinsics.checkNotNullParameter(it, "it");
        YawErrors it2 = yawErrors = new YawErrors();
        boolean bl = false;
        $trackers.visit($tracker, new LockedErrorVisitor(f, f2, f3, f4, it2.getLockedError(), null));
        return yawErrors;
    }

    private static final YawErrors adjustMovingTracker_x35fVSo$lambda$3(TrackerSkeleton $trackers, Tracker $tracker, float $centerYaw, RelaxedPose $relaxedPose, Tracker it) {
        YawErrors yawErrors;
        Intrinsics.checkNotNullParameter(it, "it");
        YawErrors it2 = yawErrors = new YawErrors();
        boolean bl = false;
        $trackers.visit($tracker, new CenterErrorVisitor($centerYaw, $relaxedPose, it2.getCenterError(), null));
        $trackers.visit($tracker, new NeighborErrorVisitor($relaxedPose, it2.getNeighborError()));
        return yawErrors;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RestDetector.State.values().length];
            try {
                nArray[RestDetector.State.MOVING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestDetector.State.AT_REST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RestDetector.State.RECENTLY_AT_REST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

