/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.processor.stayaligned.trackers;

import dev.slimevr.math.Angle;
import dev.slimevr.tracking.processor.stayaligned.StayAlignedDefaults;
import dev.slimevr.tracking.processor.stayaligned.trackers.RestDetector;
import dev.slimevr.tracking.processor.stayaligned.trackers.YawErrors;
import dev.slimevr.tracking.trackers.Tracker;
import io.github.axisangles.ktmath.Quaternion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001e\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006("}, d2={"Ldev/slimevr/tracking/processor/stayaligned/trackers/StayAlignedTrackerState;", "", "tracker", "Ldev/slimevr/tracking/trackers/Tracker;", "<init>", "(Ldev/slimevr/tracking/trackers/Tracker;)V", "getTracker", "()Ldev/slimevr/tracking/trackers/Tracker;", "hideCorrection", "", "getHideCorrection", "()Z", "setHideCorrection", "(Z)V", "restDetector", "Ldev/slimevr/tracking/processor/stayaligned/trackers/RestDetector;", "getRestDetector", "()Ldev/slimevr/tracking/processor/stayaligned/trackers/RestDetector;", "lockedRotation", "Lio/github/axisangles/ktmath/Quaternion;", "getLockedRotation", "()Lio/github/axisangles/ktmath/Quaternion;", "setLockedRotation", "(Lio/github/axisangles/ktmath/Quaternion;)V", "yawCorrection", "Ldev/slimevr/math/Angle;", "getYawCorrection-ncrbCcM", "()F", "setYawCorrection-oSiUSQg", "(F)V", "F", "yawErrors", "Ldev/slimevr/tracking/processor/stayaligned/trackers/YawErrors;", "getYawErrors", "()Ldev/slimevr/tracking/processor/stayaligned/trackers/YawErrors;", "setYawErrors", "(Ldev/slimevr/tracking/processor/stayaligned/trackers/YawErrors;)V", "update", "", "reset", "core"})
public final class StayAlignedTrackerState {
    @NotNull
    private final Tracker tracker;
    private boolean hideCorrection;
    @NotNull
    private final RestDetector restDetector;
    @Nullable
    private Quaternion lockedRotation;
    private float yawCorrection;
    @NotNull
    private YawErrors yawErrors;

    public StayAlignedTrackerState(@NotNull Tracker tracker) {
        Intrinsics.checkNotNullParameter(tracker, "tracker");
        this.tracker = tracker;
        this.restDetector = StayAlignedDefaults.INSTANCE.makeRestDetector();
        this.yawCorrection = Angle.Companion.getZERO-ncrbCcM();
        this.yawErrors = new YawErrors();
    }

    @NotNull
    public final Tracker getTracker() {
        return this.tracker;
    }

    public final boolean getHideCorrection() {
        return this.hideCorrection;
    }

    public final void setHideCorrection(boolean bl) {
        this.hideCorrection = bl;
    }

    @NotNull
    public final RestDetector getRestDetector() {
        return this.restDetector;
    }

    @Nullable
    public final Quaternion getLockedRotation() {
        return this.lockedRotation;
    }

    public final void setLockedRotation(@Nullable Quaternion quaternion) {
        this.lockedRotation = quaternion;
    }

    public final float getYawCorrection-ncrbCcM() {
        return this.yawCorrection;
    }

    public final void setYawCorrection-oSiUSQg(float f) {
        this.yawCorrection = f;
    }

    @NotNull
    public final YawErrors getYawErrors() {
        return this.yawErrors;
    }

    public final void setYawErrors(@NotNull YawErrors yawErrors) {
        Intrinsics.checkNotNullParameter(yawErrors, "<set-?>");
        this.yawErrors = yawErrors;
    }

    public final void update() {
        Quaternion quaternion = this.tracker.getRawRotation();
        this.restDetector.update-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
        if (this.restDetector.getState() == RestDetector.State.AT_REST) {
            if (this.lockedRotation == null) {
                this.lockedRotation = this.tracker.getAdjustedRotationForceStayAligned();
            }
        } else {
            this.lockedRotation = null;
        }
    }

    public final void reset() {
        this.restDetector.reset();
        this.lockedRotation = null;
        this.yawCorrection = Angle.Companion.getZERO-ncrbCcM();
        this.yawErrors = new YawErrors();
    }
}

