/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.trackers;

import dev.slimevr.VRServer;
import dev.slimevr.config.ConfigManager;
import dev.slimevr.config.TrackerConfig;
import dev.slimevr.math.Angle;
import dev.slimevr.tracking.processor.stayaligned.trackers.StayAlignedTrackerState;
import dev.slimevr.tracking.trackers.Device;
import dev.slimevr.tracking.trackers.TrackerFilteringHandler;
import dev.slimevr.tracking.trackers.TrackerFlexHandler;
import dev.slimevr.tracking.trackers.TrackerPosition;
import dev.slimevr.tracking.trackers.TrackerResetsHandler;
import dev.slimevr.tracking.trackers.TrackerStatus;
import dev.slimevr.tracking.trackers.udp.IMUType;
import dev.slimevr.tracking.trackers.udp.MagnetometerStatus;
import dev.slimevr.tracking.trackers.udp.TrackerDataType;
import dev.slimevr.util.InterpolationHandler;
import io.eiren.util.BufferedTimer;
import io.github.axisangles.ktmath.ObjectQuaternion;
import io.github.axisangles.ktmath.Quaternion;
import io.github.axisangles.ktmath.Vector3;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solarxr_protocol.datatypes.DeviceIdT;
import solarxr_protocol.datatypes.TrackerIdT;
import solarxr_protocol.rpc.StatusDataUnion;
import solarxr_protocol.rpc.StatusTrackerErrorT;
import solarxr_protocol.rpc.StatusTrackerResetT;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b!\u0018\u00002\u00020\u0001B\u00db\u0001\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u0012\b\b\u0002\u0010\u0010\u001a\u00020\r\u0012\b\b\u0002\u0010\u0011\u001a\u00020\r\u0012\b\b\u0002\u0010\u0012\u001a\u00020\r\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\r\u0012\b\b\u0002\u0010\u0016\u001a\u00020\r\u0012\b\b\u0002\u0010\u0017\u001a\u00020\r\u0012\b\b\u0002\u0010\u0018\u001a\u00020\r\u0012\b\b\u0002\u0010\u0019\u001a\u00020\r\u0012\b\b\u0002\u0010\u001a\u001a\u00020\r\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001J\n\u0010\u00a0\u0001\u001a\u00030\u0099\u0001H\u0002J\n\u0010\u00a1\u0001\u001a\u00030\u0099\u0001H\u0002J\n\u0010\u00a5\u0001\u001a\u00030\u0099\u0001H\u0002J\u0012\u0010\u00a6\u0001\u001a\u00030\u0099\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001J\u0012\u0010\u00a9\u0001\u001a\u00030\u0099\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001J\u0012\u0010\u00aa\u0001\u001a\u00030\u0099\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001J\u0013\u0010\u00aa\u0001\u001a\u00030\u0099\u00012\t\u0010\u00ab\u0001\u001a\u0004\u0018\u00010;J\u0011\u0010\u00ac\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u00ad\u0001\u001a\u00020^J\b\u0010\u00ae\u0001\u001a\u00030\u0099\u0001J\b\u0010\u00af\u0001\u001a\u00030\u0099\u0001J\t\u0010\u00b0\u0001\u001a\u00020;H\u0002J\u0007\u0010\u00b1\u0001\u001a\u00020;J\u0007\u0010\u00b2\u0001\u001a\u00020;J\u0007\u0010\u00b3\u0001\u001a\u00020;J\u0007\u0010\u00b4\u0001\u001a\u00020CJ\u0007\u0010\u00b5\u0001\u001a\u00020;J\u0019\u0010\u00b6\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u00b7\u0001\u001a\u00020;\u00a2\u0006\u0005\b\u00b8\u0001\u0010?J\u0019\u0010\u00b9\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u00ba\u0001\u001a\u00020C\u00a2\u0006\u0005\b\u00bb\u0001\u0010GJ\u0007\u0010\u00bc\u0001\u001a\u00020\rJ\u0019\u0010\u00bd\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u00be\u0001\u001a\u00020\rH\u0000\u00a2\u0006\u0003\b\u00bf\u0001J\u0007\u0010\u00c0\u0001\u001a\u00020CJ\u0019\u0010\u00c1\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u00ba\u0001\u001a\u00020C\u00a2\u0006\u0005\b\u00c2\u0001\u0010GJ\u0019\u0010\u00c6\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u00c7\u0001\u001a\u00020;\u00a2\u0006\u0005\b\u00c8\u0001\u0010?R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010&R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010)R\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)R\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010)R\u0011\u0010\u0011\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010)R\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010)R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0015\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010)R\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010)R\u0011\u0010\u0017\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010)R\u0011\u0010\u0018\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010)R\u0011\u0010\u0019\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010)R\u0011\u0010\u001a\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010)R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010:\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010A\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001e\u0010B\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010A\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001e\u0010I\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010A\u001a\u0004\bJ\u0010E\"\u0004\bK\u0010GR\u001e\u0010M\u001a\u00020CX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bP\u0010A\u001a\u0004\bN\u0010E\"\u0004\bO\u0010GR\u0011\u0010Q\u001a\u00020R\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010TR\u0011\u0010U\u001a\u00020V\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010XR\u0011\u0010Y\u001a\u00020Z\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\\R\u001e\u0010]\u001a\u0004\u0018\u00010^X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010c\u001a\u0004\b_\u0010`\"\u0004\ba\u0010bR\u001e\u0010d\u001a\u0004\u0018\u00010^X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010c\u001a\u0004\be\u0010`\"\u0004\bf\u0010bR\u001e\u0010g\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010l\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR\u001e\u0010m\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010l\u001a\u0004\bn\u0010i\"\u0004\bo\u0010kR\u001e\u0010p\u001a\u0004\u0018\u00010^X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010c\u001a\u0004\bq\u0010`\"\u0004\br\u0010bR\u001c\u0010s\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bt\u0010&\"\u0004\bu\u0010vR\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010w\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bx\u0010yR\u001a\u0010z\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b{\u0010)\"\u0004\b|\u0010}R\u000e\u0010~\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\u0081\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u007f\u001a\u00030\u0080\u00018F@FX\u0086\u008e\u0002\u00a2\u0006\u0018\n\u0006\b\u0086\u0001\u0010\u0087\u0001\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001\"\u0006\b\u0084\u0001\u0010\u0085\u0001R5\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u007f\u001a\u0004\u0018\u00010\n8F@FX\u0086\u008e\u0002\u00a2\u0006\u0018\n\u0006\b\u008c\u0001\u0010\u0087\u0001\u001a\u0006\b\u0088\u0001\u0010\u0089\u0001\"\u0006\b\u008a\u0001\u0010\u008b\u0001R\u0013\u0010\u008d\u0001\u001a\u00020\r\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008e\u0001\u0010)R\u0012\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008f\u0001\u0010$R\u0015\u0010\u0090\u0001\u001a\u00030\u0091\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0092\u0001\u0010\u0093\u0001R\u0015\u0010\u0094\u0001\u001a\u00030\u0095\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0096\u0001\u0010\u0097\u0001R\"\u0010\u009a\u0001\u001a\u00030\u009b\u0001X\u0086\u000e\u00a2\u0006\u0014\n\u0003\u0010\u009f\u0001\u001a\u0005\b\u009c\u0001\u0010$\"\u0006\b\u009d\u0001\u0010\u009e\u0001R\"\u0010\u00a2\u0001\u001a\u00030\u009b\u0001X\u0086\u000e\u00a2\u0006\u0014\n\u0003\u0010\u009f\u0001\u001a\u0005\b\u00a3\u0001\u0010$\"\u0006\b\u00a4\u0001\u0010\u009e\u0001R\u0014\u0010\u00c3\u0001\u001a\u00020^8F\u00a2\u0006\b\u001a\u0006\b\u00c4\u0001\u0010\u00c5\u0001\u00a8\u0006\u00c9\u0001"}, d2={"Ldev/slimevr/tracking/trackers/Tracker;", "", "device", "Ldev/slimevr/tracking/trackers/Device;", "id", "", "name", "", "displayName", "trackerPosition", "Ldev/slimevr/tracking/trackers/TrackerPosition;", "trackerNum", "hasPosition", "", "hasRotation", "hasAcceleration", "userEditable", "isInternal", "isComputed", "imuType", "Ldev/slimevr/tracking/trackers/udp/IMUType;", "usesTimeout", "allowFiltering", "needsReset", "needsMounting", "isHmd", "trackRotDirection", "magStatus", "Ldev/slimevr/tracking/trackers/udp/MagnetometerStatus;", "trackerDataType", "Ldev/slimevr/tracking/trackers/udp/TrackerDataType;", "<init>", "(Ldev/slimevr/tracking/trackers/Device;ILjava/lang/String;Ljava/lang/String;Ldev/slimevr/tracking/trackers/TrackerPosition;Ljava/lang/Integer;ZZZZZZLdev/slimevr/tracking/trackers/udp/IMUType;ZZZZZZLdev/slimevr/tracking/trackers/udp/MagnetometerStatus;Ldev/slimevr/tracking/trackers/udp/TrackerDataType;)V", "getDevice", "()Ldev/slimevr/tracking/trackers/Device;", "getId", "()I", "getName", "()Ljava/lang/String;", "getDisplayName", "getHasPosition", "()Z", "getHasRotation", "getHasAcceleration", "getUserEditable", "getImuType", "()Ldev/slimevr/tracking/trackers/udp/IMUType;", "getUsesTimeout", "getAllowFiltering", "getNeedsReset", "getNeedsMounting", "getTrackRotDirection", "getTrackerDataType", "()Ldev/slimevr/tracking/trackers/udp/TrackerDataType;", "timer", "Lio/eiren/util/BufferedTimer;", "timeAtLastUpdate", "", "_rotation", "Lio/github/axisangles/ktmath/Quaternion;", "get_rotation", "()Lio/github/axisangles/ktmath/Quaternion;", "set_rotation-oS71L7k", "(FFFF)V", "_rotation-w", "F", "_acceleration", "Lio/github/axisangles/ktmath/Vector3;", "get_acceleration", "()Lio/github/axisangles/ktmath/Vector3;", "set_acceleration-1s-5YWc", "(FFF)V", "_acceleration-x", "_magVector", "get_magVector", "set_magVector-1s-5YWc", "_magVector-x", "position", "getPosition", "setPosition-1s-5YWc", "position-x", "resetsHandler", "Ldev/slimevr/tracking/trackers/TrackerResetsHandler;", "getResetsHandler", "()Ldev/slimevr/tracking/trackers/TrackerResetsHandler;", "filteringHandler", "Ldev/slimevr/tracking/trackers/TrackerFilteringHandler;", "getFilteringHandler", "()Ldev/slimevr/tracking/trackers/TrackerFilteringHandler;", "trackerFlexHandler", "Ldev/slimevr/tracking/trackers/TrackerFlexHandler;", "getTrackerFlexHandler", "()Ldev/slimevr/tracking/trackers/TrackerFlexHandler;", "batteryVoltage", "", "getBatteryVoltage", "()Ljava/lang/Float;", "setBatteryVoltage", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "batteryLevel", "getBatteryLevel", "setBatteryLevel", "ping", "getPing", "()Ljava/lang/Integer;", "setPing", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "signalStrength", "getSignalStrength", "setSignalStrength", "temperature", "getTemperature", "setTemperature", "customName", "getCustomName", "setCustomName", "(Ljava/lang/String;)V", "value", "getMagStatus", "()Ldev/slimevr/tracking/trackers/udp/MagnetometerStatus;", "statusResetRecently", "getStatusResetRecently", "setStatusResetRecently", "(Z)V", "alreadyInitialized", "<set-?>", "Ldev/slimevr/tracking/trackers/TrackerStatus;", "status", "getStatus", "()Ldev/slimevr/tracking/trackers/TrackerStatus;", "setStatus", "(Ldev/slimevr/tracking/trackers/TrackerStatus;)V", "status$delegate", "Lkotlin/properties/ReadWriteProperty;", "getTrackerPosition", "()Ldev/slimevr/tracking/trackers/TrackerPosition;", "setTrackerPosition", "(Ldev/slimevr/tracking/trackers/TrackerPosition;)V", "trackerPosition$delegate", "hasAdjustedRotation", "getHasAdjustedRotation", "getTrackerNum", "stayAligned", "Ldev/slimevr/tracking/processor/stayaligned/trackers/StayAlignedTrackerState;", "getStayAligned", "()Ldev/slimevr/tracking/processor/stayaligned/trackers/StayAlignedTrackerState;", "yawResetSmoothing", "Ldev/slimevr/util/InterpolationHandler;", "getYawResetSmoothing", "()Ldev/slimevr/util/InterpolationHandler;", "checkReportRequireReset", "", "lastResetStatus", "Lkotlin/UInt;", "getLastResetStatus-pVg5ArA", "setLastResetStatus-WZ4Q5Ns", "(I)V", "I", "reportRequireReset", "checkReportErrorStatus", "lastErrorStatus", "getLastErrorStatus-pVg5ArA", "setLastErrorStatus-WZ4Q5Ns", "reportErrorStatus", "readConfig", "config", "Ldev/slimevr/config/TrackerConfig;", "writeConfig", "saveMountingResetOrientation", "quat", "tick", "deltaTime", "dataTick", "heartbeat", "getAdjustedRotation", "getAdjustedRotationForceStayAligned", "getIdentityAdjustedRotation", "getRotation", "getAcceleration", "getRawRotation", "setRotation", "rotation", "setRotation-oS71L7k", "setAcceleration", "vec", "setAcceleration-1s-5YWc", "isImu", "setMagPrivate", "mag", "setMagPrivate$core", "getMagVector", "setMagVector", "setMagVector-1s-5YWc", "tps", "getTps", "()F", "resetFilteringQuats", "reference", "resetFilteringQuats-oS71L7k", "core"})
@SourceDebugExtension(value={"SMAP\nTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tracker.kt\ndev/slimevr/tracking/trackers/Tracker\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,506:1\n33#2,3:507\n33#2,3:510\n1#3:513\n*S KotlinDebug\n*F\n+ 1 Tracker.kt\ndev/slimevr/tracking/trackers/Tracker\n*L\n116#1:507,3\n142#1:510,3\n*E\n"})
public final class Tracker {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @Nullable
    private final Device device;
    private final int id;
    @NotNull
    private final String name;
    @NotNull
    private final String displayName;
    private final boolean hasPosition;
    private final boolean hasRotation;
    private final boolean hasAcceleration;
    private final boolean userEditable;
    private final boolean isInternal;
    private final boolean isComputed;
    @Nullable
    private final IMUType imuType;
    private final boolean usesTimeout;
    private final boolean allowFiltering;
    private final boolean needsReset;
    private final boolean needsMounting;
    private final boolean isHmd;
    private final boolean trackRotDirection;
    @NotNull
    private final TrackerDataType trackerDataType;
    @NotNull
    private final BufferedTimer timer;
    private long timeAtLastUpdate;
    private float _rotation-w;
    private float _rotation-x;
    private float _rotation-y;
    private float _rotation-z;
    private float _acceleration-x;
    private float _acceleration-y;
    private float _acceleration-z;
    private float _magVector-x;
    private float _magVector-y;
    private float _magVector-z;
    private float position-x;
    private float position-y;
    private float position-z;
    @NotNull
    private final TrackerResetsHandler resetsHandler;
    @NotNull
    private final TrackerFilteringHandler filteringHandler;
    @NotNull
    private final TrackerFlexHandler trackerFlexHandler;
    @Nullable
    private Float batteryVoltage;
    @Nullable
    private Float batteryLevel;
    @Nullable
    private Integer ping;
    @Nullable
    private Integer signalStrength;
    @Nullable
    private Float temperature;
    @Nullable
    private String customName;
    @NotNull
    private MagnetometerStatus magStatus;
    private boolean statusResetRecently;
    private boolean alreadyInitialized;
    @NotNull
    private final ReadWriteProperty status$delegate;
    @NotNull
    private final ReadWriteProperty trackerPosition$delegate;
    private final boolean hasAdjustedRotation;
    private final int trackerNum;
    @NotNull
    private final StayAlignedTrackerState stayAligned;
    @NotNull
    private final InterpolationHandler yawResetSmoothing;
    private int lastResetStatus;
    private int lastErrorStatus;

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation, boolean hasAcceleration, boolean userEditable, boolean isInternal, boolean isComputed, @Nullable IMUType imuType, boolean usesTimeout, boolean allowFiltering, boolean needsReset, boolean needsMounting, boolean isHmd, boolean trackRotDirection, @NotNull MagnetometerStatus magStatus, @NotNull TrackerDataType trackerDataType) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        Intrinsics.checkNotNullParameter((Object)magStatus, "magStatus");
        Intrinsics.checkNotNullParameter((Object)trackerDataType, "trackerDataType");
        this.device = device;
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.hasPosition = hasPosition;
        this.hasRotation = hasRotation;
        this.hasAcceleration = hasAcceleration;
        this.userEditable = userEditable;
        this.isInternal = isInternal;
        this.isComputed = isComputed;
        this.imuType = imuType;
        this.usesTimeout = usesTimeout;
        this.allowFiltering = allowFiltering;
        this.needsReset = needsReset;
        this.needsMounting = needsMounting;
        this.isHmd = isHmd;
        this.trackRotDirection = trackRotDirection;
        this.trackerDataType = trackerDataType;
        this.timer = new BufferedTimer(1.0f);
        this.timeAtLastUpdate = System.currentTimeMillis();
        Object object = Quaternion.Companion;
        this._rotation-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this._rotation-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this._rotation-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this._rotation-z = ((Quaternion.Companion)object).getIDENTITY-z();
        object = Vector3.Companion;
        this._acceleration-x = ((Vector3.Companion)object).getNULL-x();
        this._acceleration-y = ((Vector3.Companion)object).getNULL-y();
        this._acceleration-z = ((Vector3.Companion)object).getNULL-z();
        object = Vector3.Companion;
        this._magVector-x = ((Vector3.Companion)object).getNULL-x();
        this._magVector-y = ((Vector3.Companion)object).getNULL-y();
        this._magVector-z = ((Vector3.Companion)object).getNULL-z();
        object = Vector3.Companion;
        this.position-x = ((Vector3.Companion)object).getNULL-x();
        this.position-y = ((Vector3.Companion)object).getNULL-y();
        this.position-z = ((Vector3.Companion)object).getNULL-z();
        this.resetsHandler = new TrackerResetsHandler(this);
        this.filteringHandler = new TrackerFilteringHandler();
        this.trackerFlexHandler = new TrackerFlexHandler(this);
        this.magStatus = magStatus;
        object = Delegates.INSTANCE;
        TrackerStatus initialValue$iv = TrackerStatus.DISCONNECTED;
        boolean $i$f$observable = false;
        this.status$delegate = new ObservableProperty<TrackerStatus>((Object)initialValue$iv, this){
            final /* synthetic */ Tracker this$0;
            {
                this.this$0 = tracker;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                void new_;
                Intrinsics.checkNotNullParameter(property, "property");
                TrackerStatus trackerStatus = (TrackerStatus)((Object)newValue);
                TrackerStatus old = (TrackerStatus)((Object)oldValue);
                boolean bl = false;
                if (old != new_) {
                    if (!new_.getReset()) {
                        if (Tracker.access$getAlreadyInitialized$p(this.this$0)) {
                            this.this$0.setStatusResetRecently(true);
                        }
                        Tracker.access$setAlreadyInitialized$p(this.this$0, true);
                    }
                    if (!this.this$0.isInternal() && VRServer.Companion.getInstanceInitialized()) {
                        VRServer.Companion.getInstance().updateSkeletonModel();
                        VRServer.Companion.getInstance().refreshTrackersDriftCompensationEnabled();
                        if (this.this$0.isHmd()) {
                            VRServer.Companion.getInstance().humanPoseManager.checkReportMissingHmd();
                        }
                        Tracker.access$checkReportErrorStatus(this.this$0);
                        this.this$0.checkReportRequireReset();
                        VRServer.Companion.getInstance().trackerStatusChanged(this.this$0, old, (TrackerStatus)new_);
                    }
                }
            }
        };
        Delegates this_$iv = Delegates.INSTANCE;
        boolean $i$f$observable2 = false;
        this.trackerPosition$delegate = new ObservableProperty<TrackerPosition>((Object)trackerPosition, this){
            final /* synthetic */ Tracker this$0;
            {
                this.this$0 = tracker;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                void new_;
                Intrinsics.checkNotNullParameter(property, "property");
                TrackerPosition trackerPosition = (TrackerPosition)((Object)newValue);
                TrackerPosition old = (TrackerPosition)((Object)oldValue);
                boolean bl = false;
                if (old != new_ && !this.this$0.isInternal()) {
                    void v0 = new_;
                    if (v0 != null) {
                        void it = v0;
                        boolean bl2 = false;
                        Quaternion quaternion = it.defaultMounting();
                        this.this$0.getResetsHandler().setMountingOrientation-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
                    }
                    this.this$0.checkReportRequireReset();
                }
            }
        };
        this.hasAdjustedRotation = this.hasRotation && (this.allowFiltering || this.needsReset);
        Integer n = trackerNum;
        this.trackerNum = n != null ? n : this.id;
        this.stayAligned = new StayAlignedTrackerState(this);
        this.yawResetSmoothing = new InterpolationHandler();
        if (!(!this.needsReset || this.hasRotation && this.needsReset)) {
            boolean $i$a$-require-Tracker$42 = false;
            String $i$a$-require-Tracker$42 = "If needsReset is true, then hasRotation must also be true";
            throw new IllegalArgumentException($i$a$-require-Tracker$42.toString());
        }
        if (!(!this.needsMounting || this.needsReset && this.needsMounting)) {
            boolean $i$a$-require-Tracker$52 = false;
            String $i$a$-require-Tracker$52 = "If needsMounting is true, then needsReset must also be true";
            throw new IllegalArgumentException($i$a$-require-Tracker$52.toString());
        }
        if (!(!this.isHmd || this.hasPosition && this.isHmd)) {
            boolean bl = false;
            String string = "If isHmd is true, then hasPosition must also be true";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Tracker(Device device, int n, String string, String object, TrackerPosition trackerPosition, Integer n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, IMUType iMUType, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, MagnetometerStatus magnetometerStatus, TrackerDataType trackerDataType, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            object = "Tracker #" + n;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        if ((n3 & 0x40) != 0) {
            bl = false;
        }
        if ((n3 & 0x80) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x100) != 0) {
            bl3 = false;
        }
        if ((n3 & 0x200) != 0) {
            bl4 = false;
        }
        if ((n3 & 0x400) != 0) {
            bl5 = false;
        }
        if ((n3 & 0x800) != 0) {
            bl6 = false;
        }
        if ((n3 & 0x1000) != 0) {
            iMUType = null;
        }
        if ((n3 & 0x2000) != 0) {
            bl7 = false;
        }
        if ((n3 & 0x4000) != 0) {
            bl8 = false;
        }
        if ((n3 & 0x8000) != 0) {
            bl9 = false;
        }
        if ((n3 & 0x10000) != 0) {
            bl10 = false;
        }
        if ((n3 & 0x20000) != 0) {
            bl11 = false;
        }
        if ((n3 & 0x40000) != 0) {
            bl12 = true;
        }
        if ((n3 & 0x80000) != 0) {
            magnetometerStatus = MagnetometerStatus.NOT_SUPPORTED;
        }
        if ((n3 & 0x100000) != 0) {
            trackerDataType = TrackerDataType.ROTATION;
        }
        this(device, n, string, (String)object, trackerPosition, n2, bl, bl2, bl3, bl4, bl5, bl6, iMUType, bl7, bl8, bl9, bl10, bl11, bl12, magnetometerStatus, trackerDataType);
    }

    @Nullable
    public final Device getDevice() {
        return this.device;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    public final boolean getHasPosition() {
        return this.hasPosition;
    }

    public final boolean getHasRotation() {
        return this.hasRotation;
    }

    public final boolean getHasAcceleration() {
        return this.hasAcceleration;
    }

    public final boolean getUserEditable() {
        return this.userEditable;
    }

    public final boolean isInternal() {
        return this.isInternal;
    }

    public final boolean isComputed() {
        return this.isComputed;
    }

    @Nullable
    public final IMUType getImuType() {
        return this.imuType;
    }

    public final boolean getUsesTimeout() {
        return this.usesTimeout;
    }

    public final boolean getAllowFiltering() {
        return this.allowFiltering;
    }

    public final boolean getNeedsReset() {
        return this.needsReset;
    }

    public final boolean getNeedsMounting() {
        return this.needsMounting;
    }

    public final boolean isHmd() {
        return this.isHmd;
    }

    public final boolean getTrackRotDirection() {
        return this.trackRotDirection;
    }

    @NotNull
    public final TrackerDataType getTrackerDataType() {
        return this.trackerDataType;
    }

    private final Quaternion get_rotation() {
        return Quaternion.box-impl(this._rotation-w, this._rotation-x, this._rotation-y, this._rotation-z);
    }

    private final void set_rotation-oS71L7k(float f, float f2, float f3, float f4) {
        this._rotation-w = f;
        this._rotation-x = f2;
        this._rotation-y = f3;
        this._rotation-z = f4;
    }

    private final Vector3 get_acceleration() {
        return Vector3.box-impl(this._acceleration-x, this._acceleration-y, this._acceleration-z);
    }

    private final void set_acceleration-1s-5YWc(float f, float f2, float f3) {
        this._acceleration-x = f;
        this._acceleration-y = f2;
        this._acceleration-z = f3;
    }

    private final Vector3 get_magVector() {
        return Vector3.box-impl(this._magVector-x, this._magVector-y, this._magVector-z);
    }

    private final void set_magVector-1s-5YWc(float f, float f2, float f3) {
        this._magVector-x = f;
        this._magVector-y = f2;
        this._magVector-z = f3;
    }

    @NotNull
    public final Vector3 getPosition() {
        return Vector3.box-impl(this.position-x, this.position-y, this.position-z);
    }

    public final void setPosition-1s-5YWc(float f, float f2, float f3) {
        this.position-x = f;
        this.position-y = f2;
        this.position-z = f3;
    }

    @NotNull
    public final TrackerResetsHandler getResetsHandler() {
        return this.resetsHandler;
    }

    @NotNull
    public final TrackerFilteringHandler getFilteringHandler() {
        return this.filteringHandler;
    }

    @NotNull
    public final TrackerFlexHandler getTrackerFlexHandler() {
        return this.trackerFlexHandler;
    }

    @Nullable
    public final Float getBatteryVoltage() {
        return this.batteryVoltage;
    }

    public final void setBatteryVoltage(@Nullable Float f) {
        this.batteryVoltage = f;
    }

    @Nullable
    public final Float getBatteryLevel() {
        return this.batteryLevel;
    }

    public final void setBatteryLevel(@Nullable Float f) {
        this.batteryLevel = f;
    }

    @Nullable
    public final Integer getPing() {
        return this.ping;
    }

    public final void setPing(@Nullable Integer n) {
        this.ping = n;
    }

    @Nullable
    public final Integer getSignalStrength() {
        return this.signalStrength;
    }

    public final void setSignalStrength(@Nullable Integer n) {
        this.signalStrength = n;
    }

    @Nullable
    public final Float getTemperature() {
        return this.temperature;
    }

    public final void setTemperature(@Nullable Float f) {
        this.temperature = f;
    }

    @Nullable
    public final String getCustomName() {
        return this.customName;
    }

    public final void setCustomName(@Nullable String string) {
        this.customName = string;
    }

    @NotNull
    public final MagnetometerStatus getMagStatus() {
        return this.magStatus;
    }

    public final boolean getStatusResetRecently() {
        return this.statusResetRecently;
    }

    public final void setStatusResetRecently(boolean bl) {
        this.statusResetRecently = bl;
    }

    @NotNull
    public final TrackerStatus getStatus() {
        return (TrackerStatus)((Object)this.status$delegate.getValue(this, $$delegatedProperties[0]));
    }

    public final void setStatus(@NotNull TrackerStatus trackerStatus) {
        Intrinsics.checkNotNullParameter((Object)trackerStatus, "<set-?>");
        this.status$delegate.setValue(this, $$delegatedProperties[0], trackerStatus);
    }

    @Nullable
    public final TrackerPosition getTrackerPosition() {
        return (TrackerPosition)((Object)this.trackerPosition$delegate.getValue(this, $$delegatedProperties[1]));
    }

    public final void setTrackerPosition(@Nullable TrackerPosition trackerPosition) {
        this.trackerPosition$delegate.setValue(this, $$delegatedProperties[1], trackerPosition);
    }

    public final boolean getHasAdjustedRotation() {
        return this.hasAdjustedRotation;
    }

    public final int getTrackerNum() {
        return this.trackerNum;
    }

    @NotNull
    public final StayAlignedTrackerState getStayAligned() {
        return this.stayAligned;
    }

    @NotNull
    public final InterpolationHandler getYawResetSmoothing() {
        return this.yawResetSmoothing;
    }

    public final void checkReportRequireReset() {
        if (this.needsReset && this.getTrackerPosition() != null && this.lastResetStatus == 0 && !this.getStatus().getReset() && (this.isImu() || !this.statusResetRecently && this.trackerDataType != TrackerDataType.FLEX_ANGLE)) {
            this.reportRequireReset();
        } else if (this.lastResetStatus != 0 && (this.getTrackerPosition() == null || this.getStatus().getReset())) {
            VRServer.Companion.getInstance().statusSystem.removeStatusInt(this.lastResetStatus);
            this.lastResetStatus = 0;
        }
    }

    public final int getLastResetStatus-pVg5ArA() {
        return this.lastResetStatus;
    }

    public final void setLastResetStatus-WZ4Q5Ns(int n) {
        this.lastResetStatus = n;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportRequireReset() {
        StatusDataUnion statusDataUnion;
        void $this$reportRequireReset_u24lambda_u249_u24lambda_u248;
        TrackerIdT trackerIdT;
        StatusTrackerResetT statusTrackerResetT;
        if (!(this.lastResetStatus == 0)) {
            boolean $i$a$-require-Tracker$reportRequireReset$22 = false;
            String $i$a$-require-Tracker$reportRequireReset$22 = "lastResetStatus must be 0u, but was " + UInt.toString-impl(this.lastResetStatus);
            throw new IllegalArgumentException($i$a$-require-Tracker$reportRequireReset$22.toString());
        }
        int tempTrackerNum = this.trackerNum;
        StatusTrackerResetT $this$reportRequireReset_u24lambda_u249 = statusTrackerResetT = new StatusTrackerResetT();
        boolean bl = false;
        TrackerIdT trackerIdT2 = trackerIdT = new TrackerIdT();
        StatusTrackerResetT statusTrackerResetT2 = $this$reportRequireReset_u24lambda_u249;
        boolean bl2 = false;
        if (this.device != null) {
            void $this$reportRequireReset_u24lambda_u249_u24lambda_u248_u24lambda_u247;
            DeviceIdT deviceIdT;
            DeviceIdT deviceIdT2 = deviceIdT = new DeviceIdT();
            void var12_16 = $this$reportRequireReset_u24lambda_u249_u24lambda_u248;
            boolean bl3 = false;
            $this$reportRequireReset_u24lambda_u249_u24lambda_u248_u24lambda_u247.setId(this.device.getId());
            var12_16.setDeviceId(deviceIdT);
        }
        $this$reportRequireReset_u24lambda_u249_u24lambda_u248.setTrackerNum(tempTrackerNum);
        statusTrackerResetT2.setTrackerId(trackerIdT);
        StatusTrackerResetT statusMsg = statusTrackerResetT;
        StatusDataUnion $this$reportRequireReset_u24lambda_u2410 = statusDataUnion = new StatusDataUnion();
        boolean bl4 = false;
        $this$reportRequireReset_u24lambda_u2410.setType((byte)1);
        $this$reportRequireReset_u24lambda_u2410.setValue(statusMsg);
        StatusDataUnion status = statusDataUnion;
        this.lastResetStatus = VRServer.Companion.getInstance().statusSystem.addStatusInt(status, true);
    }

    private final void checkReportErrorStatus() {
        if (this.getStatus() == TrackerStatus.ERROR && this.lastErrorStatus == 0) {
            this.reportErrorStatus();
        } else if (this.lastErrorStatus != 0 && this.getStatus() != TrackerStatus.ERROR) {
            VRServer.Companion.getInstance().statusSystem.removeStatusInt(this.lastErrorStatus);
            this.lastErrorStatus = 0;
        }
    }

    public final int getLastErrorStatus-pVg5ArA() {
        return this.lastErrorStatus;
    }

    public final void setLastErrorStatus-WZ4Q5Ns(int n) {
        this.lastErrorStatus = n;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportErrorStatus() {
        StatusDataUnion statusDataUnion;
        void $this$reportErrorStatus_u24lambda_u2414_u24lambda_u2413;
        TrackerIdT trackerIdT;
        StatusTrackerErrorT statusTrackerErrorT;
        if (!(this.lastErrorStatus == 0)) {
            boolean $i$a$-require-Tracker$reportErrorStatus$22 = false;
            String $i$a$-require-Tracker$reportErrorStatus$22 = "lastResetStatus must be 0u, but was " + UInt.toString-impl(this.lastErrorStatus);
            throw new IllegalArgumentException($i$a$-require-Tracker$reportErrorStatus$22.toString());
        }
        int tempTrackerNum = this.trackerNum;
        StatusTrackerErrorT $this$reportErrorStatus_u24lambda_u2414 = statusTrackerErrorT = new StatusTrackerErrorT();
        boolean bl = false;
        TrackerIdT trackerIdT2 = trackerIdT = new TrackerIdT();
        StatusTrackerErrorT statusTrackerErrorT2 = $this$reportErrorStatus_u24lambda_u2414;
        boolean bl2 = false;
        if (this.device != null) {
            void $this$reportErrorStatus_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412;
            DeviceIdT deviceIdT;
            DeviceIdT deviceIdT2 = deviceIdT = new DeviceIdT();
            void var12_16 = $this$reportErrorStatus_u24lambda_u2414_u24lambda_u2413;
            boolean bl3 = false;
            $this$reportErrorStatus_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.setId(this.device.getId());
            var12_16.setDeviceId(deviceIdT);
        }
        $this$reportErrorStatus_u24lambda_u2414_u24lambda_u2413.setTrackerNum(tempTrackerNum);
        statusTrackerErrorT2.setTrackerId(trackerIdT);
        StatusTrackerErrorT statusMsg = statusTrackerErrorT;
        StatusDataUnion $this$reportErrorStatus_u24lambda_u2415 = statusDataUnion = new StatusDataUnion();
        boolean bl4 = false;
        $this$reportErrorStatus_u24lambda_u2415.setType((byte)2);
        $this$reportErrorStatus_u24lambda_u2415.setValue(statusMsg);
        StatusDataUnion status = statusDataUnion;
        this.lastErrorStatus = VRServer.Companion.getInstance().statusSystem.addStatusInt(status, true);
    }

    public final void readConfig(@NotNull TrackerConfig config) {
        Object it;
        block15: {
            block14: {
                Unit unit;
                Intrinsics.checkNotNullParameter(config, "config");
                String string = config.getCustomName();
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    this.customName = it;
                }
                String string2 = config.getDesignation();
                if (string2 == null) break block14;
                String designation = string2;
                boolean bl = false;
                TrackerPosition trackerPosition = TrackerPosition.Companion.getByDesignation(designation);
                if (trackerPosition != null) {
                    TrackerPosition it2 = trackerPosition;
                    boolean bl2 = false;
                    this.setTrackerPosition(it2);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) break block15;
            }
            Tracker $this$readConfig_u24lambda_u2419 = this;
            boolean bl = false;
            $this$readConfig_u24lambda_u2419.setTrackerPosition(null);
        }
        if (this.needsMounting) {
            ObjectQuaternion objectQuaternion = config.getMountingOrientation();
            if (objectQuaternion != null) {
                it = objectQuaternion;
                boolean bl = false;
                Quaternion quaternion = ((ObjectQuaternion)it).toValue();
                this.resetsHandler.setMountingOrientation-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
            }
        }
        if (this.isImu() && config.getAllowDriftCompensation() == null) {
            this.resetsHandler.setAllowDriftCompensation(true);
            VRServer.Companion.getInstance().configManager.getVrConfig().getTracker(this).setAllowDriftCompensation(true);
            VRServer.Companion.getInstance().configManager.saveConfig();
        } else {
            Boolean bl = config.getAllowDriftCompensation();
            if (bl != null) {
                boolean it3 = bl;
                boolean bl3 = false;
                this.resetsHandler.setAllowDriftCompensation(it3);
            }
        }
        if (!this.isInternal && (this.isImu() || this.getTrackerPosition() != TrackerPosition.LEFT_HAND && this.getTrackerPosition() != TrackerPosition.RIGHT_HAND)) {
            this.checkReportRequireReset();
        }
    }

    public final void writeConfig(@NotNull TrackerConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        TrackerPosition trackerPosition = this.getTrackerPosition();
        if (trackerPosition != null) {
            TrackerPosition it = trackerPosition;
            boolean bl = false;
            config.setDesignation(it.getDesignation());
        } else {
            Tracker $this$writeConfig_u24lambda_u2423 = this;
            boolean bl = false;
            config.setDesignation(null);
        }
        String string = this.customName;
        if (string != null) {
            String it = string;
            boolean bl = false;
            config.setCustomName(it);
        }
        if (this.needsMounting) {
            TrackerResetsHandler trackerResetsHandler = this.resetsHandler;
            config.setMountingOrientation(Quaternion.toObject-impl(trackerResetsHandler.getMountingOrientation-w(), trackerResetsHandler.getMountingOrientation-x(), trackerResetsHandler.getMountingOrientation-y(), trackerResetsHandler.getMountingOrientation-z()));
        }
        if (this.isImu()) {
            config.setAllowDriftCompensation(this.resetsHandler.getAllowDriftCompensation());
        }
    }

    public final void saveMountingResetOrientation(@NotNull TrackerConfig config) {
        block0: {
            Intrinsics.checkNotNullParameter(config, "config");
            ObjectQuaternion objectQuaternion = config.getMountingResetOrientation();
            if (objectQuaternion == null) break block0;
            ObjectQuaternion it = objectQuaternion;
            boolean bl = false;
            Quaternion quaternion = it.toValue();
            this.resetsHandler.trySetMountingReset-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
        }
    }

    public final void saveMountingResetOrientation(@Nullable Quaternion quat) {
        ConfigManager configManager = VRServer.Companion.getInstance().configManager;
        Quaternion quaternion = quat;
        configManager.getVrConfig().getTracker(this).setMountingResetOrientation(quaternion != null ? Quaternion.toObject-impl(quaternion.unbox-impl-w(), quat.unbox-impl-x(), quat.unbox-impl-y(), quat.unbox-impl-z()) : null);
        configManager.saveConfig();
    }

    public final void tick(float deltaTime) {
        if (this.usesTimeout) {
            if (System.currentTimeMillis() - this.timeAtLastUpdate > 5000L) {
                this.setStatus(TrackerStatus.DISCONNECTED);
            } else if (System.currentTimeMillis() - this.timeAtLastUpdate > 2000L) {
                this.setStatus(TrackerStatus.TIMED_OUT);
            }
        }
        this.filteringHandler.update();
        this.yawResetSmoothing.tick(deltaTime);
        this.stayAligned.update();
    }

    public final void dataTick() {
        this.timer.update();
        this.timeAtLastUpdate = System.currentTimeMillis();
        if (this.trackRotDirection) {
            Quaternion quaternion = this.getAdjustedRotation();
            this.filteringHandler.dataTick-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
        }
    }

    public final void heartbeat() {
        this.timeAtLastUpdate = System.currentTimeMillis();
    }

    private final Quaternion getAdjustedRotation() {
        float f = this._rotation-w;
        float f2 = this._rotation-x;
        float f3 = this._rotation-y;
        float f4 = this._rotation-z;
        if (!this.stayAligned.getHideCorrection()) {
            Quaternion quaternion = Quaternion.Companion.rotationAroundYAxis(Angle.toRad-impl(this.stayAligned.getYawCorrection-ncrbCcM()));
            Quaternion quaternion2 = Quaternion.times-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z(), f, f2, f3, f4);
            float f5 = quaternion2.unbox-impl-w();
            float f6 = quaternion2.unbox-impl-x();
            float f7 = quaternion2.unbox-impl-y();
            float f8 = quaternion2.unbox-impl-z();
            f = f5;
            f2 = f6;
            f3 = f7;
            f4 = f8;
        }
        return this.needsReset && (!this.isComputed || !this.isInternal) && this.trackerDataType == TrackerDataType.ROTATION ? this.resetsHandler.getReferenceAdjustedDriftRotationFrom-oS71L7k(f, f2, f3, f4) : Quaternion.box-impl(f, f2, f3, f4);
    }

    @NotNull
    public final Quaternion getAdjustedRotationForceStayAligned() {
        float f = this._rotation-w;
        float f2 = this._rotation-x;
        float f3 = this._rotation-y;
        float f4 = this._rotation-z;
        Quaternion quaternion = Quaternion.Companion.rotationAroundYAxis(Angle.toRad-impl(this.stayAligned.getYawCorrection-ncrbCcM()));
        Quaternion quaternion2 = Quaternion.times-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z(), f, f2, f3, f4);
        float f5 = quaternion2.unbox-impl-w();
        float f6 = quaternion2.unbox-impl-x();
        float f7 = quaternion2.unbox-impl-y();
        float f8 = quaternion2.unbox-impl-z();
        f = f5;
        f2 = f6;
        f3 = f7;
        f4 = f8;
        return this.needsReset && (!this.isComputed || !this.isInternal) && this.trackerDataType == TrackerDataType.ROTATION ? this.resetsHandler.getReferenceAdjustedDriftRotationFrom-oS71L7k(f, f2, f3, f4) : Quaternion.box-impl(f, f2, f3, f4);
    }

    @NotNull
    public final Quaternion getIdentityAdjustedRotation() {
        float f = this._rotation-w;
        float f2 = this._rotation-x;
        float f3 = this._rotation-y;
        float f4 = this._rotation-z;
        if (!this.stayAligned.getHideCorrection()) {
            Quaternion quaternion = Quaternion.Companion.rotationAroundYAxis(Angle.toRad-impl(this.stayAligned.getYawCorrection-ncrbCcM()));
            Quaternion quaternion2 = Quaternion.times-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z(), f, f2, f3, f4);
            float f5 = quaternion2.unbox-impl-w();
            float f6 = quaternion2.unbox-impl-x();
            float f7 = quaternion2.unbox-impl-y();
            float f8 = quaternion2.unbox-impl-z();
            f = f5;
            f2 = f6;
            f3 = f7;
            f4 = f8;
        }
        return this.needsReset && (!this.isComputed || this.getTrackerPosition() == TrackerPosition.HEAD) && this.trackerDataType == TrackerDataType.ROTATION ? this.resetsHandler.getIdentityAdjustedDriftRotationFrom-oS71L7k(f, f2, f3, f4) : Quaternion.box-impl(f, f2, f3, f4);
    }

    @NotNull
    public final Quaternion getRotation() {
        Quaternion quaternion;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.trackRotDirection) {
            quaternion = this.filteringHandler.getFilteredRotation();
            f = quaternion.unbox-impl-w();
            f2 = quaternion.unbox-impl-x();
            f3 = quaternion.unbox-impl-y();
            f4 = quaternion.unbox-impl-z();
        } else {
            quaternion = this.getAdjustedRotation();
            f = quaternion.unbox-impl-w();
            f2 = quaternion.unbox-impl-x();
            f3 = quaternion.unbox-impl-y();
            f4 = quaternion.unbox-impl-z();
        }
        if (this.yawResetSmoothing.getRemainingTime() > 0.0f) {
            InterpolationHandler interpolationHandler = this.yawResetSmoothing;
            quaternion = Quaternion.times-oS71L7k(interpolationHandler.getCurRotation-w(), interpolationHandler.getCurRotation-x(), interpolationHandler.getCurRotation-y(), interpolationHandler.getCurRotation-z(), f, f2, f3, f4);
            float f5 = quaternion.unbox-impl-w();
            float f6 = quaternion.unbox-impl-x();
            float f7 = quaternion.unbox-impl-y();
            float f8 = quaternion.unbox-impl-z();
            f = f5;
            f2 = f6;
            f3 = f7;
            f4 = f8;
        }
        return Quaternion.box-impl(f, f2, f3, f4);
    }

    @NotNull
    public final Vector3 getAcceleration() {
        return this.needsReset ? this.resetsHandler.getReferenceAdjustedAccel-CiqQXDU(this._rotation-w, this._rotation-x, this._rotation-y, this._rotation-z, this._acceleration-x, this._acceleration-y, this._acceleration-z) : this.get_acceleration();
    }

    @NotNull
    public final Quaternion getRawRotation() {
        return this.get_rotation();
    }

    public final void setRotation-oS71L7k(float f, float f2, float f3, float f4) {
        this.set_rotation-oS71L7k(f, f2, f3, f4);
    }

    public final void setAcceleration-1s-5YWc(float f, float f2, float f3) {
        this.set_acceleration-1s-5YWc(f, f2, f3);
    }

    public final boolean isImu() {
        return this.imuType != null && this.trackerDataType == TrackerDataType.ROTATION;
    }

    public final void setMagPrivate$core(boolean mag) {
        this.magStatus = mag ? MagnetometerStatus.ENABLED : MagnetometerStatus.DISABLED;
    }

    @NotNull
    public final Vector3 getMagVector() {
        return this.needsReset ? this.resetsHandler.getReferenceAdjustedAccel-CiqQXDU(this._rotation-w, this._rotation-x, this._rotation-y, this._rotation-z, this._magVector-x, this._magVector-y, this._magVector-z) : this.get_magVector();
    }

    public final void setMagVector-1s-5YWc(float f, float f2, float f3) {
        this.set_magVector-1s-5YWc(f, f2, f3);
    }

    public final float getTps() {
        return this.timer.getAverageFPS();
    }

    public final void resetFilteringQuats-oS71L7k(float f, float f2, float f3, float f4) {
        Quaternion quaternion = this.getAdjustedRotation();
        this.filteringHandler.resetMovingAverage-T8bZSfw(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z(), f, f2, f3, f4);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation, boolean hasAcceleration, boolean userEditable, boolean isInternal, boolean isComputed, @Nullable IMUType imuType, boolean usesTimeout, boolean allowFiltering, boolean needsReset, boolean needsMounting, boolean isHmd, boolean trackRotDirection, @NotNull MagnetometerStatus magStatus) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        Intrinsics.checkNotNullParameter((Object)magStatus, "magStatus");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, hasRotation, hasAcceleration, userEditable, isInternal, isComputed, imuType, usesTimeout, allowFiltering, needsReset, needsMounting, isHmd, trackRotDirection, magStatus, null, 0x100000, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation, boolean hasAcceleration, boolean userEditable, boolean isInternal, boolean isComputed, @Nullable IMUType imuType, boolean usesTimeout, boolean allowFiltering, boolean needsReset, boolean needsMounting, boolean isHmd, boolean trackRotDirection) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, hasRotation, hasAcceleration, userEditable, isInternal, isComputed, imuType, usesTimeout, allowFiltering, needsReset, needsMounting, isHmd, trackRotDirection, null, null, 0x180000, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation, boolean hasAcceleration, boolean userEditable, boolean isInternal, boolean isComputed, @Nullable IMUType imuType, boolean usesTimeout, boolean allowFiltering, boolean needsReset, boolean needsMounting, boolean isHmd) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, hasRotation, hasAcceleration, userEditable, isInternal, isComputed, imuType, usesTimeout, allowFiltering, needsReset, needsMounting, isHmd, false, null, null, 0x1C0000, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation, boolean hasAcceleration, boolean userEditable, boolean isInternal, boolean isComputed, @Nullable IMUType imuType, boolean usesTimeout, boolean allowFiltering, boolean needsReset, boolean needsMounting) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, hasRotation, hasAcceleration, userEditable, isInternal, isComputed, imuType, usesTimeout, allowFiltering, needsReset, needsMounting, false, false, null, null, 0x1E0000, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation, boolean hasAcceleration, boolean userEditable, boolean isInternal, boolean isComputed, @Nullable IMUType imuType, boolean usesTimeout, boolean allowFiltering, boolean needsReset) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, hasRotation, hasAcceleration, userEditable, isInternal, isComputed, imuType, usesTimeout, allowFiltering, needsReset, false, false, false, null, null, 0x1F0000, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation, boolean hasAcceleration, boolean userEditable, boolean isInternal, boolean isComputed, @Nullable IMUType imuType, boolean usesTimeout, boolean allowFiltering) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, hasRotation, hasAcceleration, userEditable, isInternal, isComputed, imuType, usesTimeout, allowFiltering, false, false, false, false, null, null, 2064384, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation, boolean hasAcceleration, boolean userEditable, boolean isInternal, boolean isComputed, @Nullable IMUType imuType, boolean usesTimeout) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, hasRotation, hasAcceleration, userEditable, isInternal, isComputed, imuType, usesTimeout, false, false, false, false, false, null, null, 2080768, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation, boolean hasAcceleration, boolean userEditable, boolean isInternal, boolean isComputed, @Nullable IMUType imuType) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, hasRotation, hasAcceleration, userEditable, isInternal, isComputed, imuType, false, false, false, false, false, false, null, null, 2088960, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation, boolean hasAcceleration, boolean userEditable, boolean isInternal, boolean isComputed) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, hasRotation, hasAcceleration, userEditable, isInternal, isComputed, null, false, false, false, false, false, false, null, null, 0x1FF000, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation, boolean hasAcceleration, boolean userEditable, boolean isInternal) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, hasRotation, hasAcceleration, userEditable, isInternal, false, null, false, false, false, false, false, false, null, null, 2095104, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation, boolean hasAcceleration, boolean userEditable) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, hasRotation, hasAcceleration, userEditable, false, false, null, false, false, false, false, false, false, null, null, 2096128, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation, boolean hasAcceleration) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, hasRotation, hasAcceleration, false, false, false, null, false, false, false, false, false, false, null, null, 2096640, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition, boolean hasRotation) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, hasRotation, false, false, false, false, null, false, false, false, false, false, false, null, null, 0x1FFF00, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum, boolean hasPosition) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, hasPosition, false, false, false, false, false, null, false, false, false, false, false, false, null, null, 2097024, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition, @Nullable Integer trackerNum) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, trackerNum, false, false, false, false, false, false, null, false, false, false, false, false, false, null, null, 2097088, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @NotNull String displayName, @Nullable TrackerPosition trackerPosition) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        this(device, id, name, displayName, trackerPosition, null, false, false, false, false, false, false, null, false, false, false, false, false, false, null, null, 2097120, null);
    }

    @JvmOverloads
    public Tracker(@Nullable Device device, int id, @NotNull String name, @Nullable TrackerPosition trackerPosition) {
        Intrinsics.checkNotNullParameter(name, "name");
        this(device, id, name, null, trackerPosition, null, false, false, false, false, false, false, null, false, false, false, false, false, false, null, null, 2097128, null);
    }

    public final /* synthetic */ float get_rotation-w() {
        return this._rotation-w;
    }

    public final /* synthetic */ float get_rotation-x() {
        return this._rotation-x;
    }

    public final /* synthetic */ float get_rotation-y() {
        return this._rotation-y;
    }

    public final /* synthetic */ float get_rotation-z() {
        return this._rotation-z;
    }

    public final /* synthetic */ float get_acceleration-x() {
        return this._acceleration-x;
    }

    public final /* synthetic */ float get_acceleration-y() {
        return this._acceleration-y;
    }

    public final /* synthetic */ float get_acceleration-z() {
        return this._acceleration-z;
    }

    public final /* synthetic */ float get_magVector-x() {
        return this._magVector-x;
    }

    public final /* synthetic */ float get_magVector-y() {
        return this._magVector-y;
    }

    public final /* synthetic */ float get_magVector-z() {
        return this._magVector-z;
    }

    public final /* synthetic */ float getPosition-x() {
        return this.position-x;
    }

    public final /* synthetic */ float getPosition-y() {
        return this.position-y;
    }

    public final /* synthetic */ float getPosition-z() {
        return this.position-z;
    }

    public static final /* synthetic */ boolean access$getAlreadyInitialized$p(Tracker $this) {
        return $this.alreadyInitialized;
    }

    public static final /* synthetic */ void access$setAlreadyInitialized$p(Tracker $this, boolean bl) {
        $this.alreadyInitialized = bl;
    }

    public static final /* synthetic */ void access$checkReportErrorStatus(Tracker $this) {
        $this.checkReportErrorStatus();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(Tracker.class, "status", "getStatus()Ldev/slimevr/tracking/trackers/TrackerStatus;", 0)), Reflection.mutableProperty1(new MutablePropertyReference1Impl(Tracker.class, "trackerPosition", "getTrackerPosition()Ldev/slimevr/tracking/trackers/TrackerPosition;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

