/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.trackers;

import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerPosition;
import io.github.axisangles.ktmath.EulerAngles;
import io.github.axisangles.ktmath.EulerOrder;
import io.github.axisangles.ktmath.Quaternion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\tJ\u0012\u0010\u0017\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/slimevr/tracking/trackers/TrackerFlexHandler;", "", "tracker", "Ldev/slimevr/tracking/trackers/Tracker;", "<init>", "(Ldev/slimevr/tracking/trackers/Tracker;)V", "getTracker", "()Ldev/slimevr/tracking/trackers/Tracker;", "minResistance", "", "maxResistance", "lastMinResetResistance", "resistanceReversed", "", "lastResistance", "thumbInitialOffset", "resetMin", "", "resetMax", "setFlexResistance", "resistance", "setFlexAngle", "angle", "getMaxAngleForTrackerPosition", "trackerPosition", "Ldev/slimevr/tracking/trackers/TrackerPosition;", "core"})
public final class TrackerFlexHandler {
    @NotNull
    private final Tracker tracker;
    private float minResistance;
    private float maxResistance;
    private float lastMinResetResistance;
    private boolean resistanceReversed;
    private float lastResistance;
    private final float thumbInitialOffset;

    public TrackerFlexHandler(@NotNull Tracker tracker) {
        Intrinsics.checkNotNullParameter(tracker, "tracker");
        this.tracker = tracker;
        this.minResistance = Float.MIN_VALUE;
        this.maxResistance = Float.MAX_VALUE;
        this.lastMinResetResistance = Float.MIN_VALUE;
        this.thumbInitialOffset = 0.3926991f;
    }

    @NotNull
    public final Tracker getTracker() {
        return this.tracker;
    }

    public final void resetMin() {
        this.minResistance = this.lastResistance;
        this.lastMinResetResistance = this.lastResistance;
        this.setFlexResistance(this.lastResistance);
        this.tracker.dataTick();
    }

    public final void resetMax() {
        if (this.resistanceReversed != this.lastResistance < this.lastMinResetResistance) {
            this.resistanceReversed = this.lastResistance < this.lastMinResetResistance;
            this.minResistance = this.maxResistance;
            this.maxResistance = this.lastMinResetResistance;
        } else {
            this.maxResistance = this.lastResistance;
        }
        this.setFlexResistance(this.lastResistance);
        this.tracker.dataTick();
    }

    public final void setFlexResistance(float resistance) {
        this.minResistance = this.minResistance == Float.MIN_VALUE ? resistance : (!this.resistanceReversed ? Math.min(this.minResistance, resistance) : Math.max(this.minResistance, resistance));
        this.maxResistance = this.maxResistance == Float.MAX_VALUE ? resistance : (!this.resistanceReversed ? Math.max(this.maxResistance, resistance) : Math.min(this.maxResistance, resistance));
        float maxBend = this.getMaxAngleForTrackerPosition(this.tracker.getTrackerPosition());
        float angle = this.minResistance == this.maxResistance ? 0.0f : maxBend * (resistance - this.minResistance) / (this.maxResistance - this.minResistance);
        this.setFlexAngle(angle);
        this.lastResistance = resistance;
    }

    public final void setFlexAngle(float angle) {
        TrackerPosition trackerPosition = this.tracker.getTrackerPosition();
        switch (trackerPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$0[trackerPosition.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                EulerOrder eulerOrder = EulerOrder.YZX;
                EulerAngles.constructor-impl(eulerOrder, 0.0f, 0.0f, angle);
                Quaternion quaternion = EulerAngles.toQuaternion-impl(eulerOrder, 0.0f, 0.0f, angle);
                this.tracker.setRotation-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                EulerOrder eulerOrder = EulerOrder.YZX;
                float f = -angle;
                EulerAngles.constructor-impl(eulerOrder, 0.0f, 0.0f, f);
                Quaternion quaternion = EulerAngles.toQuaternion-impl(eulerOrder, 0.0f, 0.0f, f);
                this.tracker.setRotation-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                EulerOrder eulerOrder = EulerOrder.YZX;
                float f = this.thumbInitialOffset - angle;
                float f2 = -angle * 0.05f;
                float f3 = angle * 0.1f;
                EulerAngles.constructor-impl(eulerOrder, f, f2, f3);
                Quaternion quaternion = EulerAngles.toQuaternion-impl(eulerOrder, f, f2, f3);
                this.tracker.setRotation-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                EulerOrder eulerOrder = EulerOrder.YZX;
                float f = this.thumbInitialOffset - angle;
                float f4 = angle * 0.05f;
                float f5 = -angle * 0.1f;
                EulerAngles.constructor-impl(eulerOrder, f, f4, f5);
                Quaternion quaternion = EulerAngles.toQuaternion-impl(eulerOrder, f, f4, f5);
                this.tracker.setRotation-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
                break;
            }
            default: {
                EulerOrder eulerOrder = EulerOrder.YZX;
                EulerAngles.constructor-impl(eulerOrder, angle, 0.0f, 0.0f);
                Quaternion quaternion = EulerAngles.toQuaternion-impl(eulerOrder, angle, 0.0f, 0.0f);
                this.tracker.setRotation-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
            }
        }
    }

    private final float getMaxAngleForTrackerPosition(TrackerPosition trackerPosition) {
        if (trackerPosition == null) {
            return (float)Math.PI;
        }
        TrackerPosition trackerPosition2 = trackerPosition;
        return switch (WhenMappings.$EnumSwitchMapping$0[trackerPosition2.ordinal()]) {
            case 3, 6, 9, 12, 16, 19, 22, 25 -> 4.712389f;
            case 29, 32 -> (float)Math.PI + this.thumbInitialOffset;
            case 2, 5, 8, 11, 15, 18, 21, 24 -> (float)Math.PI;
            case 28, 31 -> 1.5707964f + this.thumbInitialOffset;
            case 1, 4, 7, 10, 14, 17, 20, 23 -> 1.5707964f;
            case 27, 30 -> 0.7853982f + this.thumbInitialOffset;
            case 13, 26 -> 0.7853982f;
            default -> 2.3561945f;
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackerPosition.values().length];
            try {
                nArray[TrackerPosition.LEFT_INDEX_PROXIMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_INDEX_INTERMEDIATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_INDEX_DISTAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_MIDDLE_PROXIMAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_MIDDLE_INTERMEDIATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_MIDDLE_DISTAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_RING_PROXIMAL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_RING_INTERMEDIATE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_RING_DISTAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_LITTLE_PROXIMAL.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_LITTLE_INTERMEDIATE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_LITTLE_DISTAL.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_SHOULDER.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_INDEX_PROXIMAL.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_INDEX_INTERMEDIATE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_INDEX_DISTAL.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_MIDDLE_PROXIMAL.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_MIDDLE_INTERMEDIATE.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_MIDDLE_DISTAL.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_RING_PROXIMAL.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_RING_INTERMEDIATE.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_RING_DISTAL.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_LITTLE_PROXIMAL.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_LITTLE_INTERMEDIATE.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_LITTLE_DISTAL.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_SHOULDER.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_THUMB_METACARPAL.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_THUMB_PROXIMAL.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.LEFT_THUMB_DISTAL.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_THUMB_METACARPAL.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_THUMB_PROXIMAL.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackerPosition.RIGHT_THUMB_DISTAL.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

