/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.trackers;

import dev.slimevr.VRServer;
import dev.slimevr.config.ArmsResetModes;
import dev.slimevr.config.DriftCompensationConfig;
import dev.slimevr.config.ResetsConfig;
import dev.slimevr.filtering.CircularArrayList;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerPosition;
import dev.slimevr.tracking.trackers.TrackerPositionKt;
import dev.slimevr.tracking.trackers.TrackerUtils;
import dev.slimevr.tracking.trackers.udp.TrackerDataType;
import dev.slimevr.util.InterpolationHandler;
import io.github.axisangles.ktmath.EulerAngles;
import io.github.axisangles.ktmath.EulerOrder;
import io.github.axisangles.ktmath.Matrix3;
import io.github.axisangles.ktmath.Quaternion;
import io.github.axisangles.ktmath.Vector3;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b:\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020cJ\u0006\u0010d\u001a\u00020aJ\u0006\u0010e\u001a\u00020aJ\u000e\u0010f\u001a\u00020a2\u0006\u0010b\u001a\u00020gJ\u0015\u0010h\u001a\u00020a2\u0006\u0010i\u001a\u00020\t\u00a2\u0006\u0004\bj\u0010\u0013J\u0015\u0010k\u001a\u00020\t2\u0006\u0010l\u001a\u00020\t\u00a2\u0006\u0004\bm\u0010nJ\u0015\u0010o\u001a\u00020\t2\u0006\u0010l\u001a\u00020\t\u00a2\u0006\u0004\bp\u0010nJ\u001d\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020\t2\u0006\u0010t\u001a\u00020r\u00a2\u0006\u0004\bu\u0010vJ\u0017\u0010w\u001a\u00020\t2\u0006\u0010l\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bx\u0010nJ\u0017\u0010y\u001a\u00020\t2\u0006\u0010l\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bz\u0010nJ\u0017\u0010{\u001a\u00020\t2\u0006\u0010l\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b|\u0010nJ\u0015\u0010}\u001a\u00020a2\u0006\u0010~\u001a\u00020\t\u00a2\u0006\u0004\b\u007f\u0010\u0013J\u0019\u0010\u0080\u0001\u001a\u00020a2\u0006\u0010~\u001a\u00020\tH\u0002\u00a2\u0006\u0005\b\u0081\u0001\u0010\u0013J\u0017\u0010\u0082\u0001\u001a\u00020a2\u0006\u0010~\u001a\u00020\t\u00a2\u0006\u0005\b\u0083\u0001\u0010\u0013J#\u0010\u0084\u0001\u001a\u00020a2\u0006\u0010~\u001a\u00020\t2\t\b\u0002\u0010\u0085\u0001\u001a\u00020!\u00a2\u0006\u0006\b\u0086\u0001\u0010\u0087\u0001J\u0018\u0010\u0088\u0001\u001a\u00020a2\u0007\u0010\u0089\u0001\u001a\u00020\t\u00a2\u0006\u0005\b\u008a\u0001\u0010\u0013J\u0007\u0010\u008b\u0001\u001a\u00020aJ\u001a\u0010\u008c\u0001\u001a\u00020\t2\u0007\u0010\u008d\u0001\u001a\u00020\tH\u0002\u00a2\u0006\u0005\b\u008e\u0001\u0010nJ\u001a\u0010\u008f\u0001\u001a\u00020\t2\u0007\u0010\u008d\u0001\u001a\u00020\tH\u0002\u00a2\u0006\u0005\b\u0090\u0001\u0010nJ#\u0010\u0091\u0001\u001a\u00020\t2\u0007\u0010\u008d\u0001\u001a\u00020\t2\u0006\u0010~\u001a\u00020\tH\u0002\u00a2\u0006\u0006\b\u0092\u0001\u0010\u0093\u0001J\u001a\u0010\u0094\u0001\u001a\u00020\t2\u0007\u0010\u0095\u0001\u001a\u00020\tH\u0002\u00a2\u0006\u0005\b\u0096\u0001\u0010nJ\t\u0010\u0097\u0001\u001a\u00020aH\u0002J\t\u0010\u0098\u0001\u001a\u00020aH\u0002J\u001a\u0010\u0099\u0001\u001a\u00020a2\u0007\u0010\u009a\u0001\u001a\u00020\tH\u0002\u00a2\u0006\u0005\b\u009b\u0001\u0010\u0013J3\u0010\u009c\u0001\u001a\u00020\t2\r\u0010\u009d\u0001\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u0019\u0010\u009e\u0001\u001a\u0014\u0012\u0004\u0012\u00020\u000f0\u009f\u0001j\t\u0012\u0004\u0012\u00020\u000f`\u00a0\u0001H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\r\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\r\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R\u001a\u00100\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010*\"\u0004\b2\u0010,R\u001c\u00103\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u000b\"\u0004\b5\u00106R(\u00108\u001a\u00020\t2\u0006\u00107\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010\r\u001a\u0004\b9\u0010\u000b\"\u0004\b:\u0010\u0013R\u001e\u0010<\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010\r\u001a\u0004\b=\u0010\u000b\"\u0004\b>\u0010\u0013R\u001e\u0010@\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0012\n\u0004\bC\u0010\r\u001a\u0004\bA\u0010\u000b\"\u0004\bB\u0010\u0013R(\u0010D\u001a\u00020\t2\u0006\u00107\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bG\u0010\r\u001a\u0004\bE\u0010\u000b\"\u0004\bF\u0010\u0013R\u001e\u0010H\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010\r\u001a\u0004\bI\u0010\u000b\"\u0004\bJ\u0010\u0013R\u001e\u0010L\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0012\n\u0004\bO\u0010\r\u001a\u0004\bM\u0010\u000b\"\u0004\bN\u0010\u0013R\u001e\u0010P\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0012\n\u0004\bS\u0010\r\u001a\u0004\bQ\u0010\u000b\"\u0004\bR\u0010\u0013R\u001e\u0010T\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010\r\u001a\u0004\bU\u0010\u000b\"\u0004\bV\u0010\u0013R\u001e\u0010X\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0012\n\u0004\b[\u0010\r\u001a\u0004\bY\u0010\u000b\"\u0004\bZ\u0010\u0013R\u001e\u0010\\\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0012\n\u0004\b_\u0010\r\u001a\u0004\b]\u0010\u000b\"\u0004\b^\u0010\u0013\u00a8\u0006\u00a1\u0001"}, d2={"Ldev/slimevr/tracking/trackers/TrackerResetsHandler;", "", "tracker", "Ldev/slimevr/tracking/trackers/Tracker;", "<init>", "(Ldev/slimevr/tracking/trackers/Tracker;)V", "getTracker", "()Ldev/slimevr/tracking/trackers/Tracker;", "HalfHorizontal", "Lio/github/axisangles/ktmath/Quaternion;", "getHalfHorizontal", "()Lio/github/axisangles/ktmath/Quaternion;", "HalfHorizontal-w", "F", "driftAmount", "", "averagedDriftQuat", "getAveragedDriftQuat", "setAveragedDriftQuat-oS71L7k", "(FFFF)V", "averagedDriftQuat-w", "rotationSinceReset", "getRotationSinceReset", "setRotationSinceReset-oS71L7k", "rotationSinceReset-w", "driftQuats", "Ldev/slimevr/filtering/CircularArrayList;", "driftTimes", "", "totalDriftTime", "driftSince", "timeAtLastReset", "compensateDrift", "", "driftPrediction", "driftCompensationEnabled", "resetMountingFeet", "armsResetMode", "Ldev/slimevr/config/ArmsResetModes;", "yawResetSmoothTime", "saveMountingReset", "getSaveMountingReset", "()Z", "setSaveMountingReset", "(Z)V", "resetHmdPitch", "getResetHmdPitch", "setResetHmdPitch", "allowDriftCompensation", "getAllowDriftCompensation", "setAllowDriftCompensation", "lastResetQuaternion", "getLastResetQuaternion", "setLastResetQuaternion", "(Lio/github/axisangles/ktmath/Quaternion;)V", "value", "mountingOrientation", "getMountingOrientation", "setMountingOrientation-oS71L7k", "mountingOrientation-w", "gyroFix", "getGyroFix", "setGyroFix-oS71L7k", "gyroFix-w", "attachmentFix", "getAttachmentFix", "setAttachmentFix-oS71L7k", "attachmentFix-w", "mountRotFix", "getMountRotFix", "setMountRotFix-oS71L7k", "mountRotFix-w", "yawFix", "getYawFix", "setYawFix-oS71L7k", "yawFix-w", "constraintFix", "getConstraintFix", "setConstraintFix-oS71L7k", "constraintFix-w", "gyroFixNoMounting", "getGyroFixNoMounting", "setGyroFixNoMounting-oS71L7k", "gyroFixNoMounting-w", "attachmentFixNoMounting", "getAttachmentFixNoMounting", "setAttachmentFixNoMounting-oS71L7k", "attachmentFixNoMounting-w", "yawFixZeroReference", "getYawFixZeroReference", "setYawFixZeroReference-oS71L7k", "yawFixZeroReference-w", "tposeDownFix", "getTposeDownFix", "setTposeDownFix-oS71L7k", "tposeDownFix-w", "readDriftCompensationConfig", "", "config", "Ldev/slimevr/config/DriftCompensationConfig;", "clearDriftCompensation", "refreshDriftCompensationEnabled", "readResetConfig", "Ldev/slimevr/config/ResetsConfig;", "trySetMountingReset", "quat", "trySetMountingReset-oS71L7k", "getReferenceAdjustedDriftRotationFrom", "rotation", "getReferenceAdjustedDriftRotationFrom-oS71L7k", "(FFFF)Lio/github/axisangles/ktmath/Quaternion;", "getIdentityAdjustedDriftRotationFrom", "getIdentityAdjustedDriftRotationFrom-oS71L7k", "getReferenceAdjustedAccel", "Lio/github/axisangles/ktmath/Vector3;", "rawRot", "accel", "getReferenceAdjustedAccel-CiqQXDU", "(FFFFFFF)Lio/github/axisangles/ktmath/Vector3;", "adjustToReference", "adjustToReference-oS71L7k", "adjustToIdentity", "adjustToIdentity-oS71L7k", "adjustToDrift", "adjustToDrift-oS71L7k", "resetFull", "reference", "resetFull-oS71L7k", "postProcessResetFull", "postProcessResetFull-oS71L7k", "resetYaw", "resetYaw-oS71L7k", "resetMounting", "forceFeet", "resetMounting-jCQAsEA", "(FFFFZ)V", "updateConstraintFix", "correctedRotation", "updateConstraintFix-oS71L7k", "clearMounting", "fixGyroscope", "sensorRotation", "fixGyroscope-oS71L7k", "fixAttachment", "fixAttachment-oS71L7k", "fixYaw", "fixYaw-T8bZSfw", "(FFFFFFFF)Lio/github/axisangles/ktmath/Quaternion;", "getYawQuaternion", "rot", "getYawQuaternion-oS71L7k", "makeIdentityAdjustmentQuatsFull", "makeIdentityAdjustmentQuatsYaw", "calculateDrift", "beforeQuat", "calculateDrift-oS71L7k", "fromAveragedQuaternions", "qn", "tn", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "core"})
public final class TrackerResetsHandler {
    @NotNull
    private final Tracker tracker;
    private final float HalfHorizontal-w;
    private final float HalfHorizontal-x;
    private final float HalfHorizontal-y;
    private final float HalfHorizontal-z;
    private float driftAmount;
    private float averagedDriftQuat-w;
    private float averagedDriftQuat-x;
    private float averagedDriftQuat-y;
    private float averagedDriftQuat-z;
    private float rotationSinceReset-w;
    private float rotationSinceReset-x;
    private float rotationSinceReset-y;
    private float rotationSinceReset-z;
    @NotNull
    private CircularArrayList<Quaternion> driftQuats;
    @NotNull
    private CircularArrayList<Long> driftTimes;
    private long totalDriftTime;
    private long driftSince;
    private long timeAtLastReset;
    private boolean compensateDrift;
    private boolean driftPrediction;
    private boolean driftCompensationEnabled;
    private boolean resetMountingFeet;
    @NotNull
    private ArmsResetModes armsResetMode;
    private float yawResetSmoothTime;
    private boolean saveMountingReset;
    private boolean resetHmdPitch;
    private boolean allowDriftCompensation;
    @Nullable
    private Quaternion lastResetQuaternion;
    private float mountingOrientation-w;
    private float mountingOrientation-x;
    private float mountingOrientation-y;
    private float mountingOrientation-z;
    private float gyroFix-w;
    private float gyroFix-x;
    private float gyroFix-y;
    private float gyroFix-z;
    private float attachmentFix-w;
    private float attachmentFix-x;
    private float attachmentFix-y;
    private float attachmentFix-z;
    private float mountRotFix-w;
    private float mountRotFix-x;
    private float mountRotFix-y;
    private float mountRotFix-z;
    private float yawFix-w;
    private float yawFix-x;
    private float yawFix-y;
    private float yawFix-z;
    private float constraintFix-w;
    private float constraintFix-x;
    private float constraintFix-y;
    private float constraintFix-z;
    private float gyroFixNoMounting-w;
    private float gyroFixNoMounting-x;
    private float gyroFixNoMounting-y;
    private float gyroFixNoMounting-z;
    private float attachmentFixNoMounting-w;
    private float attachmentFixNoMounting-x;
    private float attachmentFixNoMounting-y;
    private float attachmentFixNoMounting-z;
    private float yawFixZeroReference-w;
    private float yawFixZeroReference-x;
    private float yawFixZeroReference-y;
    private float yawFixZeroReference-z;
    private float tposeDownFix-w;
    private float tposeDownFix-x;
    private float tposeDownFix-y;
    private float tposeDownFix-z;

    public TrackerResetsHandler(@NotNull Tracker tracker) {
        Intrinsics.checkNotNullParameter(tracker, "tracker");
        this.tracker = tracker;
        EulerOrder eulerOrder = EulerOrder.YZX;
        EulerAngles.constructor-impl(eulerOrder, 0.0f, (float)Math.PI, 0.0f);
        Object object = EulerAngles.toQuaternion-impl(eulerOrder, 0.0f, (float)Math.PI, 0.0f);
        this.HalfHorizontal-w = ((Quaternion)object).unbox-impl-w();
        this.HalfHorizontal-x = ((Quaternion)object).unbox-impl-x();
        this.HalfHorizontal-y = ((Quaternion)object).unbox-impl-y();
        this.HalfHorizontal-z = ((Quaternion)object).unbox-impl-z();
        object = Quaternion.Companion;
        this.averagedDriftQuat-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this.averagedDriftQuat-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this.averagedDriftQuat-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this.averagedDriftQuat-z = ((Quaternion.Companion)object).getIDENTITY-z();
        object = Quaternion.Companion;
        this.rotationSinceReset-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this.rotationSinceReset-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this.rotationSinceReset-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this.rotationSinceReset-z = ((Quaternion.Companion)object).getIDENTITY-z();
        this.driftQuats = new CircularArrayList(0);
        this.driftTimes = new CircularArrayList(0);
        this.armsResetMode = ArmsResetModes.BACK;
        this.mountingOrientation-w = this.HalfHorizontal-w;
        this.mountingOrientation-x = this.HalfHorizontal-x;
        this.mountingOrientation-y = this.HalfHorizontal-y;
        this.mountingOrientation-z = this.HalfHorizontal-z;
        object = Quaternion.Companion;
        this.gyroFix-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this.gyroFix-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this.gyroFix-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this.gyroFix-z = ((Quaternion.Companion)object).getIDENTITY-z();
        object = Quaternion.Companion;
        this.attachmentFix-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this.attachmentFix-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this.attachmentFix-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this.attachmentFix-z = ((Quaternion.Companion)object).getIDENTITY-z();
        object = Quaternion.Companion;
        this.mountRotFix-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this.mountRotFix-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this.mountRotFix-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this.mountRotFix-z = ((Quaternion.Companion)object).getIDENTITY-z();
        object = Quaternion.Companion;
        this.yawFix-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this.yawFix-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this.yawFix-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this.yawFix-z = ((Quaternion.Companion)object).getIDENTITY-z();
        object = Quaternion.Companion;
        this.constraintFix-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this.constraintFix-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this.constraintFix-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this.constraintFix-z = ((Quaternion.Companion)object).getIDENTITY-z();
        object = Quaternion.Companion;
        this.gyroFixNoMounting-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this.gyroFixNoMounting-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this.gyroFixNoMounting-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this.gyroFixNoMounting-z = ((Quaternion.Companion)object).getIDENTITY-z();
        object = Quaternion.Companion;
        this.attachmentFixNoMounting-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this.attachmentFixNoMounting-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this.attachmentFixNoMounting-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this.attachmentFixNoMounting-z = ((Quaternion.Companion)object).getIDENTITY-z();
        object = Quaternion.Companion;
        this.yawFixZeroReference-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this.yawFixZeroReference-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this.yawFixZeroReference-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this.yawFixZeroReference-z = ((Quaternion.Companion)object).getIDENTITY-z();
        object = Quaternion.Companion;
        this.tposeDownFix-w = ((Quaternion.Companion)object).getIDENTITY-w();
        this.tposeDownFix-x = ((Quaternion.Companion)object).getIDENTITY-x();
        this.tposeDownFix-y = ((Quaternion.Companion)object).getIDENTITY-y();
        this.tposeDownFix-z = ((Quaternion.Companion)object).getIDENTITY-z();
    }

    @NotNull
    public final Tracker getTracker() {
        return this.tracker;
    }

    private final Quaternion getHalfHorizontal() {
        return Quaternion.box-impl(this.HalfHorizontal-w, this.HalfHorizontal-x, this.HalfHorizontal-y, this.HalfHorizontal-z);
    }

    private final Quaternion getAveragedDriftQuat() {
        return Quaternion.box-impl(this.averagedDriftQuat-w, this.averagedDriftQuat-x, this.averagedDriftQuat-y, this.averagedDriftQuat-z);
    }

    private final void setAveragedDriftQuat-oS71L7k(float f, float f2, float f3, float f4) {
        this.averagedDriftQuat-w = f;
        this.averagedDriftQuat-x = f2;
        this.averagedDriftQuat-y = f3;
        this.averagedDriftQuat-z = f4;
    }

    private final Quaternion getRotationSinceReset() {
        return Quaternion.box-impl(this.rotationSinceReset-w, this.rotationSinceReset-x, this.rotationSinceReset-y, this.rotationSinceReset-z);
    }

    private final void setRotationSinceReset-oS71L7k(float f, float f2, float f3, float f4) {
        this.rotationSinceReset-w = f;
        this.rotationSinceReset-x = f2;
        this.rotationSinceReset-y = f3;
        this.rotationSinceReset-z = f4;
    }

    public final boolean getSaveMountingReset() {
        return this.saveMountingReset;
    }

    public final void setSaveMountingReset(boolean bl) {
        this.saveMountingReset = bl;
    }

    public final boolean getResetHmdPitch() {
        return this.resetHmdPitch;
    }

    public final void setResetHmdPitch(boolean bl) {
        this.resetHmdPitch = bl;
    }

    public final boolean getAllowDriftCompensation() {
        return this.allowDriftCompensation;
    }

    public final void setAllowDriftCompensation(boolean bl) {
        this.allowDriftCompensation = bl;
    }

    @Nullable
    public final Quaternion getLastResetQuaternion() {
        return this.lastResetQuaternion;
    }

    public final void setLastResetQuaternion(@Nullable Quaternion quaternion) {
        this.lastResetQuaternion = quaternion;
    }

    @NotNull
    public final Quaternion getMountingOrientation() {
        return Quaternion.box-impl(this.mountingOrientation-w, this.mountingOrientation-x, this.mountingOrientation-y, this.mountingOrientation-z);
    }

    public final void setMountingOrientation-oS71L7k(float f, float f2, float f3, float f4) {
        this.mountingOrientation-w = f;
        this.mountingOrientation-x = f2;
        this.mountingOrientation-y = f3;
        this.mountingOrientation-z = f4;
        this.clearMounting();
    }

    private final Quaternion getGyroFix() {
        return Quaternion.box-impl(this.gyroFix-w, this.gyroFix-x, this.gyroFix-y, this.gyroFix-z);
    }

    private final void setGyroFix-oS71L7k(float f, float f2, float f3, float f4) {
        this.gyroFix-w = f;
        this.gyroFix-x = f2;
        this.gyroFix-y = f3;
        this.gyroFix-z = f4;
    }

    private final Quaternion getAttachmentFix() {
        return Quaternion.box-impl(this.attachmentFix-w, this.attachmentFix-x, this.attachmentFix-y, this.attachmentFix-z);
    }

    private final void setAttachmentFix-oS71L7k(float f, float f2, float f3, float f4) {
        this.attachmentFix-w = f;
        this.attachmentFix-x = f2;
        this.attachmentFix-y = f3;
        this.attachmentFix-z = f4;
    }

    @NotNull
    public final Quaternion getMountRotFix() {
        return Quaternion.box-impl(this.mountRotFix-w, this.mountRotFix-x, this.mountRotFix-y, this.mountRotFix-z);
    }

    private final void setMountRotFix-oS71L7k(float f, float f2, float f3, float f4) {
        this.mountRotFix-w = f;
        this.mountRotFix-x = f2;
        this.mountRotFix-y = f3;
        this.mountRotFix-z = f4;
    }

    private final Quaternion getYawFix() {
        return Quaternion.box-impl(this.yawFix-w, this.yawFix-x, this.yawFix-y, this.yawFix-z);
    }

    private final void setYawFix-oS71L7k(float f, float f2, float f3, float f4) {
        this.yawFix-w = f;
        this.yawFix-x = f2;
        this.yawFix-y = f3;
        this.yawFix-z = f4;
    }

    private final Quaternion getConstraintFix() {
        return Quaternion.box-impl(this.constraintFix-w, this.constraintFix-x, this.constraintFix-y, this.constraintFix-z);
    }

    private final void setConstraintFix-oS71L7k(float f, float f2, float f3, float f4) {
        this.constraintFix-w = f;
        this.constraintFix-x = f2;
        this.constraintFix-y = f3;
        this.constraintFix-z = f4;
    }

    private final Quaternion getGyroFixNoMounting() {
        return Quaternion.box-impl(this.gyroFixNoMounting-w, this.gyroFixNoMounting-x, this.gyroFixNoMounting-y, this.gyroFixNoMounting-z);
    }

    private final void setGyroFixNoMounting-oS71L7k(float f, float f2, float f3, float f4) {
        this.gyroFixNoMounting-w = f;
        this.gyroFixNoMounting-x = f2;
        this.gyroFixNoMounting-y = f3;
        this.gyroFixNoMounting-z = f4;
    }

    private final Quaternion getAttachmentFixNoMounting() {
        return Quaternion.box-impl(this.attachmentFixNoMounting-w, this.attachmentFixNoMounting-x, this.attachmentFixNoMounting-y, this.attachmentFixNoMounting-z);
    }

    private final void setAttachmentFixNoMounting-oS71L7k(float f, float f2, float f3, float f4) {
        this.attachmentFixNoMounting-w = f;
        this.attachmentFixNoMounting-x = f2;
        this.attachmentFixNoMounting-y = f3;
        this.attachmentFixNoMounting-z = f4;
    }

    private final Quaternion getYawFixZeroReference() {
        return Quaternion.box-impl(this.yawFixZeroReference-w, this.yawFixZeroReference-x, this.yawFixZeroReference-y, this.yawFixZeroReference-z);
    }

    private final void setYawFixZeroReference-oS71L7k(float f, float f2, float f3, float f4) {
        this.yawFixZeroReference-w = f;
        this.yawFixZeroReference-x = f2;
        this.yawFixZeroReference-y = f3;
        this.yawFixZeroReference-z = f4;
    }

    private final Quaternion getTposeDownFix() {
        return Quaternion.box-impl(this.tposeDownFix-w, this.tposeDownFix-x, this.tposeDownFix-y, this.tposeDownFix-z);
    }

    private final void setTposeDownFix-oS71L7k(float f, float f2, float f3, float f4) {
        this.tposeDownFix-w = f;
        this.tposeDownFix-x = f2;
        this.tposeDownFix-y = f3;
        this.tposeDownFix-z = f4;
    }

    public final void readDriftCompensationConfig(@NotNull DriftCompensationConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        this.compensateDrift = false;
        this.driftPrediction = config.getPrediction();
        this.driftAmount = config.getAmount();
        int maxResets = config.getMaxResets();
        if (this.compensateDrift && maxResets != this.driftQuats.capacity()) {
            this.driftQuats = new CircularArrayList(maxResets);
            this.driftTimes = new CircularArrayList(maxResets);
        }
        this.refreshDriftCompensationEnabled();
    }

    public final void clearDriftCompensation() {
        this.driftSince = 0L;
        this.timeAtLastReset = 0L;
        this.totalDriftTime = 0L;
        this.driftQuats.clear();
        this.driftTimes.clear();
    }

    public final void refreshDriftCompensationEnabled() {
        this.driftCompensationEnabled = this.compensateDrift && this.allowDriftCompensation && TrackerUtils.getNonInternalNonImuTrackerForBodyPosition(VRServer.Companion.getInstance().getAllTrackers(), TrackerPosition.HEAD) != null;
    }

    public final void readResetConfig(@NotNull ResetsConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        this.resetMountingFeet = config.getResetMountingFeet();
        this.armsResetMode = config.getMode();
        this.yawResetSmoothTime = config.getYawResetSmoothTime();
        this.saveMountingReset = config.getSaveMountingReset();
        this.resetHmdPitch = config.getResetHmdPitch();
    }

    public final void trySetMountingReset-oS71L7k(float f, float f2, float f3, float f4) {
        if (this.saveMountingReset) {
            this.setMountRotFix-oS71L7k(f, f2, f3, f4);
        }
    }

    @NotNull
    public final Quaternion getReferenceAdjustedDriftRotationFrom-oS71L7k(float f, float f2, float f3, float f4) {
        Quaternion quaternion = this.adjustToReference-oS71L7k(f, f2, f3, f4);
        return this.adjustToDrift-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
    }

    @NotNull
    public final Quaternion getIdentityAdjustedDriftRotationFrom-oS71L7k(float f, float f2, float f3, float f4) {
        Quaternion quaternion = this.adjustToIdentity-oS71L7k(f, f2, f3, f4);
        return this.adjustToDrift-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
    }

    @NotNull
    public final Vector3 getReferenceAdjustedAccel-CiqQXDU(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        Quaternion quaternion = this.adjustToReference-oS71L7k(f, f2, f3, f4);
        Quaternion quaternion2 = Quaternion.div-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z(), this.yawFix-w, this.yawFix-x, this.yawFix-y, this.yawFix-z);
        return Quaternion.sandwich-1s-5YWc(quaternion2.unbox-impl-w(), quaternion2.unbox-impl-x(), quaternion2.unbox-impl-y(), quaternion2.unbox-impl-z(), f5, f6, f7);
    }

    private final Quaternion adjustToReference-oS71L7k(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7;
        float f8;
        Quaternion quaternion;
        float f9 = f;
        float f10 = f2;
        float f11 = f3;
        float f12 = f4;
        if (!this.tracker.isHmd() || this.tracker.getTrackerPosition() != TrackerPosition.HEAD) {
            quaternion = Quaternion.times-oS71L7k(f9, f10, f11, f12, this.mountingOrientation-w, this.mountingOrientation-x, this.mountingOrientation-y, this.mountingOrientation-z);
            f8 = quaternion.unbox-impl-w();
            f7 = quaternion.unbox-impl-x();
            f6 = quaternion.unbox-impl-y();
            f5 = quaternion.unbox-impl-z();
            f9 = f8;
            f10 = f7;
            f11 = f6;
            f12 = f5;
        }
        quaternion = Quaternion.times-oS71L7k(this.gyroFix-w, this.gyroFix-x, this.gyroFix-y, this.gyroFix-z, f9, f10, f11, f12);
        f8 = quaternion.unbox-impl-w();
        f7 = quaternion.unbox-impl-x();
        f6 = quaternion.unbox-impl-y();
        f5 = quaternion.unbox-impl-z();
        f9 = f8;
        f10 = f7;
        f11 = f6;
        f12 = f5;
        Quaternion quaternion2 = Quaternion.times-oS71L7k(f9, f10, f11, f12, this.attachmentFix-w, this.attachmentFix-x, this.attachmentFix-y, this.attachmentFix-z);
        f7 = quaternion2.unbox-impl-w();
        f6 = quaternion2.unbox-impl-x();
        f5 = quaternion2.unbox-impl-y();
        float f13 = quaternion2.unbox-impl-z();
        f9 = f7;
        f10 = f6;
        f11 = f5;
        f12 = f13;
        Quaternion quaternion3 = Quaternion.inv-impl(this.mountRotFix-w, this.mountRotFix-x, this.mountRotFix-y, this.mountRotFix-z);
        Quaternion quaternion4 = Quaternion.times-oS71L7k(f9, f10, f11, f12, this.mountRotFix-w, this.mountRotFix-x, this.mountRotFix-y, this.mountRotFix-z);
        Quaternion quaternion5 = Quaternion.times-oS71L7k(quaternion3.unbox-impl-w(), quaternion3.unbox-impl-x(), quaternion3.unbox-impl-y(), quaternion3.unbox-impl-z(), quaternion4.unbox-impl-w(), quaternion4.unbox-impl-x(), quaternion4.unbox-impl-y(), quaternion4.unbox-impl-z());
        float f14 = quaternion5.unbox-impl-w();
        float f15 = quaternion5.unbox-impl-x();
        f13 = quaternion5.unbox-impl-y();
        float f16 = quaternion5.unbox-impl-z();
        f9 = f14;
        f10 = f15;
        f11 = f13;
        f12 = f16;
        Quaternion quaternion6 = Quaternion.times-oS71L7k(f9, f10, f11, f12, this.tposeDownFix-w, this.tposeDownFix-x, this.tposeDownFix-y, this.tposeDownFix-z);
        f15 = quaternion6.unbox-impl-w();
        f13 = quaternion6.unbox-impl-x();
        f16 = quaternion6.unbox-impl-y();
        float f17 = quaternion6.unbox-impl-z();
        f9 = f15;
        f10 = f13;
        f11 = f16;
        f12 = f17;
        Quaternion quaternion7 = Quaternion.times-oS71L7k(this.yawFix-w, this.yawFix-x, this.yawFix-y, this.yawFix-z, f9, f10, f11, f12);
        f13 = quaternion7.unbox-impl-w();
        f16 = quaternion7.unbox-impl-x();
        f17 = quaternion7.unbox-impl-y();
        float f18 = quaternion7.unbox-impl-z();
        f9 = f13;
        f10 = f16;
        f11 = f17;
        f12 = f18;
        Quaternion quaternion8 = Quaternion.times-oS71L7k(this.constraintFix-w, this.constraintFix-x, this.constraintFix-y, this.constraintFix-z, f9, f10, f11, f12);
        f16 = quaternion8.unbox-impl-w();
        f17 = quaternion8.unbox-impl-x();
        f18 = quaternion8.unbox-impl-y();
        float f19 = quaternion8.unbox-impl-z();
        f9 = f16;
        f10 = f17;
        f11 = f18;
        f12 = f19;
        return Quaternion.box-impl(f9, f10, f11, f12);
    }

    private final Quaternion adjustToIdentity-oS71L7k(float f, float f2, float f3, float f4) {
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        Quaternion quaternion = Quaternion.times-oS71L7k(this.gyroFixNoMounting-w, this.gyroFixNoMounting-x, this.gyroFixNoMounting-y, this.gyroFixNoMounting-z, f5, f6, f7, f8);
        float f9 = quaternion.unbox-impl-w();
        float f10 = quaternion.unbox-impl-x();
        float f11 = quaternion.unbox-impl-y();
        float f12 = quaternion.unbox-impl-z();
        f5 = f9;
        f6 = f10;
        f7 = f11;
        f8 = f12;
        Quaternion quaternion2 = Quaternion.times-oS71L7k(f5, f6, f7, f8, this.attachmentFixNoMounting-w, this.attachmentFixNoMounting-x, this.attachmentFixNoMounting-y, this.attachmentFixNoMounting-z);
        f10 = quaternion2.unbox-impl-w();
        f11 = quaternion2.unbox-impl-x();
        f12 = quaternion2.unbox-impl-y();
        float f13 = quaternion2.unbox-impl-z();
        f5 = f10;
        f6 = f11;
        f7 = f12;
        f8 = f13;
        Quaternion quaternion3 = Quaternion.times-oS71L7k(this.yawFixZeroReference-w, this.yawFixZeroReference-x, this.yawFixZeroReference-y, this.yawFixZeroReference-z, f5, f6, f7, f8);
        f11 = quaternion3.unbox-impl-w();
        f12 = quaternion3.unbox-impl-x();
        f13 = quaternion3.unbox-impl-y();
        float f14 = quaternion3.unbox-impl-z();
        f5 = f11;
        f6 = f12;
        f7 = f13;
        f8 = f14;
        Quaternion quaternion4 = Quaternion.times-oS71L7k(this.constraintFix-w, this.constraintFix-x, this.constraintFix-y, this.constraintFix-z, f5, f6, f7, f8);
        f12 = quaternion4.unbox-impl-w();
        f13 = quaternion4.unbox-impl-x();
        f14 = quaternion4.unbox-impl-y();
        float f15 = quaternion4.unbox-impl-z();
        f5 = f12;
        f6 = f13;
        f7 = f14;
        f8 = f15;
        return Quaternion.box-impl(f5, f6, f7, f8);
    }

    private final Quaternion adjustToDrift-oS71L7k(float f, float f2, float f3, float f4) {
        if (this.driftCompensationEnabled && this.totalDriftTime > 0L) {
            float driftTimeRatio = (float)(System.currentTimeMillis() - this.driftSince) / (float)this.totalDriftTime;
            if (!this.driftPrediction) {
                driftTimeRatio = Math.min(1.0f, driftTimeRatio);
            }
            Quaternion quaternion = Quaternion.pow-impl(this.averagedDriftQuat-w, this.averagedDriftQuat-x, this.averagedDriftQuat-y, this.averagedDriftQuat-z, this.driftAmount * driftTimeRatio);
            return Quaternion.times-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z(), f, f2, f3, f4);
        }
        return Quaternion.box-impl(f, f2, f3, f4);
    }

    public final void resetFull-oS71L7k(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7;
        float f8;
        Quaternion quaternion;
        Quaternion quaternion2;
        float f9;
        float f10;
        float f11;
        float f12;
        Object object;
        Quaternion.Companion companion = Quaternion.Companion;
        this.setConstraintFix-oS71L7k(companion.getIDENTITY-w(), companion.getIDENTITY-x(), companion.getIDENTITY-y(), companion.getIDENTITY-z());
        if (this.tracker.getTrackerDataType() == TrackerDataType.FLEX_RESISTANCE) {
            this.tracker.getTrackerFlexHandler().resetMin();
            this.postProcessResetFull-oS71L7k(f, f2, f3, f4);
            return;
        }
        if (this.tracker.getTrackerDataType() == TrackerDataType.FLEX_ANGLE) {
            this.postProcessResetFull-oS71L7k(f, f2, f3, f4);
            return;
        }
        if ((TrackerPositionKt.isLeftArm(this.tracker.getTrackerPosition()) || TrackerPositionKt.isLeftFinger(this.tracker.getTrackerPosition())) && this.armsResetMode == ArmsResetModes.TPOSE_DOWN) {
            object = EulerOrder.YZX;
            EulerAngles.constructor-impl((EulerOrder)((Object)object), 0.0f, 0.0f, -1.5707964f);
            var10_7 = EulerAngles.toQuaternion-impl((EulerOrder)((Object)object), 0.0f, 0.0f, -1.5707964f);
            f12 = ((Quaternion)var10_7).unbox-impl-w();
            f11 = ((Quaternion)var10_7).unbox-impl-x();
            f10 = ((Quaternion)var10_7).unbox-impl-y();
            f9 = ((Quaternion)var10_7).unbox-impl-z();
        } else if ((TrackerPositionKt.isRightArm(this.tracker.getTrackerPosition()) || TrackerPositionKt.isRightFinger(this.tracker.getTrackerPosition())) && this.armsResetMode == ArmsResetModes.TPOSE_DOWN) {
            object = EulerOrder.YZX;
            EulerAngles.constructor-impl((EulerOrder)((Object)object), 0.0f, 0.0f, 1.5707964f);
            var10_7 = EulerAngles.toQuaternion-impl((EulerOrder)((Object)object), 0.0f, 0.0f, 1.5707964f);
            f12 = ((Quaternion)var10_7).unbox-impl-w();
            f11 = ((Quaternion)var10_7).unbox-impl-x();
            f10 = ((Quaternion)var10_7).unbox-impl-y();
            f9 = ((Quaternion)var10_7).unbox-impl-z();
        } else {
            var10_7 = Quaternion.Companion;
            f12 = ((Quaternion.Companion)var10_7).getIDENTITY-w();
            f11 = ((Quaternion.Companion)var10_7).getIDENTITY-x();
            f10 = ((Quaternion.Companion)var10_7).getIDENTITY-y();
            f9 = ((Quaternion.Companion)var10_7).getIDENTITY-z();
        }
        this.setTposeDownFix-oS71L7k(f12, f11, f10, f9);
        Quaternion quaternion3 = this.tracker.getRawRotation();
        Quaternion quaternion4 = this.adjustToReference-oS71L7k(quaternion3.unbox-impl-w(), quaternion3.unbox-impl-x(), quaternion3.unbox-impl-y(), quaternion3.unbox-impl-z());
        float f13 = quaternion4.unbox-impl-w();
        float f14 = quaternion4.unbox-impl-x();
        float f15 = quaternion4.unbox-impl-y();
        float f16 = quaternion4.unbox-impl-z();
        this.lastResetQuaternion = Quaternion.box-impl(f13, f14, f15, f16);
        Quaternion quaternion5 = this.tracker.getRawRotation();
        object = Quaternion.times-oS71L7k(quaternion5.unbox-impl-w(), quaternion5.unbox-impl-x(), quaternion5.unbox-impl-y(), quaternion5.unbox-impl-z(), this.mountingOrientation-w, this.mountingOrientation-x, this.mountingOrientation-y, this.mountingOrientation-z);
        float f17 = ((Quaternion)object).unbox-impl-w();
        float f18 = ((Quaternion)object).unbox-impl-x();
        float f19 = ((Quaternion)object).unbox-impl-y();
        float f20 = ((Quaternion)object).unbox-impl-z();
        if (this.tracker.getNeedsMounting() || this.tracker.getTrackerPosition() == TrackerPosition.HEAD && !this.tracker.isHmd()) {
            float f21;
            if (this.tracker.isComputed()) {
                quaternion2 = this.tracker.getRawRotation();
                quaternion = this.fixGyroscope-oS71L7k(quaternion2.unbox-impl-w(), quaternion2.unbox-impl-x(), quaternion2.unbox-impl-y(), quaternion2.unbox-impl-z());
                f21 = quaternion.unbox-impl-w();
                f8 = quaternion.unbox-impl-x();
                f7 = quaternion.unbox-impl-y();
                f6 = quaternion.unbox-impl-z();
            } else {
                quaternion2 = Quaternion.times-oS71L7k(f17, f18, f19, f20, this.tposeDownFix-w, this.tposeDownFix-x, this.tposeDownFix-y, this.tposeDownFix-z);
                quaternion = this.fixGyroscope-oS71L7k(quaternion2.unbox-impl-w(), quaternion2.unbox-impl-x(), quaternion2.unbox-impl-y(), quaternion2.unbox-impl-z());
                f21 = quaternion.unbox-impl-w();
                f8 = quaternion.unbox-impl-x();
                f7 = quaternion.unbox-impl-y();
                f6 = quaternion.unbox-impl-z();
            }
            this.setGyroFix-oS71L7k(f21, f8, f7, f6);
        }
        if (this.tracker.isComputed() && this.tracker.getTrackerPosition() != TrackerPosition.HEAD) {
            Quaternion quaternion6 = this.getYawQuaternion-oS71L7k(f, f2, f3, f4);
            this.setMountRotFix-oS71L7k(quaternion6.unbox-impl-w(), quaternion6.unbox-impl-x(), quaternion6.unbox-impl-y(), quaternion6.unbox-impl-z());
        }
        if (this.tracker.getTrackerPosition() == TrackerPosition.HEAD && this.tracker.isHmd()) {
            Quaternion quaternion7;
            if (this.resetHmdPitch) {
                Quaternion quaternion8 = this.tracker.getRawRotation();
                Quaternion quaternion9 = this.getYawQuaternion-oS71L7k(quaternion8.unbox-impl-w(), quaternion8.unbox-impl-x(), quaternion8.unbox-impl-y(), quaternion8.unbox-impl-z());
                Quaternion quaternion10 = Quaternion.inv-impl(quaternion9.unbox-impl-w(), quaternion9.unbox-impl-x(), quaternion9.unbox-impl-y(), quaternion9.unbox-impl-z());
                quaternion9 = this.tracker.getRawRotation();
                quaternion2 = Quaternion.times-oS71L7k(quaternion10.unbox-impl-w(), quaternion10.unbox-impl-x(), quaternion10.unbox-impl-y(), quaternion10.unbox-impl-z(), quaternion9.unbox-impl-w(), quaternion9.unbox-impl-x(), quaternion9.unbox-impl-y(), quaternion9.unbox-impl-z());
                float f22 = quaternion2.unbox-impl-w();
                float f23 = quaternion2.unbox-impl-x();
                float f24 = quaternion2.unbox-impl-y();
                float f25 = quaternion2.unbox-impl-z();
                float f26 = -f23;
                Quaternion.constructor-impl(f22, f26, 0.0f, 0.0f);
                quaternion7 = Quaternion.unit-impl(f22, f26, 0.0f, 0.0f);
            } else {
                quaternion7 = Quaternion.Companion.getIDENTITY();
            }
            quaternion = quaternion7;
            f5 = quaternion.unbox-impl-w();
            f8 = quaternion.unbox-impl-x();
            f7 = quaternion.unbox-impl-y();
            f6 = quaternion.unbox-impl-z();
        } else {
            quaternion = this.fixAttachment-oS71L7k(f17, f18, f19, f20);
            f5 = quaternion.unbox-impl-w();
            f8 = quaternion.unbox-impl-x();
            f7 = quaternion.unbox-impl-y();
            f6 = quaternion.unbox-impl-z();
        }
        this.setAttachmentFix-oS71L7k(f5, f8, f7, f6);
        Object object2 = Quaternion.Companion;
        if (!Quaternion.equals-impl0(this.tposeDownFix-w, this.tposeDownFix-x, this.tposeDownFix-y, this.tposeDownFix-z, ((Quaternion.Companion)object2).getIDENTITY-w(), ((Quaternion.Companion)object2).getIDENTITY-x(), ((Quaternion.Companion)object2).getIDENTITY-y(), ((Quaternion.Companion)object2).getIDENTITY-z()) && this.tracker.getNeedsMounting()) {
            object2 = Quaternion.times-oS71L7k(this.attachmentFix-w, this.attachmentFix-x, this.attachmentFix-y, this.attachmentFix-z, this.HalfHorizontal-w, this.HalfHorizontal-x, this.HalfHorizontal-y, this.HalfHorizontal-z);
            this.setAttachmentFix-oS71L7k(((Quaternion)object2).unbox-impl-w(), ((Quaternion)object2).unbox-impl-x(), ((Quaternion)object2).unbox-impl-y(), ((Quaternion)object2).unbox-impl-z());
        }
        this.makeIdentityAdjustmentQuatsFull();
        if (this.tracker.getTrackerPosition() != TrackerPosition.HEAD || !this.tracker.isComputed()) {
            object2 = this.fixYaw-T8bZSfw(f17, f18, f19, f20, f, f2, f3, f4);
            this.setYawFix-oS71L7k(((Quaternion)object2).unbox-impl-w(), ((Quaternion)object2).unbox-impl-x(), ((Quaternion)object2).unbox-impl-y(), ((Quaternion)object2).unbox-impl-z());
            this.tracker.getYawResetSmoothing().reset();
        }
        this.calculateDrift-oS71L7k(f13, f14, f15, f16);
        this.tracker.getStayAligned().reset();
        this.postProcessResetFull-oS71L7k(f, f2, f3, f4);
    }

    private final void postProcessResetFull-oS71L7k(float f, float f2, float f3, float f4) {
        if (this.tracker.getLastResetStatus-pVg5ArA() != 0) {
            VRServer.Companion.getInstance().statusSystem.removeStatusInt(this.tracker.getLastResetStatus-pVg5ArA());
            this.tracker.setLastResetStatus-WZ4Q5Ns(0);
        }
        this.tracker.resetFilteringQuats-oS71L7k(f, f2, f3, f4);
    }

    public final void resetYaw-oS71L7k(float f, float f2, float f3, float f4) {
        Quaternion.Companion companion = Quaternion.Companion;
        this.setConstraintFix-oS71L7k(companion.getIDENTITY-w(), companion.getIDENTITY-x(), companion.getIDENTITY-y(), companion.getIDENTITY-z());
        if (this.tracker.getTrackerDataType() == TrackerDataType.FLEX_RESISTANCE || this.tracker.getTrackerDataType() == TrackerDataType.FLEX_ANGLE) {
            return;
        }
        Quaternion quaternion = this.tracker.getRawRotation();
        Quaternion quaternion2 = this.adjustToReference-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
        float f5 = quaternion2.unbox-impl-w();
        float f6 = quaternion2.unbox-impl-x();
        float f7 = quaternion2.unbox-impl-y();
        float f8 = quaternion2.unbox-impl-z();
        this.lastResetQuaternion = Quaternion.box-impl(f5, f6, f7, f8);
        float f9 = this.yawFix-w;
        float f10 = this.yawFix-x;
        float f11 = this.yawFix-y;
        float f12 = this.yawFix-z;
        Object object = this.tracker.getRawRotation();
        Quaternion quaternion3 = Quaternion.times-oS71L7k(((Quaternion)object).unbox-impl-w(), ((Quaternion)object).unbox-impl-x(), ((Quaternion)object).unbox-impl-y(), ((Quaternion)object).unbox-impl-z(), this.mountingOrientation-w, this.mountingOrientation-x, this.mountingOrientation-y, this.mountingOrientation-z);
        Quaternion quaternion4 = this.fixYaw-T8bZSfw(quaternion3.unbox-impl-w(), quaternion3.unbox-impl-x(), quaternion3.unbox-impl-y(), quaternion3.unbox-impl-z(), f, f2, f3, f4);
        this.setYawFix-oS71L7k(quaternion4.unbox-impl-w(), quaternion4.unbox-impl-x(), quaternion4.unbox-impl-y(), quaternion4.unbox-impl-z());
        this.tracker.getYawResetSmoothing().reset();
        this.makeIdentityAdjustmentQuatsYaw();
        this.calculateDrift-oS71L7k(f5, f6, f7, f8);
        if (this.yawResetSmoothTime > 0.0f) {
            quaternion3 = Quaternion.div-oS71L7k(f9, f10, f11, f12, this.yawFix-w, this.yawFix-x, this.yawFix-y, this.yawFix-z);
            object = Quaternion.Companion;
            InterpolationHandler.interpolate-flGzCu8$default(this.tracker.getYawResetSmoothing(), quaternion3.unbox-impl-w(), quaternion3.unbox-impl-x(), quaternion3.unbox-impl-y(), quaternion3.unbox-impl-z(), ((Quaternion.Companion)object).getIDENTITY-w(), ((Quaternion.Companion)object).getIDENTITY-x(), ((Quaternion.Companion)object).getIDENTITY-y(), ((Quaternion.Companion)object).getIDENTITY-z(), this.yawResetSmoothTime, false, 512, null);
        }
        if (this.tracker.getLastResetStatus-pVg5ArA() != 0 && this.tracker.getStatusResetRecently()) {
            VRServer.Companion.getInstance().statusSystem.removeStatusInt(this.tracker.getLastResetStatus-pVg5ArA());
            this.tracker.setStatusResetRecently(false);
            this.tracker.setLastResetStatus-WZ4Q5Ns(0);
        }
        this.tracker.getStayAligned().reset();
        this.tracker.resetFilteringQuats-oS71L7k(f, f2, f3, f4);
    }

    public final void resetMounting-jCQAsEA(float f, float f2, float f3, float f4, boolean forceFeet) {
        boolean isArmForward;
        if (this.tracker.getTrackerDataType() == TrackerDataType.FLEX_RESISTANCE) {
            this.tracker.getTrackerFlexHandler().resetMax();
            this.tracker.resetFilteringQuats-oS71L7k(f, f2, f3, f4);
            return;
        }
        if (this.tracker.getTrackerDataType() == TrackerDataType.FLEX_ANGLE) {
            return;
        }
        if (!this.resetMountingFeet && TrackerPositionKt.isFoot(this.tracker.getTrackerPosition()) && !forceFeet) {
            return;
        }
        Quaternion.Companion companion = Quaternion.Companion;
        this.setConstraintFix-oS71L7k(companion.getIDENTITY-w(), companion.getIDENTITY-x(), companion.getIDENTITY-y(), companion.getIDENTITY-z());
        Quaternion quaternion = this.tracker.getRawRotation();
        Quaternion quaternion2 = Quaternion.times-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z(), this.mountingOrientation-w, this.mountingOrientation-x, this.mountingOrientation-y, this.mountingOrientation-z);
        Quaternion quaternion3 = this.adjustToDrift-oS71L7k(quaternion2.unbox-impl-w(), quaternion2.unbox-impl-x(), quaternion2.unbox-impl-y(), quaternion2.unbox-impl-z());
        float f5 = quaternion3.unbox-impl-w();
        float f6 = quaternion3.unbox-impl-x();
        float f7 = quaternion3.unbox-impl-y();
        float f8 = quaternion3.unbox-impl-z();
        Quaternion quaternion4 = Quaternion.times-oS71L7k(this.gyroFix-w, this.gyroFix-x, this.gyroFix-y, this.gyroFix-z, f5, f6, f7, f8);
        float f9 = quaternion4.unbox-impl-w();
        float f10 = quaternion4.unbox-impl-x();
        float f11 = quaternion4.unbox-impl-y();
        float f12 = quaternion4.unbox-impl-z();
        f5 = f9;
        f6 = f10;
        f7 = f11;
        f8 = f12;
        Quaternion quaternion5 = Quaternion.times-oS71L7k(f5, f6, f7, f8, this.attachmentFix-w, this.attachmentFix-x, this.attachmentFix-y, this.attachmentFix-z);
        f10 = quaternion5.unbox-impl-w();
        f11 = quaternion5.unbox-impl-x();
        f12 = quaternion5.unbox-impl-y();
        float f13 = quaternion5.unbox-impl-z();
        f5 = f10;
        f6 = f11;
        f7 = f12;
        f8 = f13;
        Quaternion quaternion6 = Quaternion.times-oS71L7k(this.yawFix-w, this.yawFix-x, this.yawFix-y, this.yawFix-z, f5, f6, f7, f8);
        f11 = quaternion6.unbox-impl-w();
        f12 = quaternion6.unbox-impl-x();
        f13 = quaternion6.unbox-impl-y();
        float f14 = quaternion6.unbox-impl-z();
        f5 = f11;
        f6 = f12;
        f7 = f13;
        f8 = f14;
        Vector3.Companion companion2 = Vector3.Companion;
        Quaternion quaternion7 = Quaternion.project-1s-5YWc(f, f2, f3, f4, companion2.getPOS_Y-x(), companion2.getPOS_Y-y(), companion2.getPOS_Y-z());
        Quaternion quaternion8 = Quaternion.inv-impl(quaternion7.unbox-impl-w(), quaternion7.unbox-impl-x(), quaternion7.unbox-impl-y(), quaternion7.unbox-impl-z());
        Quaternion quaternion9 = Quaternion.unit-impl(quaternion8.unbox-impl-w(), quaternion8.unbox-impl-x(), quaternion8.unbox-impl-y(), quaternion8.unbox-impl-z());
        Quaternion quaternion10 = Quaternion.times-oS71L7k(quaternion9.unbox-impl-w(), quaternion9.unbox-impl-x(), quaternion9.unbox-impl-y(), quaternion9.unbox-impl-z(), f5, f6, f7, f8);
        float f15 = quaternion10.unbox-impl-w();
        float f16 = quaternion10.unbox-impl-x();
        float f17 = quaternion10.unbox-impl-y();
        float f18 = quaternion10.unbox-impl-z();
        f5 = f15;
        f6 = f16;
        f7 = f17;
        f8 = f18;
        Vector3.Companion companion3 = Vector3.Companion;
        Vector3 vector3 = Quaternion.sandwich-1s-5YWc(f5, f6, f7, f8, companion3.getPOS_Y-x(), companion3.getPOS_Y-y(), companion3.getPOS_Y-z());
        float f19 = vector3.unbox-impl-x();
        float f20 = vector3.unbox-impl-y();
        float f21 = vector3.unbox-impl-z();
        float yawAngle = (float)Math.atan2(f19, f21);
        if (TrackerPositionKt.isLeftArm(this.tracker.getTrackerPosition()) && this.armsResetMode == ArmsResetModes.TPOSE_DOWN || TrackerPositionKt.isRightArm(this.tracker.getTrackerPosition()) && this.armsResetMode == ArmsResetModes.TPOSE_UP || TrackerPositionKt.isLeftFinger(this.tracker.getTrackerPosition())) {
            yawAngle -= 1.5707964f;
        }
        if (TrackerPositionKt.isLeftArm(this.tracker.getTrackerPosition()) && this.armsResetMode == ArmsResetModes.TPOSE_UP || TrackerPositionKt.isRightArm(this.tracker.getTrackerPosition()) && this.armsResetMode == ArmsResetModes.TPOSE_DOWN || TrackerPositionKt.isRightFinger(this.tracker.getTrackerPosition())) {
            yawAngle += 1.5707964f;
        }
        boolean isLowerArmBack = this.armsResetMode == ArmsResetModes.BACK && (TrackerPositionKt.isLeftLowerArm(this.tracker.getTrackerPosition()) || TrackerPositionKt.isRightLowerArm(this.tracker.getTrackerPosition()));
        boolean bl = isArmForward = this.armsResetMode == ArmsResetModes.FORWARD && (TrackerPositionKt.isLeftArm(this.tracker.getTrackerPosition()) || TrackerPositionKt.isRightArm(this.tracker.getTrackerPosition()));
        if (!(TrackerPositionKt.isThigh(this.tracker.getTrackerPosition()) || isArmForward || isLowerArmBack)) {
            yawAngle -= (float)Math.PI;
        }
        EulerOrder eulerOrder = EulerOrder.YZX;
        float f22 = yawAngle;
        EulerAngles.constructor-impl(eulerOrder, 0.0f, f22, 0.0f);
        Quaternion quaternion11 = EulerAngles.toQuaternion-impl(eulerOrder, 0.0f, f22, 0.0f);
        this.setMountRotFix-oS71L7k(quaternion11.unbox-impl-w(), quaternion11.unbox-impl-x(), quaternion11.unbox-impl-y(), quaternion11.unbox-impl-z());
        if (this.saveMountingReset) {
            this.tracker.saveMountingResetOrientation(this.getMountRotFix());
        }
        this.tracker.resetFilteringQuats-oS71L7k(f, f2, f3, f4);
    }

    public static /* synthetic */ void resetMounting-jCQAsEA$default(TrackerResetsHandler trackerResetsHandler, float f, float f2, float f3, float f4, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        trackerResetsHandler.resetMounting-jCQAsEA(f, f2, f3, f4, bl);
    }

    public final void updateConstraintFix-oS71L7k(float f, float f2, float f3, float f4) {
        Quaternion quaternion = Quaternion.times-oS71L7k(this.constraintFix-w, this.constraintFix-x, this.constraintFix-y, this.constraintFix-z, f, f2, f3, f4);
        this.setConstraintFix-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
    }

    public final void clearMounting() {
        Quaternion.Companion companion = Quaternion.Companion;
        this.setMountRotFix-oS71L7k(companion.getIDENTITY-w(), companion.getIDENTITY-x(), companion.getIDENTITY-y(), companion.getIDENTITY-z());
    }

    private final Quaternion fixGyroscope-oS71L7k(float f, float f2, float f3, float f4) {
        Quaternion quaternion = this.getYawQuaternion-oS71L7k(f, f2, f3, f4);
        return Quaternion.inv-impl(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
    }

    private final Quaternion fixAttachment-oS71L7k(float f, float f2, float f3, float f4) {
        Quaternion quaternion = Quaternion.times-oS71L7k(this.gyroFix-w, this.gyroFix-x, this.gyroFix-y, this.gyroFix-z, f, f2, f3, f4);
        return Quaternion.inv-impl(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
    }

    private final Quaternion fixYaw-T8bZSfw(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        Quaternion quaternion = Quaternion.times-oS71L7k(this.gyroFix-w, this.gyroFix-x, this.gyroFix-y, this.gyroFix-z, f, f2, f3, f4);
        float f9 = quaternion.unbox-impl-w();
        float f10 = quaternion.unbox-impl-x();
        float f11 = quaternion.unbox-impl-y();
        float f12 = quaternion.unbox-impl-z();
        Quaternion quaternion2 = Quaternion.times-oS71L7k(f9, f10, f11, f12, this.attachmentFix-w, this.attachmentFix-x, this.attachmentFix-y, this.attachmentFix-z);
        float f13 = quaternion2.unbox-impl-w();
        float f14 = quaternion2.unbox-impl-x();
        float f15 = quaternion2.unbox-impl-y();
        float f16 = quaternion2.unbox-impl-z();
        f9 = f13;
        f10 = f14;
        f11 = f15;
        f12 = f16;
        Quaternion quaternion3 = Quaternion.inv-impl(this.mountRotFix-w, this.mountRotFix-x, this.mountRotFix-y, this.mountRotFix-z);
        Quaternion quaternion4 = Quaternion.times-oS71L7k(f9, f10, f11, f12, this.mountRotFix-w, this.mountRotFix-x, this.mountRotFix-y, this.mountRotFix-z);
        Quaternion quaternion5 = Quaternion.times-oS71L7k(quaternion3.unbox-impl-w(), quaternion3.unbox-impl-x(), quaternion3.unbox-impl-y(), quaternion3.unbox-impl-z(), quaternion4.unbox-impl-w(), quaternion4.unbox-impl-x(), quaternion4.unbox-impl-y(), quaternion4.unbox-impl-z());
        float f17 = quaternion5.unbox-impl-w();
        float f18 = quaternion5.unbox-impl-x();
        f16 = quaternion5.unbox-impl-y();
        float f19 = quaternion5.unbox-impl-z();
        f9 = f17;
        f10 = f18;
        f11 = f16;
        f12 = f19;
        Quaternion quaternion6 = this.getYawQuaternion-oS71L7k(f9, f10, f11, f12);
        f18 = quaternion6.unbox-impl-w();
        f16 = quaternion6.unbox-impl-x();
        f19 = quaternion6.unbox-impl-y();
        float f20 = quaternion6.unbox-impl-z();
        f9 = f18;
        f10 = f16;
        f11 = f19;
        f12 = f20;
        Quaternion quaternion7 = Quaternion.inv-impl(f9, f10, f11, f12);
        Vector3.Companion companion = Vector3.Companion;
        Quaternion quaternion8 = Quaternion.project-1s-5YWc(f5, f6, f7, f8, companion.getPOS_Y-x(), companion.getPOS_Y-y(), companion.getPOS_Y-z());
        Quaternion quaternion9 = Quaternion.unit-impl(quaternion8.unbox-impl-w(), quaternion8.unbox-impl-x(), quaternion8.unbox-impl-y(), quaternion8.unbox-impl-z());
        return Quaternion.times-oS71L7k(quaternion7.unbox-impl-w(), quaternion7.unbox-impl-x(), quaternion7.unbox-impl-y(), quaternion7.unbox-impl-z(), quaternion9.unbox-impl-w(), quaternion9.unbox-impl-x(), quaternion9.unbox-impl-y(), quaternion9.unbox-impl-z());
    }

    private final Quaternion getYawQuaternion-oS71L7k(float f, float f2, float f3, float f4) {
        EulerOrder eulerOrder = EulerOrder.YZX;
        float f5 = Quaternion.toEulerAngles-impl(f, f2, f3, f4, EulerOrder.YZX).unbox-impl-y();
        EulerAngles.constructor-impl(eulerOrder, 0.0f, f5, 0.0f);
        Quaternion quaternion = EulerAngles.toQuaternion-impl(eulerOrder, 0.0f, f5, 0.0f);
        return Quaternion.twinNearest-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z(), f, f2, f3, f4);
    }

    private final void makeIdentityAdjustmentQuatsFull() {
        Quaternion quaternion = this.tracker.getRawRotation();
        float f = quaternion.unbox-impl-w();
        float f2 = quaternion.unbox-impl-x();
        float f3 = quaternion.unbox-impl-y();
        float f4 = quaternion.unbox-impl-z();
        Quaternion quaternion2 = this.fixGyroscope-oS71L7k(f, f2, f3, f4);
        this.setGyroFixNoMounting-oS71L7k(quaternion2.unbox-impl-w(), quaternion2.unbox-impl-x(), quaternion2.unbox-impl-y(), quaternion2.unbox-impl-z());
        Object object = Quaternion.times-oS71L7k(this.gyroFixNoMounting-w, this.gyroFixNoMounting-x, this.gyroFixNoMounting-y, this.gyroFixNoMounting-z, f, f2, f3, f4);
        Quaternion quaternion3 = Quaternion.inv-impl(((Quaternion)object).unbox-impl-w(), ((Quaternion)object).unbox-impl-x(), ((Quaternion)object).unbox-impl-y(), ((Quaternion)object).unbox-impl-z());
        this.setAttachmentFixNoMounting-oS71L7k(quaternion3.unbox-impl-w(), quaternion3.unbox-impl-x(), quaternion3.unbox-impl-y(), quaternion3.unbox-impl-z());
        object = Quaternion.Companion;
        this.setYawFixZeroReference-oS71L7k(((Quaternion.Companion)object).getIDENTITY-w(), ((Quaternion.Companion)object).getIDENTITY-x(), ((Quaternion.Companion)object).getIDENTITY-y(), ((Quaternion.Companion)object).getIDENTITY-z());
    }

    private final void makeIdentityAdjustmentQuatsYaw() {
        Quaternion quaternion = this.tracker.getRawRotation();
        float f = quaternion.unbox-impl-w();
        float f2 = quaternion.unbox-impl-x();
        float f3 = quaternion.unbox-impl-y();
        float f4 = quaternion.unbox-impl-z();
        Quaternion quaternion2 = Quaternion.times-oS71L7k(this.gyroFixNoMounting-w, this.gyroFixNoMounting-x, this.gyroFixNoMounting-y, this.gyroFixNoMounting-z, f, f2, f3, f4);
        float f5 = quaternion2.unbox-impl-w();
        float f6 = quaternion2.unbox-impl-x();
        float f7 = quaternion2.unbox-impl-y();
        float f8 = quaternion2.unbox-impl-z();
        f = f5;
        f2 = f6;
        f3 = f7;
        f4 = f8;
        Quaternion quaternion3 = Quaternion.times-oS71L7k(f, f2, f3, f4, this.attachmentFixNoMounting-w, this.attachmentFixNoMounting-x, this.attachmentFixNoMounting-y, this.attachmentFixNoMounting-z);
        f6 = quaternion3.unbox-impl-w();
        f7 = quaternion3.unbox-impl-x();
        f8 = quaternion3.unbox-impl-y();
        float f9 = quaternion3.unbox-impl-z();
        f = f6;
        f2 = f7;
        f3 = f8;
        f4 = f9;
        Quaternion quaternion4 = this.fixGyroscope-oS71L7k(f, f2, f3, f4);
        this.setYawFixZeroReference-oS71L7k(quaternion4.unbox-impl-w(), quaternion4.unbox-impl-x(), quaternion4.unbox-impl-y(), quaternion4.unbox-impl-z());
    }

    private final void calculateDrift-oS71L7k(float f, float f2, float f3, float f4) {
        if (this.driftCompensationEnabled) {
            Quaternion quaternion = this.tracker.getRawRotation();
            Quaternion quaternion2 = this.adjustToReference-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
            float f5 = quaternion2.unbox-impl-w();
            float f6 = quaternion2.unbox-impl-x();
            float f7 = quaternion2.unbox-impl-y();
            float f8 = quaternion2.unbox-impl-z();
            if (this.driftSince > 0L && System.currentTimeMillis() - this.timeAtLastReset > 50000L) {
                Object time;
                Object time2;
                if (this.driftQuats.size() == this.driftQuats.capacity()) {
                    this.driftQuats.removeLast();
                    this.driftTimes.removeLast();
                }
                Object object = this.getYawQuaternion-oS71L7k(f5, f6, f7, f8);
                Quaternion quaternion3 = this.getYawQuaternion-oS71L7k(f, f2, f3, f4);
                this.driftQuats.add(Quaternion.div-oS71L7k(((Quaternion)object).unbox-impl-w(), ((Quaternion)object).unbox-impl-x(), ((Quaternion)object).unbox-impl-y(), ((Quaternion)object).unbox-impl-z(), quaternion3.unbox-impl-w(), quaternion3.unbox-impl-x(), quaternion3.unbox-impl-y(), quaternion3.unbox-impl-z()));
                this.driftTimes.add(System.currentTimeMillis() - this.driftSince);
                this.totalDriftTime = 0L;
                Iterator iterator2 = this.driftTimes.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                object = iterator2;
                while (object.hasNext()) {
                    time2 = (Long)object.next();
                    Intrinsics.checkNotNull(time2);
                    this.totalDriftTime += ((Long)time2).longValue();
                }
                ArrayList<Float> driftWeights = new ArrayList<Float>(this.driftTimes.size());
                Iterator iterator3 = this.driftTimes.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
                time2 = iterator3;
                while (time2.hasNext()) {
                    time = (Long)time2.next();
                    driftWeights.add(Float.valueOf((float)((Long)time).longValue() / (float)this.totalDriftTime));
                }
                for (int i = driftWeights.size() - 1; 0 < i; --i) {
                    driftWeights.set(i, Float.valueOf(((Number)driftWeights.get(i)).floatValue() + ((Number)driftWeights.get(i - 1)).floatValue() / (float)driftWeights.size()));
                    driftWeights.set(i - 1, Float.valueOf(((Number)driftWeights.get(i - 1)).floatValue() - ((Number)driftWeights.get(i - 1)).floatValue() / (float)driftWeights.size()));
                }
                Quaternion i = this.fromAveragedQuaternions(this.driftQuats, driftWeights);
                this.setAveragedDriftQuat-oS71L7k(i.unbox-impl-w(), i.unbox-impl-x(), i.unbox-impl-y(), i.unbox-impl-z());
                time = this.driftQuats.getLatest();
                this.setRotationSinceReset-oS71L7k(((Quaternion)time).unbox-impl-w(), ((Quaternion)time).unbox-impl-x(), ((Quaternion)time).unbox-impl-y(), ((Quaternion)time).unbox-impl-z());
                this.timeAtLastReset = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - this.timeAtLastReset < 50000L && this.driftQuats.size() > 0) {
                Iterator time = this.getYawQuaternion-oS71L7k(f5, f6, f7, f8);
                Quaternion quaternion4 = this.getYawQuaternion-oS71L7k(f, f2, f3, f4);
                Object i = Quaternion.div-oS71L7k(((Quaternion)((Object)time)).unbox-impl-w(), ((Quaternion)((Object)time)).unbox-impl-x(), ((Quaternion)((Object)time)).unbox-impl-y(), ((Quaternion)((Object)time)).unbox-impl-z(), quaternion4.unbox-impl-w(), quaternion4.unbox-impl-x(), quaternion4.unbox-impl-y(), quaternion4.unbox-impl-z());
                Quaternion quaternion5 = Quaternion.times-oS71L7k(this.rotationSinceReset-w, this.rotationSinceReset-x, this.rotationSinceReset-y, this.rotationSinceReset-z, ((Quaternion)i).unbox-impl-w(), ((Quaternion)i).unbox-impl-x(), ((Quaternion)i).unbox-impl-y(), ((Quaternion)i).unbox-impl-z());
                this.setRotationSinceReset-oS71L7k(quaternion5.unbox-impl-w(), quaternion5.unbox-impl-x(), quaternion5.unbox-impl-y(), quaternion5.unbox-impl-z());
                this.driftQuats.set(this.driftQuats.size() - 1, this.getRotationSinceReset());
                this.driftTimes.set(this.driftTimes.size() - 1, ((Number)this.driftTimes.getLatest()).longValue() + System.currentTimeMillis() - this.driftSince);
                this.totalDriftTime = 0L;
                Iterator iterator4 = this.driftTimes.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
                i = iterator4;
                while (i.hasNext()) {
                    time = (Long)i.next();
                    Intrinsics.checkNotNull(time);
                    this.totalDriftTime += ((Long)((Object)time)).longValue();
                }
                ArrayList<Float> driftWeights = new ArrayList<Float>(this.driftTimes.size());
                Iterator iterator5 = this.driftTimes.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator5, "iterator(...)");
                time = iterator5;
                while (time.hasNext()) {
                    Long time3 = (Long)time.next();
                    driftWeights.add(Float.valueOf((float)time3.longValue() / (float)this.totalDriftTime));
                }
                for (int i2 = driftWeights.size() - 1; 0 < i2; --i2) {
                    driftWeights.set(i2, Float.valueOf(((Number)driftWeights.get(i2)).floatValue() + ((Number)driftWeights.get(i2 - 1)).floatValue() / (float)driftWeights.size()));
                    driftWeights.set(i2 - 1, Float.valueOf(((Number)driftWeights.get(i2 - 1)).floatValue() - ((Number)driftWeights.get(i2 - 1)).floatValue() / (float)driftWeights.size()));
                }
                Quaternion quaternion6 = this.fromAveragedQuaternions(this.driftQuats, driftWeights);
                this.setAveragedDriftQuat-oS71L7k(quaternion6.unbox-impl-w(), quaternion6.unbox-impl-x(), quaternion6.unbox-impl-y(), quaternion6.unbox-impl-z());
            } else {
                this.timeAtLastReset = System.currentTimeMillis();
            }
            this.driftSince = System.currentTimeMillis();
        }
    }

    private final Quaternion fromAveragedQuaternions(CircularArrayList<Quaternion> qn, ArrayList<Float> tn) {
        Quaternion quaternion = qn.get(0);
        Matrix3 matrix3 = Quaternion.toMatrix-impl(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
        float f = matrix3.unbox-impl-xx();
        float f2 = matrix3.unbox-impl-yx();
        float f3 = matrix3.unbox-impl-zx();
        float f4 = matrix3.unbox-impl-xy();
        float f5 = matrix3.unbox-impl-yy();
        float f6 = matrix3.unbox-impl-zy();
        float f7 = matrix3.unbox-impl-xz();
        float f8 = matrix3.unbox-impl-yz();
        float f9 = matrix3.unbox-impl-zz();
        Float f10 = tn.get(0);
        Intrinsics.checkNotNullExpressionValue(f10, "get(...)");
        Matrix3 matrix32 = Matrix3.times-impl(f, f2, f3, f4, f5, f6, f7, f8, f9, ((Number)f10).floatValue());
        float f11 = matrix32.unbox-impl-xx();
        float f12 = matrix32.unbox-impl-yx();
        float f13 = matrix32.unbox-impl-zx();
        float f14 = matrix32.unbox-impl-xy();
        float f15 = matrix32.unbox-impl-yy();
        float f16 = matrix32.unbox-impl-zy();
        float f17 = matrix32.unbox-impl-xz();
        float f18 = matrix32.unbox-impl-yz();
        float f19 = matrix32.unbox-impl-zz();
        int n = 1;
        int n2 = qn.size();
        while (n < n2) {
            int i = n++;
            Quaternion quaternion2 = qn.get(i);
            Matrix3 matrix33 = Quaternion.toMatrix-impl(quaternion2.unbox-impl-w(), quaternion2.unbox-impl-x(), quaternion2.unbox-impl-y(), quaternion2.unbox-impl-z());
            float f20 = matrix33.unbox-impl-xx();
            float f21 = matrix33.unbox-impl-yx();
            float f22 = matrix33.unbox-impl-zx();
            float f23 = matrix33.unbox-impl-xy();
            float f24 = matrix33.unbox-impl-yy();
            float f25 = matrix33.unbox-impl-zy();
            float f26 = matrix33.unbox-impl-xz();
            float f27 = matrix33.unbox-impl-yz();
            float f28 = matrix33.unbox-impl-zz();
            Float f29 = tn.get(i);
            Intrinsics.checkNotNullExpressionValue(f29, "get(...)");
            Matrix3 matrix34 = Matrix3.times-impl(f20, f21, f22, f23, f24, f25, f26, f27, f28, ((Number)f29).floatValue());
            Matrix3 matrix35 = Matrix3.plus-rRYvrYE(f11, f12, f13, f14, f15, f16, f17, f18, f19, matrix34.unbox-impl-xx(), matrix34.unbox-impl-yx(), matrix34.unbox-impl-zx(), matrix34.unbox-impl-xy(), matrix34.unbox-impl-yy(), matrix34.unbox-impl-zy(), matrix34.unbox-impl-xz(), matrix34.unbox-impl-yz(), matrix34.unbox-impl-zz());
            float f30 = matrix35.unbox-impl-xx();
            float f31 = matrix35.unbox-impl-yx();
            float f32 = matrix35.unbox-impl-zx();
            float f33 = matrix35.unbox-impl-xy();
            float f34 = matrix35.unbox-impl-yy();
            float f35 = matrix35.unbox-impl-zy();
            float f36 = matrix35.unbox-impl-xz();
            float f37 = matrix35.unbox-impl-yz();
            float f38 = matrix35.unbox-impl-zz();
            f11 = f30;
            f12 = f31;
            f13 = f32;
            f14 = f33;
            f15 = f34;
            f16 = f35;
            f17 = f36;
            f18 = f37;
            f19 = f38;
        }
        return Matrix3.toQuaternion-impl(f11, f12, f13, f14, f15, f16, f17, f18, f19);
    }

    public final /* synthetic */ float getHalfHorizontal-w() {
        return this.HalfHorizontal-w;
    }

    public final /* synthetic */ float getHalfHorizontal-x() {
        return this.HalfHorizontal-x;
    }

    public final /* synthetic */ float getHalfHorizontal-y() {
        return this.HalfHorizontal-y;
    }

    public final /* synthetic */ float getHalfHorizontal-z() {
        return this.HalfHorizontal-z;
    }

    public final /* synthetic */ float getAveragedDriftQuat-w() {
        return this.averagedDriftQuat-w;
    }

    public final /* synthetic */ float getAveragedDriftQuat-x() {
        return this.averagedDriftQuat-x;
    }

    public final /* synthetic */ float getAveragedDriftQuat-y() {
        return this.averagedDriftQuat-y;
    }

    public final /* synthetic */ float getAveragedDriftQuat-z() {
        return this.averagedDriftQuat-z;
    }

    public final /* synthetic */ float getRotationSinceReset-w() {
        return this.rotationSinceReset-w;
    }

    public final /* synthetic */ float getRotationSinceReset-x() {
        return this.rotationSinceReset-x;
    }

    public final /* synthetic */ float getRotationSinceReset-y() {
        return this.rotationSinceReset-y;
    }

    public final /* synthetic */ float getRotationSinceReset-z() {
        return this.rotationSinceReset-z;
    }

    public final /* synthetic */ float getMountingOrientation-w() {
        return this.mountingOrientation-w;
    }

    public final /* synthetic */ float getMountingOrientation-x() {
        return this.mountingOrientation-x;
    }

    public final /* synthetic */ float getMountingOrientation-y() {
        return this.mountingOrientation-y;
    }

    public final /* synthetic */ float getMountingOrientation-z() {
        return this.mountingOrientation-z;
    }

    public final /* synthetic */ float getGyroFix-w() {
        return this.gyroFix-w;
    }

    public final /* synthetic */ float getGyroFix-x() {
        return this.gyroFix-x;
    }

    public final /* synthetic */ float getGyroFix-y() {
        return this.gyroFix-y;
    }

    public final /* synthetic */ float getGyroFix-z() {
        return this.gyroFix-z;
    }

    public final /* synthetic */ float getAttachmentFix-w() {
        return this.attachmentFix-w;
    }

    public final /* synthetic */ float getAttachmentFix-x() {
        return this.attachmentFix-x;
    }

    public final /* synthetic */ float getAttachmentFix-y() {
        return this.attachmentFix-y;
    }

    public final /* synthetic */ float getAttachmentFix-z() {
        return this.attachmentFix-z;
    }

    public final /* synthetic */ float getMountRotFix-w() {
        return this.mountRotFix-w;
    }

    public final /* synthetic */ float getMountRotFix-x() {
        return this.mountRotFix-x;
    }

    public final /* synthetic */ float getMountRotFix-y() {
        return this.mountRotFix-y;
    }

    public final /* synthetic */ float getMountRotFix-z() {
        return this.mountRotFix-z;
    }

    public final /* synthetic */ float getYawFix-w() {
        return this.yawFix-w;
    }

    public final /* synthetic */ float getYawFix-x() {
        return this.yawFix-x;
    }

    public final /* synthetic */ float getYawFix-y() {
        return this.yawFix-y;
    }

    public final /* synthetic */ float getYawFix-z() {
        return this.yawFix-z;
    }

    public final /* synthetic */ float getConstraintFix-w() {
        return this.constraintFix-w;
    }

    public final /* synthetic */ float getConstraintFix-x() {
        return this.constraintFix-x;
    }

    public final /* synthetic */ float getConstraintFix-y() {
        return this.constraintFix-y;
    }

    public final /* synthetic */ float getConstraintFix-z() {
        return this.constraintFix-z;
    }

    public final /* synthetic */ float getGyroFixNoMounting-w() {
        return this.gyroFixNoMounting-w;
    }

    public final /* synthetic */ float getGyroFixNoMounting-x() {
        return this.gyroFixNoMounting-x;
    }

    public final /* synthetic */ float getGyroFixNoMounting-y() {
        return this.gyroFixNoMounting-y;
    }

    public final /* synthetic */ float getGyroFixNoMounting-z() {
        return this.gyroFixNoMounting-z;
    }

    public final /* synthetic */ float getAttachmentFixNoMounting-w() {
        return this.attachmentFixNoMounting-w;
    }

    public final /* synthetic */ float getAttachmentFixNoMounting-x() {
        return this.attachmentFixNoMounting-x;
    }

    public final /* synthetic */ float getAttachmentFixNoMounting-y() {
        return this.attachmentFixNoMounting-y;
    }

    public final /* synthetic */ float getAttachmentFixNoMounting-z() {
        return this.attachmentFixNoMounting-z;
    }

    public final /* synthetic */ float getYawFixZeroReference-w() {
        return this.yawFixZeroReference-w;
    }

    public final /* synthetic */ float getYawFixZeroReference-x() {
        return this.yawFixZeroReference-x;
    }

    public final /* synthetic */ float getYawFixZeroReference-y() {
        return this.yawFixZeroReference-y;
    }

    public final /* synthetic */ float getYawFixZeroReference-z() {
        return this.yawFixZeroReference-z;
    }

    public final /* synthetic */ float getTposeDownFix-w() {
        return this.tposeDownFix-w;
    }

    public final /* synthetic */ float getTposeDownFix-x() {
        return this.tposeDownFix-x;
    }

    public final /* synthetic */ float getTposeDownFix-y() {
        return this.tposeDownFix-y;
    }

    public final /* synthetic */ float getTposeDownFix-z() {
        return this.tposeDownFix-z;
    }
}

