/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.trackers.hid;

import dev.slimevr.VRServer;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerStatus;
import dev.slimevr.tracking.trackers.hid.HIDDevice;
import dev.slimevr.tracking.trackers.udp.BoardType;
import dev.slimevr.tracking.trackers.udp.IMUType;
import dev.slimevr.tracking.trackers.udp.MCUType;
import dev.slimevr.tracking.trackers.udp.MagnetometerStatus;
import io.eiren.util.logging.LogManager;
import io.github.axisangles.ktmath.Quaternion;
import io.github.axisangles.ktmath.Vector3;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Ldev/slimevr/tracking/trackers/hid/HIDCommon;", "", "<init>", "()V", "Companion", "core"})
public final class HIDCommon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int HID_TRACKER_RECEIVER_VID = 4617;
    public static final int HID_TRACKER_RECEIVER_PID = 30352;
    public static final int PACKET_SIZE = 16;
    private static final float AXES_OFFSET-w;
    private static final float AXES_OFFSET-x;
    private static final float AXES_OFFSET-y;
    private static final float AXES_OFFSET-z;

    static {
        Quaternion quaternion = Quaternion.Companion.fromRotationVector(-1.5707964f, 0.0f, 0.0f);
        AXES_OFFSET-w = quaternion.unbox-impl-w();
        AXES_OFFSET-x = quaternion.unbox-impl-x();
        AXES_OFFSET-y = quaternion.unbox-impl-y();
        AXES_OFFSET-z = quaternion.unbox-impl-z();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011J>\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002JL\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006-"}, d2={"Ldev/slimevr/tracking/trackers/hid/HIDCommon$Companion;", "", "<init>", "()V", "HID_TRACKER_RECEIVER_VID", "", "HID_TRACKER_RECEIVER_PID", "PACKET_SIZE", "AXES_OFFSET", "Lio/github/axisangles/ktmath/Quaternion;", "getAXES_OFFSET", "()Lio/github/axisangles/ktmath/Quaternion;", "AXES_OFFSET-w", "F", "deviceIdLookup", "Ldev/slimevr/tracking/trackers/hid/HIDDevice;", "hidDevices", "", "hidSerialNumber", "", "deviceId", "deviceName", "deviceList", "setUpSensor", "", "device", "trackerId", "sensorType", "Ldev/slimevr/tracking/trackers/udp/IMUType;", "sensorStatus", "Ldev/slimevr/tracking/trackers/TrackerStatus;", "magStatus", "Ldev/slimevr/tracking/trackers/udp/MagnetometerStatus;", "trackersConsumer", "Ljava/util/function/Consumer;", "Ldev/slimevr/tracking/trackers/Tracker;", "processPacket", "dataReceived", "", "i", "packetType", "q", "", "a", "m", "core"})
    @SourceDebugExtension(value={"SMAP\nHIDCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HIDCommon.kt\ndev/slimevr/tracking/trackers/hid/HIDCommon$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1557#2:327\n1628#2,3:328\n1#3:331\n*S KotlinDebug\n*F\n+ 1 HIDCommon.kt\ndev/slimevr/tracking/trackers/hid/HIDCommon$Companion\n*L\n43#1:327\n43#1:328,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Quaternion getAXES_OFFSET() {
            return Quaternion.box-impl(AXES_OFFSET-w, AXES_OFFSET-x, AXES_OFFSET-y, AXES_OFFSET-z);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Nullable
        public final HIDDevice deviceIdLookup(@NotNull List<HIDDevice> hidDevices, @Nullable String hidSerialNumber, int deviceId, @Nullable String deviceName, @NotNull List<Integer> deviceList) {
            Intrinsics.checkNotNullParameter(hidDevices, "hidDevices");
            Intrinsics.checkNotNullParameter(deviceList, "deviceList");
            List<HIDDevice> list = hidDevices;
            synchronized (list) {
                block10: {
                    block9: {
                        Object v0;
                        block8: {
                            Iterator $this$mapTo$iv$iv;
                            boolean bl = false;
                            Iterable $this$map$iv = deviceList;
                            boolean $i$f$map22 = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            boolean $i$f$mapTo = false;
                            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                            while (iterator2.hasNext()) {
                                void it;
                                Object item$iv$iv = iterator2.next();
                                int n = ((Number)item$iv$iv).intValue();
                                Collection collection = destination$iv$iv;
                                boolean bl2 = false;
                                collection.add(hidDevices.get((int)it));
                            }
                            Iterable $i$f$map22 = (List)destination$iv$iv;
                            for (Object t : $i$f$map22) {
                                HIDDevice it = (HIDDevice)t;
                                boolean bl3 = false;
                                if (!(it.getHidId() == deviceId)) continue;
                                v0 = t;
                                break block8;
                            }
                            v0 = null;
                        }
                        HIDDevice hIDDevice = v0;
                        if (hIDDevice == null) break block9;
                        HIDDevice it = hIDDevice;
                        boolean bl = false;
                        HIDDevice hIDDevice2 = it;
                        return hIDDevice2;
                    }
                    if (deviceName != null) break block10;
                    HIDDevice hIDDevice = null;
                    return hIDDevice;
                }
                HIDDevice device = new HIDDevice(deviceId);
                device.setName(deviceName);
                device.setManufacturer("HID Device");
                device.setHardwareIdentifier(deviceName);
                hidDevices.add(device);
                deviceList.add(hidDevices.size() - 1);
                VRServer.Companion.getInstance().deviceManager.addDevice(device);
                String string = hidSerialNumber;
                if (string == null) {
                    string = "Unknown HID Device";
                }
                LogManager.info("[TrackerServer] Added device " + deviceName + " for " + string + ", id " + deviceId);
                HIDDevice hIDDevice = device;
                return hIDDevice;
            }
        }

        public static /* synthetic */ HIDDevice deviceIdLookup$default(Companion companion, List list, String string, int n, String string2, List list2, int n2, Object object) {
            if ((n2 & 8) != 0) {
                string2 = null;
            }
            return companion.deviceIdLookup(list, string, n, string2, list2);
        }

        private final void setUpSensor(HIDDevice device, int trackerId, IMUType sensorType, TrackerStatus sensorStatus, MagnetometerStatus magStatus, Consumer<Tracker> trackersConsumer) {
            Tracker imuTracker = device.getTracker(trackerId);
            if (imuTracker == null) {
                String formattedHWID = StringsKt.takeLast(StringsKt.replace$default(device.getHardwareIdentifier(), ":", "", false, 4, null), 5);
                int n = VRServer.Companion.getNextLocalTrackerId();
                Object object = device.getName() + "/" + trackerId;
                String string = "Tracker " + formattedHWID;
                imuTracker = new Tracker(device, n, (String)object, string, null, trackerId, false, true, true, true, false, false, sensorType, false, true, true, true, false, false, magStatus, null, 1444928, null);
                object = trackerId;
                device.getTrackers().put((Integer)object, imuTracker);
                trackersConsumer.accept(imuTracker);
                imuTracker.setStatus(sensorStatus);
                LogManager.info("[TrackerServer] Added sensor " + trackerId + " for " + device.getName() + ", type " + sensorType);
            }
        }

        public final void processPacket(@NotNull byte[] dataReceived, int i, int packetType, @NotNull HIDDevice device, @NotNull int[] q, @NotNull int[] a, @NotNull int[] m, @NotNull Consumer<Tracker> trackersConsumer) {
            float f;
            float s;
            TrackerStatus status;
            Object object;
            Object object2;
            MCUType mcuType;
            BoardType boardType;
            Tracker tracker;
            Intrinsics.checkNotNullParameter(dataReceived, "dataReceived");
            Intrinsics.checkNotNullParameter(device, "device");
            Intrinsics.checkNotNullParameter(q, "q");
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(m, "m");
            Intrinsics.checkNotNullParameter(trackersConsumer, "trackersConsumer");
            int trackerId = 0;
            if (packetType == 0) {
                int imu_id = UByte.constructor-impl(dataReceived[i + 8]) & 0xFF;
                int mag_id = UByte.constructor-impl(dataReceived[i + 9]) & 0xFF;
                IMUType sensorType = IMUType.Companion.getById-WZ4Q5Ns(UInt.constructor-impl(imu_id));
                MagnetometerStatus magStatus = MagnetometerStatus.Companion.getById-7apg3OU(UByte.constructor-impl((byte)mag_id));
                if (sensorType != null && magStatus != null) {
                    this.setUpSensor(device, trackerId, sensorType, TrackerStatus.OK, magStatus, trackersConsumer);
                }
            }
            if ((tracker = device.getTracker(trackerId)) == null) {
                return;
            }
            Integer batt = null;
            Integer batt_v = null;
            Integer temp = null;
            Integer brd_id = null;
            Integer mcu_id = null;
            Integer fw_date = null;
            Integer fw_major = null;
            Integer fw_minor = null;
            Integer fw_patch = null;
            Integer svr_status = null;
            Integer rssi = null;
            switch (packetType) {
                case 0: {
                    batt = UByte.constructor-impl(dataReceived[i + 2]) & 0xFF;
                    batt_v = UByte.constructor-impl(dataReceived[i + 3]) & 0xFF;
                    temp = UByte.constructor-impl(dataReceived[i + 4]) & 0xFF;
                    brd_id = UByte.constructor-impl(dataReceived[i + 5]) & 0xFF;
                    mcu_id = UByte.constructor-impl(dataReceived[i + 6]) & 0xFF;
                    fw_date = (UByte.constructor-impl(dataReceived[i + 11]) & 0xFF) << 8 | UByte.constructor-impl(dataReceived[i + 10]) & 0xFF;
                    fw_major = UByte.constructor-impl(dataReceived[i + 12]) & 0xFF;
                    fw_minor = UByte.constructor-impl(dataReceived[i + 13]) & 0xFF;
                    fw_patch = UByte.constructor-impl(dataReceived[i + 14]) & 0xFF;
                    rssi = UByte.constructor-impl(dataReceived[i + 15]) & 0xFF;
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 1: {
                    int j;
                    for (j = 0; j < 4; ++j) {
                        q[j] = dataReceived[i + 2 + j * 2 + 1] << 8 | UByte.constructor-impl(dataReceived[i + 2 + j * 2]) & 0xFF;
                    }
                    for (j = 0; j < 3; ++j) {
                        a[j] = dataReceived[i + 10 + j * 2 + 1] << 8 | UByte.constructor-impl(dataReceived[i + 10 + j * 2]) & 0xFF;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 2: {
                    batt = UByte.constructor-impl(dataReceived[i + 2]) & 0xFF;
                    batt_v = UByte.constructor-impl(dataReceived[i + 3]) & 0xFF;
                    temp = UByte.constructor-impl(dataReceived[i + 4]) & 0xFF;
                    ByteBuffer buffer = ByteBuffer.wrap(dataReceived, i + 5, 4);
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    int q_buf = UInt.constructor-impl(buffer.getInt());
                    q[0] = UInt.constructor-impl(q_buf & 0x3FF);
                    q[1] = UInt.constructor-impl(UInt.constructor-impl(q_buf >>> 10) & 0x7FF);
                    q[2] = UInt.constructor-impl(UInt.constructor-impl(q_buf >>> 21) & 0x7FF);
                    for (int j = 0; j < 3; ++j) {
                        a[j] = dataReceived[i + 9 + j * 2 + 1] << 8 | UByte.constructor-impl(dataReceived[i + 9 + j * 2]) & 0xFF;
                    }
                    rssi = UByte.constructor-impl(dataReceived[i + 15]) & 0xFF;
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 3: {
                    svr_status = UByte.constructor-impl(dataReceived[i + 2]) & 0xFF;
                    rssi = UByte.constructor-impl(dataReceived[i + 15]) & 0xFF;
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                case 4: {
                    int j;
                    for (j = 0; j < 4; ++j) {
                        q[j] = dataReceived[i + 2 + j * 2 + 1] << 8 | UByte.constructor-impl(dataReceived[i + 2 + j * 2]) & 0xFF;
                    }
                    for (j = 0; j < 3; ++j) {
                        m[j] = dataReceived[i + 10 + j * 2 + 1] << 8 | UByte.constructor-impl(dataReceived[i + 10 + j * 2]) & 0xFF;
                    }
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                default: {
                    Unit unit = Unit.INSTANCE;
                }
            }
            if (batt != null) {
                int n = 128;
                tracker.setBatteryLevel(batt == n ? Float.valueOf(1.0f) : Float.valueOf(batt & 0x7F));
            }
            if (batt_v != null) {
                tracker.setBatteryVoltage(Float.valueOf(((float)batt_v.intValue() + 245.0f) / 100.0f));
            }
            if (temp != null) {
                tracker.setTemperature(temp > 0 ? Float.valueOf((float)temp.intValue() / 2.0f - 39.0f) : null);
            }
            if (brd_id != null && (boardType = BoardType.Companion.getById-WZ4Q5Ns(UInt.constructor-impl(brd_id))) != null) {
                device.setBoardType(boardType);
            }
            if (mcu_id != null && (mcuType = MCUType.Companion.getById-WZ4Q5Ns(UInt.constructor-impl(mcu_id))) != null) {
                device.setMcuType(mcuType);
            }
            if (fw_date != null && fw_major != null && fw_minor != null && fw_patch != null) {
                int firmwareYear = 2020 + (fw_date >> 9 & 0x7F);
                int firmwareMonth = fw_date >> 5 & 0xF;
                int firmwareDay = fw_date & 0x1F;
                object2 = "%04d-%02d-%02d";
                object = new Object[]{firmwareYear, firmwareMonth, firmwareDay};
                String string = String.format((String)object2, Arrays.copyOf(object, ((Object)object).length));
                Intrinsics.checkNotNullExpressionValue(string, "format(...)");
                String firmwareDate = string;
                device.setFirmwareVersion(fw_major + "." + fw_minor + "." + fw_patch + " (Build " + firmwareDate + ")");
            }
            if (svr_status != null && (status = TrackerStatus.Companion.getById(svr_status)) != null) {
                tracker.setStatus(status);
            }
            if (rssi != null) {
                tracker.setSignalStrength(-rssi.intValue());
            }
            switch (packetType) {
                case 1: 
                case 4: {
                    float f2 = q[3];
                    float f3 = q[0];
                    float f4 = q[1];
                    float f5 = q[2];
                    Quaternion.constructor-impl(f2, f3, f4, f5);
                    float scaleRot = 3.0517578E-5f;
                    object = Quaternion.times-impl(this.getAXES_OFFSET-w(), this.getAXES_OFFSET-x(), this.getAXES_OFFSET-y(), this.getAXES_OFFSET-z(), scaleRot);
                    object2 = Quaternion.times-oS71L7k(((Quaternion)object).unbox-impl-w(), ((Quaternion)object).unbox-impl-x(), ((Quaternion)object).unbox-impl-y(), ((Quaternion)object).unbox-impl-z(), f2, f3, f4, f5);
                    float f6 = ((Quaternion)object2).unbox-impl-w();
                    float f7 = ((Quaternion)object2).unbox-impl-x();
                    float f8 = ((Quaternion)object2).unbox-impl-y();
                    float f9 = ((Quaternion)object2).unbox-impl-z();
                    f2 = f6;
                    f3 = f7;
                    f4 = f8;
                    f5 = f9;
                    tracker.setRotation-oS71L7k(f2, f3, f4, f5);
                }
            }
            if (packetType == 2) {
                float[] f3 = new float[]{q[0], q[1], q[2]};
                float[] v = f3;
                v[0] = v[0] / 1024.0f;
                v[1] = v[1] / 2048.0f;
                v[2] = v[2] / 2048.0f;
                for (int i2 = 0; i2 < 3; ++i2) {
                    v[i2] = v[i2] * (float)2 - 1.0f;
                }
                float d = v[0] * v[0] + v[1] * v[1] + v[2] * v[2];
                float invSqrtD = 1.0f / (float)Math.sqrt(d + 1.0E-6f);
                float a2 = 1.5707964f * d * invSqrtD;
                s = (float)Math.sin(a2);
                float k = s * invSqrtD;
                float f10 = (float)Math.cos(a2);
                float rot-x2 = k * v[0];
                float f11 = k * v[1];
                float f12 = k * v[2];
                Quaternion.constructor-impl(f10, rot-x2, f11, f12);
                Quaternion quaternion = Quaternion.times-oS71L7k(this.getAXES_OFFSET-w(), this.getAXES_OFFSET-x(), this.getAXES_OFFSET-y(), this.getAXES_OFFSET-z(), f10, rot-x2, f11, f12);
                float f13 = quaternion.unbox-impl-w();
                float f14 = quaternion.unbox-impl-x();
                float f15 = quaternion.unbox-impl-y();
                float f16 = quaternion.unbox-impl-z();
                f10 = f13;
                rot-x2 = f14;
                f11 = f15;
                f12 = f16;
                tracker.setRotation-oS71L7k(f10, rot-x2, f11, f12);
            }
            switch (packetType) {
                case 1: 
                case 2: {
                    float scaleAccel = 0.0078125f;
                    float invSqrtD = a[0];
                    float a2 = a[1];
                    s = a[2];
                    Vector3.constructor-impl(invSqrtD, a2, s);
                    Vector3 vector3 = Vector3.times-impl(invSqrtD, a2, s, scaleAccel);
                    float f17 = vector3.unbox-impl-x();
                    float f18 = vector3.unbox-impl-y();
                    f = vector3.unbox-impl-z();
                    tracker.setAcceleration-1s-5YWc(f17, f18, f);
                }
            }
            if (packetType == 4) {
                float scaleMag = 0.9765625f;
                float f17 = m[0];
                float f18 = m[1];
                f = m[2];
                Vector3.constructor-impl(f17, f18, f);
                Vector3 vector3 = Vector3.times-impl(f17, f18, f, scaleMag);
                float f19 = vector3.unbox-impl-x();
                float f20 = vector3.unbox-impl-y();
                float f21 = vector3.unbox-impl-z();
                tracker.setMagVector-1s-5YWc(f19, f20, f21);
            }
            switch (packetType) {
                case 1: 
                case 2: 
                case 4: {
                    tracker.dataTick();
                }
            }
        }

        public final /* synthetic */ float getAXES_OFFSET-w() {
            return AXES_OFFSET-w;
        }

        public final /* synthetic */ float getAXES_OFFSET-x() {
            return AXES_OFFSET-x;
        }

        public final /* synthetic */ float getAXES_OFFSET-y() {
            return AXES_OFFSET-y;
        }

        public final /* synthetic */ float getAXES_OFFSET-z() {
            return AXES_OFFSET-z;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

