/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.trackers.udp;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/slimevr/tracking/trackers/udp/FirmwareFeatures;", "", "<init>", "()V", "has", "", "flag", "Ldev/slimevr/tracking/trackers/udp/FirmwareFeatures$FirmwareFeatureFlags;", "value", "available", "getAvailable", "()Z", "flags", "", "FirmwareFeatureFlags", "Companion", "core"})
public final class FirmwareFeatures {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean available;
    @NotNull
    private final byte[] flags = new byte[FirmwareFeatureFlags.BITS_TOTAL.ordinal() / 8 + 1];

    public final boolean has(@NotNull FirmwareFeatureFlags flag) {
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        int bit = flag.ordinal();
        return (this.flags[bit / 8] & 1 << bit % 8) != 0;
    }

    public final boolean getAvailable() {
        return this.available;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ldev/slimevr/tracking/trackers/udp/FirmwareFeatures$Companion;", "", "<init>", "()V", "from", "Ldev/slimevr/tracking/trackers/udp/FirmwareFeatures;", "received", "Ljava/nio/ByteBuffer;", "length", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FirmwareFeatures from(@NotNull ByteBuffer received, int length) {
            Intrinsics.checkNotNullParameter(received, "received");
            FirmwareFeatures res = new FirmwareFeatures();
            res.available = true;
            received.get(res.flags, 0, RangesKt.coerceAtMost(res.flags.length, length));
            return res;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ldev/slimevr/tracking/trackers/udp/FirmwareFeatures$FirmwareFeatureFlags;", "", "<init>", "(Ljava/lang/String;I)V", "REMOTE_COMMAND", "B64_WIFI_SCANNING", "SENSOR_CONFIG", "BITS_TOTAL", "core"})
    public static final class FirmwareFeatureFlags
    extends Enum<FirmwareFeatureFlags> {
        public static final /* enum */ FirmwareFeatureFlags REMOTE_COMMAND = new FirmwareFeatureFlags();
        public static final /* enum */ FirmwareFeatureFlags B64_WIFI_SCANNING = new FirmwareFeatureFlags();
        public static final /* enum */ FirmwareFeatureFlags SENSOR_CONFIG = new FirmwareFeatureFlags();
        public static final /* enum */ FirmwareFeatureFlags BITS_TOTAL = new FirmwareFeatureFlags();
        private static final /* synthetic */ FirmwareFeatureFlags[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FirmwareFeatureFlags[] values() {
            return (FirmwareFeatureFlags[])$VALUES.clone();
        }

        public static FirmwareFeatureFlags valueOf(String value) {
            return Enum.valueOf(FirmwareFeatureFlags.class, value);
        }

        @NotNull
        public static EnumEntries<FirmwareFeatureFlags> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = firmwareFeatureFlagsArray = new FirmwareFeatureFlags[]{FirmwareFeatureFlags.REMOTE_COMMAND, FirmwareFeatureFlags.B64_WIFI_SCANNING, FirmwareFeatureFlags.SENSOR_CONFIG, FirmwareFeatureFlags.BITS_TOTAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

