/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.trackers.udp;

import dev.slimevr.NetworkProtocol;
import dev.slimevr.VRServer;
import dev.slimevr.config.TrackerConfigKt;
import dev.slimevr.config.VRConfig;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerPosition;
import dev.slimevr.tracking.trackers.TrackerStatus;
import dev.slimevr.tracking.trackers.udp.ConfigTypeId;
import dev.slimevr.tracking.trackers.udp.FirmwareFeatures;
import dev.slimevr.tracking.trackers.udp.IMUType;
import dev.slimevr.tracking.trackers.udp.MagnetometerStatus;
import dev.slimevr.tracking.trackers.udp.RotationPacket;
import dev.slimevr.tracking.trackers.udp.SensorConfig;
import dev.slimevr.tracking.trackers.udp.SensorSpecificPacket;
import dev.slimevr.tracking.trackers.udp.TrackerDataType;
import dev.slimevr.tracking.trackers.udp.UDPDevice;
import dev.slimevr.tracking.trackers.udp.UDPPacket;
import dev.slimevr.tracking.trackers.udp.UDPPacket0Heartbeat;
import dev.slimevr.tracking.trackers.udp.UDPPacket10PingPong;
import dev.slimevr.tracking.trackers.udp.UDPPacket11Serial;
import dev.slimevr.tracking.trackers.udp.UDPPacket12BatteryLevel;
import dev.slimevr.tracking.trackers.udp.UDPPacket13Tap;
import dev.slimevr.tracking.trackers.udp.UDPPacket14Error;
import dev.slimevr.tracking.trackers.udp.UDPPacket15SensorInfo;
import dev.slimevr.tracking.trackers.udp.UDPPacket17RotationData;
import dev.slimevr.tracking.trackers.udp.UDPPacket18MagnetometerAccuracy;
import dev.slimevr.tracking.trackers.udp.UDPPacket19SignalStrength;
import dev.slimevr.tracking.trackers.udp.UDPPacket1Heartbeat;
import dev.slimevr.tracking.trackers.udp.UDPPacket200ProtocolChange;
import dev.slimevr.tracking.trackers.udp.UDPPacket20Temperature;
import dev.slimevr.tracking.trackers.udp.UDPPacket21UserAction;
import dev.slimevr.tracking.trackers.udp.UDPPacket22FeatureFlags;
import dev.slimevr.tracking.trackers.udp.UDPPacket23RotationAndAcceleration;
import dev.slimevr.tracking.trackers.udp.UDPPacket24AckConfigChange;
import dev.slimevr.tracking.trackers.udp.UDPPacket25SetConfigFlag;
import dev.slimevr.tracking.trackers.udp.UDPPacket26FlexData;
import dev.slimevr.tracking.trackers.udp.UDPPacket3Handshake;
import dev.slimevr.tracking.trackers.udp.UDPPacket4Acceleration;
import dev.slimevr.tracking.trackers.udp.UDPProtocolParser;
import io.eiren.util.Util;
import io.eiren.util.collections.FastList;
import io.eiren.util.logging.LogManager;
import io.github.axisangles.ktmath.Quaternion;
import io.github.axisangles.ktmath.Vector3;
import java.io.Closeable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 O2\u00020\u0001:\u0002NOB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002JB\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u000206H\u0002J2\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u0002092\u0006\u0010?\u001a\u00020@2\b\b\u0002\u0010A\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0004\bB\u0010CJ/\u0010D\u001a\u00020$2\u0006\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u0002092\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\bE\u0010FJ\b\u0010G\u001a\u00020$H\u0016J\"\u0010H\u001a\u00020$2\u0006\u0010I\u001a\u00020&2\u0006\u0010J\u001a\u00020K2\b\u0010,\u001a\u0004\u0018\u00010\u000fH\u0002J\u000e\u0010L\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0015J\u000e\u0010M\u001a\u00020$2\u0006\u0010=\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u00107\u001a&\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\u000308\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0:0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Ldev/slimevr/tracking/trackers/udp/TrackersUDPServer;", "Ljava/lang/Thread;", "port", "", "name", "", "trackersConsumer", "Ljava/util/function/Consumer;", "Ldev/slimevr/tracking/trackers/Tracker;", "<init>", "(ILjava/lang/String;Ljava/util/function/Consumer;)V", "random", "Ljava/util/Random;", "connections", "", "Ldev/slimevr/tracking/trackers/udp/UDPDevice;", "connectionsByAddress", "", "Ljava/net/SocketAddress;", "connectionsByMAC", "broadcastAddresses", "", "Ljava/net/InetSocketAddress;", "parser", "Ldev/slimevr/tracking/trackers/udp/UDPProtocolParser;", "rcvBuffer", "", "bb", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "Ljava/nio/ByteBuffer;", "socket", "Ljava/net/DatagramSocket;", "lastKeepup", "", "setUpNewConnection", "", "handshakePacket", "Ljava/net/DatagramPacket;", "handshake", "Ldev/slimevr/tracking/trackers/udp/UDPPacket3Handshake;", "mainScope", "Lkotlinx/coroutines/CoroutineScope;", "setUpSensor", "connection", "trackerId", "sensorType", "Ldev/slimevr/tracking/trackers/udp/IMUType;", "sensorStatus", "magStatus", "Ldev/slimevr/tracking/trackers/udp/MagnetometerStatus;", "trackerPosition", "Ldev/slimevr/tracking/trackers/TrackerPosition;", "trackerDataType", "Ldev/slimevr/tracking/trackers/udp/TrackerDataType;", "queues", "Lkotlin/Triple;", "Ldev/slimevr/tracking/trackers/udp/ConfigTypeId;", "Ljava/util/Deque;", "Ldev/slimevr/tracking/trackers/udp/TrackersUDPServer$ConfigStateWaiter;", "setConfigFlag", "device", "configTypeId", "state", "", "sensorId", "setConfigFlag-IGi9fH8", "(Ldev/slimevr/tracking/trackers/udp/UDPDevice;SZILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "actualSetConfigFlag", "actualSetConfigFlag-YexF7dQ", "(Ldev/slimevr/tracking/trackers/udp/UDPDevice;SZI)V", "run", "processPacket", "received", "packet", "Ldev/slimevr/tracking/trackers/udp/UDPPacket;", "getConnections", "disconnectDevice", "ConfigStateWaiter", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTrackersUDPServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackersUDPServer.kt\ndev/slimevr/tracking/trackers/udp/TrackersUDPServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,631:1\n1#2:632\n318#3,11:633\n1755#4,3:644\n1863#4,2:647\n1863#4,2:651\n1863#4,2:653\n1557#4:655\n1628#4,3:656\n1863#4,2:666\n216#5,2:649\n216#5,2:668\n535#6:659\n520#6,6:660\n*S KotlinDebug\n*F\n+ 1 TrackersUDPServer.kt\ndev/slimevr/tracking/trackers/udp/TrackersUDPServer\n*L\n258#1:633,11\n284#1:644,3\n304#1:647,2\n453#1:651,2\n497#1:653,2\n565#1:655\n565#1:656,3\n591#1:666,2\n306#1:649,2\n595#1:668,2\n591#1:659\n591#1:660,6\n*E\n"})
public final class TrackersUDPServer
extends Thread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int port;
    @NotNull
    private final Consumer<Tracker> trackersConsumer;
    @NotNull
    private final Random random;
    @NotNull
    private final List<UDPDevice> connections;
    @NotNull
    private final Map<SocketAddress, UDPDevice> connectionsByAddress;
    @NotNull
    private final Map<String, UDPDevice> connectionsByMAC;
    @NotNull
    private final List<InetSocketAddress> broadcastAddresses;
    @NotNull
    private final UDPProtocolParser parser;
    @NotNull
    private final byte[] rcvBuffer;
    private final ByteBuffer bb;
    private DatagramSocket socket;
    private long lastKeepup;
    @NotNull
    private final CoroutineScope mainScope;
    @NotNull
    private final Map<Triple<SocketAddress, ConfigTypeId, Integer>, Deque<ConfigStateWaiter>> queues;
    private static final float AXES_OFFSET-w;
    private static final float AXES_OFFSET-x;
    private static final float AXES_OFFSET-y;
    private static final float AXES_OFFSET-z;
    @NotNull
    private static final String RESET_SOURCE_NAME = "TrackerServer";

    /*
     * WARNING - void declaration
     */
    public TrackersUDPServer(int port2, @NotNull String name, @NotNull Consumer<Tracker> trackersConsumer) {
        List<Object> list;
        TrackersUDPServer trackersUDPServer;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(trackersConsumer, "trackersConsumer");
        super(name);
        this.port = port2;
        this.trackersConsumer = trackersConsumer;
        this.random = new Random();
        this.connections = new FastList();
        this.connectionsByAddress = new HashMap();
        this.connectionsByMAC = new HashMap();
        TrackersUDPServer trackersUDPServer2 = this;
        try {
            trackersUDPServer = trackersUDPServer2;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            Intrinsics.checkNotNullExpressionValue(enumeration, "getNetworkInterfaces(...)");
            list = SequencesKt.toList(SequencesKt.map(SequencesKt.filter(SequencesKt.map(SequencesKt.flatMap(SequencesKt.filter(SequencesKt.asSequence(CollectionsKt.iterator(enumeration)), TrackersUDPServer::broadcastAddresses$lambda$0), TrackersUDPServer::broadcastAddresses$lambda$1), TrackersUDPServer::broadcastAddresses$lambda$2), TrackersUDPServer::broadcastAddresses$lambda$3), arg_0 -> TrackersUDPServer.broadcastAddresses$lambda$4(this, arg_0)));
        }
        catch (Exception exception) {
            void e;
            trackersUDPServer = trackersUDPServer2;
            LogManager.severe("[TrackerServer] Can't enumerate network interfaces", (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        trackersUDPServer.broadcastAddresses = list;
        this.parser = new UDPProtocolParser();
        this.rcvBuffer = new byte[1472];
        this.bb = ByteBuffer.wrap(this.rcvBuffer).order(ByteOrder.BIG_ENDIAN);
        this.lastKeepup = System.currentTimeMillis();
        this.mainScope = CoroutineScopeKt.CoroutineScope(SupervisorKt.SupervisorJob$default(null, 1, null));
        this.queues = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void setUpNewConnection(DatagramPacket handshakePacket, UDPPacket3Handshake handshake) {
        UDPDevice uDPDevice;
        block25: {
            Object object;
            Object object2;
            UDPDevice connection;
            TrackersUDPServer $this$setUpNewConnection_u24lambda_u2413;
            SocketAddress socketAddr;
            InetAddress addr;
            block27: {
                block26: {
                    void it;
                    UDPDevice uDPDevice2;
                    Object object3;
                    Object object4;
                    LogManager.info("[TrackerServer] Handshake received from " + handshakePacket.getAddress() + ":" + handshakePacket.getPort());
                    addr = handshakePacket.getAddress();
                    socketAddr = handshakePacket.getSocketAddress();
                    VRConfig vrConfig = VRServer.Companion.getInstance().configManager.getVrConfig();
                    boolean bl = false;
                    if (!vrConfig.isKnownDevice(handshake.getMacString())) {
                        String string = handshake.getMacString();
                        if (string != null) {
                            String mac = string;
                            VRServer.Companion.getInstance().handshakeHandler.sendUnknownHandshake(mac);
                            return;
                        }
                    }
                    List<UDPDevice> mac = this.connections;
                    synchronized (mac) {
                        Object object5;
                        block21: {
                            block22: {
                                Object object6;
                                UDPDevice uDPDevice3;
                                UDPDevice $this$setUpNewConnection_u24lambda_u2410_u24lambda_u249;
                                UDPDevice $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247;
                                block24: {
                                    block23: {
                                        void it2;
                                        Object object7;
                                        block20: {
                                            String string;
                                            boolean bl2 = false;
                                            object5 = this.connectionsByMAC.get(handshake.getMacString());
                                            if (object5 == null) break block20;
                                            object4 = object5;
                                            $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247 = object4;
                                            boolean bl3 = false;
                                            this.connectionsByAddress.remove($this$setUpNewConnection_u24lambda_u2410_u24lambda_u247.getAddress());
                                            $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247.setAddress(socketAddr);
                                            $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247.lastPacketNumber = 0L;
                                            $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247.setIpAddress(addr);
                                            Object object8 = $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247;
                                            String string2 = handshake.getMacString();
                                            if (string2 != null) {
                                                void it3;
                                                object3 = string2;
                                                object7 = object8;
                                                boolean bl4 = false;
                                                string = "udp://" + (String)it3;
                                                object8 = object7;
                                            } else {
                                                string = null;
                                            }
                                            ((UDPDevice)object8).setName(string);
                                            $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247.descriptiveName = "udp:/" + addr;
                                            $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247.protocolVersion = handshake.getProtocolVersion();
                                            $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247.setFirmwareVersion(handshake.getFirmware());
                                            this.connectionsByAddress.put($this$setUpNewConnection_u24lambda_u2410_u24lambda_u247.getAddress(), $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247);
                                            int i = this.connections.indexOf($this$setUpNewConnection_u24lambda_u2410_u24lambda_u247);
                                            LogManager.info(StringsKt.trimIndent("\n\t\t\t\t\t\t[TrackerServer] Tracker " + i + " handed over to address " + socketAddr + ".\n\t\t\t\t\t\tBoard type: " + handshake.getBoardType() + ",\n\t\t\t\t\t\tfirmware name: " + handshake.getFirmware() + ",\n\t\t\t\t\t\tprotocol version: " + $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247.protocolVersion + ",\n\t\t\t\t\t\tmac: " + handshake.getMacString() + ",\n\t\t\t\t\t\tname: " + $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247.getName() + "\n\t\t\t\t\t\t"));
                                            object5 = object4;
                                            if (object5 != null) break block21;
                                        }
                                        UDPDevice uDPDevice4 = this.connectionsByAddress.get(socketAddr);
                                        if (uDPDevice4 == null) break block22;
                                        $this$setUpNewConnection_u24lambda_u2410_u24lambda_u249 = $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247 = uDPDevice4;
                                        boolean bl5 = false;
                                        $this$setUpNewConnection_u24lambda_u2410_u24lambda_u249.lastPacketNumber = 0L;
                                        $this$setUpNewConnection_u24lambda_u2410_u24lambda_u249.setIpAddress(addr);
                                        uDPDevice3 = $this$setUpNewConnection_u24lambda_u2410_u24lambda_u249;
                                        object6 = handshake.getMacString();
                                        if (object6 == null) break block23;
                                        object7 = object6;
                                        UDPDevice uDPDevice5 = uDPDevice3;
                                        boolean bl6 = false;
                                        String string = "udp://" + (String)it2;
                                        uDPDevice3 = uDPDevice5;
                                        object6 = string;
                                        if (string != null) break block24;
                                    }
                                    object6 = "udp:/" + addr;
                                }
                                uDPDevice3.setName((String)object6);
                                $this$setUpNewConnection_u24lambda_u2410_u24lambda_u249.descriptiveName = "udp:/" + addr;
                                $this$setUpNewConnection_u24lambda_u2410_u24lambda_u249.protocolVersion = handshake.getProtocolVersion();
                                $this$setUpNewConnection_u24lambda_u2410_u24lambda_u249.setFirmwareVersion(handshake.getFirmware());
                                int i = this.connections.indexOf($this$setUpNewConnection_u24lambda_u2410_u24lambda_u249);
                                LogManager.info(StringsKt.trimIndent("\n\t\t\t\t\t\t[TrackerServer] Tracker " + i + " reconnected from address " + socketAddr + ".\n\t\t\t\t\t\tBoard type: " + handshake.getBoardType() + ",\n\t\t\t\t\t\tfirmware name: " + handshake.getFirmware() + ",\n\t\t\t\t\t\tprotocol version: " + $this$setUpNewConnection_u24lambda_u2410_u24lambda_u249.protocolVersion + ",\n\t\t\t\t\t\tmac: " + handshake.getMacString() + ",\n\t\t\t\t\t\tname: " + $this$setUpNewConnection_u24lambda_u2410_u24lambda_u249.getName() + "\n\t\t\t\t\t\t"));
                                object5 = $this$setUpNewConnection_u24lambda_u2410_u24lambda_u247;
                                break block21;
                            }
                            object5 = null;
                        }
                        UDPDevice bl2 = object5;
                        // MONITOREXIT @DISABLED, blocks:[0, 2] lbl78 : MonitorExitStatement: MONITOREXIT : mac
                        uDPDevice2 = bl2;
                    }
                    uDPDevice = uDPDevice2;
                    if (uDPDevice2 != null) break block25;
                    $this$setUpNewConnection_u24lambda_u2413 = this;
                    boolean bl7 = false;
                    Intrinsics.checkNotNull(socketAddr);
                    Intrinsics.checkNotNull(addr);
                    String string = handshake.getMacString();
                    if (string == null) {
                        string = addr.getHostAddress();
                    }
                    object4 = string;
                    Intrinsics.checkNotNull(object4);
                    connection = new UDPDevice(socketAddr, addr, (String)object4, handshake.getBoardType(), handshake.getMcuType());
                    VRServer.Companion.getInstance().deviceManager.addDevice(connection);
                    connection.protocolVersion = handshake.getProtocolVersion();
                    String string3 = handshake.getFirmware();
                    connection.protocol = (string3 != null ? ((CharSequence)string3).length() == 0 : false) ? NetworkProtocol.OWO_LEGACY : NetworkProtocol.SLIMEVR_RAW;
                    object2 = connection;
                    object = handshake.getMacString();
                    if (object == null) break block26;
                    String $this$setUpNewConnection_u24lambda_u2410_u24lambda_u249 = object;
                    object3 = object2;
                    boolean bl8 = false;
                    String string4 = "udp://" + (String)it;
                    object2 = object3;
                    object = string4;
                    if (string4 != null) break block27;
                }
                object = "udp:/" + addr;
            }
            ((UDPDevice)object2).setName((String)object);
            connection.descriptiveName = "udp:/" + addr;
            connection.setFirmwareVersion(handshake.getFirmware());
            List<UDPDevice> list = $this$setUpNewConnection_u24lambda_u2413.connections;
            synchronized (list) {
                boolean bl = false;
                int i = $this$setUpNewConnection_u24lambda_u2413.connections.size();
                $this$setUpNewConnection_u24lambda_u2413.connections.add(connection);
                $this$setUpNewConnection_u24lambda_u2413.connectionsByAddress.put(socketAddr, connection);
                if (handshake.getMacString() != null) {
                    Map<String, UDPDevice> map = $this$setUpNewConnection_u24lambda_u2413.connectionsByMAC;
                    String string = handshake.getMacString();
                    Intrinsics.checkNotNull(string);
                    map.put(string, connection);
                }
                LogManager.info(StringsKt.trimIndent("\n\t\t\t\t\t\t[TrackerServer] Tracker " + i + " connected from address " + socketAddr + ".\n\t\t\t\t\t\tBoard type: " + handshake.getBoardType() + ",\n\t\t\t\t\t\tfirmware name: " + handshake.getFirmware() + ",\n\t\t\t\t\t\tprotocol version: " + connection.protocolVersion + ",\n\t\t\t\t\t\tmac: " + handshake.getMacString() + ",\n\t\t\t\t\t\tname: " + connection.getName() + "\n\t\t\t\t\t\t"));
                Unit unit = Unit.INSTANCE;
            }
            if (connection.protocol == NetworkProtocol.OWO_LEGACY || connection.protocolVersion < 9) {
                $this$setUpNewConnection_u24lambda_u2413.setUpSensor(connection, 0, handshake.getImuType(), 1, MagnetometerStatus.NOT_SUPPORTED, null, TrackerDataType.ROTATION);
            }
            uDPDevice = connection;
        }
        UDPDevice connection = uDPDevice;
        connection.setFirmwareFeatures(new FirmwareFeatures());
        this.bb.limit(this.bb.capacity());
        this.bb.rewind();
        ByteBuffer byteBuffer = this.bb;
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "bb");
        this.parser.writeHandshakeResponse(byteBuffer, connection);
        DatagramSocket datagramSocket = this.socket;
        if (datagramSocket == null) {
            Intrinsics.throwUninitializedPropertyAccessException("socket");
            datagramSocket = null;
        }
        datagramSocket.send(new DatagramPacket(this.rcvBuffer, this.bb.position(), connection.getAddress()));
    }

    private final void setUpSensor(UDPDevice connection, int trackerId, IMUType sensorType, int sensorStatus, MagnetometerStatus magStatus, TrackerPosition trackerPosition, TrackerDataType trackerDataType) {
        TrackerStatus status;
        LogManager.info("[TrackerServer] Sensor " + trackerId + " for " + connection.getName() + " status: " + sensorStatus);
        Tracker imuTracker = connection.getTracker(trackerId);
        if (imuTracker == null) {
            Object formattedHWID = StringsKt.takeLast(StringsKt.replace$default(connection.getHardwareIdentifier(), ":", "", false, 4, null), 5);
            if (trackerId != 0) {
                formattedHWID = (String)formattedHWID + " Extension";
                if (trackerId > 1) {
                    formattedHWID = (String)formattedHWID + " " + trackerId;
                }
            }
            int n = VRServer.Companion.getNextLocalTrackerId();
            Object object = connection.getName() + "/" + trackerId;
            String string = "Tracker " + (String)formattedHWID;
            IMUType iMUType = trackerDataType == TrackerDataType.ROTATION ? sensorType : null;
            imuTracker = new Tracker(connection, n, (String)object, string, trackerPosition, trackerId, false, true, true, true, false, false, iMUType, true, true, true, true, false, false, magStatus, trackerDataType, 396352, null);
            object = trackerId;
            connection.getTrackers().put(object, imuTracker);
            this.trackersConsumer.accept(imuTracker);
            LogManager.info("[TrackerServer] Added sensor " + trackerId + " for " + connection.getName() + ", ImuType " + sensorType + ", DataType " + trackerDataType + ", default TrackerPosition " + trackerPosition);
        }
        if ((status = UDPPacket15SensorInfo.Companion.getStatus(sensorStatus)) != null) {
            imuTracker.setStatus(status);
        }
        if (magStatus == MagnetometerStatus.NOT_SUPPORTED) {
            return;
        }
        if (magStatus == MagnetometerStatus.ENABLED && (!VRServer.Companion.getInstance().configManager.getVrConfig().getServer().getUseMagnetometerOnAllTrackers() || Intrinsics.areEqual(TrackerConfigKt.getConfig(imuTracker).getShouldHaveMagEnabled(), false))) {
            BuildersKt.launch$default(this.mainScope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(connection, trackerId, null){
                int label;
                final /* synthetic */ UDPDevice $connection;
                final /* synthetic */ int $trackerId;
                {
                    this.$connection = $connection;
                    this.$trackerId = $trackerId;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.label = 1;
                            Object object3 = TimeoutKt.withTimeoutOrNull(10000L, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$connection, this.$trackerId, null){
                                int label;
                                final /* synthetic */ UDPDevice $connection;
                                final /* synthetic */ int $trackerId;
                                {
                                    this.$connection = $connection;
                                    this.$trackerId = $trackerId;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.label = 1;
                                            Object object3 = this.$connection.setMag(false, this.$trackerId, this);
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure($result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
        } else if (magStatus == MagnetometerStatus.DISABLED && VRServer.Companion.getInstance().configManager.getVrConfig().getServer().getUseMagnetometerOnAllTrackers() && Intrinsics.areEqual(TrackerConfigKt.getConfig(imuTracker).getShouldHaveMagEnabled(), true)) {
            BuildersKt.launch$default(this.mainScope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(connection, trackerId, null){
                int label;
                final /* synthetic */ UDPDevice $connection;
                final /* synthetic */ int $trackerId;
                {
                    this.$connection = $connection;
                    this.$trackerId = $trackerId;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.label = 1;
                            Object object3 = TimeoutKt.withTimeoutOrNull(10000L, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$connection, this.$trackerId, null){
                                int label;
                                final /* synthetic */ UDPDevice $connection;
                                final /* synthetic */ int $trackerId;
                                {
                                    this.$connection = $connection;
                                    this.$trackerId = $trackerId;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.label = 1;
                                            Object object3 = this.$connection.setMag(true, this.$trackerId, this);
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure($result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
        }
    }

    @Nullable
    public final Object setConfigFlag-IGi9fH8(@NotNull UDPDevice device, short configTypeId, boolean state, int sensorId, @NotNull Continuation<? super Unit> $completion) {
        if (device.timedOut) {
            return Unit.INSTANCE;
        }
        Triple<SocketAddress, ConfigTypeId, Integer> triple = new Triple<SocketAddress, ConfigTypeId, Integer>(device.getAddress(), ConfigTypeId.box-impl(configTypeId), Boxing.boxInt(sensorId));
        Deque deque = this.queues.computeIfAbsent(triple, arg_0 -> TrackersUDPServer.setConfigFlag_IGi9fH8$lambda$15(TrackersUDPServer::setConfigFlag_IGi9fH8$lambda$14, arg_0));
        Intrinsics.checkNotNullExpressionValue(deque, "computeIfAbsent(...)");
        Deque queue = deque;
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl<? super Unit> cancellable$iv = new CancellableContinuationImpl<Unit>(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation it = cancellable$iv;
        boolean bl2 = false;
        ConfigStateWaiter waiter = new ConfigStateWaiter(state, it, false, 4, null);
        queue.add(waiter);
        it.invokeOnCancellation((Function1<Throwable, Unit>)new Function1<Throwable, Unit>((Deque<ConfigStateWaiter>)queue, waiter){
            final /* synthetic */ Deque<ConfigStateWaiter> $queue;
            final /* synthetic */ ConfigStateWaiter $waiter;
            {
                this.$queue = $queue;
                this.$waiter = $waiter;
            }

            public final void invoke(Throwable it) {
                this.$queue.remove(this.$waiter);
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object setConfigFlag-IGi9fH8$default(TrackersUDPServer trackersUDPServer, UDPDevice uDPDevice, short s, boolean bl, int n, Continuation continuation2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 255;
        }
        return trackersUDPServer.setConfigFlag-IGi9fH8(uDPDevice, s, bl, n, continuation2);
    }

    private final void actualSetConfigFlag-YexF7dQ(UDPDevice device, short configTypeId, boolean state, int sensorId) {
        UDPPacket25SetConfigFlag packet = new UDPPacket25SetConfigFlag(sensorId, configTypeId, state, null);
        this.bb.limit(this.bb.capacity());
        this.bb.rewind();
        ByteBuffer byteBuffer = this.bb;
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "bb");
        this.parser.write(byteBuffer, null, packet);
        DatagramSocket datagramSocket = this.socket;
        if (datagramSocket == null) {
            Intrinsics.throwUninitializedPropertyAccessException("socket");
            datagramSocket = null;
        }
        datagramSocket.send(new DatagramPacket(this.rcvBuffer, this.bb.position(), device.getAddress()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        StringBuilder serialBuffer2 = new StringBuilder();
        try {
            try {
                this.socket = new DatagramSocket(this.port);
                long prevPacketTime = System.currentTimeMillis();
                DatagramSocket datagramSocket = this.socket;
                if (datagramSocket == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("socket");
                    datagramSocket = null;
                }
                datagramSocket.setSoTimeout(250);
                while (true) {
                    DatagramPacket received = null;
                    try {
                        Object element$iv;
                        Map<Triple<SocketAddress, ConfigTypeId, Integer>, Deque<ConfigStateWaiter>> $this$forEach$iv;
                        Iterator<Map.Entry<Triple<SocketAddress, ConfigTypeId, Integer>, Deque<ConfigStateWaiter>>> $i$a$-synchronized-TrackersUDPServer$run$connection$22;
                        long discoveryPacketTime;
                        boolean hasActiveTrackers;
                        block33: {
                            Iterable $this$any$iv = this.connections;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v1 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv) {
                                    UDPDevice it = (UDPDevice)element$iv2;
                                    boolean bl = false;
                                    if (!(((ConcurrentHashMap)it.getTrackers()).size() > 0)) continue;
                                    v1 = true;
                                    break block33;
                                }
                                v1 = hasActiveTrackers = false;
                            }
                        }
                        if (!hasActiveTrackers && (discoveryPacketTime = System.currentTimeMillis()) - prevPacketTime >= 2000L) {
                            for (InetSocketAddress addr : this.broadcastAddresses) {
                                this.bb.limit(this.bb.capacity());
                                this.bb.rewind();
                                ByteBuffer byteBuffer = this.bb;
                                Intrinsics.checkNotNullExpressionValue(byteBuffer, "bb");
                                this.parser.write(byteBuffer, null, UDPPacket0Heartbeat.INSTANCE);
                                DatagramSocket datagramSocket2 = this.socket;
                                if (datagramSocket2 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("socket");
                                    datagramSocket2 = null;
                                }
                                datagramSocket2.send(new DatagramPacket(this.rcvBuffer, this.bb.position(), addr));
                            }
                            prevPacketTime = discoveryPacketTime;
                        }
                        received = new DatagramPacket(this.rcvBuffer, this.rcvBuffer.length);
                        DatagramSocket datagramSocket3 = this.socket;
                        if (datagramSocket3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("socket");
                            datagramSocket3 = null;
                        }
                        datagramSocket3.receive(received);
                        this.bb.limit(received.getLength());
                        this.bb.rewind();
                        List<UDPDevice> list = this.connections;
                        synchronized (list) {
                            boolean $i$a$-synchronized-TrackersUDPServer$run$connection$22 = false;
                            $i$a$-synchronized-TrackersUDPServer$run$connection$22 = this.connectionsByAddress.get(received.getSocketAddress());
                        }
                        UDPDevice connection = $i$a$-synchronized-TrackersUDPServer$run$connection$22;
                        ByteBuffer byteBuffer = this.bb;
                        Intrinsics.checkNotNullExpressionValue(byteBuffer, "bb");
                        Iterable $i$f$any = ArraysKt.filterNotNull(this.parser.parse(byteBuffer, connection));
                        boolean $i$f$forEach = false;
                        $i$a$-synchronized-TrackersUDPServer$run$connection$22 = $this$forEach$iv.iterator();
                        while ($i$a$-synchronized-TrackersUDPServer$run$connection$22.hasNext()) {
                            element$iv = $i$a$-synchronized-TrackersUDPServer$run$connection$22.next();
                            UDPPacket it = (UDPPacket)element$iv;
                            boolean bl = false;
                            this.processPacket(received, it, connection);
                        }
                        $this$forEach$iv = this.queues;
                        $i$f$forEach = false;
                        $i$a$-synchronized-TrackersUDPServer$run$connection$22 = $this$forEach$iv.entrySet().iterator();
                        while ($i$a$-synchronized-TrackersUDPServer$run$connection$22.hasNext()) {
                            UDPDevice device;
                            ConfigStateWaiter q;
                            Object it = element$iv = $i$a$-synchronized-TrackersUDPServer$run$connection$22.next();
                            boolean bl = false;
                            Triple t = (Triple)it.getKey();
                            Deque p = (Deque)it.getValue();
                            if ((ConfigStateWaiter)CollectionsKt.firstOrNull(p) == null || q.getRan()) continue;
                            if (this.connectionsByAddress.get(t.getFirst()) == null) {
                                TrackersUDPServer $this$run_u24lambda_u2421_u24lambda_u2420 = this;
                                boolean bl2 = false;
                                p.removeFirst();
                                LogManager.info("[TrackerServer] Device " + t.getFirst() + " not connected, so can't communicate with it");
                                continue;
                            }
                            this.actualSetConfigFlag-YexF7dQ(device, ((ConfigTypeId)t.getSecond()).unbox-impl(), q.getExpectedState(), ((Number)t.getThird()).intValue());
                            if (device.timedOut) continue;
                            q.setRan(true);
                        }
                    }
                    catch (SocketTimeoutException hasActiveTrackers) {
                    }
                    catch (Exception e) {
                        LogManager.warning("[TrackerServer] Error parsing packet " + TrackersUDPServer.Companion.packetToString(received), e);
                    }
                    if (this.lastKeepup + (long)500 >= System.currentTimeMillis()) continue;
                    this.lastKeepup = System.currentTimeMillis();
                    List<UDPDevice> list = this.connections;
                    synchronized (list) {
                        boolean bl = false;
                        for (UDPDevice conn : this.connections) {
                            this.bb.limit(this.bb.capacity());
                            this.bb.rewind();
                            ByteBuffer byteBuffer = this.bb;
                            Intrinsics.checkNotNullExpressionValue(byteBuffer, "bb");
                            this.parser.write(byteBuffer, conn, UDPPacket1Heartbeat.INSTANCE);
                            DatagramSocket datagramSocket4 = this.socket;
                            if (datagramSocket4 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("socket");
                                datagramSocket4 = null;
                            }
                            datagramSocket4.send(new DatagramPacket(this.rcvBuffer, this.bb.position(), conn.getAddress()));
                            if (conn.lastPacket + (long)1000 < System.currentTimeMillis()) {
                                if (!conn.timedOut) {
                                    conn.timedOut = true;
                                    LogManager.info("[TrackerServer] Tracker timed out: " + conn);
                                }
                            } else {
                                for (Tracker value : ((ConcurrentHashMap)conn.getTrackers()).values()) {
                                    if (value.getStatus() != TrackerStatus.DISCONNECTED && value.getStatus() != TrackerStatus.TIMED_OUT) continue;
                                    value.setStatus(TrackerStatus.OK);
                                }
                                conn.timedOut = false;
                            }
                            if (((CharSequence)conn.serialBuffer).length() > 0 && conn.lastSerialUpdate + 500L < System.currentTimeMillis()) {
                                serialBuffer2.append('[').append(conn.getName()).append("] ").append((CharSequence)conn.serialBuffer);
                                System.out.println(serialBuffer2);
                                serialBuffer2.setLength(0);
                                conn.serialBuffer.setLength(0);
                            }
                            if (conn.lastPingPacketTime + (long)500 >= System.currentTimeMillis()) continue;
                            conn.lastPingPacketId = this.random.nextInt();
                            conn.lastPingPacketTime = System.currentTimeMillis();
                            this.bb.limit(this.bb.capacity());
                            this.bb.rewind();
                            this.bb.putInt(10);
                            this.bb.putLong(0L);
                            this.bb.putInt(conn.lastPingPacketId);
                            DatagramSocket datagramSocket5 = this.socket;
                            if (datagramSocket5 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("socket");
                                datagramSocket5 = null;
                            }
                            datagramSocket5.send(new DatagramPacket(this.rcvBuffer, this.bb.position(), conn.getAddress()));
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Closeable[] closeableArray = new Closeable[1];
                DatagramSocket datagramSocket = this.socket;
                if (datagramSocket == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("socket");
                    datagramSocket = null;
                }
                closeableArray[0] = datagramSocket;
                Util.close(closeableArray);
                return;
            }
        }
        catch (Throwable throwable) {
            Closeable[] closeableArray = new Closeable[1];
            DatagramSocket datagramSocket = this.socket;
            if (datagramSocket == null) {
                Intrinsics.throwUninitializedPropertyAccessException("socket");
                datagramSocket = null;
            }
            closeableArray[0] = datagramSocket;
            Util.close(closeableArray);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processPacket(DatagramPacket received, UDPPacket packet, UDPDevice connection) {
        Object tracker = null;
        UDPPacket uDPPacket = packet;
        if (!(uDPPacket instanceof UDPPacket0Heartbeat || uDPPacket instanceof UDPPacket1Heartbeat || uDPPacket instanceof UDPPacket25SetConfigFlag)) {
            if (uDPPacket instanceof UDPPacket3Handshake) {
                this.setUpNewConnection(received, (UDPPacket3Handshake)packet);
            } else if (uDPPacket instanceof RotationPacket) {
                Quaternion quaternion = ((RotationPacket)((Object)packet)).getRotation();
                float f = quaternion.unbox-impl-w();
                float f2 = quaternion.unbox-impl-x();
                float f3 = quaternion.unbox-impl-y();
                float f4 = quaternion.unbox-impl-z();
                Quaternion quaternion2 = Quaternion.times-oS71L7k(AXES_OFFSET-w, AXES_OFFSET-x, AXES_OFFSET-y, AXES_OFFSET-z, f, f2, f3, f4);
                float f5 = quaternion2.unbox-impl-w();
                float f6 = quaternion2.unbox-impl-x();
                float f7 = quaternion2.unbox-impl-y();
                float f8 = quaternion2.unbox-impl-z();
                f = f5;
                f2 = f6;
                f3 = f7;
                f4 = f8;
                UDPDevice uDPDevice = connection;
                Object object = tracker = uDPDevice != null ? uDPDevice.getTracker(((SensorSpecificPacket)((Object)packet)).getSensorId()) : null;
                if (tracker == null) {
                    return;
                }
                ((Tracker)tracker).setRotation-oS71L7k(f, f2, f3, f4);
                if (packet instanceof UDPPacket23RotationAndAcceleration) {
                    f5 = ((UDPPacket23RotationAndAcceleration)packet).getAcceleration-y();
                    f6 = ((UDPPacket23RotationAndAcceleration)packet).getAcceleration-x();
                    f7 = ((UDPPacket23RotationAndAcceleration)packet).getAcceleration-z();
                    Vector3.constructor-impl(f5, f6, f7);
                    ((Tracker)tracker).setAcceleration-1s-5YWc(f5, f6, f7);
                }
                ((Tracker)tracker).dataTick();
            } else if (uDPPacket instanceof UDPPacket17RotationData) {
                UDPDevice uDPDevice = connection;
                Object object = tracker = uDPDevice != null ? uDPDevice.getTracker(((UDPPacket17RotationData)packet).getSensorId()) : null;
                if (tracker == null) {
                    return;
                }
                float f = ((UDPPacket17RotationData)packet).getRotation-w();
                float f9 = ((UDPPacket17RotationData)packet).getRotation-x();
                float f10 = ((UDPPacket17RotationData)packet).getRotation-y();
                float f11 = ((UDPPacket17RotationData)packet).getRotation-z();
                Quaternion f4 = Quaternion.times-oS71L7k(AXES_OFFSET-w, AXES_OFFSET-x, AXES_OFFSET-y, AXES_OFFSET-z, f, f9, f10, f11);
                float f12 = f4.unbox-impl-w();
                float f13 = f4.unbox-impl-x();
                float f14 = f4.unbox-impl-y();
                float f15 = f4.unbox-impl-z();
                f = f12;
                f9 = f13;
                f10 = f14;
                f11 = f15;
                switch (((UDPPacket17RotationData)packet).getDataType()) {
                    case 1: {
                        ((Tracker)tracker).setRotation-oS71L7k(f, f9, f10, f11);
                        ((Tracker)tracker).dataTick();
                    }
                }
            } else if (!(uDPPacket instanceof UDPPacket18MagnetometerAccuracy)) {
                if (uDPPacket instanceof UDPPacket4Acceleration) {
                    UDPDevice uDPDevice = connection;
                    Object object = tracker = uDPDevice != null ? uDPDevice.getTracker(((UDPPacket4Acceleration)packet).getSensorId()) : null;
                    if (tracker == null) {
                        return;
                    }
                    float f = ((UDPPacket4Acceleration)packet).getAcceleration-y();
                    float f9 = ((UDPPacket4Acceleration)packet).getAcceleration-x();
                    float f10 = ((UDPPacket4Acceleration)packet).getAcceleration-z();
                    Vector3.constructor-impl(f, f9, f10);
                    ((Tracker)tracker).setAcceleration-1s-5YWc(f, f9, f10);
                } else if (uDPPacket instanceof UDPPacket10PingPong) {
                    if (connection == null) {
                        return;
                    }
                    if (connection.lastPingPacketId == ((UDPPacket10PingPong)packet).getPingId()) {
                        for (Tracker t : ((ConcurrentHashMap)connection.getTrackers()).values()) {
                            t.setPing((int)(System.currentTimeMillis() - connection.lastPingPacketTime) / 2);
                            t.dataTick();
                        }
                    } else {
                        LogManager.debug("[TrackerServer] Wrong ping id " + ((UDPPacket10PingPong)packet).getPingId() + " != " + connection.lastPingPacketId);
                    }
                } else if (uDPPacket instanceof UDPPacket11Serial) {
                    if (connection == null) {
                        return;
                    }
                    System.out.println((Object)("[" + connection.getName() + "] " + ((UDPPacket11Serial)packet).getSerial()));
                } else if (uDPPacket instanceof UDPPacket12BatteryLevel) {
                    Object object = connection;
                    if (object != null && (object = ((UDPDevice)object).getTrackers()) != null && (object = ((ConcurrentHashMap)object).values()) != null) {
                        Iterable $this$forEach$iv = (Iterable)object;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Tracker it = (Tracker)element$iv;
                            boolean bl = false;
                            it.setBatteryVoltage(Float.valueOf(((UDPPacket12BatteryLevel)packet).getVoltage()));
                            it.setBatteryLevel(Float.valueOf(((UDPPacket12BatteryLevel)packet).getLevel() * (float)100));
                        }
                    }
                } else if (uDPPacket instanceof UDPPacket13Tap) {
                    UDPDevice uDPDevice = connection;
                    Object object = tracker = uDPDevice != null ? uDPDevice.getTracker(((UDPPacket13Tap)packet).getSensorId()) : null;
                    if (tracker == null) {
                        return;
                    }
                    LogManager.info("[TrackerServer] Tap packet received from " + ((Tracker)tracker).getName() + ": " + ((UDPPacket13Tap)packet).getTap());
                } else if (uDPPacket instanceof UDPPacket14Error) {
                    LogManager.severe("[TrackerServer] Error received from " + received.getSocketAddress() + ": " + ((UDPPacket14Error)packet).getErrorNumber());
                    UDPDevice uDPDevice = connection;
                    Object object = tracker = uDPDevice != null ? uDPDevice.getTracker(((UDPPacket14Error)packet).getSensorId()) : null;
                    if (tracker == null) {
                        return;
                    }
                    ((Tracker)tracker).setStatus(TrackerStatus.ERROR);
                } else if (uDPPacket instanceof UDPPacket15SensorInfo) {
                    if (connection == null) {
                        return;
                    }
                    Object object = ((UDPPacket15SensorInfo)packet).getSensorConfig-4v-Uck0();
                    if (object == null || (object = SensorConfig.getMagStatus-impl(object.unbox-impl())) == null) {
                        object = MagnetometerStatus.NOT_SUPPORTED;
                    }
                    Object magStatus = object;
                    this.setUpSensor(connection, ((UDPPacket15SensorInfo)packet).getSensorId(), ((UDPPacket15SensorInfo)packet).getSensorType(), ((UDPPacket15SensorInfo)packet).getSensorStatus(), (MagnetometerStatus)((Object)magStatus), ((UDPPacket15SensorInfo)packet).getTrackerPosition(), ((UDPPacket15SensorInfo)packet).getTrackerDataType());
                    this.bb.limit(this.bb.capacity());
                    this.bb.rewind();
                    ByteBuffer byteBuffer = this.bb;
                    Intrinsics.checkNotNullExpressionValue(byteBuffer, "bb");
                    this.parser.writeSensorInfoResponse(byteBuffer, connection, (UDPPacket15SensorInfo)packet);
                    DatagramSocket datagramSocket = this.socket;
                    if (datagramSocket == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("socket");
                        datagramSocket = null;
                    }
                    datagramSocket.send(new DatagramPacket(this.rcvBuffer, this.bb.position(), connection.getAddress()));
                    LogManager.info("[TrackerServer] Sensor info for " + connection.descriptiveName + "/" + ((UDPPacket15SensorInfo)packet).getSensorId() + ": " + ((UDPPacket15SensorInfo)packet).getSensorStatus() + ", mag " + (MagnetometerStatus)((Object)magStatus));
                } else if (uDPPacket instanceof UDPPacket19SignalStrength) {
                    Object object = connection;
                    if (object != null && (object = ((UDPDevice)object).getTrackers()) != null && (object = ((ConcurrentHashMap)object).values()) != null) {
                        Iterable $this$forEach$iv = (Iterable)object;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Tracker it = (Tracker)element$iv;
                            boolean bl = false;
                            it.setSignalStrength(((UDPPacket19SignalStrength)packet).getSignalStrength());
                        }
                    }
                } else if (uDPPacket instanceof UDPPacket20Temperature) {
                    Object object = connection;
                    if (object == null || (object = ((UDPDevice)object).getTracker(((UDPPacket20Temperature)packet).getSensorId())) == null) {
                        return;
                    }
                    tracker = object;
                    ((Tracker)tracker).setTemperature(Float.valueOf(((UDPPacket20Temperature)packet).getTemperature()));
                } else if (uDPPacket instanceof UDPPacket21UserAction) {
                    if (connection == null) {
                        return;
                    }
                    String name = "";
                    switch (((UDPPacket21UserAction)packet).getType()) {
                        case 2: {
                            name = "Full reset";
                            VRServer.Companion.getInstance().resetHandler.sendStarted(1);
                            VRServer.resetTrackersFull$default(VRServer.Companion.getInstance(), RESET_SOURCE_NAME, null, 2, null);
                            break;
                        }
                        case 3: {
                            name = "Yaw reset";
                            VRServer.Companion.getInstance().resetHandler.sendStarted(0);
                            VRServer.resetTrackersYaw$default(VRServer.Companion.getInstance(), RESET_SOURCE_NAME, null, 2, null);
                            break;
                        }
                        case 4: {
                            name = "Mounting reset";
                            VRServer.Companion.getInstance().resetHandler.sendStarted(2);
                            VRServer.resetTrackersMounting$default(VRServer.Companion.getInstance(), RESET_SOURCE_NAME, null, 2, null);
                            break;
                        }
                        case 5: {
                            name = "Pause tracking toggle";
                            VRServer.Companion.getInstance().togglePauseTracking(RESET_SOURCE_NAME);
                        }
                    }
                    LogManager.info("[TrackerServer] User action from " + connection.descriptiveName + " received. " + name + " performed.");
                } else if (uDPPacket instanceof UDPPacket22FeatureFlags) {
                    if (connection == null) {
                        return;
                    }
                    this.bb.limit(this.bb.capacity());
                    this.bb.rewind();
                    ByteBuffer byteBuffer = this.bb;
                    Intrinsics.checkNotNullExpressionValue(byteBuffer, "bb");
                    this.parser.write(byteBuffer, connection, packet);
                    DatagramSocket datagramSocket = this.socket;
                    if (datagramSocket == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("socket");
                        datagramSocket = null;
                    }
                    datagramSocket.send(new DatagramPacket(this.rcvBuffer, this.bb.position(), connection.getAddress()));
                    connection.setFirmwareFeatures(((UDPPacket22FeatureFlags)packet).getFirmwareFeatures());
                } else if (uDPPacket instanceof UDPPacket24AckConfigChange) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List<Object> list;
                    if (connection == null) {
                        return;
                    }
                    Deque<ConfigStateWaiter> deque = this.queues.get(new Triple<SocketAddress, ConfigTypeId, Integer>(connection.getAddress(), ConfigTypeId.box-impl(((UDPPacket24AckConfigChange)packet).getConfigType-LSZ9PFI()), ((UDPPacket24AckConfigChange)packet).getSensorId()));
                    if (deque == null) {
                        TrackersUDPServer $this$processPacket_u24lambda_u2425 = this;
                        boolean bl = false;
                        LogManager.severe("[TrackerServer] Error, acknowledgment of config change that we don't have in our queue.");
                        return;
                    }
                    Deque<ConfigStateWaiter> queue = deque;
                    ConfigStateWaiter changed = queue.removeFirst();
                    ((Continuation)changed.getChannel()).resumeWith(Result.constructor-impl(true));
                    if (SensorSpecificPacket.Companion.isGlobal(((UDPPacket24AckConfigChange)packet).getSensorId())) {
                        Collection collection = ((ConcurrentHashMap)connection.getTrackers()).values();
                        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                        list = CollectionsKt.toList(collection);
                    } else {
                        Tracker tracker2 = connection.getTracker(((UDPPacket24AckConfigChange)packet).getSensorId());
                        if (tracker2 == null) {
                            return;
                        }
                        list = CollectionsKt.listOf(tracker2);
                    }
                    List<Object> trackers = list;
                    Iterable $this$processPacket_u24lambda_u2425 = trackers;
                    String string = connection.descriptiveName;
                    boolean $i$f$map = false;
                    void element$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Tracker tracker3 = (Tracker)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getTrackerNum());
                    }
                    LogManager.info("[TrackerServer] Acknowledged config change on " + string + " (" + CollectionsKt.joinToString$default((List)destination$iv$iv, null, null, null, 0, null, null, 63, null) + "). Config changed on " + ConfigTypeId.toString-impl(((UDPPacket24AckConfigChange)packet).getConfigType-LSZ9PFI()));
                } else if (uDPPacket instanceof UDPPacket26FlexData) {
                    UDPDevice uDPDevice = connection;
                    Object object = tracker = uDPDevice != null ? uDPDevice.getTracker(((UDPPacket26FlexData)packet).getSensorId()) : null;
                    if (tracker == null) {
                        return;
                    }
                    if (((Tracker)tracker).getTrackerDataType() == TrackerDataType.FLEX_RESISTANCE) {
                        ((Tracker)tracker).getTrackerFlexHandler().setFlexResistance(((UDPPacket26FlexData)packet).getFlexData());
                    } else if (((Tracker)tracker).getTrackerDataType() == TrackerDataType.FLEX_ANGLE) {
                        ((Tracker)tracker).getTrackerFlexHandler().setFlexAngle(((UDPPacket26FlexData)packet).getFlexData());
                    }
                    ((Tracker)tracker).dataTick();
                } else if (!(uDPPacket instanceof UDPPacket200ProtocolChange)) {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @NotNull
    public final List<UDPDevice> getConnections() {
        return this.connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void disconnectDevice(@NotNull UDPDevice device) {
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter(device, "device");
        Object object2 = this.connections;
        synchronized (object2) {
            bl = false;
            bl = this.connections.remove(device);
        }
        object2 = this.connectionsByAddress;
        synchronized (object2) {
            void $this$filterTo$iv$iv;
            bl = false;
            Map<SocketAddress, UDPDevice> map = this.connectionsByAddress;
            boolean $i$f$filter = false;
            Map<SocketAddress, UDPDevice> map2 = map;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry entry = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                UDPDevice dev = (UDPDevice)entry.getValue();
                if (!(dev.getId() == device.getId())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Iterable iterable = destination$iv$iv.keySet();
            object = this.connectionsByAddress;
            boolean $i$f$forEach = false;
            for (Object element$iv : iterable) {
                SocketAddress p0 = (SocketAddress)element$iv;
                boolean bl3 = false;
                object.remove(p0);
            }
            Unit unit = Unit.INSTANCE;
        }
        Map $this$forEach$iv = device.getTrackers();
        boolean $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            object = entry;
            boolean bl2 = false;
            Tracker tracker = (Tracker)object.getValue();
            tracker.setStatus(TrackerStatus.DISCONNECTED);
        }
        LogManager.info("[TrackerServer] Forcefully disconnected " + device.getHardwareIdentifier() + " device.");
    }

    private static final boolean broadcastAddresses$lambda$0(NetworkInterface it) {
        return !it.isLoopback() && it.isUp() && !it.isPointToPoint() && !it.isVirtual();
    }

    private static final Sequence broadcastAddresses$lambda$1(NetworkInterface it) {
        List<InterfaceAddress> list = it.getInterfaceAddresses();
        Intrinsics.checkNotNullExpressionValue(list, "getInterfaceAddresses(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    private static final InetAddress broadcastAddresses$lambda$2(InterfaceAddress it) {
        return it.getBroadcast();
    }

    private static final boolean broadcastAddresses$lambda$3(InetAddress it) {
        return it != null && it.isSiteLocalAddress();
    }

    private static final InetSocketAddress broadcastAddresses$lambda$4(TrackersUDPServer this$0, InetAddress it) {
        return new InetSocketAddress(it, this$0.port);
    }

    private static final Deque setConfigFlag_IGi9fH8$lambda$14(Triple triple) {
        Intrinsics.checkNotNullParameter(triple, "<unused var>");
        return new ConcurrentLinkedDeque();
    }

    private static final Deque setConfigFlag_IGi9fH8$lambda$15(Function1 $tmp0, Object p0) {
        return (Deque)$tmp0.invoke(p0);
    }

    static {
        Quaternion quaternion = Quaternion.Companion.fromRotationVector(-1.5707964f, 0.0f, 0.0f);
        AXES_OFFSET-w = quaternion.unbox-impl-w();
        AXES_OFFSET-x = quaternion.unbox-impl-x();
        AXES_OFFSET-y = quaternion.unbox-impl-y();
        AXES_OFFSET-z = quaternion.unbox-impl-z();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u0018\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/slimevr/tracking/trackers/udp/TrackersUDPServer$Companion;", "", "<init>", "()V", "AXES_OFFSET", "Lio/github/axisangles/ktmath/Quaternion;", "getAXES_OFFSET", "()Lio/github/axisangles/ktmath/Quaternion;", "AXES_OFFSET-w", "F", "RESET_SOURCE_NAME", "", "packetToString", "packet", "Ljava/net/DatagramPacket;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final Quaternion getAXES_OFFSET() {
            return Quaternion.box-impl(AXES_OFFSET-w, AXES_OFFSET-x, AXES_OFFSET-y, AXES_OFFSET-z);
        }

        private final String packetToString(DatagramPacket packet) {
            StringBuilder sb = new StringBuilder();
            sb.append("DatagramPacket{");
            if (packet == null) {
                v0 = sb.append("null");
            } else {
                sb.append(packet.getAddress().toString());
                sb.append(':');
                sb.append(packet.getPort());
                sb.append(',');
                sb.append(packet.getLength());
                sb.append(',');
                sb.append('{');
                sb.append(HexFormat.ofDelimiter(",").formatHex(packet.getData(), 0, packet.getLength()));
                v0 = sb.append('}');
            }
            sb.append('}');
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        public final /* synthetic */ float getAXES_OFFSET-w() {
            return AXES_OFFSET-w;
        }

        public final /* synthetic */ float getAXES_OFFSET-x() {
            return AXES_OFFSET-x;
        }

        public final /* synthetic */ float getAXES_OFFSET-y() {
            return AXES_OFFSET-y;
        }

        public final /* synthetic */ float getAXES_OFFSET-z() {
            return AXES_OFFSET-z;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Ldev/slimevr/tracking/trackers/udp/TrackersUDPServer$ConfigStateWaiter;", "", "expectedState", "", "channel", "Lkotlinx/coroutines/CancellableContinuation;", "ran", "<init>", "(ZLkotlinx/coroutines/CancellableContinuation;Z)V", "getExpectedState", "()Z", "getChannel", "()Lkotlinx/coroutines/CancellableContinuation;", "getRan", "setRan", "(Z)V", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "core"})
    private static final class ConfigStateWaiter {
        private final boolean expectedState;
        @NotNull
        private final CancellableContinuation<Boolean> channel;
        private boolean ran;

        public ConfigStateWaiter(boolean expectedState, @NotNull CancellableContinuation<? super Boolean> channel, boolean ran) {
            Intrinsics.checkNotNullParameter(channel, "channel");
            this.expectedState = expectedState;
            this.channel = channel;
            this.ran = ran;
        }

        public /* synthetic */ ConfigStateWaiter(boolean bl, CancellableContinuation cancellableContinuation, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(bl, cancellableContinuation, bl2);
        }

        public final boolean getExpectedState() {
            return this.expectedState;
        }

        @NotNull
        public final CancellableContinuation<Boolean> getChannel() {
            return this.channel;
        }

        public final boolean getRan() {
            return this.ran;
        }

        public final void setRan(boolean bl) {
            this.ran = bl;
        }

        public final boolean component1() {
            return this.expectedState;
        }

        @NotNull
        public final CancellableContinuation<Boolean> component2() {
            return this.channel;
        }

        public final boolean component3() {
            return this.ran;
        }

        @NotNull
        public final ConfigStateWaiter copy(boolean expectedState, @NotNull CancellableContinuation<? super Boolean> channel, boolean ran) {
            Intrinsics.checkNotNullParameter(channel, "channel");
            return new ConfigStateWaiter(expectedState, channel, ran);
        }

        public static /* synthetic */ ConfigStateWaiter copy$default(ConfigStateWaiter configStateWaiter, boolean bl, CancellableContinuation cancellableContinuation, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = configStateWaiter.expectedState;
            }
            if ((n & 2) != 0) {
                cancellableContinuation = configStateWaiter.channel;
            }
            if ((n & 4) != 0) {
                bl2 = configStateWaiter.ran;
            }
            return configStateWaiter.copy(bl, cancellableContinuation, bl2);
        }

        @NotNull
        public String toString() {
            return "ConfigStateWaiter(expectedState=" + this.expectedState + ", channel=" + this.channel + ", ran=" + this.ran + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.expectedState);
            result = result * 31 + this.channel.hashCode();
            result = result * 31 + Boolean.hashCode(this.ran);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConfigStateWaiter)) {
                return false;
            }
            ConfigStateWaiter configStateWaiter = (ConfigStateWaiter)other;
            if (this.expectedState != configStateWaiter.expectedState) {
                return false;
            }
            if (!Intrinsics.areEqual(this.channel, configStateWaiter.channel)) {
                return false;
            }
            return this.ran == configStateWaiter.ran;
        }
    }
}

