/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.trackers.udp;

import dev.slimevr.NetworkProtocol;
import dev.slimevr.VRServer;
import dev.slimevr.tracking.trackers.Device;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.udp.BoardType;
import dev.slimevr.tracking.trackers.udp.ConfigTypeId;
import dev.slimevr.tracking.trackers.udp.FirmwareFeatures;
import dev.slimevr.tracking.trackers.udp.MCUType;
import dev.slimevr.tracking.trackers.udp.TrackersUDPServer;
import dev.slimevr.tracking.trackers.udp.UDPDevice;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001e\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0002\u0010<J\u000e\u0010C\u001a\u0002022\u0006\u0010D\u001a\u00020!J\b\u0010E\u001a\u00020\u0007H\u0016J\u0010\u0010I\u001a\u0004\u0018\u0001052\u0006\u0010\u001c\u001a\u00020\u001dR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00020!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u00020\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00020!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R(\u0010$\u001a\u0004\u0018\u00010\u00072\b\u0010$\u001a\u0004\u0018\u00010\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0017\"\u0004\b&\u0010'R\u0014\u0010(\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\u00060*j\u0002`+8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010,\u001a\u00020!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010-\u001a\u00020!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u0004\u0018\u00010/8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00100\u001a\u00020\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00101\u001a\u0002028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R \u00103\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020504X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u001a\u0010=\u001a\u00020>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR(\u0010F\u001a\u0004\u0018\u00010\u00072\b\u0010F\u001a\u0004\u0018\u00010\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bG\u0010\u0017\"\u0004\bH\u0010'\u00a8\u0006J"}, d2={"Ldev/slimevr/tracking/trackers/udp/UDPDevice;", "Ldev/slimevr/tracking/trackers/Device;", "address", "Ljava/net/SocketAddress;", "ipAddress", "Ljava/net/InetAddress;", "hardwareIdentifier", "", "boardType", "Ldev/slimevr/tracking/trackers/udp/BoardType;", "mcuType", "Ldev/slimevr/tracking/trackers/udp/MCUType;", "<init>", "(Ljava/net/SocketAddress;Ljava/net/InetAddress;Ljava/lang/String;Ldev/slimevr/tracking/trackers/udp/BoardType;Ldev/slimevr/tracking/trackers/udp/MCUType;)V", "getAddress", "()Ljava/net/SocketAddress;", "setAddress", "(Ljava/net/SocketAddress;)V", "getIpAddress", "()Ljava/net/InetAddress;", "setIpAddress", "(Ljava/net/InetAddress;)V", "getHardwareIdentifier", "()Ljava/lang/String;", "getBoardType", "()Ldev/slimevr/tracking/trackers/udp/BoardType;", "getMcuType", "()Ldev/slimevr/tracking/trackers/udp/MCUType;", "id", "", "getId", "()I", "lastPacket", "", "lastPingPacketId", "lastPingPacketTime", "name", "getName", "setName", "(Ljava/lang/String;)V", "descriptiveName", "serialBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "lastSerialUpdate", "lastPacketNumber", "protocol", "Ldev/slimevr/NetworkProtocol;", "protocolVersion", "timedOut", "", "trackers", "Ljava/util/concurrent/ConcurrentHashMap;", "Ldev/slimevr/tracking/trackers/Tracker;", "getTrackers", "()Ljava/util/concurrent/ConcurrentHashMap;", "setMag", "", "state", "sensorId", "(ZILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "firmwareFeatures", "Ldev/slimevr/tracking/trackers/udp/FirmwareFeatures;", "getFirmwareFeatures", "()Ldev/slimevr/tracking/trackers/udp/FirmwareFeatures;", "setFirmwareFeatures", "(Ldev/slimevr/tracking/trackers/udp/FirmwareFeatures;)V", "isNextPacket", "packetId", "toString", "manufacturer", "getManufacturer", "setManufacturer", "getTracker", "core"})
@SourceDebugExtension(value={"SMAP\nUDPDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UDPDevice.kt\ndev/slimevr/tracking/trackers/udp/UDPDevice\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n216#2,2:87\n1#3:89\n*S KotlinDebug\n*F\n+ 1 UDPDevice.kt\ndev/slimevr/tracking/trackers/udp/UDPDevice\n*L\n60#1:87,2\n*E\n"})
public final class UDPDevice
extends Device {
    @NotNull
    private SocketAddress address;
    @NotNull
    private InetAddress ipAddress;
    @NotNull
    private final String hardwareIdentifier;
    @NotNull
    private final BoardType boardType;
    @NotNull
    private final MCUType mcuType;
    private final int id;
    @JvmField
    public long lastPacket;
    @JvmField
    public int lastPingPacketId;
    @JvmField
    public long lastPingPacketTime;
    @Nullable
    private String name;
    @JvmField
    @Nullable
    public String descriptiveName;
    @JvmField
    @NotNull
    public StringBuilder serialBuffer;
    @JvmField
    public long lastSerialUpdate;
    @JvmField
    public long lastPacketNumber;
    @JvmField
    @Nullable
    public NetworkProtocol protocol;
    @JvmField
    public int protocolVersion;
    @JvmField
    public boolean timedOut;
    @NotNull
    private final ConcurrentHashMap<Integer, Tracker> trackers;
    @NotNull
    private FirmwareFeatures firmwareFeatures;

    public UDPDevice(@NotNull SocketAddress address, @NotNull InetAddress ipAddress, @NotNull String hardwareIdentifier, @NotNull BoardType boardType, @NotNull MCUType mcuType) {
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(ipAddress, "ipAddress");
        Intrinsics.checkNotNullParameter(hardwareIdentifier, "hardwareIdentifier");
        Intrinsics.checkNotNullParameter((Object)boardType, "boardType");
        Intrinsics.checkNotNullParameter((Object)mcuType, "mcuType");
        super(true);
        this.address = address;
        this.ipAddress = ipAddress;
        this.hardwareIdentifier = hardwareIdentifier;
        this.boardType = boardType;
        this.mcuType = mcuType;
        this.id = Device.getNextLocalDeviceId().incrementAndGet();
        this.lastPacket = System.currentTimeMillis();
        this.lastPingPacketId = -1;
        this.serialBuffer = new StringBuilder();
        this.lastPacketNumber = -1L;
        this.trackers = new ConcurrentHashMap();
        this.firmwareFeatures = new FirmwareFeatures();
    }

    public /* synthetic */ UDPDevice(SocketAddress socketAddress, InetAddress inetAddress, String string, BoardType boardType, MCUType mCUType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            boardType = BoardType.UNKNOWN;
        }
        if ((n & 0x10) != 0) {
            mCUType = MCUType.UNKNOWN;
        }
        this(socketAddress, inetAddress, string, boardType, mCUType);
    }

    @NotNull
    public final SocketAddress getAddress() {
        return this.address;
    }

    public final void setAddress(@NotNull SocketAddress socketAddress) {
        Intrinsics.checkNotNullParameter(socketAddress, "<set-?>");
        this.address = socketAddress;
    }

    @NotNull
    public final InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public final void setIpAddress(@NotNull InetAddress inetAddress) {
        Intrinsics.checkNotNullParameter(inetAddress, "<set-?>");
        this.ipAddress = inetAddress;
    }

    @Override
    @NotNull
    public String getHardwareIdentifier() {
        return this.hardwareIdentifier;
    }

    @Override
    @NotNull
    public BoardType getBoardType() {
        return this.boardType;
    }

    @Override
    @NotNull
    public MCUType getMcuType() {
        return this.mcuType;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@Nullable String name) {
        super.setName(name);
        this.name = name;
    }

    @NotNull
    public ConcurrentHashMap<Integer, Tracker> getTrackers() {
        return this.trackers;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object setMag(boolean var1_1, int var2_2, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof setMag.1)) ** GOTO lbl-1000
        var12_4 = $completion;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                boolean Z$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ UDPDevice this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.setMag(false, 0, this);
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                if (sensorId != 255) break;
                $continuation.L$0 = this;
                $continuation.Z$0 = state;
                $continuation.label = 1;
                v0 = TrackersUDPServer.setConfigFlag-IGi9fH8$default(VRServer.Companion.getInstance().getTrackersServer(), this, ConfigTypeId.constructor-impl((short)1), state != false, 0, $continuation, 8, null);
                if (v0 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                state = $continuation.Z$0;
                this = (UDPDevice)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl25:
                // 2 sources

                $this$forEach$iv = this.getTrackers();
                $i$f$forEach = false;
                var6_11 = $this$forEach$iv.entrySet().iterator();
                while (var6_11.hasNext()) {
                    var8_13 = element$iv = var6_11.next();
                    $i$a$-forEach-UDPDevice$setMag$2 = false;
                    t = (Tracker)var8_13.getValue();
                    t.setMagPrivate$core(state != false);
                }
                ** GOTO lbl56
            }
        }
        if (!(this.getTrackers().get(Boxing.boxInt(sensorId)) != null)) {
            $i$a$-require-UDPDevice$setMag$3 = false;
            var5_10 = "There is no tracker " + sensorId + " in device " + this;
            throw new IllegalArgumentException(var5_10.toString());
        }
        $continuation.L$0 = this;
        $continuation.Z$0 = state;
        $continuation.I$0 = sensorId;
        $continuation.label = 2;
        v1 = VRServer.Companion.getInstance().getTrackersServer().setConfigFlag-IGi9fH8(this, ConfigTypeId.constructor-impl((short)1), state != false, sensorId, $continuation);
        if (v1 == var13_6) {
            return var13_6;
        }
        ** GOTO lbl53
        {
            case 2: {
                sensorId = $continuation.I$0;
                state = $continuation.Z$0;
                this = (UDPDevice)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl53:
                // 2 sources

                v2 = this.getTrackers().get(Boxing.boxInt(sensorId));
                Intrinsics.checkNotNull(v2);
                ((Tracker)v2).setMagPrivate$core(state != false);
lbl56:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final FirmwareFeatures getFirmwareFeatures() {
        return this.firmwareFeatures;
    }

    public final void setFirmwareFeatures(@NotNull FirmwareFeatures firmwareFeatures) {
        Intrinsics.checkNotNullParameter(firmwareFeatures, "<set-?>");
        this.firmwareFeatures = firmwareFeatures;
    }

    public final boolean isNextPacket(long packetId) {
        if (packetId != 0L && packetId <= this.lastPacketNumber) {
            return false;
        }
        this.lastPacketNumber = packetId;
        return true;
    }

    @NotNull
    public String toString() {
        return "udp:/" + this.ipAddress;
    }

    @Override
    @Nullable
    public String getManufacturer() {
        return "SlimeVR";
    }

    @Override
    public void setManufacturer(@Nullable String manufacturer) {
        super.setManufacturer(manufacturer);
    }

    @Nullable
    public final Tracker getTracker(int id) {
        return (Tracker)((ConcurrentHashMap)this.getTrackers()).get(id);
    }
}

