/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.trackers.udp;

import dev.slimevr.tracking.trackers.udp.BoardType;
import dev.slimevr.tracking.trackers.udp.IMUType;
import dev.slimevr.tracking.trackers.udp.MCUType;
import dev.slimevr.tracking.trackers.udp.UDPPacket;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0007H\u00c6\u0003J\t\u0010-\u001a\u00020\tH\u00c6\u0003J\u000b\u0010.\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JI\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J\t\u00105\u001a\u00020\tH\u00d6\u0001J\t\u00106\u001a\u00020\u000bH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010 \"\u0004\b$\u0010\"\u00a8\u00067"}, d2={"Ldev/slimevr/tracking/trackers/udp/UDPPacket3Handshake;", "Ldev/slimevr/tracking/trackers/udp/UDPPacket;", "boardType", "Ldev/slimevr/tracking/trackers/udp/BoardType;", "imuType", "Ldev/slimevr/tracking/trackers/udp/IMUType;", "mcuType", "Ldev/slimevr/tracking/trackers/udp/MCUType;", "protocolVersion", "", "firmware", "", "macString", "<init>", "(Ldev/slimevr/tracking/trackers/udp/BoardType;Ldev/slimevr/tracking/trackers/udp/IMUType;Ldev/slimevr/tracking/trackers/udp/MCUType;ILjava/lang/String;Ljava/lang/String;)V", "getBoardType", "()Ldev/slimevr/tracking/trackers/udp/BoardType;", "setBoardType", "(Ldev/slimevr/tracking/trackers/udp/BoardType;)V", "getImuType", "()Ldev/slimevr/tracking/trackers/udp/IMUType;", "setImuType", "(Ldev/slimevr/tracking/trackers/udp/IMUType;)V", "getMcuType", "()Ldev/slimevr/tracking/trackers/udp/MCUType;", "setMcuType", "(Ldev/slimevr/tracking/trackers/udp/MCUType;)V", "getProtocolVersion", "()I", "setProtocolVersion", "(I)V", "getFirmware", "()Ljava/lang/String;", "setFirmware", "(Ljava/lang/String;)V", "getMacString", "setMacString", "readData", "", "buf", "Ljava/nio/ByteBuffer;", "writeData", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "toString", "core"})
public final class UDPPacket3Handshake
extends UDPPacket {
    @NotNull
    private BoardType boardType;
    @NotNull
    private IMUType imuType;
    @NotNull
    private MCUType mcuType;
    private int protocolVersion;
    @Nullable
    private String firmware;
    @Nullable
    private String macString;

    public UDPPacket3Handshake(@NotNull BoardType boardType, @NotNull IMUType imuType, @NotNull MCUType mcuType, int protocolVersion, @Nullable String firmware, @Nullable String macString) {
        Intrinsics.checkNotNullParameter((Object)boardType, "boardType");
        Intrinsics.checkNotNullParameter((Object)imuType, "imuType");
        Intrinsics.checkNotNullParameter((Object)mcuType, "mcuType");
        super(3, null);
        this.boardType = boardType;
        this.imuType = imuType;
        this.mcuType = mcuType;
        this.protocolVersion = protocolVersion;
        this.firmware = firmware;
        this.macString = macString;
    }

    public /* synthetic */ UDPPacket3Handshake(BoardType boardType, IMUType iMUType, MCUType mCUType, int n, String string, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            boardType = BoardType.UNKNOWN;
        }
        if ((n2 & 2) != 0) {
            iMUType = IMUType.UNKNOWN;
        }
        if ((n2 & 4) != 0) {
            mCUType = MCUType.UNKNOWN;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            string = null;
        }
        if ((n2 & 0x20) != 0) {
            string2 = null;
        }
        this(boardType, iMUType, mCUType, n, string, string2);
    }

    @NotNull
    public final BoardType getBoardType() {
        return this.boardType;
    }

    public final void setBoardType(@NotNull BoardType boardType) {
        Intrinsics.checkNotNullParameter((Object)boardType, "<set-?>");
        this.boardType = boardType;
    }

    @NotNull
    public final IMUType getImuType() {
        return this.imuType;
    }

    public final void setImuType(@NotNull IMUType iMUType) {
        Intrinsics.checkNotNullParameter((Object)iMUType, "<set-?>");
        this.imuType = iMUType;
    }

    @NotNull
    public final MCUType getMcuType() {
        return this.mcuType;
    }

    public final void setMcuType(@NotNull MCUType mCUType) {
        Intrinsics.checkNotNullParameter((Object)mCUType, "<set-?>");
        this.mcuType = mCUType;
    }

    public final int getProtocolVersion() {
        return this.protocolVersion;
    }

    public final void setProtocolVersion(int n) {
        this.protocolVersion = n;
    }

    @Nullable
    public final String getFirmware() {
        return this.firmware;
    }

    public final void setFirmware(@Nullable String string) {
        this.firmware = string;
    }

    @Nullable
    public final String getMacString() {
        return this.macString;
    }

    public final void setMacString(@Nullable String string) {
        this.macString = string;
    }

    @Override
    public void readData(@NotNull ByteBuffer buf) {
        MCUType mCUType;
        IMUType iMUType;
        BoardType boardType;
        Intrinsics.checkNotNullParameter(buf, "buf");
        if (buf.remaining() == 0) {
            return;
        }
        if (buf.remaining() > 3 && (boardType = BoardType.Companion.getById-WZ4Q5Ns(UInt.constructor-impl(buf.getInt()))) == null) {
            boardType = this.boardType = BoardType.UNKNOWN;
        }
        if (buf.remaining() > 3 && (iMUType = IMUType.Companion.getById-WZ4Q5Ns(UInt.constructor-impl(buf.getInt()))) == null) {
            iMUType = this.imuType = IMUType.UNKNOWN;
        }
        if (buf.remaining() > 3 && (mCUType = MCUType.Companion.getById-WZ4Q5Ns(UInt.constructor-impl(buf.getInt()))) == null) {
            mCUType = this.mcuType = MCUType.UNKNOWN;
        }
        if (buf.remaining() > 11) {
            buf.getInt();
            buf.getInt();
            buf.getInt();
        }
        if (buf.remaining() > 3) {
            this.protocolVersion = buf.getInt();
        }
        byte length = 0;
        if (buf.remaining() > 0) {
            length = buf.get();
        }
        this.firmware = UDPPacket.Companion.readASCIIString(buf, length);
        byte[] mac = new byte[6];
        if (buf.remaining() >= mac.length) {
            buf.get(mac);
            String string = "%02X:%02X:%02X:%02X:%02X:%02X";
            Object[] objectArray = new Object[]{mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            this.macString = string2;
            if (Intrinsics.areEqual(this.macString, "00:00:00:00:00:00")) {
                this.macString = null;
            }
        }
    }

    @Override
    public void writeData(@NotNull ByteBuffer buf) {
        Intrinsics.checkNotNullParameter(buf, "buf");
    }

    @NotNull
    public final BoardType component1() {
        return this.boardType;
    }

    @NotNull
    public final IMUType component2() {
        return this.imuType;
    }

    @NotNull
    public final MCUType component3() {
        return this.mcuType;
    }

    public final int component4() {
        return this.protocolVersion;
    }

    @Nullable
    public final String component5() {
        return this.firmware;
    }

    @Nullable
    public final String component6() {
        return this.macString;
    }

    @NotNull
    public final UDPPacket3Handshake copy(@NotNull BoardType boardType, @NotNull IMUType imuType, @NotNull MCUType mcuType, int protocolVersion, @Nullable String firmware, @Nullable String macString) {
        Intrinsics.checkNotNullParameter((Object)boardType, "boardType");
        Intrinsics.checkNotNullParameter((Object)imuType, "imuType");
        Intrinsics.checkNotNullParameter((Object)mcuType, "mcuType");
        return new UDPPacket3Handshake(boardType, imuType, mcuType, protocolVersion, firmware, macString);
    }

    public static /* synthetic */ UDPPacket3Handshake copy$default(UDPPacket3Handshake uDPPacket3Handshake, BoardType boardType, IMUType iMUType, MCUType mCUType, int n, String string, String string2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            boardType = uDPPacket3Handshake.boardType;
        }
        if ((n2 & 2) != 0) {
            iMUType = uDPPacket3Handshake.imuType;
        }
        if ((n2 & 4) != 0) {
            mCUType = uDPPacket3Handshake.mcuType;
        }
        if ((n2 & 8) != 0) {
            n = uDPPacket3Handshake.protocolVersion;
        }
        if ((n2 & 0x10) != 0) {
            string = uDPPacket3Handshake.firmware;
        }
        if ((n2 & 0x20) != 0) {
            string2 = uDPPacket3Handshake.macString;
        }
        return uDPPacket3Handshake.copy(boardType, iMUType, mCUType, n, string, string2);
    }

    @NotNull
    public String toString() {
        return "UDPPacket3Handshake(boardType=" + this.boardType + ", imuType=" + this.imuType + ", mcuType=" + this.mcuType + ", protocolVersion=" + this.protocolVersion + ", firmware=" + this.firmware + ", macString=" + this.macString + ")";
    }

    public int hashCode() {
        int result = this.boardType.hashCode();
        result = result * 31 + this.imuType.hashCode();
        result = result * 31 + this.mcuType.hashCode();
        result = result * 31 + Integer.hashCode(this.protocolVersion);
        result = result * 31 + (this.firmware == null ? 0 : this.firmware.hashCode());
        result = result * 31 + (this.macString == null ? 0 : this.macString.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UDPPacket3Handshake)) {
            return false;
        }
        UDPPacket3Handshake uDPPacket3Handshake = (UDPPacket3Handshake)other;
        if (this.boardType != uDPPacket3Handshake.boardType) {
            return false;
        }
        if (this.imuType != uDPPacket3Handshake.imuType) {
            return false;
        }
        if (this.mcuType != uDPPacket3Handshake.mcuType) {
            return false;
        }
        if (this.protocolVersion != uDPPacket3Handshake.protocolVersion) {
            return false;
        }
        if (!Intrinsics.areEqual(this.firmware, uDPPacket3Handshake.firmware)) {
            return false;
        }
        return Intrinsics.areEqual(this.macString, uDPPacket3Handshake.macString);
    }

    public UDPPacket3Handshake() {
        this(null, null, null, 0, null, null, 63, null);
    }
}

