/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.tracking.trackers.udp;

import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.udp.UDPDevice;
import dev.slimevr.tracking.trackers.udp.UDPPacket;
import dev.slimevr.tracking.trackers.udp.UDPPacket0Heartbeat;
import dev.slimevr.tracking.trackers.udp.UDPPacket10PingPong;
import dev.slimevr.tracking.trackers.udp.UDPPacket11Serial;
import dev.slimevr.tracking.trackers.udp.UDPPacket12BatteryLevel;
import dev.slimevr.tracking.trackers.udp.UDPPacket13Tap;
import dev.slimevr.tracking.trackers.udp.UDPPacket14Error;
import dev.slimevr.tracking.trackers.udp.UDPPacket15SensorInfo;
import dev.slimevr.tracking.trackers.udp.UDPPacket16Rotation2;
import dev.slimevr.tracking.trackers.udp.UDPPacket17RotationData;
import dev.slimevr.tracking.trackers.udp.UDPPacket18MagnetometerAccuracy;
import dev.slimevr.tracking.trackers.udp.UDPPacket19SignalStrength;
import dev.slimevr.tracking.trackers.udp.UDPPacket1Rotation;
import dev.slimevr.tracking.trackers.udp.UDPPacket200ProtocolChange;
import dev.slimevr.tracking.trackers.udp.UDPPacket20Temperature;
import dev.slimevr.tracking.trackers.udp.UDPPacket21UserAction;
import dev.slimevr.tracking.trackers.udp.UDPPacket22FeatureFlags;
import dev.slimevr.tracking.trackers.udp.UDPPacket24AckConfigChange;
import dev.slimevr.tracking.trackers.udp.UDPPacket26FlexData;
import dev.slimevr.tracking.trackers.udp.UDPPacket3Handshake;
import dev.slimevr.tracking.trackers.udp.UDPPacket4Acceleration;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u0006J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0004\u00a8\u0006\u0016"}, d2={"Ldev/slimevr/tracking/trackers/udp/UDPProtocolParser;", "", "<init>", "()V", "parse", "", "Ldev/slimevr/tracking/trackers/udp/UDPPacket;", "buf", "Ljava/nio/ByteBuffer;", "connection", "Ldev/slimevr/tracking/trackers/udp/UDPDevice;", "(Ljava/nio/ByteBuffer;Ldev/slimevr/tracking/trackers/udp/UDPDevice;)[Ldev/slimevr/tracking/trackers/udp/UDPPacket;", "write", "", "packet", "writeHandshakeResponse", "writeSensorInfoResponse", "Ldev/slimevr/tracking/trackers/udp/UDPPacket15SensorInfo;", "getNewPacket", "packetId", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nUDPProtocolParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UDPProtocolParser.kt\ndev/slimevr/tracking/trackers/udp/UDPProtocolParser\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,168:1\n216#2,2:169\n37#3,2:171\n37#3,2:173\n*S KotlinDebug\n*F\n+ 1 UDPProtocolParser.kt\ndev/slimevr/tracking/trackers/udp/UDPProtocolParser\n*L\n20#1:169,2\n42#1:171,2\n61#1:173,2\n*E\n"})
public final class UDPProtocolParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int PACKET_HEARTBEAT = 0;
    public static final int PACKET_ROTATION = 1;
    public static final int PACKET_HANDSHAKE = 3;
    public static final int PACKET_ACCEL = 4;
    public static final int PACKET_PING_PONG = 10;
    public static final int PACKET_SERIAL = 11;
    public static final int PACKET_BATTERY_LEVEL = 12;
    public static final int PACKET_TAP = 13;
    public static final int PACKET_ERROR = 14;
    public static final int PACKET_SENSOR_INFO = 15;
    public static final int PACKET_ROTATION_2 = 16;
    public static final int PACKET_ROTATION_DATA = 17;
    public static final int PACKET_MAGNETOMETER_ACCURACY = 18;
    public static final int PACKET_SIGNAL_STRENGTH = 19;
    public static final int PACKET_TEMPERATURE = 20;
    public static final int PACKET_USER_ACTION = 21;
    public static final int PACKET_FEATURE_FLAGS = 22;
    public static final int PACKET_ROTATION_AND_ACCELERATION = 23;
    public static final int PACKET_ACK_CONFIG_CHANGE = 24;
    public static final int PACKET_SET_CONFIG_FLAG = 25;
    public static final int PACKET_FLEX_DATA = 26;
    public static final int PACKET_BUNDLE = 100;
    public static final int PACKET_BUNDLE_COMPACT = 101;
    public static final int PACKET_PROTOCOL_CHANGE = 200;
    @NotNull
    private static final byte[] HANDSHAKE_BUFFER = new byte[64];
    @NotNull
    private static final ArrayList<UDPPacket> bundlePackets = new ArrayList(128);

    @NotNull
    public final UDPPacket[] parse(@NotNull ByteBuffer buf, @Nullable UDPDevice connection) throws IOException {
        Intrinsics.checkNotNullParameter(buf, "buf");
        int packetId = buf.getInt();
        long packetNumber = buf.getLong();
        if (connection != null) {
            if (!connection.isNextPacket(packetNumber)) {
                throw new IOException("Out of order packet received: id " + packetId + ", number " + packetNumber + ", last " + connection.lastPacketNumber + ", from " + connection);
            }
            connection.lastPacket = System.currentTimeMillis();
            Map $this$forEach$iv = connection.getTrackers();
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                Tracker tracker = (Tracker)entry.getValue();
                tracker.heartbeat();
            }
        }
        switch (packetId) {
            case 100: {
                UDPPacket newPacket;
                ByteBuffer bundleBuf;
                int bundlePacketStart;
                bundlePackets.clear();
                while (buf.hasRemaining()) {
                    int bundlePacketLen = Math.min(buf.getShort(), buf.remaining());
                    if (bundlePacketLen == 0) continue;
                    bundlePacketStart = buf.position();
                    bundleBuf = buf.slice();
                    bundleBuf.limit(bundlePacketLen);
                    int bundlePacketId = bundleBuf.getInt();
                    newPacket = this.getNewPacket(bundlePacketId);
                    if (newPacket != null) {
                        boolean bl = false;
                        Intrinsics.checkNotNull(bundleBuf);
                        newPacket.readData(bundleBuf);
                        bundlePackets.add(newPacket);
                    }
                    buf.position(bundlePacketStart + bundlePacketLen);
                }
                Collection $this$toTypedArray$iv = bundlePackets;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new UDPPacket[0]);
            }
            case 101: {
                UDPPacket newPacket;
                ByteBuffer bundleBuf;
                int bundlePacketStart;
                bundlePackets.clear();
                while (buf.hasRemaining()) {
                    int bundlePacketLen = Math.min(UByte.constructor-impl(buf.get()) & 0xFF, buf.remaining());
                    if (bundlePacketLen == 0) continue;
                    bundlePacketStart = buf.position();
                    bundleBuf = buf.slice();
                    bundleBuf.limit(bundlePacketLen);
                    int bundlePacketId = UByte.constructor-impl(bundleBuf.get()) & 0xFF;
                    newPacket = this.getNewPacket(bundlePacketId);
                    if (newPacket != null) {
                        boolean bl = false;
                        Intrinsics.checkNotNull(bundleBuf);
                        newPacket.readData(bundleBuf);
                        bundlePackets.add(newPacket);
                    }
                    buf.position(bundlePacketStart + bundlePacketLen);
                }
                Collection $this$toTypedArray$iv = bundlePackets;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new UDPPacket[0]);
            }
        }
        UDPPacket newPacket = this.getNewPacket(packetId);
        if (newPacket != null) {
            newPacket.readData(buf);
        }
        UDPPacket[] uDPPacketArray = new UDPPacket[]{newPacket};
        return uDPPacketArray;
    }

    public final void write(@NotNull ByteBuffer buf, @Nullable UDPDevice connection, @NotNull UDPPacket packet) throws IOException {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Intrinsics.checkNotNullParameter(packet, "packet");
        buf.putInt(packet.getPacketId());
        buf.putLong(0L);
        packet.writeData(buf);
    }

    public final void writeHandshakeResponse(@NotNull ByteBuffer buf, @Nullable UDPDevice connection) throws IOException {
        Intrinsics.checkNotNullParameter(buf, "buf");
        buf.put(HANDSHAKE_BUFFER);
    }

    public final void writeSensorInfoResponse(@NotNull ByteBuffer buf, @Nullable UDPDevice connection, @NotNull UDPPacket15SensorInfo packet) throws IOException {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Intrinsics.checkNotNullParameter(packet, "packet");
        buf.putInt(packet.getPacketId());
        buf.put((byte)packet.getSensorId());
        buf.put((byte)packet.getSensorStatus());
    }

    @Nullable
    protected final UDPPacket getNewPacket(int packetId) {
        return switch (packetId) {
            case 0 -> UDPPacket0Heartbeat.INSTANCE;
            case 1 -> new UDPPacket1Rotation(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
            case 3 -> new UDPPacket3Handshake(null, null, null, 0, null, null, 63, null);
            case 10 -> new UDPPacket10PingPong(0, 1, null);
            case 4 -> new UDPPacket4Acceleration(0.0f, 0.0f, 0.0f, 7, null);
            case 11 -> new UDPPacket11Serial(null, 1, null);
            case 12 -> new UDPPacket12BatteryLevel(0.0f, 0.0f, 3, null);
            case 13 -> new UDPPacket13Tap(null, 1, null);
            case 14 -> new UDPPacket14Error(0, 1, null);
            case 15 -> new UDPPacket15SensorInfo(0, null, null, null, null, null, 63, null);
            case 16 -> new UDPPacket16Rotation2(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
            case 17 -> new UDPPacket17RotationData(0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 63, null);
            case 18 -> new UDPPacket18MagnetometerAccuracy(0.0f, 1, null);
            case 19 -> new UDPPacket19SignalStrength(0, 1, null);
            case 20 -> new UDPPacket20Temperature(0.0f, 1, null);
            case 21 -> new UDPPacket21UserAction(0, 1, null);
            case 22 -> new UDPPacket22FeatureFlags(null, 1, null);
            case 24 -> new UDPPacket24AckConfigChange(0, 0, 3, null);
            case 26 -> new UDPPacket26FlexData(0.0f, 1, null);
            case 200 -> new UDPPacket200ProtocolChange(0, 0, 3, null);
            default -> null;
        };
    }

    static {
        UDPProtocolParser.HANDSHAKE_BUFFER[0] = 3;
        String string = "Hey OVR =D 5";
        Charset charset = StandardCharsets.US_ASCII;
        Intrinsics.checkNotNullExpressionValue(charset, "US_ASCII");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] str = byArray;
        System.arraycopy(str, 0, HANDSHAKE_BUFFER, 1, str.length);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ldev/slimevr/tracking/trackers/udp/UDPProtocolParser$Companion;", "", "<init>", "()V", "PACKET_HEARTBEAT", "", "PACKET_ROTATION", "PACKET_HANDSHAKE", "PACKET_ACCEL", "PACKET_PING_PONG", "PACKET_SERIAL", "PACKET_BATTERY_LEVEL", "PACKET_TAP", "PACKET_ERROR", "PACKET_SENSOR_INFO", "PACKET_ROTATION_2", "PACKET_ROTATION_DATA", "PACKET_MAGNETOMETER_ACCURACY", "PACKET_SIGNAL_STRENGTH", "PACKET_TEMPERATURE", "PACKET_USER_ACTION", "PACKET_FEATURE_FLAGS", "PACKET_ROTATION_AND_ACCELERATION", "PACKET_ACK_CONFIG_CHANGE", "PACKET_SET_CONFIG_FLAG", "PACKET_FLEX_DATA", "PACKET_BUNDLE", "PACKET_BUNDLE_COMPACT", "PACKET_PROTOCOL_CHANGE", "HANDSHAKE_BUFFER", "", "bundlePackets", "Ljava/util/ArrayList;", "Ldev/slimevr/tracking/trackers/udp/UDPPacket;", "Lkotlin/collections/ArrayList;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

