/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.util;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B<\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\b\b\u0002\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0004J\u0006\u0010\u0016\u001a\u00020\bR)\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\n\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/slimevr/util/TickReducer;", "", "onTick", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "delta", "", "interval", "resolution", "<init>", "(Lkotlin/jvm/functions/Function1;FF)V", "getInterval", "()F", "setInterval", "(F)V", "getResolution", "setResolution", "tickDelta", "tickOffset", "tick", "reset", "core"})
public final class TickReducer {
    @NotNull
    private final Function1<Float, Unit> onTick;
    private float interval;
    private float resolution;
    private float tickDelta;
    private float tickOffset;

    public TickReducer(@NotNull Function1<? super Float, Unit> onTick, float interval, float resolution) {
        Intrinsics.checkNotNullParameter(onTick, "onTick");
        this.onTick = onTick;
        this.interval = interval;
        this.resolution = resolution;
    }

    public /* synthetic */ TickReducer(Function1 function1, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f2 = 0.0f;
        }
        this(function1, f, f2);
    }

    public final float getInterval() {
        return this.interval;
    }

    public final void setInterval(float f) {
        this.interval = f;
    }

    public final float getResolution() {
        return this.resolution;
    }

    public final void setResolution(float f) {
        this.resolution = f;
    }

    public final synchronized void tick(float delta) {
        this.tickDelta += delta;
        if (this.tickDelta + this.tickOffset + this.resolution < this.interval) {
            return;
        }
        this.onTick.invoke(Float.valueOf(this.tickDelta));
        this.tickOffset = RangesKt.coerceAtMost(this.tickDelta - this.interval, this.interval / 2.0f);
        this.tickDelta = 0.0f;
    }

    public final synchronized void reset() {
        this.tickDelta = 0.0f;
        this.tickOffset = 0.0f;
    }
}

