/*
 * Decompiled with CFR 0.152.
 */
package dev.slimevr.websocketapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import dev.slimevr.VRServer;
import dev.slimevr.bridge.Bridge;
import dev.slimevr.tracking.trackers.Device;
import dev.slimevr.tracking.trackers.Tracker;
import dev.slimevr.tracking.trackers.TrackerPosition;
import dev.slimevr.tracking.trackers.TrackerRole;
import dev.slimevr.tracking.trackers.TrackerStatus;
import dev.slimevr.websocketapi.WebsocketAPI;
import io.eiren.util.collections.FastList;
import io.eiren.util.logging.LogManager;
import io.github.axisangles.ktmath.Quaternion;
import io.github.axisangles.ktmath.Vector3;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010!\u001a\u00020\u0013H\u0016J\u0012\u0010\"\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010$\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010%\u001a\u00020\u0013H\u0016J\b\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ldev/slimevr/websocketapi/WebSocketVRBridge;", "Ldev/slimevr/websocketapi/WebsocketAPI;", "Ldev/slimevr/bridge/Bridge;", "computedTrackers", "", "Ldev/slimevr/tracking/trackers/Tracker;", "server", "Ldev/slimevr/VRServer;", "<init>", "(Ljava/util/List;Ldev/slimevr/VRServer;)V", "internalTrackers", "", "newHMDData", "Ljava/util/concurrent/atomic/AtomicBoolean;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "internalHMDTracker", "hmdTracker", "dataRead", "", "dataWrite", "onOpen", "conn", "Lorg/java_websocket/WebSocket;", "handshake", "Lorg/java_websocket/handshake/ClientHandshake;", "onMessage", "message", "", "parsePosition", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "parseAction", "onStart", "addSharedTracker", "tracker", "removeSharedTracker", "startBridge", "isConnected", "", "Companion", "core"})
public final class WebSocketVRBridge
extends WebsocketAPI
implements Bridge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Tracker> computedTrackers;
    @NotNull
    private final List<Tracker> internalTrackers;
    @NotNull
    private final AtomicBoolean newHMDData;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final Tracker internalHMDTracker;
    @Nullable
    private Tracker hmdTracker;
    @NotNull
    private static final String RESET_SOURCE_NAME = "WebSocketVRBridge";

    public WebSocketVRBridge(@NotNull List<Tracker> computedTrackers, @NotNull VRServer server) {
        Intrinsics.checkNotNullParameter(computedTrackers, "computedTrackers");
        Intrinsics.checkNotNullParameter(server, "server");
        super(server, server.protocolAPI);
        this.computedTrackers = new FastList<Collection>(computedTrackers);
        this.internalTrackers = new FastList<int>(computedTrackers.size());
        this.newHMDData = new AtomicBoolean(false);
        this.mapper = new ObjectMapper();
        this.internalHMDTracker = new Tracker(null, 0, "internal://HMD", "internal://HMD", TrackerPosition.HEAD, null, true, true, false, false, true, true, null, false, false, false, false, false, false, null, null, 2093856, null);
        for (Tracker t : computedTrackers) {
            Tracker ct = new Tracker(null, t.getId(), "internal://" + t.getName(), "internal://" + t.getName(), t.getTrackerPosition(), null, true, true, false, true, true, false, null, false, false, false, false, false, false, null, null, 2095392, null);
            ct.setStatus(TrackerStatus.OK);
            this.internalTrackers.add(ct);
        }
    }

    @Override
    public void dataRead() {
        if (this.newHMDData.compareAndSet(true, false)) {
            if (this.hmdTracker == null) {
                Device hmdDevice = this.server.deviceManager.createDevice(RESET_SOURCE_NAME, null, null);
                Tracker tracker = this.hmdTracker = new Tracker(null, VRServer.Companion.getNextLocalTrackerId(), "WebSocketHMD", "WebSocketHMD", TrackerPosition.HEAD, null, true, true, false, true, false, true, null, false, false, false, false, false, false, null, null, 2094368, null);
                Intrinsics.checkNotNull(tracker);
                tracker.setStatus(TrackerStatus.OK);
                Map<Integer, Tracker> map = hmdDevice.getTrackers();
                Integer n = 0;
                Tracker tracker2 = this.hmdTracker;
                Intrinsics.checkNotNull(tracker2);
                map.put(n, tracker2);
                Tracker tracker3 = this.hmdTracker;
                Intrinsics.checkNotNull(tracker3);
                this.server.registerTracker(tracker3);
            }
            Tracker tracker = this.hmdTracker;
            Intrinsics.checkNotNull(tracker);
            tracker.setPosition-1s-5YWc(this.internalHMDTracker.getPosition-x(), this.internalHMDTracker.getPosition-y(), this.internalHMDTracker.getPosition-z());
            Quaternion quaternion = this.internalHMDTracker.getRotation();
            Tracker tracker4 = this.hmdTracker;
            Intrinsics.checkNotNull(tracker4);
            tracker4.setRotation-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
            Tracker tracker5 = this.hmdTracker;
            Intrinsics.checkNotNull(tracker5);
            tracker5.dataTick();
        }
    }

    @Override
    public void dataWrite() {
        int n = ((Collection)this.computedTrackers).size();
        for (int i = 0; i < n; ++i) {
            Tracker t = this.computedTrackers.get(i);
            Tracker it = this.internalTrackers.get(i);
            if (t.getHasPosition()) {
                it.setPosition-1s-5YWc(t.getPosition-x(), t.getPosition-y(), t.getPosition-z());
            }
            if (!t.getHasRotation()) continue;
            Quaternion quaternion = t.getRotation();
            it.setRotation-oS71L7k(quaternion.unbox-impl-w(), quaternion.unbox-impl-x(), quaternion.unbox-impl-y(), quaternion.unbox-impl-z());
        }
    }

    @Override
    public void onOpen(@NotNull WebSocket conn, @NotNull ClientHandshake handshake) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(handshake, "handshake");
        super.onOpen(conn, handshake);
        int n = ((Collection)this.internalTrackers).size();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2;
            TrackerRole trackerRole;
            ObjectNode message = this.mapper.getNodeFactory().objectNode();
            message.put("type", "config");
            message.put("tracker_id", "SlimeVR Tracker " + (i + 1));
            TrackerPosition trackerPosition = this.computedTrackers.get(i).getTrackerPosition();
            if (trackerPosition != null && (trackerRole = trackerPosition.getTrackerRole()) != null && (string2 = trackerRole.name()) != null) {
                String string3 = string2;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string4 = string3.toLowerCase(locale);
                string = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
            } else {
                string = null;
            }
            message.put("location", string);
            message.put("tracker_type", message.get("location").asText());
            conn.send(message.toString());
        }
    }

    @Override
    public void onMessage(@NotNull WebSocket conn, @NotNull String message) {
        Intrinsics.checkNotNullParameter(conn, "conn");
        Intrinsics.checkNotNullParameter(message, "message");
        try {
            block15: {
                String string;
                JsonNode jsonNode = this.mapper.readTree(message);
                Intrinsics.checkNotNull(jsonNode, "null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                ObjectNode json = (ObjectNode)jsonNode;
                if (!json.has("type") || (string = json.get("type").asText()) == null) break block15;
                int n = -1;
                switch (string.hashCode()) {
                    case 111188: {
                        if (string.equals("pos")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1422950858: {
                        if (string.equals("action")) {
                            n = 2;
                        }
                        break;
                    }
                    case -1354792126: {
                        if (string.equals("config")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        this.parsePosition(json, conn);
                        return;
                    }
                    case 2: {
                        this.parseAction(json, conn);
                        return;
                    }
                    case 3: {
                        LogManager.info("[WebSocket] Config received: " + json);
                        return;
                    }
                }
            }
            LogManager.warning("[WebSocket] Unrecognized message from " + conn.getRemoteSocketAddress().getAddress().getHostAddress() + ": " + message);
        }
        catch (Exception e) {
            LogManager.severe("[WebSocket] Exception parsing message from " + conn.getRemoteSocketAddress().getAddress().getHostAddress() + ". Message: " + message, e);
        }
    }

    private final void parsePosition(ObjectNode json, WebSocket conn) {
        if (json.get("tracker_id").asInt() == 0) {
            float f = (float)json.get("x").asDouble();
            float f2 = (float)json.get("y").asDouble() + 0.2f;
            float f3 = (float)json.get("z").asDouble();
            Vector3.constructor-impl(f, f2, f3);
            this.internalHMDTracker.setPosition-1s-5YWc(f, f2, f3);
            float f4 = (float)json.get("qw").asDouble();
            float f5 = (float)json.get("qx").asDouble();
            float f6 = (float)json.get("qy").asDouble();
            float f7 = (float)json.get("qz").asDouble();
            Quaternion.constructor-impl(f4, f5, f6, f7);
            this.internalHMDTracker.setRotation-oS71L7k(f4, f5, f6, f7);
            this.internalHMDTracker.dataTick();
            this.newHMDData.set(true);
            int n = ((Collection)this.internalTrackers).size();
            for (int i = 0; i < n; ++i) {
                ObjectNode message = this.mapper.getNodeFactory().objectNode();
                message.put("type", "pos");
                message.put("src", "full");
                message.put("tracker_id", "SlimeVR Tracker " + (i + 1));
                Tracker t = this.internalTrackers.get(i);
                message.put("x", t.getPosition-x());
                message.put("y", t.getPosition-y());
                message.put("z", t.getPosition-z());
                message.put("qx", t.getRotation().unbox-impl-x());
                message.put("qy", t.getRotation().unbox-impl-y());
                message.put("qz", t.getRotation().unbox-impl-z());
                message.put("qw", t.getRotation().unbox-impl-w());
                conn.send(message.toString());
            }
        }
    }

    private final void parseAction(ObjectNode json, WebSocket conn) {
        block19: {
            String string = json.get("name").asText();
            if (string == null) break block19;
            int n = -1;
            switch (string.hashCode()) {
                case 691146679: {
                    if (string.equals("mounting_clear")) {
                        n = 1;
                    }
                    break;
                }
                case -1129246009: {
                    if (string.equals("calibrate")) {
                        n = 2;
                    }
                    break;
                }
                case 1939835159: {
                    if (string.equals("full_calibrate")) {
                        n = 3;
                    }
                    break;
                }
                case -1559191765: {
                    if (string.equals("toggle_pause_tracking")) {
                        n = 4;
                    }
                    break;
                }
                case 641640241: {
                    if (string.equals("mounting_calibrate")) {
                        n = 5;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    VRServer.resetTrackersYaw$default(VRServer.Companion.getInstance(), RESET_SOURCE_NAME, null, 2, null);
                    break;
                }
                case 3: {
                    VRServer.resetTrackersFull$default(VRServer.Companion.getInstance(), RESET_SOURCE_NAME, null, 2, null);
                    break;
                }
                case 5: {
                    VRServer.resetTrackersMounting$default(VRServer.Companion.getInstance(), RESET_SOURCE_NAME, null, 2, null);
                    break;
                }
                case 1: {
                    VRServer.Companion.getInstance().clearTrackersMounting(RESET_SOURCE_NAME);
                    break;
                }
                case 4: {
                    VRServer.Companion.getInstance().togglePauseTracking(RESET_SOURCE_NAME);
                }
            }
        }
    }

    @Override
    public void onStart() {
        LogManager.info("[WebSocket] Web Socket VR Bridge started on port " + this.getPort());
        this.setConnectionLostTimeout(0);
        this.setConnectionLostTimeout(1);
    }

    @Override
    public void addSharedTracker(@Nullable Tracker tracker) {
    }

    @Override
    public void removeSharedTracker(@Nullable Tracker tracker) {
    }

    @Override
    public void startBridge() {
        this.start();
    }

    @Override
    public boolean isConnected() {
        Collection<WebSocket> collection = super.getConnections();
        Intrinsics.checkNotNullExpressionValue(collection, "getConnections(...)");
        return !collection.isEmpty();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/slimevr/websocketapi/WebSocketVRBridge$Companion;", "", "<init>", "()V", "RESET_SOURCE_NAME", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

