/*
 * Decompiled with CFR 0.152.
 */
package io.eiren.util;

import com.jme3.system.NanoTimer;

public class BufferedTimer
extends NanoTimer {
    private final float measureInterval;
    private float averageTpf;
    private float averageFps = 0.0f;
    private float averageFrameRenderTime;
    private float sumFrameRenderTime;
    private float sumTpf = 0.0f;
    private float minFpsCurrent;
    private float maxFpsCurrent;
    private float maxFps;
    private float minFps;
    private int count = 0;
    private boolean measured = false;

    public BufferedTimer(float measureInterval) {
        this.measureInterval = measureInterval;
    }

    public float getAverageFPS() {
        return this.averageFps;
    }

    public float getMinFPS() {
        return this.minFps;
    }

    public float getMaxFPS() {
        return this.maxFps;
    }

    public void addRenderTime(float renderTime) {
        this.sumFrameRenderTime += renderTime;
    }

    public float getAverageFrameRenderTime() {
        return this.averageFrameRenderTime;
    }

    public boolean isMeasured() {
        if (this.measured) {
            this.measured = false;
            return true;
        }
        return false;
    }

    public TimerSample getCurrentData() {
        return new TimerSample(this.getFrameRate(), this.minFps, this.maxFps, this.averageFps);
    }

    @Override
    public void update() {
        super.update();
        this.sumTpf += this.getTimePerFrame();
        float fps = this.getFrameRate();
        if (fps < this.minFpsCurrent) {
            this.minFpsCurrent = fps;
        }
        if (fps > this.maxFpsCurrent) {
            this.maxFpsCurrent = fps;
        }
        ++this.count;
        if (!this.measured || this.sumTpf > this.measureInterval) {
            this.averageTpf = this.sumTpf / (float)this.count;
            this.averageFps = 1.0f / this.averageTpf;
            this.averageFrameRenderTime = this.sumFrameRenderTime / (float)this.count;
            this.minFps = this.minFpsCurrent;
            this.maxFps = this.maxFpsCurrent;
            this.sumTpf = 0.0f;
            this.sumFrameRenderTime = 0.0f;
            this.minFpsCurrent = Float.MAX_VALUE;
            this.maxFpsCurrent = 0.0f;
            this.count = 0;
            this.measured = true;
        }
    }

    public static class TimerSample {
        public float fps;
        public float minFps;
        public float maxFps;
        public float averageFps;

        public TimerSample(float fps, float minFps, float maxFps, float averageFps) {
            this.fps = fps;
            this.minFps = minFps;
            this.maxFps = maxFps;
            this.averageFps = averageFps;
        }

        public float getFps() {
            return this.fps;
        }

        public float getMinFps() {
            return this.minFps;
        }

        public float getMaxFps() {
            return this.maxFps;
        }

        public float getAverageFps() {
            return this.averageFps;
        }
    }
}

