/*
 * Decompiled with CFR 0.152.
 */
package io.eiren.util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lio/eiren/util/OperatingSystem;", "", "descriptor", "", "aliases", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;[Ljava/lang/String;)V", "getDescriptor", "()Ljava/lang/String;", "[Ljava/lang/String;", "LINUX", "WINDOWS", "OSX", "UNKNOWN", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nOperatingSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatingSystem.kt\nio/eiren/util/OperatingSystem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,70:1\n1#2:71\n12574#3,2:72\n*S KotlinDebug\n*F\n+ 1 OperatingSystem.kt\nio/eiren/util/OperatingSystem\n*L\n21#1:72,2\n*E\n"})
public final class OperatingSystem
extends Enum<OperatingSystem> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String descriptor;
    @NotNull
    private final String[] aliases;
    @NotNull
    private static final Lazy<OperatingSystem> currentPlatform$delegate;
    public static final /* enum */ OperatingSystem LINUX;
    public static final /* enum */ OperatingSystem WINDOWS;
    public static final /* enum */ OperatingSystem OSX;
    public static final /* enum */ OperatingSystem UNKNOWN;
    private static final /* synthetic */ OperatingSystem[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private OperatingSystem(String descriptor, String[] aliases) {
        this.descriptor = descriptor;
        this.aliases = aliases;
    }

    @NotNull
    public final String getDescriptor() {
        return this.descriptor;
    }

    public static OperatingSystem[] values() {
        return (OperatingSystem[])$VALUES.clone();
    }

    public static OperatingSystem valueOf(String value) {
        return Enum.valueOf(OperatingSystem.class, value);
    }

    @NotNull
    public static EnumEntries<OperatingSystem> getEntries() {
        return $ENTRIES;
    }

    private static final OperatingSystem currentPlatform_delegate$lambda$3() {
        Object v4;
        Object object;
        block4: {
            String string = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
            object = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string2 = object.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            String osName = string2;
            Iterable iterable = OperatingSystem.getEntries();
            for (Object t : iterable) {
                boolean bl;
                block3: {
                    OperatingSystem os = (OperatingSystem)((Object)t);
                    boolean bl2 = false;
                    String[] $this$any$iv = os.aliases;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        String element$iv;
                        String alias = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        if (!StringsKt.contains$default((CharSequence)osName, alias, false, 2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (!bl) continue;
                v4 = t;
                break block4;
            }
            v4 = null;
        }
        object = v4;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        return UNKNOWN;
    }

    static {
        String[] stringArray = new String[]{"linux", "unix"};
        LINUX = new OperatingSystem("linux", stringArray);
        stringArray = new String[]{"win"};
        WINDOWS = new OperatingSystem("windows", stringArray);
        stringArray = new String[]{"mac"};
        OSX = new OperatingSystem("osx", stringArray);
        UNKNOWN = new OperatingSystem("unknown", new String[0]);
        $VALUES = operatingSystemArray = new OperatingSystem[]{OperatingSystem.LINUX, OperatingSystem.WINDOWS, OperatingSystem.OSX, OperatingSystem.UNKNOWN};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        currentPlatform$delegate = LazyKt.lazy(OperatingSystem::currentPlatform_delegate$lambda$3);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000bJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000bR\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lio/eiren/util/OperatingSystem$Companion;", "", "<init>", "()V", "currentPlatform", "Lio/eiren/util/OperatingSystem;", "getCurrentPlatform", "()Lio/eiren/util/OperatingSystem;", "currentPlatform$delegate", "Lkotlin/Lazy;", "getJavaExecutable", "", "forceConsole", "", "socketDirectory", "getSocketDirectory", "()Ljava/lang/String;", "resolveConfigDirectory", "Ljava/nio/file/Path;", "identifier", "resolveLogDirectory", "core"})
    @SourceDebugExtension(value={"SMAP\nOperatingSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatingSystem.kt\nio/eiren/util/OperatingSystem$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OperatingSystem getCurrentPlatform() {
            Lazy lazy = currentPlatform$delegate;
            return (OperatingSystem)((Object)lazy.getValue());
        }

        @NotNull
        public final String getJavaExecutable(boolean forceConsole) {
            String separator = System.getProperty("file.separator");
            String path = System.getProperty("java.home") + separator + "bin" + separator;
            return this.getCurrentPlatform() == WINDOWS ? (!forceConsole && new File(path + "javaw.exe").isFile() ? path + "javaw.exe" : path + "java.exe") : path + "java";
        }

        @NotNull
        public final String getSocketDirectory() {
            String dir = System.getenv("SLIMEVR_SOCKET_DIR");
            if (dir != null) {
                return dir;
            }
            if (this.getCurrentPlatform() == LINUX && (dir = System.getenv("XDG_RUNTIME_DIR")) != null) {
                return dir;
            }
            String string = System.getProperty("java.io.tmpdir");
            Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
            return string;
        }

        @Nullable
        public final Path resolveConfigDirectory(@NotNull String identifier) {
            Object object;
            Intrinsics.checkNotNullParameter(identifier, "identifier");
            switch (WhenMappings.$EnumSwitchMapping$0[this.getCurrentPlatform().ordinal()]) {
                case 1: {
                    object = System.getenv("XDG_CONFIG_HOME");
                    if (object != null) {
                        String it = object;
                        boolean bl = false;
                        String[] stringArray = new String[]{identifier};
                        Path path = Paths.get(it, Arrays.copyOf(stringArray, stringArray.length));
                        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
                        object = path;
                        if (path != null) break;
                    }
                    String string = System.getenv("HOME");
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        String[] stringArray = new String[]{".config", identifier};
                        Path path = Paths.get(it, Arrays.copyOf(stringArray, stringArray.length));
                        object = path;
                        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
                        break;
                    }
                    object = null;
                    break;
                }
                case 2: {
                    String string = System.getenv("AppData");
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        String[] stringArray = new String[]{identifier};
                        Path path = Paths.get(it, Arrays.copyOf(stringArray, stringArray.length));
                        object = path;
                        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
                        break;
                    }
                    object = null;
                    break;
                }
                case 3: {
                    String string = System.getenv("HOME");
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        String[] stringArray = new String[]{"Library", "Application Support", identifier};
                        Path path = Paths.get(it, Arrays.copyOf(stringArray, stringArray.length));
                        object = path;
                        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
                        break;
                    }
                    object = null;
                    break;
                }
                case 4: {
                    object = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return object;
        }

        @Nullable
        public final Path resolveLogDirectory(@NotNull String identifier) {
            Object object;
            Intrinsics.checkNotNullParameter(identifier, "identifier");
            switch (WhenMappings.$EnumSwitchMapping$0[this.getCurrentPlatform().ordinal()]) {
                case 1: {
                    object = System.getenv("XDG_DATA_HOME");
                    if (object != null) {
                        String it = object;
                        boolean bl = false;
                        String[] stringArray = new String[]{identifier, "logs"};
                        Path path = Paths.get(it, Arrays.copyOf(stringArray, stringArray.length));
                        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
                        object = path;
                        if (path != null) break;
                    }
                    String string = System.getenv("HOME");
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        String[] stringArray = new String[]{".local", "share", identifier, "logs"};
                        Path path = Paths.get(it, Arrays.copyOf(stringArray, stringArray.length));
                        object = path;
                        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
                        break;
                    }
                    object = null;
                    break;
                }
                case 2: {
                    String string = System.getenv("AppData");
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        String[] stringArray = new String[]{identifier, "logs"};
                        Path path = Paths.get(it, Arrays.copyOf(stringArray, stringArray.length));
                        object = path;
                        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
                        break;
                    }
                    object = null;
                    break;
                }
                case 3: {
                    String string = System.getenv("HOME");
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        String[] stringArray = new String[]{"Library", "Logs", identifier};
                        Path path = Paths.get(it, Arrays.copyOf(stringArray, stringArray.length));
                        object = path;
                        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
                        break;
                    }
                    object = null;
                    break;
                }
                case 4: {
                    object = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=50)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OperatingSystem.values().length];
                try {
                    nArray[OperatingSystem.LINUX.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OperatingSystem.WINDOWS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OperatingSystem.OSX.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OperatingSystem.UNKNOWN.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

