/*
 * Decompiled with CFR 0.152.
 */
package io.eiren.util;

import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class StringUtils {
    private static char DECIMAL_SEP;

    public static char getDecimalSeparator() {
        if (DECIMAL_SEP == '\u0000') {
            Locale l = Locale.getDefault(Locale.Category.FORMAT);
            DECIMAL_SEP = (char)(l == null || l.equals(Locale.US) ? 46 : (int)DecimalFormatSymbols.getInstance(l).getDecimalSeparator());
        }
        return DECIMAL_SEP;
    }

    public static String prettyNumber(float f) {
        return StringUtils.prettyNumber(f, 4);
    }

    public static String prettyNumber(float f, int numDigits) {
        char lastChar;
        String str = String.format("%." + numDigits + "f", Float.valueOf(f));
        if (numDigits != 0) {
            str = org.apache.commons.lang3.StringUtils.stripEnd(str, "0");
        }
        if ((lastChar = str.charAt(str.length() - 1)) == StringUtils.getDecimalSeparator()) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

