/*
 * Decompiled with CFR 0.152.
 */
package io.eiren.util.collections;

import io.eiren.util.collections.RemoveAtSwapList;
import io.eiren.util.collections.ResettableIterator;
import io.eiren.util.collections.SkipIterator;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class FastList<E>
extends AbstractList<E>
implements RandomAccess,
Cloneable,
RemoveAtSwapList<E> {
    private static final Object[] emptyArray = new Object[0];
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    protected int size = 0;
    protected Object[] array;

    public FastList(int capacity) {
        this.array = capacity == 0 ? emptyArray : new Object[capacity];
    }

    public FastList() {
        this(5);
    }

    public FastList(Collection<E> source) {
        this(source.size());
        this.addAll(source);
    }

    public FastList(FastList<E> source) {
        this(source.size);
        this.addAllInternal(0, source.array, source.size);
    }

    public FastList(E[] source) {
        this(source.length);
        this.addAll(source);
    }

    public FastList(E source) {
        this();
        this.add(source);
    }

    private FastList(Object[] arr, int size2) {
        this(size2);
        System.arraycopy(arr, 0, this.array, 0, size2);
        this.size = size2;
    }

    private FastList(boolean f) {
    }

    public static <E> FastList<E> reuseArray(E[] source) {
        FastList<E> list = new FastList<E>(true);
        list.array = source;
        list.size = source.length;
        return list;
    }

    private void checkBounds(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", size: " + this.size);
        }
    }

    public void ensureCapacity(int numToFit) {
        if (this.array.length < this.size + numToFit) {
            this.grow(numToFit + this.size);
        }
    }

    private void grow(int i) {
        int j = this.array.length;
        int k = j + (j >> 1);
        if (k - i < 0) {
            k = i;
        }
        if (k - 0x7FFFFFF7 > 0) {
            k = FastList.hugeCapacity(i);
        }
        this.array = Arrays.copyOf(this.array, k);
    }

    private static int hugeCapacity(int i) {
        if (i < 0) {
            throw new OutOfMemoryError("Huge capacity negative: " + i);
        }
        return i <= 0x7FFFFFF7 ? 0x7FFFFFF7 : Integer.MAX_VALUE;
    }

    public void copyInto(Object[] anArray) {
        System.arraycopy(this.array, 0, anArray, 0, this.size);
    }

    @Override
    public E get(int index) {
        this.checkBounds(index);
        return (E)this.array[index];
    }

    public E unsafeGet(int index) {
        return (E)this.array[index];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int indexOf(Object obj) {
        for (int j = 0; j < this.size; ++j) {
            if (obj != this.array[j]) continue;
            return j;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object obj) {
        for (int j = this.size - 1; j >= 0; --j) {
            if (obj != this.array[j]) continue;
            return j;
        }
        return -1;
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    public void trimToSize() {
        int i = this.array.length;
        if (this.size < i) {
            this.array = Arrays.copyOf(this.array, this.size);
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.array, this.size);
    }

    @Override
    public <T> T[] toArray(T[] aobj) {
        if (aobj.length < this.size) {
            return Arrays.copyOf(this.array, this.size, aobj.getClass());
        }
        System.arraycopy(this.array, 0, aobj, 0, this.size);
        if (aobj.length > this.size) {
            aobj[this.size] = null;
        }
        return aobj;
    }

    @Override
    public boolean add(E e) {
        this.ensureCapacity(1);
        this.array[this.size++] = e;
        return true;
    }

    @Override
    public E remove(int i) {
        this.checkBounds(i);
        Object obj = this.array[i];
        this.removeInternal(i);
        return (E)obj;
    }

    @Override
    public boolean remove(Object obj) {
        for (int j = 0; j < this.size; ++j) {
            if (obj != this.array[j]) continue;
            this.removeInternal(j);
            return true;
        }
        return false;
    }

    public boolean removeAll(Object[] toRemove) {
        boolean removed = false;
        for (int i = toRemove.length - 1; i >= 0; --i) {
            int index = this.indexOf(toRemove[i]);
            if (index == -1) continue;
            this.removeInternal(index);
            removed = true;
        }
        return removed;
    }

    protected void removeInternal(int i) {
        int j = this.size - i - 1;
        if (j > 0) {
            System.arraycopy(this.array, i + 1, this.array, i, j);
        }
        this.array[--this.size] = null;
    }

    public void unsafeRemove(int i) {
        this.removeInternal(i);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.batchRemove(c, false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.batchRemove(c, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchRemove(Collection<?> c, boolean complement) {
        boolean modified;
        int w;
        block8: {
            int r;
            Object[] elementData = this.array;
            w = 0;
            modified = false;
            try {
                for (r = 0; r < this.size; ++r) {
                    if (c.contains(elementData[r]) != complement) continue;
                    elementData[w++] = elementData[r];
                }
                if (r == this.size) break block8;
            }
            catch (Throwable throwable) {
                if (r != this.size) {
                    System.arraycopy(elementData, r, elementData, w, this.size - r);
                    w += this.size - r;
                }
                if (w != this.size) {
                    for (int i = w; i < this.size; ++i) {
                        elementData[i] = null;
                    }
                    this.size = w;
                    modified = true;
                }
                throw throwable;
            }
            System.arraycopy(elementData, r, elementData, w, this.size - r);
            w += this.size - r;
        }
        if (w != this.size) {
            for (int i = w; i < this.size; ++i) {
                elementData[i] = null;
            }
            this.size = w;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = null;
        }
        this.size = 0;
    }

    public void fakeClear() {
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.size, collection);
    }

    public void addAll(E[] arr) {
        this.addAllInternal(this.size, arr, arr.length);
    }

    public void addAll(E[] arr, int limit) {
        this.addAllInternal(this.size, arr, limit);
    }

    public void addAll(int index, E[] arr) {
        this.addAllInternal(index, arr, arr.length);
    }

    public void addAll(int index, E[] arr, int limit) {
        this.addAllInternal(index, arr, limit);
    }

    private void addAllInternal(int index, Object[] arr, int limit) {
        if (limit > arr.length) {
            limit = arr.length;
        }
        if (limit == 1) {
            this.add(index, arr[0]);
        } else if (limit > 0) {
            if (index >= this.size) {
                this.ensureCapacity(this.size - index + limit);
                System.arraycopy(arr, 0, this.array, index, limit);
                this.size = index + limit;
            } else {
                if (this.array.length < this.size + limit) {
                    Object[] newArray = new Object[this.size + limit];
                    System.arraycopy(this.array, 0, newArray, 0, index);
                    System.arraycopy(arr, 0, newArray, index, limit);
                    System.arraycopy(this.array, index, newArray, index + limit, this.size - index);
                    this.array = newArray;
                } else {
                    System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
                    System.arraycopy(arr, 0, this.array, index, limit);
                }
                this.size += limit;
            }
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        if (collection.size() > 0) {
            if (collection instanceof FastList) {
                this.addAllInternal(index, ((FastList)collection).array, collection.size());
            } else if (collection instanceof RandomAccess) {
                Object[] arr = collection.toArray(new Object[collection.size()]);
                this.addAllInternal(index, arr, arr.length);
            } else if (index >= this.size) {
                this.ensureCapacity(this.size - index + collection.size());
                Iterator<E> iterator2 = collection.iterator();
                int i = index;
                while (iterator2.hasNext()) {
                    this.array[i++] = iterator2.next();
                }
                this.size = index + collection.size();
            } else {
                if (this.array.length < this.size + collection.size()) {
                    Object[] newArray = new Object[this.size + collection.size()];
                    System.arraycopy(this.array, 0, newArray, 0, index);
                    Iterator<E> iterator3 = collection.iterator();
                    int i = index;
                    while (iterator3.hasNext()) {
                        newArray[i++] = iterator3.next();
                    }
                    System.arraycopy(this.array, index, newArray, index + collection.size(), this.size - index);
                    this.array = newArray;
                } else {
                    System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
                    for (E e : collection) {
                        this.array[index++] = e;
                    }
                }
                this.size += collection.size();
            }
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        if (index >= this.size) {
            this.ensureCapacity(this.size - index + 1);
            this.size = index + 1;
            this.array[index] = element;
        } else {
            if (this.array.length < this.size + 1) {
                Object[] newArray = new Object[this.size + 1];
                System.arraycopy(this.array, 0, newArray, 0, index);
                newArray[index] = element;
                System.arraycopy(this.array, index, newArray, index + 1, this.size - index);
                this.array = newArray;
            } else {
                System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
                this.array[index] = element;
            }
            ++this.size;
        }
    }

    @Override
    public E set(int index, E element) {
        this.checkBounds(index);
        Object oldValue = this.array[index];
        this.array[index] = element;
        return (E)oldValue;
    }

    public FastList<E> clone() {
        return new FastList<E>(this.array, this.size);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int expectedModCount = this.modCount;
        Object[] elementData = this.array;
        int size2 = this.size;
        for (int i = 0; this.modCount == expectedModCount && i < size2; ++i) {
            action.accept(elementData[i]);
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public E removeAtSwap(int i) {
        this.checkBounds(i);
        Object obj = this.array[i];
        this.removeAtSwapInternal(i);
        return (E)obj;
    }

    @Override
    public boolean removeAtSwap(Object obj) {
        for (int j = 0; j < this.size; ++j) {
            if (obj != this.array[j]) continue;
            this.removeAtSwapInternal(j);
            return true;
        }
        return false;
    }

    protected void removeAtSwapInternal(int i) {
        int j = this.size - i - 1;
        if (j > 0) {
            this.array[i] = this.array[this.size - 1];
        }
        this.array[--this.size] = null;
    }

    @Override
    public void removeRange(int i, int toIndex) {
        this.checkBounds(i);
        this.checkBounds(toIndex);
        int j = this.size - toIndex - 1;
        if (j > 0) {
            System.arraycopy(this.array, toIndex + 1, this.array, i, j);
        }
        this.size -= toIndex - i + 1;
        Arrays.fill(this.array, i, toIndex, null);
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        Objects.requireNonNull(operator);
        for (int i = 0; i < this.size; ++i) {
            this.set(i, operator.apply(this.get(i)));
        }
    }

    @Override
    public void sort(Comparator<? super E> c) {
        Arrays.sort(this.array, 0, this.size, c);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            Object o = this.array[i];
            hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
        }
        return hashCode;
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.array, 0, this.size, 16);
    }

    public SkipFastListIterator skipIterator() {
        return new SkipFastListIterator();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        boolean anyToRemove;
        Objects.requireNonNull(filter);
        int removeCount = 0;
        BitSet removeSet = new BitSet(this.size);
        int expectedModCount = this.modCount;
        int size2 = this.size;
        for (int i = 0; this.modCount == expectedModCount && i < size2; ++i) {
            Object element = this.array[i];
            if (!filter.test(element)) continue;
            removeSet.set(i);
            ++removeCount;
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        boolean bl = anyToRemove = removeCount > 0;
        if (anyToRemove) {
            int newSize = size2 - removeCount;
            int i = 0;
            for (int j = 0; i < size2 && j < newSize; ++i, ++j) {
                i = removeSet.nextClearBit(i);
                this.array[j] = this.array[i];
            }
            for (int k = newSize; k < size2; ++k) {
                this.array[k] = null;
            }
            this.size = newSize;
            if (this.modCount != expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ++this.modCount;
        }
        return anyToRemove;
    }

    public class SkipFastListIterator
    implements ResettableIterator<E>,
    SkipIterator<E> {
        public int position;

        @Override
        public boolean hasNext() {
            return this.position < FastList.this.size;
        }

        @Override
        public E next() {
            Object[] arr = FastList.this.array;
            if (arr.length > this.position) {
                return arr[this.position++];
            }
            ++this.position;
            return null;
        }

        @Override
        public void reset() {
            this.position = 0;
        }
    }
}

