/*
 * Decompiled with CFR 0.152.
 */
package io.eiren.util.logging;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001,B;\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u001c\u001a\b\u0018\u00010\u0014R\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010\u001f\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00000\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001a\u0010 \u001a\u00020\f2\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00000!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010$\u001a\b\u0018\u00010\u0014R\u00020\u00002\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00000!H\u0002J\b\u0010%\u001a\u00020#H\u0002J\u0012\u0010&\u001a\u00020#2\b\b\u0002\u0010'\u001a\u00020\tH\u0002J\b\u0010(\u001a\u00020#H\u0002J\u0012\u0010)\u001a\u00020#2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/eiren/util/logging/FileLogHandler;", "Ljava/util/logging/StreamHandler;", "path", "Ljava/nio/file/Path;", "logTag", "", "dateFormat", "Ljava/time/format/DateTimeFormatter;", "limit", "", "maxCount", "collectiveLimit", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/time/format/DateTimeFormatter;IIJ)V", "sectionSeparator", "", "logSuffix", "logFiles", "", "Lio/eiren/util/logging/FileLogHandler$DatedLogFile;", "dateTime", "Ljava/time/LocalDateTime;", "date", "curStream", "Ljava/io/DataOutputStream;", "fileCount", "collectiveSize", "parseFileName", "file", "Ljava/io/File;", "findLogs", "sumFileSizes", "", "deleteFile", "", "getEarliestFile", "deleteEarliestFile", "deleteOverCollectiveLimit", "curFileSize", "newFile", "publish", "record", "Ljava/util/logging/LogRecord;", "DatedLogFile", "core"})
public final class FileLogHandler
extends StreamHandler {
    @NotNull
    private final Path path;
    @NotNull
    private final String logTag;
    @NotNull
    private final DateTimeFormatter dateFormat;
    private final int limit;
    private final int maxCount;
    private final long collectiveLimit;
    private final char sectionSeparator;
    @NotNull
    private final String logSuffix;
    @NotNull
    private final List<DatedLogFile> logFiles;
    @NotNull
    private final LocalDateTime dateTime;
    @NotNull
    private final String date;
    @Nullable
    private DataOutputStream curStream;
    private int fileCount;
    private long collectiveSize;

    @JvmOverloads
    public FileLogHandler(@NotNull Path path, @NotNull String logTag, @NotNull DateTimeFormatter dateFormat, int limit, int maxCount, long collectiveLimit) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(logTag, "logTag");
        Intrinsics.checkNotNullParameter(dateFormat, "dateFormat");
        this.path = path;
        this.logTag = logTag;
        this.dateFormat = dateFormat;
        this.limit = limit;
        this.maxCount = maxCount;
        this.collectiveLimit = collectiveLimit;
        this.sectionSeparator = (char)95;
        this.logSuffix = ".log";
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue(localDateTime, "now(...)");
        this.dateTime = localDateTime;
        String string = this.dateTime.format(this.dateFormat);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        this.date = string;
        this.logFiles = this.findLogs(this.path);
        if (this.collectiveLimit > 0L) {
            this.collectiveSize = this.sumFileSizes(this.logFiles);
        }
        this.newFile();
    }

    public /* synthetic */ FileLogHandler(Path path, String string, DateTimeFormatter dateTimeFormatter, int n, int n2, long l, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            l = -1L;
        }
        this(path, string, dateTimeFormatter, n, n2, l);
    }

    private final DatedLogFile parseFileName(File file) {
        String name = file.getName();
        Intrinsics.checkNotNull(name);
        if (!StringsKt.startsWith$default(name, this.logTag, false, 2, null) || !StringsKt.endsWith$default(name, this.logSuffix, false, 2, null) || name.length() < this.logTag.length() + this.logSuffix.length() + 4) {
            return null;
        }
        int dateEnd = StringsKt.lastIndexOf$default((CharSequence)name, this.sectionSeparator, 0, false, 6, null);
        if (dateEnd < 0) {
            return null;
        }
        try {
            String string = name.substring(this.logTag.length() + 1, dateEnd);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String dateTimeStr = string;
            LocalDateTime dateTime = LocalDateTime.parse(dateTimeStr, this.dateFormat);
            String string2 = name.substring(dateEnd + 1, name.length() - this.logSuffix.length());
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            int logNum = Integer.parseInt(string2);
            Intrinsics.checkNotNull(dateTime);
            return new DatedLogFile(file, dateTime, logNum);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final List<DatedLogFile> findLogs(Path path) {
        List logFiles = new ArrayList();
        File[] files = path.toFile().listFiles();
        if (files == null) {
            return logFiles;
        }
        Iterator<File> iterator2 = ArrayIteratorKt.iterator(files);
        while (iterator2.hasNext()) {
            File log = iterator2.next();
            Intrinsics.checkNotNull(log);
            DatedLogFile parsedFile = this.parseFileName(log);
            if (parsedFile == null) continue;
            logFiles.add(parsedFile);
        }
        return logFiles;
    }

    private final long sumFileSizes(List<DatedLogFile> logFiles) {
        long size2 = 0L;
        for (DatedLogFile log : logFiles) {
            size2 += log.getFile().length();
        }
        return size2;
    }

    private final void deleteFile(File file) {
        if (file.delete()) {
            return;
        }
        file.deleteOnExit();
        this.reportError("Failed to delete file, deleting on exit.", null, 0);
    }

    private final DatedLogFile getEarliestFile(List<DatedLogFile> logFiles) {
        DatedLogFile earliest = null;
        for (DatedLogFile log : logFiles) {
            if (earliest != null && log.compareTo(earliest) >= 0) continue;
            earliest = log;
        }
        return earliest;
    }

    private final synchronized void deleteEarliestFile() {
        DatedLogFile earliest = this.getEarliestFile(this.logFiles);
        if (earliest == null) {
            return;
        }
        if (this.collectiveLimit > 0L) {
            this.collectiveSize = RangesKt.coerceAtLeast(this.collectiveSize - earliest.getFile().length(), 0L);
        }
        this.logFiles.remove(earliest);
        this.deleteFile(earliest.getFile());
    }

    private final synchronized void deleteOverCollectiveLimit(int curFileSize) {
        if (this.collectiveLimit <= 0L) {
            return;
        }
        while (!this.logFiles.isEmpty() && this.collectiveSize + (long)curFileSize >= this.collectiveLimit) {
            this.deleteEarliestFile();
        }
    }

    static /* synthetic */ void deleteOverCollectiveLimit$default(FileLogHandler fileLogHandler, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        fileLogHandler.deleteOverCollectiveLimit(n);
    }

    private final synchronized void newFile() {
        DataOutputStream lastStream = this.curStream;
        if (lastStream != null) {
            this.close();
            this.collectiveSize += (long)lastStream.size();
        }
        if (this.maxCount > 0) {
            while (this.logFiles.size() >= this.maxCount) {
                this.deleteEarliestFile();
            }
        }
        FileLogHandler.deleteOverCollectiveLimit$default(this, 0, 1, null);
        try {
            File newFile = this.path.resolve(this.logTag + this.sectionSeparator + this.date + this.sectionSeparator + this.fileCount + this.logSuffix).toFile();
            DataOutputStream newStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
            this.setOutputStream(newStream);
            this.curStream = newStream;
            Intrinsics.checkNotNull(newFile);
            this.logFiles.add(new DatedLogFile(newFile, this.dateTime, this.fileCount));
            ++this.fileCount;
        }
        catch (FileNotFoundException e) {
            this.reportError(null, e, 4);
        }
    }

    @Override
    public synchronized void publish(@Nullable LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
        DataOutputStream dataOutputStream = this.curStream;
        Intrinsics.checkNotNull(dataOutputStream);
        int curFileSize = dataOutputStream.size();
        this.deleteOverCollectiveLimit(curFileSize);
        if (this.limit > 0 && curFileSize >= this.limit) {
            this.newFile();
        }
    }

    @JvmOverloads
    public FileLogHandler(@NotNull Path path, @NotNull String logTag, @NotNull DateTimeFormatter dateFormat, int limit, int maxCount) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(logTag, "logTag");
        Intrinsics.checkNotNullParameter(dateFormat, "dateFormat");
        this(path, logTag, dateFormat, limit, maxCount, 0L, 32, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u0011\u001a\u00020\b2\n\u0010\u0012\u001a\u00060\u0000R\u00020\u0002H\u0096\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lio/eiren/util/logging/FileLogHandler$DatedLogFile;", "", "Lio/eiren/util/logging/FileLogHandler;", "file", "Ljava/io/File;", "dateTime", "Ljava/time/LocalDateTime;", "count", "", "<init>", "(Lio/eiren/util/logging/FileLogHandler;Ljava/io/File;Ljava/time/LocalDateTime;I)V", "getFile", "()Ljava/io/File;", "getDateTime", "()Ljava/time/LocalDateTime;", "getCount", "()I", "compareTo", "o", "core"})
    public final class DatedLogFile
    implements Comparable<DatedLogFile> {
        @NotNull
        private final File file;
        @NotNull
        private final LocalDateTime dateTime;
        private final int count;

        public DatedLogFile(@NotNull File file, LocalDateTime dateTime, int count) {
            Intrinsics.checkNotNullParameter(file, "file");
            Intrinsics.checkNotNullParameter(dateTime, "dateTime");
            this.file = file;
            this.dateTime = dateTime;
            this.count = count;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final LocalDateTime getDateTime() {
            return this.dateTime;
        }

        public final int getCount() {
            return this.count;
        }

        @Override
        public int compareTo(@NotNull DatedLogFile o) {
            Intrinsics.checkNotNullParameter(o, "o");
            int dtCompare = this.dateTime.compareTo(o.dateTime);
            return dtCompare != 0 ? dtCompare : Intrinsics.compare(this.count, o.count);
        }
    }
}

