/*
 * Decompiled with CFR 0.152.
 */
package io.eiren.util.logging;

import io.eiren.util.logging.IGLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;

public class LoggerOutputStream
extends ByteArrayOutputStream {
    private static final String separator = System.getProperty("line.separator");
    private final IGLog logger;
    private final Level level;
    private final String prefix;
    private final StringBuilder buffer = new StringBuilder();

    public LoggerOutputStream(IGLog logger, Level level) {
        this(logger, level, "");
    }

    public LoggerOutputStream(IGLog logger, Level level, String prefix) {
        this.logger = logger;
        this.level = level;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        LoggerOutputStream loggerOutputStream = this;
        synchronized (loggerOutputStream) {
            super.flush();
            String record = this.toString();
            super.reset();
            if (record.length() > 0) {
                this.buffer.append(record);
                if (record.contains(separator)) {
                    String[] split;
                    String s = this.buffer.toString();
                    for (String value : split = s.split(separator)) {
                        this.logger.log(this.level, this.prefix + value);
                    }
                    this.buffer.setLength(0);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

